/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.CasDataException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.LoanDataTypeEnum;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.app.InAcctControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanCaculaterHelper {
    private static final String COMPANY_ID = "company.id";
    private static final String BankAcct_ID = "bankAcctID";
    private static final String CURRENCY_ID = "currencyID";
    private static final String BIZEDATE = "bizDate";
    private static Logger logger = Logger.getLogger(InAcctControllerBean.class);
    private static final String SEL_LOAN = " sum(ISNULL(LOAN.FAmount, 0)) AS T, sum(ISNULL(LOAN.FBalance, 0)) AS Y, sum(ISNULL(LOAN.FAmountLocalCur, 0)) AS S ";
    private static final String JOIN_LOAN = "";
    private static final String SEL_MAINCONLOAN = "  sum(ISNULL(MAINCONLOAN.FConAmount, 0))       AS C,   sum(ISNULL(MAINCONLOAN.FAddConAmount, 0))    AS O,   sum(ISNULL(MAINCONLOAN.FRemainConAmount, 0)) AS N     from  T_FIN_MainConLoan AS MAINCONLOAN where MAINCONLOAN.FID in (   SELECT LOAN.FMainConLoanID ";
    private static final String JOIN_MAINCONLOAN = "";
    private static final String SEL_LOANINTEREST = " sum(ISNULL(LOANINTEREST.FInterest, 0)) AS I ";
    private static final String JOIN_LOANINTEREST = " LEFT OUTER JOIN T_FIN_LoanInterest AS LOANINTEREST                ON LOAN.FID = LOANINTEREST.FLoanID                               ";
    private static final String SEL_FINFEE = "sum(ISNULL(FINFEE.FAmount, 0)) AS F ";
    private static final String JOIN_FINFEE = " LEFT OUTER JOIN T_FIN_FinancingFeeBill AS FINFEE                 ON LOAN.FID = FINFEE.FSourceBillID                              ";
    private String Main_QUERY = "SELECT {0} FROM T_FIN_Loan AS LOAN   INNER JOIN T_BD_Currency AS CURRENCY    ON LOAN.FCurrencyID = CURRENCY.FID                               INNER JOIN T_FIN_FinancingProducts AS TYPE                       ON LOAN.FTypeID = TYPE.FID                                       INNER JOIN T_FIN_FinancingSources AS SOURCE                      ON LOAN.FSourceID = SOURCE.FID                                   INNER JOIN T_ORG_Company AS COMPANY                              ON LOAN.FCompanyID = COMPANY.FID                                 INNER JOIN T_FIN_CreditorGroup AS CREDITORGROUP                  ON LOAN.FCreditorGroupID = CREDITORGROUP.FID                     LEFT OUTER JOIN T_BD_AccountBanks AS BANKACCT                    ON LOAN.FBankAcctID = BANKACCT.FID                               LEFT OUTER JOIN T_BD_AccountView AS LOANACCT                     ON LOAN.FLoanAcctID = LOANACCT.FID                               LEFT OUTER JOIN T_INT_IntRateType AS INTRATETYPE                 ON LOAN.FIntRateTypeID = INTRATETYPE.FID                         LEFT OUTER JOIN T_BD_Bank AS INSTITUTION                         ON INSTITUTION.FID = LOAN.FInstitutionId                         LEFT OUTER JOIN T_ORG_Company AS GROUPID                         ON LOAN.FGroupId = GROUPID.FID                                   LEFT OUTER JOIN T_BD_Project AS PROJECT                          ON LOAN.FProjectID = PROJECT.FID                                 LEFT OUTER JOIN T_FIN_GuaranteeType AS GARANTEETYPE              ON LOAN.FGaranteeTypeID = GARANTEETYPE.FID                       LEFT OUTER JOIN T_INT_IntScheme AS PAYINTMODE                    ON LOAN.FPayIntModeID = PAYINTMODE.FID                           LEFT OUTER JOIN T_IVT_ChLoan AS ENTLOANID                        ON LOAN.FEntLoanID = ENTLOANID.FID                                {1}  where 1=1                ";

    public BigDecimal getInAccBatch(ICalculateContextProvider calContext, Context serverCtx, Object[] args) throws BOSException, EASBizException, SQLException {
        String resourcePath = "com.kingdee.eas.fm.fin.LoanExceptionMessageResource";
        LoanDataTypeEnum DataType = LoanDataTypeEnum.getEnum(args[8].toString());
        if (DataType == null) {
            throw new FSException(FSException.INACCTTYPEISNULL);
        }
        String Rsql = "";
        IRowSet rs = null;
        String mainSql = "";
        if (DataType == LoanDataTypeEnum.T || DataType == LoanDataTypeEnum.Y) {
            mainSql = MessageFormat.format(this.Main_QUERY, SEL_LOAN, "");
            Rsql = mainSql + this.getWhereSQL(calContext, serverCtx, args);
        } else if (DataType == LoanDataTypeEnum.C || DataType == LoanDataTypeEnum.O || DataType == LoanDataTypeEnum.N) {
            mainSql = MessageFormat.format(this.Main_QUERY, SEL_MAINCONLOAN, "");
            Rsql = mainSql + this.getWhereSQL(calContext, serverCtx, args) + ")";
        } else if (DataType == LoanDataTypeEnum.I) {
            mainSql = MessageFormat.format(this.Main_QUERY, SEL_LOANINTEREST, JOIN_LOANINTEREST);
            Rsql = mainSql + this.getWhereSQL(calContext, serverCtx, args);
        } else if (DataType == LoanDataTypeEnum.F) {
            mainSql = MessageFormat.format(this.Main_QUERY, SEL_FINFEE, JOIN_FINFEE);
            Rsql = mainSql + this.getWhereSQL(calContext, serverCtx, args);
        }
        try {
            rs = this.getResultBySQL(serverCtx, Rsql);
        }
        catch (BOSException e) {
            throw new BOSException(EASResource.getString((String)resourcePath, (String)"breakOutBOSException"));
        }
        BigDecimal result = SysConstant.BIGZERO;
        try {
            while (rs.next()) {
                if (DataType == LoanDataTypeEnum.T) {
                    result = rs.getBigDecimal("T");
                    continue;
                }
                if (DataType == LoanDataTypeEnum.Y) {
                    result = rs.getBigDecimal("Y");
                    continue;
                }
                if (DataType == LoanDataTypeEnum.C) {
                    result = rs.getBigDecimal("C");
                    continue;
                }
                if (DataType == LoanDataTypeEnum.O) {
                    result = rs.getBigDecimal("O");
                    continue;
                }
                if (DataType == LoanDataTypeEnum.N) {
                    result = rs.getBigDecimal("N");
                    continue;
                }
                if (DataType == LoanDataTypeEnum.I) {
                    result = rs.getBigDecimal("I");
                    continue;
                }
                if (DataType != LoanDataTypeEnum.F) continue;
                result = rs.getBigDecimal("F");
            }
        }
        catch (SQLException e) {
            throw new BOSException(EASResource.getString((String)resourcePath, (String)"breakOutSQLException"));
        }
        return result == null ? SysConstant.BIGZERO : result;
    }

    private String getWhereSQL(ICalculateContextProvider context, Context ctx, Object[] args) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat format = FMHelper.getNationalDateFormat((Context)ctx);
        if (args[0] != null && !args[0].equals("")) {
            sql.append(" and ").append(StringUtil.buildIn((String)" COMPANY.fid ", (Object[])this.getCompanyIds(ctx, args[0].toString()).toArray()));
        } else {
            String companyNum = this.getReportCompany(context, ctx);
            sql.append(" and ").append(StringUtil.buildIn((String)" COMPANY.fid ", (Object[])this.getCompanyIds(ctx, companyNum).toArray()));
        }
        if (args[1] != null && !args[1].equals("")) {
            sql.append(" and CURRENCY.fnumber='" + args[1].toString() + "'");
        } else {
            String currency = this.getReportCurrency(context, ctx);
            sql.append(" and CURRENCY.fnumber='" + currency + "'");
        }
        if (args[2] != null && !args[2].equals("")) {
            sql.append(" and TYPE.fnumber='" + args[2].toString() + "'");
        }
        if (args[3] != null && !args[3].equals("")) {
            if (args[3].toString().equalsIgnoreCase("OutGroup")) {
                sql.append(" and LOAN.FIsGroupLoan=0");
            } else {
                sql.append(" and LOAN.FIsGroupLoan=1");
            }
        }
        if (args[4] != null && !args[4].equals("")) {
            if (args[3].toString().equalsIgnoreCase("OutGroup")) {
                sql.append(" and ").append(StringUtil.buildIn((String)" INSTITUTION.fid ", (Object[])this.getBankAcctIds(ctx, args[4].toString()).toArray()));
            } else {
                sql.append(" and ").append(StringUtil.buildIn((String)" GROUPID.fid ", (Object[])this.getCompanyIds(ctx, args[4].toString()).toArray()));
            }
        } else if (args[3].toString().equalsIgnoreCase("OutGroup")) {
            sql.append(" and  LOAN.FGroupId IS NULL ");
        } else {
            sql.append(" and  LOAN.FInstitutionId IS NULL ");
        }
        String beginDate = null;
        if (args[5] != null && !args[5].equals("")) {
            try {
                beginDate = dateFormat.format(format.parse(args[5].toString()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            beginDate = this.getReportStartDate(context, ctx).toString();
        }
        sql.append(" and LOAN.fIssueDate >= {").append(beginDate).append("} ");
        String endDate = null;
        if (args[6] != null && !args[6].equals("")) {
            try {
                endDate = dateFormat.format(format.parse(args[6].toString()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            endDate = this.getReportEndDate(context, ctx).toString();
        }
        sql.append(" and LOAN.fIssueDate <= {").append(endDate).append("} ");
        if (args[7] != null && !args[7].equals("")) {
            sql.append(" and ( " + args[7].toString()).append(" )");
        }
        return sql.toString();
    }

    private IRowSet getResultBySQL(Context ctx, String sql) throws SQLDataException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        DynamicRowSet drs = null;
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            drs = new DynamicRowSet(colCount);
            String[] columnNameArray = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                int columnClz = rsmd.getColumnType(i + 1);
                String columnlbl = rsmd.getColumnLabel(i + 1);
                columnNameArray[i] = columnName;
                ColInfo ciId = new ColInfo(columnName, columnlbl, columnClz, null);
                drs.setColInfo(i + 1, ciId);
            }
            while (rs.next()) {
                drs.moveToInsertRow();
                for (i = 0; i < colCount; ++i) {
                    drs.updateObject(columnNameArray[i], rs.getObject(columnNameArray[i]));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    private Set getBankAcctIds(Context ctx, String bankAcctNum) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)bankAcctNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from t_bd_bank where 1=1");
        if (!StringUtils.isEmpty((String)bankAcctNum)) {
            if (bankAcctNum.indexOf(";") > 0) {
                sql.append(" and FNumber in (");
                String[] nums = bankAcctNum.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        sql.append(",");
                    }
                    sql.append(" '").append(nums[i].trim()).append("'");
                }
                sql.append(")");
            } else {
                sql.append(" and FNumber = '").append(bankAcctNum.trim()).append("'");
            }
        }
        HashSet<String> bankAcctIdSet = new HashSet<String>();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                if (rs.getString("FID") == null) continue;
                bankAcctIdSet.add(rs.getString("FID"));
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        if (bankAcctIdSet.size() > 0) {
            return bankAcctIdSet;
        }
        throw new CasDataException(CasDataException.NULL_ACCOUNTBANK);
    }

    private Set getCompanyIds(Context ctx, String companyNum) throws BOSException {
        if (EmptyUtil.isEmpty((String)companyNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(120);
        sql.append("select fid from t_org_company where (");
        if (companyNum.indexOf(";") > 0) {
            String[] nums = companyNum.split(";");
            for (int i = 0; i < nums.length; ++i) {
                if (i > 0) {
                    sql.append(" or ");
                }
                sql.append(" (FNumber = '").append(nums[i].trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%') ");
            }
        } else {
            sql.append(" FNumber = '").append(companyNum.trim()).append("'").append(" or FLongNumber like '").append(companyNum).append("!%' ").append(" or FLongNumber like '%!").append(companyNum).append("!%'");
        }
        sql.append(" ) and FIsOnlyUnion =0 ");
        sql.append(" order by FLongNumber asc");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashSet<String> idSet = new HashSet<String>();
            while (rs.next()) {
                idSet.add(rs.getString("fid"));
            }
            if (idSet.size() > 0) {
                return idSet;
            }
            return null;
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private Date getReportEndDate(ICalculateContextProvider context, Context ctx) {
        return (Date)context.getReportAdapter().getReportProperty("Report_EndDate");
    }

    private String getReportCompany(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getCompany_Number();
    }

    private String getReportCurrency(ICalculateContextProvider context, Context ctx) {
        return (String)context.getReportAdapter().getReportProperty("Currency.Number");
    }

    private Date getReportStartDate(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getReport_StartDate();
    }
}

