/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.fin.LoanEntryInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentTypeEnum;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowCollection;
import com.kingdee.eas.fm.mnt.ForecastedBlockingFlowInfo;
import com.kingdee.eas.fm.mnt.IForecastedBlockingFlowGenerator;
import com.kingdee.eas.fm.mnt.SourceTypeEnum;

public class LoanForecastedBlockingFlowGenerator
implements IForecastedBlockingFlowGenerator {
    private boolean flag = false;

    public ForecastedBlockingFlowCollection genForecastedBlockingFlowColl(Context ctx, String billId) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("entrys.*");
        selectors.add("entrys.BlockFlowType.id");
        selectors.add("company.id");
        selectors.add("company.name");
        selectors.add("Institution.id");
        selectors.add("Institution.name");
        selectors.add("GroupID.id");
        selectors.add("GroupID.name");
        LoanInfo srcInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(billId), selectors);
        ForecastedBlockingFlowCollection destColl = new ForecastedBlockingFlowCollection();
        String billTypeName = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityAlias(srcInfo.getId().toString());
        for (int i = 0; i < srcInfo.getEntrys().size(); ++i) {
            ForecastedBlockingFlowInfo destInfo = new ForecastedBlockingFlowInfo();
            LoanEntryInfo srcEntry = srcInfo.getEntrys().get(i);
            if (srcEntry.getBlockFlowType() == null && !DateUtil.getDayBegin().after(srcEntry.getDate())) continue;
            if (srcInfo.isHistoryBill() && srcInfo.getRepaymentType().equals((Object)RepaymentTypeEnum.SERIAL) && srcEntry.getAmount().equals(srcInfo.getAmount().subtract(srcInfo.getBalance())) && !this.flag) {
                this.flag = true;
                continue;
            }
            String number = srcInfo.getNumber() + "_" + i;
            destInfo.setNumber(number);
            destInfo.setBillId(srcInfo.getId().toString());
            destInfo.setCompany(srcInfo.getCompany());
            if (srcInfo.getInstitution() != null) {
                destInfo.setCounterPart(srcInfo.getInstitution().getName());
            }
            if (srcInfo.getGroupID() != null) {
                destInfo.setCounterPart(srcInfo.getGroupID().getName());
            }
            destInfo.setCurrency(srcInfo.getCurrency());
            destInfo.setDescription(billTypeName + srcInfo.getNumber());
            destInfo.setExchangeRate(srcInfo.getLocalCurExRate());
            destInfo.setIsInsider(srcInfo.isIsGroupLoan());
            destInfo.setRegion(srcInfo.getRegion());
            destInfo.setSourceType(SourceTypeEnum.system);
            destInfo.setIsInFlow(false);
            destInfo.setBlockFlowType(srcEntry.getBlockFlowType());
            destInfo.setAmount(srcEntry.getAmount());
            destInfo.setOriginalAmount(srcEntry.getAmount());
            destInfo.setExpectedDate(srcEntry.getDate());
            destColl.add(destInfo);
        }
        return destColl;
    }
}

