/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.nt.PayableBillFactory;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import java.util.Locale;

public class RepaymentBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        RepaymentInfo repaymentInfo = this.getRepaymentInfo(ctx, billId);
        String sourceBillId = repaymentInfo.getSourceBillId();
        Object srcBillInfo = null;
        if (FinancingBillTypeEnum.CommercialDraft == repaymentInfo.getSourceType() && !FMHelper.isEmpty((String)sourceBillId)) {
            srcBillInfo = PayableBillFactory.getLocalInstance((Context)ctx).getPayableBillInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        } else if (FinancingBillTypeEnum.LetterOfCredit == repaymentInfo.getSourceType() && !FMHelper.isEmpty((String)sourceBillId)) {
            srcBillInfo = LetterOfCreditFactory.getLocalInstance(ctx).getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        } else if (!(FinancingBillTypeEnum.Loan != repaymentInfo.getSourceType() && FinancingBillTypeEnum.BONDS != repaymentInfo.getSourceType() || FMHelper.isEmpty((String)sourceBillId))) {
            srcBillInfo = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectUuidPK(sourceBillId));
        }
        JournalCollection journalColl = new JournalCollection();
        this.addRepayAmtJournal(ctx, repaymentInfo, journalColl, 0, (CoreBillBaseInfo)srcBillInfo);
        if (repaymentInfo.getCautionAmt().compareTo(Constants.ZERO) != 0 && repaymentInfo.getAcutionAcctBank() != null) {
            this.addCautionAmtJournal(ctx, repaymentInfo, journalColl, (CoreBillBaseInfo)srcBillInfo);
        }
        return journalColl;
    }

    private void addCautionAmtJournal(Context ctx, RepaymentInfo repaymentInfo, JournalCollection journalColl, CoreBillBaseInfo srcBillInfo) throws BOSException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setAccountBank(repaymentInfo.getAcutionAcctBank());
        journalInfo.setCurrency(repaymentInfo.getMarginCurrency());
        journalInfo.setCreateDate(repaymentInfo.getBizDate());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setCreditAmount(repaymentInfo.getCautionAmt());
        journalInfo.setIsDebit(false);
        journalInfo.setBizDate(repaymentInfo.getBizDate());
        journalInfo.setAccountView(repaymentInfo.getAcutionAcctBank().getAccount());
        journalInfo.setOppAccountView(repaymentInfo.getLoanAcct());
        journalInfo.setBillType(BillTypeEnum.caution);
        journalInfo.setBillId(repaymentInfo.getId().toString());
        journalInfo.setBillNumber(repaymentInfo.getNumber());
        String des = "";
        des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"455_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"455_RepaymentBook4PayableNotifyBuilder");
        journalInfo.setDescription(des);
        journalInfo.setCompany(repaymentInfo.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        if (!FMHelper.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LetterOfCreditInfo) {
            LetterOfCreditInfo letterOfCreditInfo = (LetterOfCreditInfo)srcBillInfo;
            journalInfo.setSettlementType(this.getSettlementType(ctx, "55555555-5555-5555-5555-5555555555551C9A9013"));
            journalInfo.setSettlementNumber(letterOfCreditInfo.getNumber());
            String des1 = "";
            des1 = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder");
            journalInfo.setDescription(des1);
        }
        journalColl.add(journalInfo);
    }

    private void addRepayAmtJournal(Context ctx, RepaymentInfo repaymentInfo, JournalCollection journalColl, int type, CoreBillBaseInfo srcBillInfo) throws EASBizException, BOSException {
        if (repaymentInfo.getBankAcct() == null) {
            return;
        }
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setType(JournalTypeEnum.BANK);
        journalInfo.setCurrency(repaymentInfo.getCurrency());
        journalInfo.setDebitAmount(Constants.ZERO);
        journalInfo.setIsDebit(false);
        journalInfo.setCompany(repaymentInfo.getCompany());
        journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
        journalInfo.setSource(JournalSourceEnum.BYBILL);
        if (type == 0) {
            this.addRepaymentBillJournal(ctx, repaymentInfo, srcBillInfo, journalInfo);
        } else {
            this.addLoanInterestJournal(ctx, repaymentInfo, srcBillInfo, journalInfo);
        }
        if (journalInfo.getBillId() != null) {
            journalColl.add(journalInfo);
        }
    }

    private void addLoanInterestJournal(Context ctx, RepaymentInfo repaymentInfo, CoreBillBaseInfo srcBillInfo, JournalInfo journalInfo) throws BOSException, EASBizException {
        LoanInterestInfo info = this.getLoanInterestInfoByRepaymentBill(ctx, repaymentInfo);
        if (info == null || info.getAccount() == null) {
            return;
        }
        journalInfo.setBillId(info.getId().toString());
        journalInfo.setBillNumber(info.getNumber());
        journalInfo.setBizDate(info.getBizDate());
        journalInfo.setCreateDate(info.getBizDate());
        journalInfo.setAccountBank(info.getAccount());
        journalInfo.setCreditAmount(info.getRealInterest());
        journalInfo.setBillType(BillTypeEnum.intBill);
        journalInfo.setAccountView(info.getAccount().getAccount());
        if (!FMHelper.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LoanInfo) {
            journalInfo.setOppAccountView(info.getIntFeeAcctView());
            String des = "";
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"453_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"453_RepaymentBook4PayableNotifyBuilder");
            journalInfo.setDescription(des);
        } else if (!FMHelper.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof PayableBillInfo) {
            PayableBillInfo payableBill = (PayableBillInfo)srcBillInfo;
            journalInfo.setOppAccountView(payableBill.getBillAccount());
            journalInfo.setSettlementNumber(payableBill.getNumber());
            journalInfo.setSettlementType(this.getSettlementType(ctx, "66666666-6666-6666-6666-6666666666661C9A9013"));
            journalInfo.setOppUnit(payableBill.getPayeeName());
            String des = "";
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"454_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"454_RepaymentBook4PayableNotifyBuilder");
            journalInfo.setDescription(des);
        }
    }

    private void addRepaymentBillJournal(Context ctx, RepaymentInfo repaymentInfo, CoreBillBaseInfo srcBillInfo, JournalInfo journalInfo) throws BOSException {
        journalInfo.setBillId(repaymentInfo.getId().toString());
        journalInfo.setBillNumber(repaymentInfo.getNumber());
        journalInfo.setBizDate(repaymentInfo.getBizDate());
        journalInfo.setAccountBank(repaymentInfo.getBankAcct());
        journalInfo.setCreditAmount(repaymentInfo.getSourceAmount());
        journalInfo.setCreateDate(repaymentInfo.getBizDate());
        journalInfo.setBillType(BillTypeEnum.repaymentbill);
        journalInfo.setAccountView(repaymentInfo.getBankAcct().getAccount());
        if (!FMHelper.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LoanInfo) {
            journalInfo.setOppAccountView(repaymentInfo.getLoanAcct());
            String des = "";
            des = repaymentInfo.isIsBondsRepayment() ? EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"317_BondsRepaymentEditUI") : (ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"450_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"450_RepaymentBook4PayableNotifyBuilder"));
            journalInfo.setDescription(des);
        } else if (!FMHelper.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof PayableBillInfo) {
            PayableBillInfo payableBill = (PayableBillInfo)srcBillInfo;
            journalInfo.setOppAccountView(payableBill.getBillAccount());
            journalInfo.setSettlementNumber(payableBill.getNumber());
            journalInfo.setSettlementType(this.getSettlementType(ctx, "66666666-6666-6666-6666-6666666666661C9A9013"));
            journalInfo.setOppUnit(payableBill.getPayeeName());
            String des = "";
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"451_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"451_RepaymentBook4PayableNotifyBuilder");
            journalInfo.setDescription(des);
        } else if (!FMHelper.isEmpty((CoreBaseInfo)srcBillInfo) && srcBillInfo instanceof LetterOfCreditInfo) {
            LetterOfCreditInfo letterOfCreditInfo = (LetterOfCreditInfo)srcBillInfo;
            journalInfo.setSettlementType(this.getSettlementType(ctx, "55555555-5555-5555-5555-5555555555551C9A9013"));
            journalInfo.setSettlementNumber(letterOfCreditInfo.getNumber());
            String des = "";
            des = ctx != null ? ResourceBase.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder", (Locale)ctx.getLocale()) : EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"452_RepaymentBook4PayableNotifyBuilder");
            journalInfo.setDescription(des);
        }
    }

    private LoanInterestInfo getLoanInterestInfoByRepaymentBill(Context ctx, RepaymentInfo repaymentInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)repaymentInfo.getId().toString()));
        view.setSelector(this.getInterestSelectors());
        view.setFilter(filter);
        LoanInterestCollection colls = LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(view);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)colls) || colls.size() == 0) {
            return null;
        }
        return colls.get(0);
    }

    private SelectorItemCollection getInterestSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("account.id");
        sic.add("account.account");
        return sic;
    }

    private RepaymentInfo getRepaymentInfo(Context ctx, String billId) throws EASBizException, BOSException {
        RepaymentInfo info = RepaymentFactory.getLocalInstance(ctx).getRepaymentInfo((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        return info;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("InterestAcct.id");
        sic.add("InterestAcct.name");
        sic.add("InterestAcct.number");
        sic.add("LoanAcct.id");
        sic.add("LoanAcct.name");
        sic.add("LoanAcct.number");
        sic.add("BankAcct.id");
        sic.add("BankAcct.name");
        sic.add("BankAcct.number");
        sic.add("BankAcct.account.id");
        sic.add("BankAcct.account.name");
        sic.add("BankAcct.account.number");
        sic.add("acutionAcctBank.account.id");
        sic.add("acutionAcctBank.account.number");
        sic.add("acutionAcctBank.account.name");
        return sic;
    }

    private SettlementTypeInfo getSettlementType(Context ctx, String ntTypeID) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("ntType", (Object)ntTypeID));
        view.setFilter(filter);
        SettlementTypeCollection coll = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        SettlementTypeInfo type = null;
        if (coll != null && coll.size() == 1) {
            type = coll.get(0);
        }
        return type;
    }
}

