/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

public class RptLetterOfCreditDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = 2569551756907096879L;
    Set companyIdSet;
    Set bankIdSet;
    Date dateFrom;
    Date dateTo;
    int unit1;
    BigDecimal amount;
    int dimType;
    String letterStatus;

    public String getLetterStatus() {
        return this.letterStatus;
    }

    public void setLetterStatus(String letterStatus) {
        this.letterStatus = letterStatus;
    }

    public FilterInfo getFilter() {
        CompanyOrgUnitInfo companyif = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        if (this.getBankIdSet() != null && this.getBankIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Institution.id", (Object)this.getBankIdSet(), CompareType.INCLUDE));
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyif) && companyif != null) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("company.id", (Object)companyif.getId().toString(), CompareType.EQUALS));
        }
        if (this.getDateFrom() != null) {
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)DateTimeUtils.truncateDate((Date)this.getDateFrom()), CompareType.GREATER_EQUALS));
        }
        if (this.getDateTo() != null) {
            filterCollection.add(new FilterItemInfo("IssueDate", (Object)DateTimeUtils.truncateDate((Date)this.getDateTo()), CompareType.LESS_EQUALS));
        }
        if (this.getAmount() != null) {
            int intUnit = this.getUnit().getValue();
            BigDecimal bdUnit = new BigDecimal(String.valueOf(intUnit));
            filterCollection.add(new FilterItemInfo("Amount", (Object)this.getAmount().multiply(bdUnit), CompareType.GREATER_EQUALS));
        }
        this.setLetterStatus("0");
        filterCollection.add(new FilterItemInfo("LetterStatus", (Object)this.getLetterStatus(), CompareType.EQUALS));
        return filter;
    }

    public SorterItemCollection getSorterItems() {
        SorterItemCollection sorter = new SorterItemCollection();
        switch (this.getDimType()) {
            case 1: {
                sorter.add(new SorterItemInfo("company.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            case 2: {
                sorter.add(new SorterItemInfo("Institution.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            case 3: {
                sorter.add(new SorterItemInfo("Currency.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            case 4: {
                sorter.add(new SorterItemInfo("GaranteeType.id"));
                sorter.add(new SorterItemInfo("number"));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalidate getOrderType");
            }
        }
        return sorter;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Set getBankIdSet() {
        return this.bankIdSet;
    }

    public void setBankIdSet(Set bankIdSet) {
        this.bankIdSet = bankIdSet;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date dateFrom) {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }

    public int getDimType() {
        return this.dimType;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unit1);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unit1 = unit == null ? -1 : unit.getValue();
    }
}

