/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin;

import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.fin.CycleTypeEnum;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;

public class RptRepaymentDetailFilterParam
implements FilterParam {
    private static final long serialVersionUID = -7717093513647814198L;
    private Set companyIdSet;
    private int unit1;
    private BigDecimal amount;
    private int timeType1;
    private Integer timeNumber;
    private Date currentDate;
    private String loanProperty1;
    private Set loanerIds;
    private Set financingProductIds;
    private Set projectIds;
    private int forcastType;
    private boolean isContainBond;

    public FilterInfo getFilter() {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterCollection = filter.getFilterItems();
        CompanyOrgUnitInfo companyif = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (GLUtil.isCompanyUnion((CompanyOrgUnitInfo)companyif) && companyif != null && this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Company.id", (Object)this.getCompanyIdSet(), CompareType.INCLUDE));
        } else if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterCollection.add(new FilterItemInfo("Company.id", (Object)companyif.getId().toString(), CompareType.EQUALS));
        }
        int addNumber = this.getTimeNumber();
        GregorianCalendar startDateQuery = new GregorianCalendar();
        startDateQuery.setTime(this.getCurrentDate());
        GregorianCalendar endDateQuery = new GregorianCalendar();
        endDateQuery.setTime(this.getCurrentDate());
        if (this.getTimeType().getName().equals(CycleTypeEnum.YEAR.getName())) {
            endDateQuery.add(1, addNumber);
        }
        if (this.getTimeType().getName().equals(CycleTypeEnum.QUARTER.getName())) {
            endDateQuery.add(2, 3 * addNumber);
        }
        if (this.getTimeType().getName().equals(CycleTypeEnum.MONTH.getName())) {
            endDateQuery.add(2, addNumber);
        }
        Date startQueryDate = startDateQuery.getTime();
        Date endQueryDate = endDateQuery.getTime();
        filterCollection.add(new FilterItemInfo("date", (Object)DateUtil.getDayBegin((Date)endQueryDate), CompareType.LESS_EQUALS));
        filterCollection.add(new FilterItemInfo("date", (Object)DateUtil.getDayBegin((Date)startQueryDate), CompareType.GREATER_EQUALS));
        if (this.getAmount() != null) {
            int intUnit = this.getUnit().getValue();
            filterCollection.add(new FilterItemInfo("LocalAmount", (Object)this.getAmount().multiply(new BigDecimal(String.valueOf(intUnit))), CompareType.GREATER_EQUALS));
        }
        return filter;
    }

    public boolean isContainBond() {
        return this.isContainBond;
    }

    public void setContainBond(boolean isContainBond) {
        this.isContainBond = isContainBond;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Set getCompanyIdSet() {
        return this.companyIdSet;
    }

    public void setCompanyIdSet(Set companyIdSet) {
        this.companyIdSet = companyIdSet;
    }

    public Integer getTimeNumber() {
        return this.timeNumber;
    }

    public void setTimeNumber(Integer timeNumber) {
        this.timeNumber = timeNumber;
    }

    public CycleTypeEnum getTimeType() {
        return CycleTypeEnum.getEnum(this.timeType1);
    }

    public void setTimeType(CycleTypeEnum timeType) {
        this.timeType1 = timeType == null ? -1 : timeType.getValue();
    }

    public AmountUnitEnum getUnit() {
        return AmountUnitEnum.getEnum((int)this.unit1);
    }

    public void setUnit(AmountUnitEnum unit) {
        this.unit1 = unit == null ? -1 : unit.getValue();
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public Set getFinancingProductIds() {
        return this.financingProductIds;
    }

    public void setFinancingProductIds(Set financingProductIds) {
        this.financingProductIds = financingProductIds;
    }

    public Set getLoanerIds() {
        return this.loanerIds;
    }

    public void setLoanerIds(Set loanerIds) {
        this.loanerIds = loanerIds;
    }

    public LoanPropertyEnum getLoanProperty() {
        return LoanPropertyEnum.getEnum(this.loanProperty1);
    }

    public void setLoanProperty(LoanPropertyEnum loanProperty) {
        this.loanProperty1 = loanProperty == null ? null : loanProperty.getValue();
    }

    public Set getProjectIds() {
        return this.projectIds;
    }

    public void setProjectIds(Set projectIds) {
        this.projectIds = projectIds;
    }

    public int getForcastType() {
        return this.forcastType;
    }

    public void setForcastType(int forcastType) {
        this.forcastType = forcastType;
    }
}

