/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.AbstractUIFactory;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.botp.client.BOTMappingSelectUI;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.uiframe.client.UIFixTab;
import com.kingdee.eas.base.uiframe.client.UINewTab;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.CasPaymentBillListUI;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.EJBAccessFactory;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.fin.LoanContractInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.client.BondsContractEditUI;
import com.kingdee.eas.fm.fin.client.BondsContractListUI;
import com.kingdee.eas.fm.fin.client.BondsEditUI;
import com.kingdee.eas.fm.fin.client.BondsListUI;
import com.kingdee.eas.fm.fin.client.BondsRepaymentEditUI;
import com.kingdee.eas.fm.nt.client.IBotEditUI;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BondClientHelper {
    public static void generateDestBillWithCU(CtrlUnitInfo cu, CoreBillListUI owner, String srcBosType, String destBosType, String billId) throws Exception {
        String openType = owner != null && owner.getUIWindow() instanceof UINewTab ? "com.kingdee.eas.base.uiframe.client.UINewTabFactory" : (owner != null && owner.getUIWindow() instanceof UIFixTab ? "com.kingdee.eas.base.uiframe.client.UIFixTabFactory" : "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        BondClientHelper.generateDestBillWithCU(cu, owner, srcBosType, destBosType, billId, openType);
    }

    public static void generateDestBillWithCU(CtrlUnitInfo cu, CoreBillListUI owner, String srcBosType, String destBosType, String billId, String openType) throws Exception {
        CoreBillBaseInfo billInfo = (CoreBillBaseInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(billId, owner.getBOTPSelectors());
        CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
        billCollection.add(billInfo);
        BondClientHelper.innerGenerateDestBillWithSelection(cu, owner, srcBosType, destBosType, billCollection, openType);
    }

    private static void innerGenerateDestBillWithSelection(CtrlUnitInfo cu, CoreBillListUI owner, String srcBosType, String destBosType, CoreBillBaseCollection srcBillCollection, String openType) throws Exception {
        IBOTMapping botMapping = BOTMappingFactory.getRemoteInstance();
        CoreBillBaseInfo billInfo = srcBillCollection.get(0);
        owner.beforeTransform((IObjectCollection)srcBillCollection, destBosType);
        BOTMappingInfo botMappingInfo = BondClientHelper.getBotMappingInfoWithSelection(cu, srcBosType, destBosType, botMapping, billInfo);
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        BTPTransformResult btpResult = null;
        String[] ids = new String[srcBillCollection.size()];
        for (int i = 0; i < srcBillCollection.size(); ++i) {
            CoreBillBaseInfo info = srcBillCollection.get(i);
            ids[i] = info.getId().toString();
        }
        btpResult = iBTPManager.transformForBotp(ids, new String[]{owner.getEntriesName()}, new ArrayList(), BondClientHelper.getBotpSelectors(botMappingInfo, destBosType, iBTPManager), destBosType, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()), srcBosType);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        int showUIMode = botMappingInfo.getIsShowEditUI();
        if (showUIMode == 1) {
            BondClientHelper.showEditUIForBotMapping(owner, destBosType, openType, billInfo, iBTPManager, destBillCols, botRelationCols);
        } else {
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                iBTPManager.submitRelations(destBillInfo, botRelationCols);
            }
        }
    }

    private static BOTMappingInfo getBotMappingInfoWithSelection(CtrlUnitInfo cu, String srcBosType, String destBosType, IBOTMapping botMapping, CoreBillBaseInfo billInfo) throws BOSException, BOTPException, FMException {
        BOTMappingInfo botMappingInfo = null;
        if (cu == null) {
            botMappingInfo = botMapping.getMapping(billInfo, destBosType, DefineSysEnum.BTP);
        } else {
            HashMap<String, CtrlUnitInfo> transmitContext = new HashMap<String, CtrlUnitInfo>();
            transmitContext.put("TRANSMITCU", cu);
            BOTMappingCollection btps = botMapping.getMappingCollectionForSelectUseRuleFilter(srcBosType, destBosType, DefineSysEnum.BTP, transmitContext, null, null, null, null);
            if (btps.size() == 0) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"210_BondClientHelper")});
            }
            HashMap<String, BOTMappingCollection> uiContext = new HashMap<String, BOTMappingCollection>();
            uiContext.put("BOTMappings", btps);
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow window = uiFactory.create("com.kingdee.eas.base.botp.client.BOTMappingSelectUI", uiContext, null);
            window.show();
            botMappingInfo = ((BOTMappingSelectUI)window.getUIObject()).getSelectBotMappingInfo();
        }
        if (botMappingInfo == null) {
            throw new FMException(FMException.NODESTBILL);
        }
        return botMappingInfo;
    }

    private static SelectorItemCollection getBotpSelectors(BOTMappingInfo botMappingInfo, String destBillTypeBOSType, IBTPManager iBTPManager) throws Exception {
        SelectorItemCollection botpSelectors = new SelectorItemCollection();
        if (botMappingInfo.getIsTempSave() != 2) {
            botpSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)botMappingInfo);
        } else {
            String destBillEditUIClassName = iBTPManager.getEntityObjectInfoExtendPro(destBillTypeBOSType, "editUI");
            if (!StringUtils.isEmpty((String)destBillEditUIClassName)) {
                try {
                    Class<?> c = null;
                    try {
                        c = Class.forName(destBillEditUIClassName + "CTEx", false, AbstractUIFactory.class.getClassLoader());
                    }
                    catch (ClassNotFoundException ex) {
                        try {
                            c = Class.forName(destBillEditUIClassName + "PIEx", false, AbstractUIFactory.class.getClassLoader());
                        }
                        catch (ClassNotFoundException _) {
                            c = Class.forName(destBillEditUIClassName);
                        }
                    }
                    IUIObject uiObj = (IUIObject)c.newInstance();
                    if (uiObj instanceof EditUI) {
                        botpSelectors = ((EditUI)uiObj).getSelectors();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return botpSelectors;
    }

    private static void showEditUIForBotMapping(CoreBillListUI owner, String destBosType, String openType, CoreBillBaseInfo billInfo, IBTPManager iBTPManager, IObjectCollection destBillCols, BOTRelationCollection botRelationCols) throws BOSException, BTPException, EASBizException, UIException, Exception {
        String destBillEditUIClassName = iBTPManager.getEntityObjectInfoExtendPro(destBosType, "editUI");
        if (destBosType.equals(LoanContractInfo.BOSTYPE.toString())) {
            destBillEditUIClassName = BondsContractEditUI.class.getName();
        }
        if (destBosType.equals(LoanInfo.BOSTYPE.toString())) {
            destBillEditUIClassName = BondsEditUI.class.getName();
        }
        UIContext map = owner != null && owner.getUIWindow() instanceof UINewTab ? new UIContext((Object)owner) : new UIContext((Object)owner);
        map.put("srcBillID", billInfo.getId().toString());
        map.put("BOTPViewStatus", new Integer(1));
        if (owner instanceof CasPaymentBillListUI) {
            String[] srcPaymentIds = ((CasPaymentBillListUI)owner).getSelectedListId();
            map.put("srcPaymentIds", srcPaymentIds);
        }
        map.put("fmtype", "createTo");
        IUIWindow uiWindow = null;
        if (destBillCols.size() > 1) {
            RealModeIDList idList = RealModeIDList.getEmptyIDList();
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                iBTPManager.saveRelations(destBillInfo, botRelationCols);
                idList.add(destBillInfo.getId().toString());
            }
            idList.setCurrentIndex(0);
            map.put("ID", idList.getCurrentID());
            map.put("IDList", idList);
            uiWindow = UIFactory.createUIFactory((String)openType).create(destBillEditUIClassName, (Map)map, null, OprtState.EDIT);
        } else {
            IObjectValue dataObject = destBillCols.getObject(0);
            map.put("InitDataObject", dataObject);
            map.put("BOTPUIParam", "test");
            uiWindow = UIFactory.createUIFactory((String)openType).create(destBillEditUIClassName, (Map)map, null, OprtState.ADDNEW);
            IUIObject uiObject = uiWindow.getUIObject();
            if (uiObject instanceof IBotEditUI) {
                ((IBotEditUI)uiObject).initDataObject(dataObject);
            }
            if (uiWindow.getUIObject().getDataObject() == null || uiWindow.getUIObject().getDataObject().get("id") == null || !uiWindow.getUIObject().getDataObject().get("id").toString().equals(dataObject.get("id").toString())) {
                uiObject.setDataObject(dataObject);
                uiObject.loadFields();
            }
            ((CoreBillEditUI)uiWindow.getUIObject()).setMakeRelations(botRelationCols);
        }
        uiWindow.show();
    }

    public static void generateDestBillForCompany(String companyid, CoreBillListUI owner, String srcBosType, String destBosType, String billId) throws Exception {
        String openType = owner != null && owner.getUIWindow() instanceof UINewTab ? "com.kingdee.eas.base.uiframe.client.UINewTabFactory" : (owner != null && owner.getUIWindow() instanceof UIFixTab ? "com.kingdee.eas.base.uiframe.client.UIFixTabFactory" : "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        CoreBillBaseInfo billInfo = (CoreBillBaseInfo)EJBAccessFactory.createRemoteInstance().getEntityInfo(billId, owner.getBOTPSelectors());
        CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
        billCollection.add(billInfo);
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo(ConvertUtils.PK((Object)companyid), ConvertUtils.SIC((Object[])new Object[]{"cu.*"}));
        BondClientHelper.innerGenerateDestBill(company.getCU(), owner, srcBosType, destBosType, billCollection, openType);
    }

    private static void innerGenerateDestBill(CtrlUnitInfo cu, CoreBillListUI owner, String srcBosType, String destBosType, CoreBillBaseCollection srcBillCollection, String openType) throws Exception {
        IBOTMapping botMapping = BOTMappingFactory.getRemoteInstance();
        CoreBillBaseInfo billInfo = srcBillCollection.get(0);
        owner.beforeTransform((IObjectCollection)srcBillCollection, destBosType);
        BOTMappingInfo botMappingInfo = BondClientHelper.getBotMappingInfoWithSelection(cu, srcBosType, destBosType, botMapping, billInfo);
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        BTPTransformResult btpResult = null;
        String[] ids = new String[srcBillCollection.size()];
        for (int i = 0; i < srcBillCollection.size(); ++i) {
            CoreBillBaseInfo info = srcBillCollection.get(i);
            ids[i] = info.getId().toString();
        }
        btpResult = iBTPManager.transformForBotp(ids, new String[]{owner.getEntriesName()}, new ArrayList(), BondClientHelper.getBotpSelectors(botMappingInfo, destBosType, iBTPManager), destBosType, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()), srcBosType);
        IObjectCollection destBillCols = btpResult.getBills();
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        int showUIMode = botMappingInfo.getIsShowEditUI();
        if (showUIMode == 1) {
            BondClientHelper.showEditUIForBotMapping(owner, destBosType, openType, billInfo, iBTPManager, destBillCols, botRelationCols, true);
        } else {
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                iBTPManager.submitRelations(destBillInfo, botRelationCols);
            }
        }
    }

    private static void showEditUIForBotMapping(CoreBillListUI owner, String destBosType, String openType, CoreBillBaseInfo billInfo, IBTPManager iBTPManager, IObjectCollection destBillCols, BOTRelationCollection botRelationCols, boolean isRePayment) throws BOSException, BTPException, EASBizException, UIException, Exception {
        String destBillEditUIClassName = iBTPManager.getEntityObjectInfoExtendPro(destBosType, "editUI");
        UIContext map = owner != null && owner.getUIWindow() instanceof UINewTab ? new UIContext((Object)owner) : new UIContext((Object)owner);
        if (owner instanceof BondsListUI) {
            new RepaymentInfo();
            if (destBosType.equals(RepaymentInfo.BOSTYPE.toString())) {
                destBillEditUIClassName = BondsRepaymentEditUI.class.getName();
            }
        }
        if (owner instanceof BondsContractListUI) {
            new LoanInfo();
            if (destBosType.equals(LoanInfo.BOSTYPE)) {
                destBillEditUIClassName = BondsEditUI.class.getName();
            }
        }
        map.put("srcBillID", billInfo.getId().toString());
        map.put("BOTPViewStatus", new Integer(1));
        if (owner instanceof CasPaymentBillListUI) {
            String[] srcPaymentIds = ((CasPaymentBillListUI)owner).getSelectedListId();
            map.put("srcPaymentIds", srcPaymentIds);
        }
        map.put("fmtype", "createTo");
        IUIWindow uiWindow = null;
        if (destBillCols.size() > 1) {
            RealModeIDList idList = RealModeIDList.getEmptyIDList();
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                iBTPManager.saveRelations(destBillInfo, botRelationCols);
                idList.add(destBillInfo.getId().toString());
            }
            idList.setCurrentIndex(0);
            map.put("ID", idList.getCurrentID());
            map.put("IDList", idList);
            uiWindow = UIFactory.createUIFactory((String)openType).create(destBillEditUIClassName, (Map)map, null, OprtState.EDIT);
        } else {
            IObjectValue dataObject = destBillCols.getObject(0);
            map.put("InitDataObject", dataObject);
            map.put("BOTPUIParam", "test");
            uiWindow = UIFactory.createUIFactory((String)openType).create(destBillEditUIClassName, (Map)map, null, OprtState.ADDNEW);
            IUIObject uiObject = uiWindow.getUIObject();
            if (uiObject instanceof IBotEditUI) {
                ((IBotEditUI)uiObject).initDataObject(dataObject);
            }
            if (uiWindow.getUIObject().getDataObject() == null || uiWindow.getUIObject().getDataObject().get("id") == null || !uiWindow.getUIObject().getDataObject().get("id").toString().equals(dataObject.get("id").toString())) {
                uiObject.setDataObject(dataObject);
                uiObject.loadFields();
            }
            ((CoreBillEditUI)uiWindow.getUIObject()).setMakeRelations(botRelationCols);
        }
        uiWindow.show();
    }
}

