/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataParameter;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.ILoanInterest;
import com.kingdee.eas.fm.fin.LoanFacadeFactory;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.StatusExtEnum;
import com.kingdee.eas.fm.fin.StrikeEnum;
import com.kingdee.eas.fm.fin.client.AbstractBondInterestListUI;
import com.kingdee.eas.fm.fin.client.BondInterestEditUI;
import com.kingdee.eas.fm.fin.client.BondInterestFilterParam;
import com.kingdee.eas.fm.fin.client.BondInterestFilterUI;
import com.kingdee.eas.fm.fin.client.CalInterestBondUI;
import com.kingdee.eas.fm.fin.client.FinListProcessUtils;
import com.kingdee.eas.fm.fin.client.LoanInterestQueryProcessor;
import com.kingdee.eas.fm.fin.client.PreInterestBondUI;
import com.kingdee.eas.fm.fin.client.RecInterestBondUI;
import com.kingdee.eas.fm.im.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BondInterestListUI
extends AbstractBondInterestListUI {
    private static final Logger logger = CoreUIObject.getLogger(BondInterestListUI.class);
    private Map hm = null;
    private Set setIDs;
    boolean isEnterByPreInt = false;
    private CompanyOrgUnitInfo currentCompany;
    private BondInterestFilterUI filterUI;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    private static Integer preInt = new Integer(0);
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    public static final String LOANINTEREST_FILENAME = "/FM/IM/LOANINTEREST";

    public BondInterestListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)new FillListener());
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionPreInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionReceiveInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inquirebudget"));
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        int val = ctxHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_discount"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_canceldiscount"));
        boolean isBillBook = val == 0;
        this.actionBook.setVisible(isBillBook);
        this.actionCancelBook.setVisible(isBillBook);
        this.btnCancelCancel.setVisible(false);
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionBatchSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionGenPayBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionTDPrint.setEnabled(true);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BondInterestFilterUI();
        }
        return this.filterUI;
    }

    protected void checkOnlyUnion() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            this.btnVoucher.setVisible(false);
            this.btnDelVoucher.setVisible(false);
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
        }
    }

    public void onLoad() throws Exception {
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1 && uiParam != null) {
            this.licenseService.checkLicence();
            if (uiParam.equals("DBCKICKFROMRECINT")) {
                this.checkHasNumber();
                this.hm = RecInterestBondUI.showRecInterestBondUI((CoreUI)this);
                this.setIDs = (Set)this.hm.get("createdID");
                if (EmptyUtil.isEmpty((Collection)this.setIDs)) {
                    SysUtil.abort();
                }
            } else if (uiParam.equals("DBCLICKPREINT")) {
                this.checkHasNumber();
                this.hm = PreInterestBondUI.showPreInterestBondUI((CoreUI)this);
                this.isEnterByPreInt = true;
                this.setIDs = (Set)this.hm.get("createdID");
                if (EmptyUtil.isEmpty((Collection)this.setIDs)) {
                    SysUtil.abort();
                }
            } else if (uiParam.equals("CALCULATE")) {
                this.checkHasNumber();
                this.hm = CalInterestBondUI.showCalInterestBondUI((CoreUI)this);
                this.isEnterByPreInt = true;
                this.setIDs = (Set)this.hm.get("createdID");
                if (EmptyUtil.isEmpty((Collection)this.setIDs)) {
                    SysUtil.abort();
                }
            }
        }
        super.onLoad();
        this.checkOnlyUnion();
        this.tblMain.getColumn("intCurrencyRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn("intCurrencyAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.actionPreInt.setVisible(true);
        this.actionPreInt.setEnabled(true);
        this.actionReceiveInt.setVisible(true);
        this.actionReceiveInt.setEnabled(true);
        this.actionBatchSubmit.setVisible(true);
        this.actionBatchSubmit.setEnabled(true);
        this.actionAudit.setVisible(true);
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setVisible(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionRemove.setVisible(true);
        this.actionRemove.setEnabled(true);
        this.actionEdit.setVisible(true);
        this.actionEdit.setEnabled(true);
        this.tblMain.getColumn("beginDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.initButton(uiParam);
    }

    private void initButton(String uiParam) {
        if (uiParam != null && uiParam.equals("CALCULATE")) {
            this.actionAddNew.setVisible(false);
            this.actionCloudFeed.setVisible(false);
            this.actionCloudFeed.setVisible(false);
            this.actionXunTongFeed.setVisible(false);
            this.actionEdit.setVisible(false);
            this.actionRemove.setVisible(false);
            this.actionQuery.setVisible(false);
            this.actionLocate.setVisible(false);
            this.actionAttachment.setVisible(false);
            this.actionPageSetup.setVisible(false);
            this.actionCreateTo.setVisible(false);
            this.actionViewBdgBalance.setVisible(false);
            this.actionCopyTo.setVisible(false);
            this.actionQueryScheme.setVisible(false);
            this.actionBatchSubmit.setVisible(false);
            this.actionAudit.setVisible(false);
            this.actionPreInt.setVisible(false);
            this.actionReceiveInt.setVisible(false);
            this.actionNumberSign.setVisible(false);
            this.actionBook.setVisible(false);
            this.actionGenPayBill.setVisible(false);
            this.actionTraceUp.setVisible(false);
            this.actionPCVoucher.setVisible(false);
            this.actionTraceDown.setVisible(false);
            this.actionDelPCVoucher.setVisible(false);
            this.actionWorkFlowG.setVisible(false);
            this.actionWorkflowList.setVisible(false);
            this.actionSignature.setVisible(false);
            this.actionVoucher.setVisible(false);
            this.actionDelVoucher.setVisible(false);
            this.actionMultiapprove.setVisible(false);
            this.actionNextPerson.setVisible(false);
            this.actionAuditResult.setVisible(false);
            this.actionCancel.setVisible(false);
            this.actionCancelCancel.setVisible(false);
            this.actionViewDoProccess.setVisible(false);
            this.actionViewBgBalance.setVisible(false);
            this.actionAntiAudit.setVisible(false);
            this.actionCancelBook.setVisible(false);
            this.btnPrint.setVisible(false);
            this.btnPrintPreview.setVisible(false);
            this.btnTDPrint.setVisible(false);
            this.btnTDPrintPreview.setVisible(false);
        }
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new LoanInterestInfo(), this.currentCompany.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LoanInterestFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return BondInterestEditUI.class.getName();
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.isEnterByPreInt = false;
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionPreInt_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasNumber();
        if (this.isEnterByPreInt) {
            boolean hasSavedBill;
            FilterInfo filt = new FilterInfo();
            filt.getFilterItems().add(new FilterItemInfo("statusextenum", (Object)new Integer(-1)));
            this.mainQuery.getFilter().mergeFilter(filt, "AND");
            LoanInterestCollection col = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(this.mainQuery);
            boolean bl = hasSavedBill = col.size() > 0;
            if (hasSavedBill) {
                boolean isSave;
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"319_LoanInterestListUI"));
                boolean bl2 = isSave = result == 1;
                if (isSave) {
                    return;
                }
                FilterInfo f = new FilterInfo();
                f.getFilterItems().add(new FilterItemInfo("statusextenum", (Object)new Integer(-1)));
                this.mainQuery.getFilter().mergeFilter(f, "AND");
                LoanInterestFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                this.refreshList();
                this.isEnterByPreInt = true;
            }
        }
        this.hm = PreInterestBondUI.showPreInterestBondUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdID");
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.isEnterByPreInt = true;
            this.refresh(e);
        }
    }

    @Override
    public void actionReceiveInt_actionPerformed(ActionEvent e) throws Exception {
        this.checkHasNumber();
        if (this.isEnterByPreInt) {
            boolean hasSavedBill;
            FilterInfo filt = new FilterInfo();
            filt.getFilterItems().add(new FilterItemInfo("statusextenum", (Object)new Integer(-1)));
            this.mainQuery.getFilter().mergeFilter(filt, "AND");
            LoanInterestCollection col = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(this.mainQuery);
            boolean bl = hasSavedBill = col.size() > 0;
            if (hasSavedBill) {
                boolean isSave;
                int result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"319_LoanInterestListUI"));
                boolean bl2 = isSave = result == 1;
                if (isSave) {
                    return;
                }
                FilterInfo f = new FilterInfo();
                f.getFilterItems().add(new FilterItemInfo("statusextenum", (Object)new Integer(-1)));
                this.mainQuery.getFilter().mergeFilter(f, "AND");
                LoanInterestFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                this.refreshList();
                this.isEnterByPreInt = false;
            }
        }
        this.hm = RecInterestBondUI.showRecInterestBondUI((CoreUI)this);
        this.setIDs = (Set)this.hm.get("createdID");
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
            this.refresh(e);
        }
    }

    private String parseValue(Set setIDs) {
        StringBuffer returnSb = new StringBuffer();
        Object[] ids = setIDs.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                returnSb.append(ids[i].toString());
                continue;
            }
            returnSb.append(ids[i].toString()).append(",");
        }
        return returnSb.toString();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("endDate"));
        view.setSelector(sic);
        LoanInterestCollection colls = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LoanInterestInfo intBillInfo = colls.get(i);
            this.checkFinalCheckout(intBillInfo.getEndDate());
            boolean hasWf = FMHelper.hasWFInstance(null, (String)intBillInfo.getId().toString());
            if (!hasWf || intBillInfo.getStatusExtEnum().equals((Object)StatusExtEnum.SAVE)) continue;
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ctl.CTLAutoGenerateResource", (String)"97_GuaranteeApplyListUI"));
            this.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanbEdit();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanbEdit() throws Exception {
        this.checkSelected();
        LoanInterestInfo info = LoanInterestFactory.getRemoteInstance().getLoanInterestInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        this.checkFinalCheckout(info.getEndDate());
        if (info.getStrikeStatus() != null && info.getStrikeStatus() == StrikeEnum.STRIKED) {
            throw new FinBizException(FinBizException.LOANINTEREST_STRIKED_ERROR);
        }
        if (info.isFivouchered()) {
            throw new CHLoanException(CHLoanException.LOANINTBILL_EDIT_ERROR1);
        }
        if (info.getCashier() != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"212_BondInterestListUI"));
            SysUtil.abort();
        }
        if (info.isIsGenPayBill()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"324_LoanInterestListUI"));
            this.abort();
        }
        if (info.getStatusExtEnum() == StatusExtEnum.AUDIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"213_BondInterestListUI"));
            this.abort();
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = null;
        if (this.setIDs == null) {
            filter = super.getDefaultFilterForQuery();
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.parseValue(this.setIDs), CompareType.INCLUDE));
        }
        return filter;
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            LoanInterestInfo info = ((ILoanInterest)this.getBizInterface()).getLoanInterestInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
            FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.LoanInterest", null, (IObjectValue)info);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("fpItem.id"));
        sic.add(new SelectorItemInfo("fpItem.number"));
        sic.add(new SelectorItemInfo("fpItem.name"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        return sic;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("entrys.beginDate"));
        sic.add(new SelectorItemInfo("entrys.endDate"));
        sic.add(new SelectorItemInfo("entrys.days"));
        sic.add(new SelectorItemInfo("entrys.amount"));
        sic.add(new SelectorItemInfo("entrys.intRate"));
        sic.add(new SelectorItemInfo("entrys.interest"));
        sic.add(new SelectorItemInfo("entrys.daysOverdue"));
        sic.add(new SelectorItemInfo("entrys.punishIntRate"));
        sic.add(new SelectorItemInfo("entrys.punishInterest"));
        sic.add(new SelectorItemInfo("entrys.*"));
        sic.add(new SelectorItemInfo("entrys.id"));
        sic.add(new SelectorItemInfo("entrys.seq"));
        sic.add(new SelectorItemInfo("entrys.yearDays"));
        sic.add(new SelectorItemInfo("entrys.intRateTypeExpression"));
        sic.add(new SelectorItemInfo("interestType"));
        sic.add(new SelectorItemInfo("loan.*"));
        sic.add(new SelectorItemInfo("creditorAsCompany.id"));
        sic.add(new SelectorItemInfo("creditorAsCompany.name"));
        sic.add(new SelectorItemInfo("creditorAsCompany.number"));
        sic.add(new SelectorItemInfo("creditorAsBank.id"));
        sic.add(new SelectorItemInfo("creditorAsBank.name"));
        sic.add(new SelectorItemInfo("creditorAsBank.number"));
        sic.add(new SelectorItemInfo("account.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("beginDate"));
        sic.add(new SelectorItemInfo("endDate"));
        sic.add(new SelectorItemInfo("days"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("intRateTypeExpression"));
        sic.add(new SelectorItemInfo("intRate"));
        sic.add(new SelectorItemInfo("interest"));
        sic.add(new SelectorItemInfo("realInterest"));
        sic.add(new SelectorItemInfo("daysOverdue"));
        sic.add(new SelectorItemInfo("punishIntType"));
        sic.add(new SelectorItemInfo("punishIntRate"));
        sic.add(new SelectorItemInfo("punishInterest"));
        sic.add(new SelectorItemInfo("realPunishInterest"));
        sic.add(new SelectorItemInfo("strikeAmount"));
        sic.add(new SelectorItemInfo("exchange"));
        sic.add(new SelectorItemInfo("intFeeAcctView.id"));
        sic.add(new SelectorItemInfo("intFeeAcctView.name"));
        sic.add(new SelectorItemInfo("intFeeAcctView.number"));
        sic.add(new SelectorItemInfo("repayment.*"));
        sic.add(new SelectorItemInfo("repayment.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("statusExtEnum"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("cashier.id"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("cashier.number"));
        sic.add(new SelectorItemInfo("accountant.id"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("accountant.number"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        return sic;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        String[] keys = new String[]{"loan.number", "company.name"};
        return keys;
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        IColumn intRateColumn = tblMain.getColumn("intRate");
        intRateColumn.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        intRateColumn.getStyleAttributes().setNumberFormat("%r{#,##0.0000}f");
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            BizEnumValueDTO strikeStatus;
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell(this.getCurrencyIdColName()).getValue();
            if (currencyId != null) {
                String[] formatCol = this.getPrecColName();
                for (int j = 0; j < formatCol.length; ++j) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
                }
            }
            if (row.getCell("intRateTypeExpression") != null) {
                String intRateTypeExp = row.getCell("intRateTypeExpression").getValue().toString();
                if (EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"480_CompDepositAccountBillListUI").equals(intRateTypeExp)) {
                    row.getCell("intRate").getStyleAttributes().setNumberFormat("#,##0.0000000000\\%");
                } else {
                    row.getCell("intRate").getStyleAttributes().setNumberFormat("#,##0.0000000000\\\u2030");
                }
            }
            String curID = (String)row.getCell("currencyID").getValue();
            String intCurID = (String)row.getCell("intCurrencyID").getValue();
            if (FMHelper.isEmpty((String)curID) || FMHelper.isEmpty((String)intCurID)) continue;
            int ratePre = 3;
            if (!curID.equals(intCurID)) {
                try {
                    ratePre = FMClientHelper.getExchangeRatePrec((String)curID, (String)intCurID);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String rateFtm = FMClientHelper.getNumberFtm((int)ratePre);
            row.getCell("intCurrencyRate").getStyleAttributes().setNumberFormat(rateFtm);
            int intCurPre = FMClientHelper.getPrecOfCurrency((BOSUuid)BOSUuid.read((String)intCurID));
            String intCurFtm = FMClientHelper.getNumberFtm((int)intCurPre);
            row.getCell("intCurrencyAmt").getStyleAttributes().setNumberFormat(intCurFtm);
            if (!EmptyUtil.isEmpty((Object)row.getCell("strikeStatus").getValue()) && (strikeStatus = (BizEnumValueDTO)row.getCell("strikeStatus").getValue()).getValue().equals("null")) {
                row.getCell("strikeStatus").setValue((Object)"");
            }
            tblMain.getColumn("amount").getStyleAttributes().setNumberFormat(intCurFtm);
            tblMain.getColumn("interest").getStyleAttributes().setNumberFormat(intCurFtm);
            tblMain.getColumn("realInterest").getStyleAttributes().setNumberFormat(intCurFtm);
        }
    }

    protected String getCurrencyIdColName() {
        return "currencyID";
    }

    protected String[] getPrecColName() {
        return new String[]{"amount", "interest", "realInterest"};
    }

    protected void execQuery() {
        FilterInfo extFilter;
        if (this.setIDs != null) {
            String includeValue = this.parseValue(this.setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        if ((extFilter = this.getBillCanbePayed()) != null && extFilter.getFilterItems().size() > 0) {
            try {
                if (this.mainQuery.getFilter().getFilterItems().size() == 0) {
                    this.mainQuery.setFilter(extFilter);
                } else {
                    this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
                }
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e.getCause());
            }
        }
        super.execQuery();
        this.formatFootRow();
        this.setIDs = null;
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private FilterInfo getBillCanbePayed() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo f = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("FromFinRepayment")) != null && "FromFinRepayment".equals(targetBillType)) {
            f.getFilterItems().add(new FilterItemInfo("cashier.id", null, CompareType.EQUALS));
            f.getFilterItems().add(new FilterItemInfo("isGenPayBill", (Object)Boolean.FALSE));
            f.getFilterItems().add(new FilterItemInfo("interestType", (Object)preInt, CompareType.NOTEQUALS));
            f.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)new Integer(1)));
        }
        return f;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
        String uiParam = (String)this.getUIContext().get("UIClassParam");
        this.initButton(uiParam);
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            BondInterestFilterParam param = (BondInterestFilterParam)((Object)this.getFilterUI().getParam());
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new SumFiledsInfo(SumBillEnum.FinLoanInt).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doBook(e);
    }

    private void doBook(ActionEvent e) throws BOSException, EASBizException, Exception {
        int result;
        ILoanInterest iLoanInterest = (ILoanInterest)this.getBizInterface();
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toBeBooked = this.getToBeBookedIdSet(allSelected);
        if (toBeBooked.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"484_LoanInterestListUI"));
            SysUtil.abort();
        }
        if (toBeBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"327_LoanInterestListUI")));
            SysUtil.abort();
        } else if (toBeBooked.size() == allSelected.size()) {
            iLoanInterest.book(new ArrayList(toBeBooked));
            this.showMsg(e);
        } else if (toBeBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"328_LoanInterestListUI"))) == 0) {
            iLoanInterest.book(new ArrayList(toBeBooked));
            this.showMsg(e);
        }
    }

    private Set getToBeBookedIdSet(Set allSelected) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("cashier", null, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("statusExtEnum", (Object)new Integer(1), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("interestType", (Object)new Integer(4), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("interestType", (Object)new Integer(2), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isGenPayBill", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("account", null, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and (#3 or #4) and #5 and #6");
        view.setFilter(filter);
        LoanInterestCollection toBeBooked = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(view);
        HashSet<String> toBeBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeBookIDSet;
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doCancelBook(e);
    }

    private void doCancelBook(ActionEvent e) throws Exception {
        int result;
        ILoanInterest iLoanInterest = (ILoanInterest)this.getBizInterface();
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toBeCancelBooked = this.getToBeCancelBookedIdSet(allSelected);
        if (toBeCancelBooked.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"528_LoanInterestListUI"));
            SysUtil.abort();
        }
        if (toBeCancelBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"327_LoanInterestListUI")));
            SysUtil.abort();
        } else if (toBeCancelBooked.size() == allSelected.size()) {
            iLoanInterest.cancelBook(new ArrayList(toBeCancelBooked));
            this.showMsg(e);
        } else if (toBeCancelBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"330_LoanInterestListUI"))) == 0) {
            iLoanInterest.cancelBook(new ArrayList(toBeCancelBooked));
            this.showMsg(e);
        }
    }

    private Set getToBeCancelBookedIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("cashier", null, CompareType.NOTEQUALS));
        f.getFilterItems().add(new FilterItemInfo("interestType", (Object)IntCalTypeEnum.PRE_INT, CompareType.NOTEQUALS));
        evi.setFilter(f);
        LoanInterestCollection toBeBooked = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(evi);
        HashSet<String> toBeBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeBookIDSet;
    }

    private void showMsg(ActionEvent e) throws Exception {
        this.refresh(e);
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkDelVoucher();
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkVoucher();
        super.actionVoucher_actionPerformed(e);
    }

    private void checkDelVoucher() throws EASBizException, BOSException {
        LoanInterestInfo info;
        if (IvtModualUtils.getSysParam(null, (String)"FIN009") && (info = this.getSelectObject()).getInterestType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"331_LoanInterestListUI"));
            SysUtil.abort();
        }
    }

    private void checkVoucher() throws EASBizException, BOSException {
        LoanInterestInfo info;
        if (IvtModualUtils.getSysParam(null, (String)"FIN009") && (info = this.getSelectObject()).getInterestType() == IntCalTypeEnum.REPAY_INT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"331_LoanInterestListUI"));
            SysUtil.abort();
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        LoanInterestInfo info = this.getSelectObject();
        this.actionVoucher.setEnabled(StatusExtEnum.AUDIT.equals((Object)info.getStatusExtEnum()) && !info.isFivouchered());
    }

    private LoanInterestInfo getSelectObject() throws EASBizException, BOSException {
        this.checkSelected();
        return LoanInterestFactory.getRemoteInstance().getLoanInterestInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filters = new FilterInfo();
        filters.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filters);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("endDate"));
        view.setSelector(sic);
        LoanInterestCollection colls = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(view);
        for (int i = 0; i < colls.size(); ++i) {
            LoanInterestInfo intBillInfo = colls.get(i);
            this.checkFinalCheckout(intBillInfo.getEndDate());
        }
        LoanInterestCollection col = this.getLoanIntetestColl(idSet);
        for (int i = 0; i < col.size(); ++i) {
            LoanInterestInfo info = col.get(i);
            if (info.getStatusExtEnum() == StatusExtEnum.AUDIT && info.getCashier() == null && !info.isIsGenPayBill()) continue;
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"199_FinListProcessUtils"));
            SysUtil.abort();
        }
        LoanFacadeFactory.getRemoteInstance().antiAudit(idSet);
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"200_FinListProcessUtils"));
        this.refreshList();
    }

    protected LoanInterestCollection getLoanIntetestColl(Set idSet) throws BOSException, Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        evi.setFilter(filter);
        return ((ILoanInterest)this.getBizInterface()).getLoanInterestCollection(evi);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (List)idList);
        if (idsInProcess) {
            this.actionMultiapprove_actionPerformed(e);
            return;
        }
        FinListProcessUtils.audit((ListUI)this, this.tblMain, this.getSelectedIdValues());
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.isEnterByPreInt = false;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    public boolean destroyWindow() {
        block8: {
            try {
                this.licenseService.releaseLicense();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            try {
                if (this.isEnterByPreInt) {
                    boolean hasSavedBill;
                    FilterInfo filt = new FilterInfo();
                    filt.getFilterItems().add(new FilterItemInfo("statusextenum", (Object)new Integer(-1)));
                    if (this.mainQuery == null) {
                        return super.destroyWindow();
                    }
                    this.mainQuery.getFilter().mergeFilter(filt, "AND");
                    LoanInterestCollection col = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(this.mainQuery);
                    boolean bl = hasSavedBill = col.size() > 0;
                    if (hasSavedBill) {
                        boolean isSave;
                        String uiParam = (String)this.getUIContext().get("UIClassParam");
                        int result = uiParam.equals("CALCULATE") ? MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"680_LoanInterestListUI")) : MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"332_LoanInterestListUI"));
                        boolean bl2 = isSave = result == 1 || result == 2;
                        if (isSave) {
                            return false;
                        }
                        this.isEnterByPreInt = false;
                        FilterInfo f = new FilterInfo();
                        f.getFilterItems().add(new FilterItemInfo("statusextenum", (Object)new Integer(-1)));
                        this.mainQuery.getFilter().mergeFilter(f, "AND");
                        LoanInterestFactory.getRemoteInstance().delete(this.mainQuery.getFilter());
                        return super.destroyWindow();
                    }
                    break block8;
                }
                return super.destroyWindow();
            }
            catch (Exception ex) {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
        }
        return super.destroyWindow();
    }

    @Override
    public void actionBatchSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid,fenddate from T_FIN_LoanInterest where 1=1 and  ");
        sb.append(FMHelper.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  FStatusExtEnum != 1");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
            this.checkFinalCheckout(rs.getDate(2));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"333_LoanInterestListUI"));
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", IDs, CompareType.INCLUDE));
        evi.setFilter(f);
        evi.setSelector(this.getSelectors());
        LoanInterestCollection col = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(evi);
        LoanInterestFactory.getRemoteInstance().batchSubmit(col);
        this.isEnterByPreInt = false;
        this.refreshList();
    }

    @Override
    public void actionGenPayBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList errorNumber = new ArrayList();
        Map m = this.checkGenIntBill(idList);
        for (Map.Entry entry : m.entrySet()) {
            errorNumber.add(entry.getValue());
            idList.remove(entry.getKey());
        }
        if (idList.size() > 0) {
            CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
            evi.setFilter(filter);
            evi.setSelector(this.getSelectors());
            for (String arr : idList) {
                ObjectUuidPK pk = new ObjectUuidPK(arr);
                ILoanInterest iLoanInterest = (ILoanInterest)this.getBizInterface();
                LoanInterestInfo loanInfo = iLoanInterest.getLoanInterestInfo((IObjectPK)pk, this.getBOTPSelectors());
                billCollection.add((CoreBillBaseInfo)loanInfo);
            }
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)new LoanInterestInfo().getBOSType().toString(), (String)new PaymentBillInfo().getBOSType().toString(), (CoreBillBaseCollection)billCollection, (boolean)false);
        }
        if (errorNumber.size() > 0) {
            String errorRes = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"636_loanIntList_error");
            MsgBox.showError((String)MessageFormat.format(errorRes, errorNumber.size(), errorNumber.toString()));
        } else if (idList.size() == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"638_loanIntlist_succ"));
        } else if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"637_loanIntList_allSucc"));
        }
        this.refreshList();
    }

    private Map checkGenIntBill(ArrayList idList) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        Set idSet = FMHelper.list2Set((List)idList);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("interestType");
        selector.add("cashier");
        selector.add("isGenPayBill");
        selector.add("statusExtEnum");
        selector.add("realInterest");
        String[] str = new String[idList.size()];
        LoanInterestCollection loanCollection = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, null));
        for (int i = 0; i < loanCollection.size(); ++i) {
            LoanInterestInfo loanIntInfo = loanCollection.get(i);
            str[i] = loanIntInfo.getId().toString();
            if (loanIntInfo.getInterestType() != IntCalTypeEnum.PRE_INT && loanIntInfo.getCashier() == null && !loanIntInfo.isIsGenPayBill() && loanIntInfo.getStatusExtEnum() == StatusExtEnum.AUDIT && loanIntInfo != null && loanIntInfo.getRealInterest().compareTo(BigDecimal.ZERO) != 0) continue;
            map.put(str[i], loanIntInfo.getNumber());
        }
        return map;
    }

    public SelectorItemCollection getSelectorsExt() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        return sic;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new LoanInterestQueryProcessor();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.loanInterestTDPrintMode(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.loanInterestTDPrintMode(true);
    }

    private void loanInterestTDPrintMode(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        Set idSet = FMHelper.list2Set((List)idList);
        IMetaDataPK headPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fin.LoanInterestHeaderTDQuery");
        DefaultNoteDataProvider dataProvider = new DefaultNoteDataProvider(idSet, headPK);
        String mainDsName = "LoanInterestHeaderTDQuery";
        dataProvider.addMetaDataPK(mainDsName, headPK);
        dataProvider.addCustomFilterMaker(mainDsName, (DefaultNoteDataProvider.ICustomFilterMaker)new DefaultNoteDataProvider.DefaultIdFilterMaker(idSet));
        String entryDsName = "LoanInterestEntryTDQuery";
        IMetaDataPK entryPK = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fin.LoanInterestEntryTDQuery");
        dataProvider.addMetaDataPK(entryDsName, entryPK);
        dataProvider.addForeignKey((Object)entryDsName, "parentId");
        dataProvider.addCustomFilterMaker(entryDsName, new DefaultNoteDataProvider.ICustomFilterMaker(){

            public void customize(FilterInfo filter, R1PrintDataParameter[] params) {
            }
        });
        dataProvider.setBatchSupported(true);
        dataProvider.setNumberOfEachBatch(100);
        KDNoteHelper helper = new KDNoteHelper();
        if (isPreview) {
            helper.printPreview(LOANINTEREST_FILENAME, (Object)dataProvider, (Component)((Object)this));
        } else {
            helper.print(LOANINTEREST_FILENAME, (Object)dataProvider, (Component)((Object)this));
        }
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    protected String[] getWhiteList() {
        return new String[]{"actionTDPrint", "actionTDPrintPreview"};
    }

    private void checkFinalCheckout(Date endDate) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        Calendar cl = Calendar.getInstance();
        cl.setTime(endDate);
        cl.add(5, 1);
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.IVT_MANAGE, (String)companyInfo.getId().toString(), (Date)cl.getTime());
        if (!canOp) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            BondInterestListUI.this.setListUITable(BondInterestListUI.this.tblMain, e);
        }
    }
}

