/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMKDTableHelper;
import com.kingdee.eas.fm.fin.ControlWayEnum;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditFinancingReduceInfo;
import com.kingdee.eas.fm.fin.CreditLimitEntryCollection;
import com.kingdee.eas.fm.fin.CreditLimitEntryInfo;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitManagerFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractChooseFinancingProductUI;
import com.kingdee.eas.fm.fin.util.ReduceSeqSorter;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ChooseFinancingProductUI
extends AbstractChooseFinancingProductUI {
    private static final Logger logger = CoreUIObject.getLogger(ChooseFinancingProductUI.class);
    private IObjectPK creditPK = null;
    private BigDecimal creditLocalAmt = Constants.ZERO;
    private BigDecimal bakCreditLocalAmt = Constants.ZERO;
    private CreditLimitInfo info = null;
    private String billID;
    private String finProID;
    private CreditFinancingReduceCollection retLeft = null;
    private CreditFinancingReduceCollection retRight = null;
    private CreditFinancingReduceCollection retForCaller = null;
    private CompanyOrgUnitInfo currencyCom;

    public static CreditFinancingReduceCollection showChooseFinancingProductUI(CoreUI ui) throws Exception {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.putAll(ui.getUIContext());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChooseFinancingProductUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        uiWindow.close();
        return ((ChooseFinancingProductUI)uiWindow.getUIObject()).getResult();
    }

    public void onLoad() throws Exception {
        this.currencyCom = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.creditPK = (IObjectPK)this.getUIContext().get("creditPK");
        String contentMoney = (String)this.getUIContext().get("CONTENT_MONEY");
        this.creditLocalAmt = (BigDecimal)this.getUIContext().get("creditLocalAmt");
        this.bakCreditLocalAmt = (BigDecimal)this.getUIContext().get("bakCreditLocalAmt");
        this.info = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo(this.creditPK, this.getSelects());
        this.billID = (String)this.getUIContext().get("billID");
        this.finProID = (String)this.getUIContext().get("finproID");
        if (this.finProID == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"115_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        if (this.creditLocalAmt == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"510_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        if (this.bakCreditLocalAmt != null && this.bakCreditLocalAmt.compareTo(BigDecimal.ZERO) > 0) {
            this.info.setBalance(this.info.getBalance().add(this.bakCreditLocalAmt));
        }
        if (contentMoney != null) {
            if (this.creditLocalAmt.compareTo(this.info.getBalance().add(new BigDecimal(contentMoney))) == 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"116_ChooseFinancingProductUI"));
                SysUtil.abort();
            }
        } else if (this.creditLocalAmt.compareTo(this.info.getBalance()) == 1) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"116_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        if (!FMHelper.isEmpty((String)this.billID)) {
            Map hm = CreditLimitManagerFactory.getRemoteInstance().getCreditEntryAfterRetore(BOSUuid.read((String)this.billID), BOSUuid.read((String)this.creditPK.toString()));
            this.retLeft = (CreditFinancingReduceCollection)((Object)hm.get("left"));
            this.retRight = (CreditFinancingReduceCollection)((Object)hm.get("right"));
            if (this.retRight != null && this.retRight.size() > 0) {
                List<Object> reduceColList = Arrays.asList(this.retRight.toArray());
                Collections.sort(reduceColList, new ReduceSeqSorter());
                this.retRight.clear();
                int n = reduceColList.size();
                for (int i = 0; i < n; ++i) {
                    this.retRight.add((CreditFinancingReduceInfo)reduceColList.get(i));
                }
            }
        } else {
            this.retRight = (CreditFinancingReduceCollection)((Object)this.getUIContext().get("col"));
            this.retLeft = this.sub(this.info.getEntrys(), this.retRight);
        }
        super.onLoad();
        this.processTableLeft();
        this.processTableRight();
        this.prmtCreditLimit.setQueryInfo("com.kingdee.eas.fm.fin.app.F7CreditLimitQuery");
        this.prmtCreditLimit.setDisplayFormat("$number$");
        this.prmtCreditLimit.setEditFormat("$number$");
        this.prmtCreditLimit.setCommitFormat("$number$");
        this.prmtCreditLimit.setValue((Object)this.info);
        this.txtBalance.setHorizontalAlignment(4);
        this.txtBalance.setPrecision(2);
        this.txtBalance.setRemoveingZeroInDispaly(false);
        this.txtBalance.setValue((Object)this.info.getBalance());
        this.txtCreditLocalAmt.setHorizontalAlignment(4);
        this.txtCreditLocalAmt.setPrecision(2);
        this.txtCreditLocalAmt.setRemoveingZeroInDispaly(false);
        this.txtCreditLocalAmt.setValue((Object)this.creditLocalAmt);
        this.actionToLeft.setEnabled(true);
        this.actionToLeftAll.setEnabled(false);
        this.actionToLeftAll.setVisible(false);
        this.actionToRight.setEnabled(true);
        this.actionToRightAll.setEnabled(false);
        this.actionToRightAll.setVisible(false);
        this.setBtnStatus();
    }

    private CreditFinancingReduceCollection sub(CreditLimitEntryCollection entry, CreditFinancingReduceCollection retRight) {
        if (retRight == null || retRight.size() <= 0) {
            this.populate(entry, this.retLeft);
            return this.retLeft;
        }
        int rightSize = retRight.size();
        int all = this.info.getEntrys().size();
        CreditLimitEntryInfo entryInfo = null;
        CreditFinancingReduceInfo creditFinancingReduceInfo = null;
        this.retLeft = new CreditFinancingReduceCollection();
        for (int i = 0; i < all; ++i) {
            entryInfo = this.info.getEntrys().get(i);
            for (int j = 0; j < rightSize; ++j) {
                creditFinancingReduceInfo = retRight.get(j);
                if (creditFinancingReduceInfo.getCreditEntry().getId().equals((Object)entryInfo.getId())) continue;
                creditFinancingReduceInfo = new CreditFinancingReduceInfo();
                this.setValues(creditFinancingReduceInfo, entryInfo);
                this.retLeft.add(creditFinancingReduceInfo);
            }
        }
        return this.retLeft;
    }

    private void populate(CreditLimitEntryCollection entry, CreditFinancingReduceCollection retLeft2) {
        if (this.info != null) {
            this.retLeft = new CreditFinancingReduceCollection();
            CreditLimitEntryCollection entrys = this.info.getEntrys();
            CreditFinancingReduceInfo creditFinancingReduceInfo = null;
            int size = entrys.size();
            CreditLimitEntryInfo entryInfo = null;
            for (int i = 0; i < size; ++i) {
                creditFinancingReduceInfo = new CreditFinancingReduceInfo();
                entryInfo = entrys.get(i);
                this.setValues(creditFinancingReduceInfo, entryInfo);
                this.retLeft.add(creditFinancingReduceInfo);
            }
        }
    }

    private void setValues(CreditFinancingReduceInfo creditFinancingReduceInfo, CreditLimitEntryInfo entryInfo) {
        creditFinancingReduceInfo.setAssignAmt(entryInfo.getSharedAmount());
        creditFinancingReduceInfo.setBalance(entryInfo.getBanlance());
        creditFinancingReduceInfo.setUsedAmt(FMHelper.subtract((BigDecimal)creditFinancingReduceInfo.getAssignAmt(), (BigDecimal)creditFinancingReduceInfo.getBalance()));
        creditFinancingReduceInfo.setFinPro(entryInfo.getFinPro());
        creditFinancingReduceInfo.setCreditEntry(entryInfo);
        creditFinancingReduceInfo.setControlWay(entryInfo.getControlWay());
        creditFinancingReduceInfo.setShareOrg(entryInfo.getShareOrg());
        creditFinancingReduceInfo.setCreditEntry(entryInfo);
    }

    private CreditFinancingReduceCollection getCreditFinancingReduceCollection() throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("billID", (Object)this.billID.toString()));
        f.getFilterItems().add(new FilterItemInfo("creditLimitID", (Object)this.creditPK.toString()));
        return CreditFinancingReduceFactory.getRemoteInstance().getCreditFinancingReduceCollection(evi);
    }

    private void processTableLeft() throws Exception {
        this.initTableLeft();
        this.loadDataLeft(this.tblLeft);
    }

    private void initTableLeft() throws Exception {
        this.tblLeft.checkParsed();
        FMKDTableHelper.setTableCellEditorByF7((KDTable)this.tblLeft, (String)"com.kingdee.eas.fm.fin.app.F7FinancingProductsQuery", null, (String)"finPro");
        FMKDTableHelper.setTableCellEditorByF7((KDTable)this.tblLeft, (String)"com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery", null, (String)"shareOrg");
        FMKDTableHelper.setTableCellEditorByCombox((KDTable)this.tblLeft, ControlWayEnum.class, (String)"controlWay");
        this.tblLeft.getColumn("usedAmt").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblLeft.getColumn("usedAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblLeft.getColumn("balance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblLeft.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblLeft.getColumn("assignAmt").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblLeft.getColumn("assignAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.enableTable(this.tblLeft, 0);
    }

    private void loadDataLeft(KDTable tbl) throws Exception {
        if (this.retLeft != null) {
            int size = this.retLeft.size();
            CreditFinancingReduceInfo entryInfo = null;
            for (int i = 0; i < size; ++i) {
                entryInfo = this.retLeft.get(i);
                this.addRowOfLeftTable(tbl, entryInfo);
            }
        }
    }

    private void processTableRight() throws Exception {
        this.initTableRight();
        this.loadDataRight();
    }

    private void initTableRight() throws Exception {
        this.tblRight.checkParsed();
        FMKDTableHelper.setTableCellEditorByF7((KDTable)this.tblRight, (String)"com.kingdee.eas.fm.fin.app.F7FinancingProductsQuery", null, (String)"finPro");
        FMKDTableHelper.setTableCellEditorByF7((KDTable)this.tblRight, (String)"com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery", null, (String)"shareOrg");
        FMKDTableHelper.setTableCellEditorByCombox((KDTable)this.tblRight, ControlWayEnum.class, (String)"controlWay");
        this.tblRight.getColumn("usedAmt").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblRight.getColumn("usedAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblRight.getColumn("balance").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblRight.getColumn("balance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblRight.getColumn("assignAmt").getStyleAttributes().setNumberFormat("%r{#,##0.00}f");
        this.tblRight.getColumn("assignAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblRight.getColumn("entryID").getStyleAttributes().setHided(true);
        this.enableTable(this.tblRight, 1);
    }

    private void enableTable(KDTable tbl, int type) {
        tbl.getColumn("shareOrg").getStyleAttributes().setLocked(true);
        tbl.getColumn("assignAmt").getStyleAttributes().setLocked(true);
        tbl.getColumn("usedAmt").getStyleAttributes().setLocked(true);
        tbl.getColumn("balance").getStyleAttributes().setLocked(true);
        tbl.getColumn("finPro").getStyleAttributes().setLocked(true);
        tbl.getColumn("controlWay").getStyleAttributes().setLocked(true);
        tbl.getColumn("entryID").getStyleAttributes().setLocked(true);
        if (type == 1) {
            tbl.getColumn("reduceSeq").getStyleAttributes().setLocked(true);
        }
    }

    private void loadDataRight() {
        if (this.retRight != null) {
            int size = this.retRight.size();
            CreditFinancingReduceInfo entryInfo = null;
            for (int i = 0; i < size; ++i) {
                entryInfo = this.retRight.get(i);
                this.addRowOfRightTable(this.tblRight, entryInfo);
            }
        }
    }

    private void addRowOfLeftTable(KDTable tbl, CreditFinancingReduceInfo entryInfo) {
        IRow row = tbl.addRow();
        row.getCell("shareOrg").setValue((Object)entryInfo.getShareOrg());
        row.getCell("assignAmt").setValue((Object)entryInfo.getAssignAmt());
        row.getCell("usedAmt").setValue((Object)FMHelper.subtract((BigDecimal)entryInfo.getAssignAmt(), (BigDecimal)entryInfo.getBalance()));
        row.getCell("balance").setValue((Object)entryInfo.getBalance());
        row.getCell("finPro").setValue((Object)entryInfo.getFinPro());
        row.getCell("controlWay").setValue((Object)entryInfo.getControlWay());
        row.getCell("entryID").setValue((Object)entryInfo.getCreditEntry());
    }

    private void addRowOfRightTable(KDTable tblRight, CreditFinancingReduceInfo entryInfo) {
        IRow row = tblRight.addRow();
        row.getCell("shareOrg").setValue((Object)entryInfo.getShareOrg());
        row.getCell("assignAmt").setValue((Object)entryInfo.getAssignAmt());
        row.getCell("usedAmt").setValue((Object)FMHelper.subtract((BigDecimal)entryInfo.getAssignAmt(), (BigDecimal)entryInfo.getBalance()));
        row.getCell("balance").setValue((Object)entryInfo.getBalance());
        row.getCell("finPro").setValue((Object)entryInfo.getFinPro());
        row.getCell("controlWay").setValue((Object)entryInfo.getControlWay());
        row.getCell("entryID").setValue((Object)entryInfo.getCreditEntry());
        row.getCell("reduceSeq").setValue((Object)new Integer(entryInfo.getReduceSeq()));
    }

    private SelectorItemCollection getSelects() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("entrys.*");
        sic.add("entrys.ShareOrg.*");
        sic.add("entrys.finPro.*");
        return sic;
    }

    public CreditFinancingReduceCollection getResult() {
        return this.retForCaller;
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        int count = this.tblRight.getRowCount();
        BigDecimal balanceTmp = this.creditLocalAmt;
        this.retForCaller = new CreditFinancingReduceCollection();
        CreditFinancingReduceInfo entryInfo = null;
        for (int i = 0; i < count; ++i) {
            entryInfo = new CreditFinancingReduceInfo();
            entryInfo.setShareOrg((CompanyOrgUnitInfo)this.tblRight.getRow(i).getCell("shareOrg").getValue());
            entryInfo.setAssignAmt((BigDecimal)this.tblRight.getRow(i).getCell("assignAmt").getValue());
            entryInfo.setControlWay((ControlWayEnum)((Object)this.tblRight.getRow(i).getCell("controlWay").getValue()));
            entryInfo.setFinPro((FinancingProductsInfo)this.tblRight.getRow(i).getCell("finPro").getValue());
            entryInfo.setCreditEntry((CreditLimitEntryInfo)this.tblRight.getRow(i).getCell("entryID").getValue());
            entryInfo.setCreditLimitID(BOSUuid.read((String)this.creditPK.toString()));
            entryInfo.setBalance((BigDecimal)this.tblRight.getRow(i).getCell("balance").getValue());
            entryInfo.setReduceSeq((Integer)this.tblRight.getRow(i).getCell("reduceSeq").getValue());
            if (balanceTmp.subtract(entryInfo.getBalance()).compareTo(Constants.ZERO) >= 0) {
                entryInfo.setUsedAmt(entryInfo.getBalance());
            } else {
                entryInfo.setUsedAmt(balanceTmp);
            }
            balanceTmp = balanceTmp.subtract(entryInfo.getBalance());
            this.retForCaller.add(entryInfo);
        }
        this.destroyWindow();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.retForCaller = null;
        this.destroyWindow();
    }

    @Override
    public void actionToLeft_actionPerformed(ActionEvent e) throws Exception {
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblLeft);
        this.moveSelectedTableReord(this.tblLeft, index, this.tblRight, true);
        this.tblLeft.removeRow(index);
        this.setBtnStatus();
    }

    @Override
    public void actionToLeftAll_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblLeft);
        for (int i = 0; i < indexs.length; ++i) {
            this.moveSelectedTableReord(this.tblLeft, indexs[i], this.tblRight, true);
        }
        this.tblLeft.removeRows();
        this.setBtnStatus();
    }

    private void moveSelectedTableReord(KDTable srcTbl, int rowIndex, KDTable destRight, boolean fromLeftToRight) {
        BigDecimal balance;
        if (rowIndex == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"117_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        IRow srcRow = srcTbl.getRow(rowIndex);
        String company = AccessHelper.getId((Object)srcRow.getCell("shareOrg").getValue());
        String curCOmpanyID = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString();
        if (!EmptyUtil.isEmpty((String)this.billID) && LoanInfo.BOSTYPE.equals((Object)BOSUuid.read((String)this.billID).getType())) {
            try {
                LoanInfo loan = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(this.billID));
                curCOmpanyID = loan.getCompany().getId().toString();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        if (!curCOmpanyID.equals(company)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"118_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        ControlWayEnum cw = (ControlWayEnum)((Object)srcRow.getCell("controlWay").getValue());
        String srcFinPro = AccessHelper.getId((Object)srcRow.getCell("finPro").getValue());
        String finproID = (String)this.getUIContext().get("finproID");
        if (srcFinPro != null && !srcFinPro.equals(finproID) && ControlWayEnum.YES == cw) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"119_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        if ((balance = (BigDecimal)srcRow.getCell("balance").getValue()).compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"120_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        if (fromLeftToRight) {
            for (int i = 0; i < srcTbl.getRowCount(); ++i) {
                String leftFinPro = AccessHelper.getId((Object)srcTbl.getRow(i).getCell("finPro").getValue());
                String leftfinproID = (String)this.getUIContext().get("finproID");
                BigDecimal leftbalance = (BigDecimal)srcTbl.getRow(i).getCell("balance").getValue();
                String leftcompany = AccessHelper.getId((Object)srcTbl.getRow(i).getCell("shareOrg").getValue());
                if (leftcompany == null || leftFinPro == null || !leftcompany.equals(curCOmpanyID) || !leftFinPro.equals(leftfinproID) || i == rowIndex || leftbalance.compareTo(Constants.ZERO) <= 0) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"121_ChooseFinancingProductUI"));
                SysUtil.abort();
            }
        } else if (srcTbl.getRowCount() > 1 && srcFinPro.equals(finproID)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"122_ChooseFinancingProductUI"));
            SysUtil.abort();
        }
        IRow destRow = destRight.addRow();
        this.copyRow(srcRow, destRow, fromLeftToRight);
    }

    private void copyRow(IRow srcRow, IRow destRow, boolean fromLeftToRight) {
        destRow.getCell("entryID").setValue(srcRow.getCell("entryID").getValue());
        destRow.getCell("shareOrg").setValue(srcRow.getCell("shareOrg").getValue());
        destRow.getCell("assignAmt").setValue(srcRow.getCell("assignAmt").getValue());
        this.calUsedAmtAndBalance(srcRow, destRow);
        destRow.getCell("finPro").setValue(srcRow.getCell("finPro").getValue());
        destRow.getCell("controlWay").setValue(srcRow.getCell("controlWay").getValue());
        if (fromLeftToRight) {
            destRow.getCell("reduceSeq").setValue((Object)new Integer(this.tblRight.getRowCount()));
        }
    }

    private void calUsedAmtAndBalance(IRow srcRow, IRow destRow) {
        destRow.getCell("balance").setValue(srcRow.getCell("balance").getValue());
        destRow.getCell("usedAmt").setValue(srcRow.getCell("usedAmt").getValue());
    }

    @Override
    public void actionToRight_actionPerformed(ActionEvent e) throws Exception {
        int index = KDTableUtil.getSelectedRow((KDTable)this.tblRight);
        this.moveSelectedTableReord(this.tblRight, index, this.tblLeft, false);
        this.tblRight.removeRow(index);
        this.setBtnStatus();
    }

    @Override
    public void actionToRightAll_actionPerformed(ActionEvent e) throws Exception {
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblRight);
        for (int i = 0; i < indexs.length; ++i) {
            this.moveSelectedTableReord(this.tblRight, indexs[i], this.tblLeft, false);
        }
        this.tblRight.removeRows();
    }

    private void setBtnStatus() {
        BigDecimal balanceTmp = this.creditLocalAmt;
        this.copyTable2Entry();
        int size = this.retRight.size();
        CreditFinancingReduceInfo entryInfo = null;
        BOSUuid curCompanyId = this.currencyCom.getId();
        if (!EmptyUtil.isEmpty((String)this.billID) && LoanInfo.BOSTYPE.equals((Object)BOSUuid.read((String)this.billID).getType())) {
            try {
                LoanInfo loan = LoanFactory.getRemoteInstance().getLoanInfo((IObjectPK)new ObjectUuidPK(this.billID));
                curCompanyId = loan.getCompany().getId();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < size; ++i) {
            entryInfo = this.retRight.get(i);
            if (!curCompanyId.equals((Object)entryInfo.getShareOrg().getId())) continue;
            if (entryInfo.getFinPro() == null || entryInfo.getFinPro().getId().toString().equals(this.finProID.toString())) {
                balanceTmp = balanceTmp.subtract(entryInfo.getCreditEntry().getBanlance());
                continue;
            }
            if (entryInfo.getControlWay() != ControlWayEnum.NO) continue;
            balanceTmp = balanceTmp.subtract(entryInfo.getCreditEntry().getBanlance());
        }
        boolean isLalanceTmpNagitNegate = balanceTmp.compareTo(Constants.ZERO) <= 0;
        this.btnConfirm.setEnabled(isLalanceTmpNagitNegate);
        this.toLeft.setEnabled(!this.btnConfirm.isEnabled());
    }

    private void copyTable2Entry() {
        int count = this.tblRight.getRowCount();
        this.retRight = new CreditFinancingReduceCollection();
        CreditFinancingReduceInfo entryInfo = null;
        for (int i = 0; i < count; ++i) {
            entryInfo = new CreditFinancingReduceInfo();
            entryInfo = new CreditFinancingReduceInfo();
            entryInfo.setShareOrg((CompanyOrgUnitInfo)this.tblRight.getRow(i).getCell("shareOrg").getValue());
            entryInfo.setAssignAmt((BigDecimal)this.tblRight.getRow(i).getCell("assignAmt").getValue());
            entryInfo.setControlWay((ControlWayEnum)((Object)this.tblRight.getRow(i).getCell("controlWay").getValue()));
            entryInfo.setFinPro((FinancingProductsInfo)this.tblRight.getRow(i).getCell("finPro").getValue());
            entryInfo.setCreditEntry((CreditLimitEntryInfo)this.tblRight.getRow(i).getCell("entryID").getValue());
            entryInfo.setBalance((BigDecimal)this.tblRight.getRow(i).getCell("balance").getValue());
            entryInfo.setReduceSeq((Integer)this.tblRight.getRow(i).getCell("reduceSeq").getValue());
            this.retRight.add(entryInfo);
        }
    }
}

