/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.TimeDepositTypeEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFactory;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillFilterParam;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.ICompUnTimeDepositBill;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.client.AbstractCompUntimeDepositBillListUI;
import com.kingdee.eas.fm.fin.client.CompUnTimeDepositBillFilterUI;
import com.kingdee.eas.fm.fin.client.CompUntimeDepositBillDataProvider;
import com.kingdee.eas.fm.fin.client.CompUntimeDepositBillEditUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CompUntimeDepositBillListUI
extends AbstractCompUntimeDepositBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(CompUntimeDepositBillListUI.class);
    CompUnTimeDepositBillFilterUI filterUI;
    FillListener fillListener = new FillListener();
    private static final String COMPUNTIMEDEPOSITBILL_FILENAME = "/FM/FIN/COMPUNTIMEDEPOSIT";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("BOTPViewStatus") == null || (Integer)this.getUIContext().get("BOTPViewStatus") != 1 || this.getUIContext().get("BTPCreateMode") != null && (Integer)this.getUIContext().get("BTPCreateMode") != 1) {
            FSClientHelper.checkClearingHouseCompany();
        }
        super.onLoad();
        this.tblMain.getColumn("acceptedDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("untimeDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("timeDepositBill.maturityDay").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CompUnTimeDepositBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CompUnTimeDepositBillFactory.getRemoteInstance();
    }

    private void checkCanBeDeleted() throws Exception {
        CompUnTimeDepositBillInfo info = this.getSelectObject();
        if (info.getStatus() == CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.EXCEPTION62);
        }
        this.condition1(info);
        this.condition2(info);
        this.condition3(info);
        this.condition4(info);
    }

    private void condition1(CompUnTimeDepositBillInfo info) throws Exception {
        if (info.isFiVouchered()) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC2);
        }
    }

    private void condition3(CompUnTimeDepositBillInfo info) throws TDException {
        if (info.getTimeDepositBill().isIsChangeByReDeposited()) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC4);
        }
    }

    private void condition2(CompUnTimeDepositBillInfo info) throws TDException {
        if (info.isFiVouchered()) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC2);
        }
        int maxSeqNo = this.getMaxSeqNo(info.getTimeDepositBill().getId().toString());
        int deletedSeqNo = info.getUnTimeDepositSeqNo();
        if (deletedSeqNo != maxSeqNo) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC3);
        }
    }

    private void condition4(CompUnTimeDepositBillInfo info) throws Exception {
        if (info.isIsreceived()) {
            throw new TDException(TDException.UNTIEMDEPOSIT_CANNOT_DELETE_EXC5);
        }
    }

    private CompUnTimeDepositBillInfo getSelectObject() throws Exception {
        this.checkSelected();
        CompUnTimeDepositBillInfo info = ((ICompUnTimeDepositBill)this.getBizInterface()).getCompUnTimeDepositBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getSelectors());
        return info;
    }

    private int getMaxSeqNo(String id) {
        int maxSeqNo = 0;
        try {
            Map hm = CompUnTimeDepositBillFactory.getRemoteInstance().getMaxUnDepositSeqAndAccumalateAmt((IObjectPK)new ObjectUuidPK(id));
            Integer maxSeqInteger = (Integer)hm.get("UNDEPOSIT_MAX_SEQ");
            maxSeqNo = maxSeqInteger;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return maxSeqNo;
    }

    @Override
    protected String getEditUIName() {
        return CompUntimeDepositBillEditUI.class.getName();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionTdPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTdPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionAccepted.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.actionAntiAccepted.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcase"));
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("timeDepositBill.isReDeposited"));
        sic.add(new SelectorItemInfo("timeDepositBill.interm.*"));
        return sic;
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeDeleted();
        super.actionRemove_actionPerformed(e);
    }

    protected void execQuery() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("NewUnTimeDepositID") != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)new ObjectUuidPK((String)this.getUIContext().get("NewUnTimeDepositID")), CompareType.EQUALS));
            this.mainQuery.setFilter(filter);
        } else if (this.getUIContext().get("BTPEDITPARAMETER") != null && "PaymentBill".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
            filter.getFilterItems().add(new FilterItemInfo("isCreatePayment", (Object)new Integer(1), CompareType.NOTEQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isCreatePayment", null, CompareType.IS));
            filter.getFilterItems().add(new FilterItemInfo("depositType", (Object)TimeDepositTypeEnum.TIMEDEPOSIT_OUTER.getValue(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("depositType", (Object)TimeDepositTypeEnum.CALLDEPOSIT_OUTER.getValue(), CompareType.EQUALS));
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("ARAPCOMPANY");
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)CompDepositBillStatusEnum.ACCEPTED.getValue(), CompareType.EQUALS));
            filter.setMaskString("(#0 or #1 ) and (#2 or #3) and #4 and #5");
            this.mainQuery.setFilter(filter);
        }
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CompUnTimeDepositBillFilterParam param = (CompUnTimeDepositBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrency());
            String[] columns = new SumFiledsInfo(SumBillEnum.ComUnDep).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    @Override
    public void actionTdPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTdPrint_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CompUntimeDepositBillDataProvider data = new CompUntimeDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(COMPUNTIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTdPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        super.actionTdPreview_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CompUntimeDepositBillDataProvider data = new CompUntimeDepositBillDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(COMPUNTIMEDEPOSITBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    @Override
    public void actionAccepted_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompUnTimeDepositBillInfo info = this.getSelectObject();
        if (info.getStatus() != CompDepositBillStatusEnum.SUBMIT) {
            throw new TDException(TDException.EXCEPTION63);
        }
        ICompUnTimeDepositBill iComp = (ICompUnTimeDepositBill)this.getBizInterface();
        iComp.accepted((IObjectPK)new ObjectStringPK(info.getId().toString()));
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionAntiAccepted_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompUnTimeDepositBillInfo info = this.getSelectObject();
        if (info.getStatus() != CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.EXCEPTION64);
        }
        if (info.isFiVouchered()) {
            throw new TDException(TDException.EXCEPTION71);
        }
        if (info.isIsreceived()) {
            throw new TDException(TDException.EXCEPTION77);
        }
        Set downBillSet = BOTPUtil.getDestBillIdSet(null, (String)info.getId().toString());
        if (!EmptyUtil.isEmpty((Collection)downBillSet)) {
            boolean isExistOtherInt = false;
            for (String downId : downBillSet) {
                if (EmptyUtil.isEmpty((String)downId) || FMHelper.isInstanceof((String)downId, CompIntReceivedBillInfo.class)) continue;
                isExistOtherInt = true;
                break;
            }
            if (downBillSet.size() > 0 && isExistOtherInt) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"downBillWarning"));
                SysUtil.abort();
            }
        }
        Date settleDate = FSClientHelper.getClearingHouse().getSettleDate();
        if (null != info.getAcceptedDate() && info.getAcceptedDate().before(settleDate)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"HasDailySettle"));
            SysUtil.abort();
        }
        ICompUnTimeDepositBill iComp = (ICompUnTimeDepositBill)this.getBizInterface();
        iComp.antiAccepted((IObjectPK)new ObjectStringPK(info.getId().toString()));
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompUnTimeDepositBillInfo info = this.getSelectObject();
        if (info.getStatus() != CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.CREATE_VOUCHER_EXC2);
        }
        super.actionVoucher_actionPerformed(e);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "untimeDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAccepted"};
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(CompUntimeDepositBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                this.setAmtCellNumberFormat(row);
                String currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId == null) continue;
                FMClientHelper.setNumberFormat((IRow)row, (String)"unDepositAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"accumulativeUnTimeDepostAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"unDepositAmtLocal", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"timeDepositBill.amount", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"timeDepositBill.balance", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"unDepositAmtLocal", (String)currencyId);
            }
        }

        private void setNumberFormat(IRow row, String columnKey, int type) {
            String formatString = "";
            formatString = type == 1 ? "%r-[ ]0.2n" : "%r-[ ]0.5n";
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            styleAttributes.setNumberFormat(formatString);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }

        private void setAmtCellNumberFormat(IRow row) {
            this.setNumberFormat(row, "exchangeRate", 2);
        }
    }
}

