/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IChangeOrgEvent;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.SourceBillTypeEnum;
import com.kingdee.eas.fm.fin.client.AbstractCreateFromLoanInterestBillUI;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreateFromLoanInterestBillUI
extends AbstractCreateFromLoanInterestBillUI {
    private static final Logger logger = CoreUIObject.getLogger(CreateFromLoanInterestBillUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private Set createdIdSet;
    Map hm = new HashMap();
    protected static SourceBillTypeEnum sourceBill;

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!this.verify()) {
            SysUtil.abort();
        }
        this.createdIdSet = new HashSet();
        this.createdIdSet.clear();
        CoreBillBaseInfo info = (CoreBillBaseInfo)this.prmtInterestBill.getData();
        this.hm = LoanInterestFactory.getRemoteInstance().createFromLoanInterestBill(info.getId().toString(), sourceBill);
        this.createdIdSet = (Set)this.hm.get("createdID");
        if (this.createdIdSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"not_loanbill"));
            SysUtil.abort();
        } else {
            if (this.getUIContext().get("UIClassParam") != null) {
                // empty if block
            }
            this.disposeUIWindow();
        }
    }

    private boolean verify() {
        if (this.prmtInterestBill.getData() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"139_CreateFromLoanInterestBillUI"));
            return false;
        }
        return true;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIdSet = null;
        super.disposeUIWindow();
    }

    public static Map showCreateFromLoanInterestBillUI(CoreUI ui, SourceBillTypeEnum sourceBillType) {
        CreateFromLoanInterestBillUI.setSourceBillTypeEnum(sourceBillType);
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CreateFromLoanInterestBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((CreateFromLoanInterestBillUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        Set id = (Set)returnValue.get("createdID");
        if (id == null) {
            SysUtil.abort();
        }
        if (id.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"not_loanbill"));
        } else {
            String msg = (String)returnValue.get("failureMsg");
            if (msg != null && msg.length() > 0) {
                MsgBox.showInfo((String)msg);
                msg = null;
            }
        }
        return returnValue;
    }

    private Map getReturnValueWithMsg() {
        return this.hm;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.setPrmtInterestBillEV();
        FMClientHelper.initCompanyF7((String)"fin_Loan_addnew", (KDBizPromptBox)this.prmtMainOrgCompany, (boolean)false, (IChangeOrgEvent)new IChangeOrgEvent(){

            public void afterMainOrgChanged(OrgChangeVO chgVo) {
                if (chgVo.getNewOrg() == null) {
                    MsgBox.showInfo((String)EASResource.getString((String)CreateFromLoanInterestBillUI.RESOURCE, (String)"newOrg_notNull"));
                    CreateFromLoanInterestBillUI.this.prmtMainOrgCompany.setValue(chgVo.getOldOrg());
                }
                CreateFromLoanInterestBillUI.this.prmtInterestBill.setValue(null);
            }
        });
    }

    protected void setPrmtInterestBillEV() throws Exception {
        if (sourceBill.equals((Object)SourceBillTypeEnum.EntLoanInterest)) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            ConvertUtils.FILTER((FilterInfo)filterInfo, (FilterItemInfo[])new FilterItemInfo[]{ConvertUtils.FITEM((Object[])new Object[]{"loanCompany.id", ConvertUtils.IDSTR((Object)this.prmtMainOrgCompany.getValue())})});
            filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("loanBill.isDownLoaded", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDownLoaded", (Object)new Boolean(false)));
            filterInfo.getFilterItems().add(new FilterItemInfo("intCalType", (Object)new Integer(3), CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("intCalType", (Object)new Integer(0), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(2), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4), CompareType.EQUALS));
            filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4 and ((#5 and #6) or #7)");
            evi.setFilter(filterInfo);
            this.prmtInterestBill.setEntityViewInfo(evi);
        } else if (sourceBill.equals((Object)SourceBillTypeEnum.FundTransferInterest)) {
            this.prmtInterestBill.setQueryInfo("com.kingdee.eas.fm.ft.app.FundTransferInterestBillQuery");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            ConvertUtils.FILTER((FilterInfo)filterInfo, (FilterItemInfo[])new FilterItemInfo[]{ConvertUtils.FITEM((Object[])new Object[]{"transCompany.id", ConvertUtils.IDSTR((Object)this.prmtMainOrgCompany.getValue())})});
            filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)2));
            filterInfo.getFilterItems().add(new FilterItemInfo("transBill.isGenLoan", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isGenLoanInt", (Object)Boolean.FALSE));
            evi.setFilter(filterInfo);
            this.prmtInterestBill.setEntityViewInfo(evi);
        } else if (sourceBill.equals((Object)SourceBillTypeEnum.ConsignLoanInterest)) {
            this.prmtInterestBill.setQueryInfo("com.kingdee.eas.fm.cl.app.ConsignLoanIntBillQuery");
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            ConvertUtils.FILTER((FilterInfo)filterInfo, (FilterItemInfo[])new FilterItemInfo[]{ConvertUtils.FITEM((Object[])new Object[]{"loanCompany.id", ConvertUtils.IDSTR((Object)this.prmtMainOrgCompany.getValue())})});
            filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)2));
            filterInfo.getFilterItems().add(new FilterItemInfo("loan.isCreateToLoan", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isGenLoanInt", (Object)Boolean.FALSE));
            evi.setFilter(filterInfo);
            this.prmtInterestBill.setEntityViewInfo(evi);
        }
    }

    @Override
    protected void prmtInterestBill_willCommit(CommitEvent e) throws Exception {
        this.setPrmtInterestBillEV();
        this.prmtInterestBill.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtInterestBill_willShow(SelectorEvent e) throws Exception {
        this.setPrmtInterestBillEV();
        this.prmtInterestBill.getQueryAgent().resetRuntimeEntityView();
    }

    private static void setSourceBillTypeEnum(SourceBillTypeEnum sourceBillType) {
        if (sourceBillType.equals((Object)SourceBillTypeEnum.EntLoanInterest)) {
            sourceBill = SourceBillTypeEnum.EntLoanInterest;
        } else if (sourceBillType.equals((Object)SourceBillTypeEnum.FundTransferInterest)) {
            sourceBill = SourceBillTypeEnum.FundTransferInterest;
        } else if (sourceBillType.equals((Object)SourceBillTypeEnum.ConsignLoanInterest)) {
            sourceBill = SourceBillTypeEnum.ConsignLoanInterest;
        }
    }
}

