/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BillStateEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.ApplyResultEnum;
import com.kingdee.eas.fm.fin.CreditApplyBillFactory;
import com.kingdee.eas.fm.fin.CreditApplyBillInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LimitIsBankCreditEnum;
import com.kingdee.eas.fm.fin.LimitPropertyEnum;
import com.kingdee.eas.fm.fin.client.AbstractCreditApplyBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class CreditApplyBillEditUI
extends AbstractCreditApplyBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditApplyBillEditUI.class);

    @Override
    public void loadFields() {
        super.loadFields();
        this.initButtonState();
        this.initDataStatus();
    }

    protected void initDataStatus() {
        CreditApplyBillInfo info;
        LimitIsBankCreditEnum selectedItem;
        this.creator.setEnabled(false);
        if (this.editData != null) {
            super.initDataStatus();
        }
        if ((selectedItem = (info = (CreditApplyBillInfo)this.getDataObject()).getIsBankCreditCbB()) != LimitIsBankCreditEnum.INNER) {
            this.contcreditCompany.setVisible(false);
            this.prmtcreditCompany.setValue(null);
            this.prmtcreditCompany.setRequired(false);
            this.contcreditInst.setVisible(true);
            this.prmtcreditInst.setRequired(true);
            this.prmtcreditCompany.setRequestFocusEnabled(false);
            this.prmtcreditInst.setRequestFocusEnabled(true);
        } else {
            this.contcreditCompany.setVisible(true);
            this.prmtcreditCompany.setRequired(true);
            this.contcreditInst.setVisible(false);
            this.prmtcreditInst.setValue(null);
            this.prmtcreditInst.setRequired(false);
            this.prmtcreditCompany.setRequestFocusEnabled(true);
            this.prmtcreditInst.setRequestFocusEnabled(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"140_CreditApplyBillEditUI"));
            SysUtil.abort();
        }
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        CompanyOrgUnitInfo currentFIUnit = SysContext.getSysContext().getCurrentFIUnit();
        if (currentFIUnit == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentFIUnit)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"140_CreditApplyBillEditUI"));
            SysUtil.abort();
        }
        super.actionAddNew_actionPerformed(e);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtcurrency);
        if (e.getSource() instanceof KDWorkButton && this.btnSave.getName().equals(((KDWorkButton)e.getSource()).getName()) || e.getSource() instanceof KDMenuItem && this.btnSave.getName().equals(((KDMenuItem)e.getSource()).getName())) {
            return;
        }
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.isBankCreditCbB);
        LimitIsBankCreditEnum selectedItem = (LimitIsBankCreditEnum)((Object)this.isBankCreditCbB.getSelectedItem());
        if (selectedItem != LimitIsBankCreditEnum.INNER) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtcreditInst);
        } else {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtcreditCompany);
        }
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtcreditUsage);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.property);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtquotaAmount);
        BigDecimal bdAmount = this.txtquotaAmount.getBigDecimalValue();
        if (bdAmount.compareTo(SysConstant.BIGZERO) <= 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"141_CreditApplyBillEditUI"));
            this.txtquotaAmount.requestFocus();
            SysUtil.abort();
        }
        Date beginDate = (Date)this.pkissueDate.getValue();
        Date endDate = (Date)this.pkexpiredDate.getValue();
        if (beginDate != null && endDate != null && !beginDate.before(endDate)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"142_CreditApplyBillEditUI"));
            this.pkissueDate.requestFocus();
            SysUtil.abort();
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CreditApplyBillFactory.getRemoteInstance();
    }

    @Override
    protected KDTable getDetailTable() {
        return null;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        CreditApplyBillInfo objectValue = new CreditApplyBillInfo();
        objectValue.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        objectValue.setOrg(currentCompany);
        Date date = new Date();
        try {
            date = DateUtil.getTimeStampDayBegin();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        objectValue.setCompany(currentCompany);
        objectValue.setBizDate(date);
        objectValue.setIsCreateToLimit(false);
        objectValue.setIsGroupCredit(true);
        objectValue.setApplyResult(ApplyResultEnum.OTHER);
        objectValue.setIsBankCreditCbB(LimitIsBankCreditEnum.TRUE);
        objectValue.setProperty(LimitPropertyEnum.REVOLVING_AMOUNT);
        objectValue.setQuotaAmount(SysConstant.BIGZERO);
        objectValue.setBillState(BillStateEnum.SAVED);
        try {
            if (currentCompany.getBaseCurrency() != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                objectValue.setCurrency(iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currentCompany.getBaseCurrency().getId())));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return objectValue;
    }

    private void initButtonState() {
        if (BillStateEnum.AUDITED.equals((Object)this.getBillState())) {
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(false);
        } else if (BillStateEnum.SUBMITTED.equals((Object)this.getBillState()) || OprtState.VIEW.equals(this.getOprtState())) {
            this.btnSave.setEnabled(false);
            this.btnEdit.setEnabled(false);
            this.btnRemove.setEnabled(true);
            this.menuItemEdit.setEnabled(false);
            this.menuItemRemove.setEnabled(true);
        }
    }

    private BillStateEnum getBillState() {
        if (this.editData.getId() == null) {
            return BillStateEnum.SAVED;
        }
        return this.editData.getBillState();
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    public void onLoad() throws Exception {
        FMClientHelper.checkOnlyUnion((String)this.oprtState);
        super.onLoad();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isleaf", (Object)Boolean.TRUE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtcreditCompany.setEntityViewInfo(evi);
        this.prmtcreditCompany.getQueryAgent().resetRuntimeEntityView();
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("isUsed", (Object)Boolean.TRUE));
        EntityViewInfo evi1 = new EntityViewInfo();
        evi1.setFilter(filter1);
        this.prmtcreditUsage.setEntityViewInfo(evi1);
        this.prmtcreditUsage.getQueryAgent().resetRuntimeEntityView();
        int precision = 0;
        if (this.prmtcurrency.getValue() == null) {
            try {
                CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                if (currentCompany.getBaseCurrency() != null) {
                    ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                    precision = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currentCompany.getBaseCurrency().getId())).getPrecision();
                }
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.prmtcurrency.getValue();
            precision = currency.getPrecision();
        }
        this.txtquotaAmount.setPrecision(precision);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtquotaAmount);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtproject);
    }

    @Override
    protected void isBankCreditCbB_actionPerformed(ActionEvent e) throws Exception {
        super.isBankCreditCbB_actionPerformed(e);
        if ((LimitIsBankCreditEnum)((Object)this.isBankCreditCbB.getSelectedItem()) == LimitIsBankCreditEnum.TRUE) {
            FinUtils.initBankTree((IUIObject)this, this.prmtcreditInst, new Boolean(true), true);
        } else {
            FinUtils.initBankTree((IUIObject)this, this.prmtcreditInst, new Boolean(false), true);
        }
    }

    @Override
    protected void isBankCreditCbB_itemStateChanged(ItemEvent e) throws Exception {
        super.isBankCreditCbB_itemStateChanged(e);
        LimitIsBankCreditEnum selectedItem = (LimitIsBankCreditEnum)((Object)this.isBankCreditCbB.getSelectedItem());
        if (selectedItem != LimitIsBankCreditEnum.INNER) {
            if (selectedItem == LimitIsBankCreditEnum.TRUE) {
                this.prmtcreditInst.setData(null);
                FinUtils.initBankTree((IUIObject)this, this.prmtcreditInst, new Boolean(true));
            } else {
                FinUtils.initBankTree((IUIObject)this, this.prmtcreditInst, new Boolean(false));
            }
            this.contcreditCompany.setVisible(false);
            this.prmtcreditCompany.setValue(null);
            this.prmtcreditCompany.setRequired(false);
            this.contcreditInst.setVisible(true);
            this.prmtcreditInst.setRequired(true);
            this.prmtcreditCompany.setRequestFocusEnabled(false);
            this.prmtcreditInst.setRequestFocusEnabled(true);
        } else {
            this.contcreditCompany.setVisible(true);
            this.prmtcreditCompany.setRequired(true);
            this.contcreditInst.setVisible(false);
            this.prmtcreditInst.setValue(null);
            this.prmtcreditInst.setRequired(false);
            this.prmtcreditCompany.setRequestFocusEnabled(true);
            this.prmtcreditInst.setRequestFocusEnabled(false);
        }
    }

    @Override
    protected void prmtcurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtcurrency_dataChanged(e);
        int precision = 0;
        if (e.getNewValue() == null) {
            try {
                CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                if (currentCompany.getBaseCurrency() != null) {
                    ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                    precision = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currentCompany.getBaseCurrency().getId())).getPrecision();
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            CurrencyInfo currency = (CurrencyInfo)this.prmtcurrency.getValue();
            precision = currency.getPrecision();
        }
        this.txtquotaAmount.setPrecision(precision);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.*"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("creditInst.*"));
        sic.add(new SelectorItemInfo("creditUsage.*"));
        sic.add(new SelectorItemInfo("property"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("quotaAmount"));
        sic.add(new SelectorItemInfo("issueDate"));
        sic.add(new SelectorItemInfo("expiredDate"));
        sic.add(new SelectorItemInfo("isGroupCredit"));
        sic.add(new SelectorItemInfo("remark"));
        sic.add(new SelectorItemInfo("isBankCreditCbB"));
        sic.add(new SelectorItemInfo("org.*"));
        sic.add(new SelectorItemInfo("isCreateToLimit"));
        sic.add(new SelectorItemInfo("applyResult"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("billState"));
        sic.add(new SelectorItemInfo("creditCompany.*"));
        sic.add(new SelectorItemInfo("creditInst.*"));
        sic.add(new SelectorItemInfo("company.*"));
        return sic;
    }

    @Override
    protected void setFieldsNull(AbstractObjectValue vo) {
        super.setFieldsNull(vo);
        vo.put("applyResult", (Object)new Integer(3));
        vo.put("billState", (Object)new Integer(1));
        vo.put("isCreateToLimit", (Object)Boolean.FALSE);
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        vo.put("creator", (Object)userInfo);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        vo.put("org", (Object)currentCompany);
    }

    protected boolean isModifySave() {
        return BillStateEnum.SAVED.equals((Object)this.getBillState());
    }
}

