/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.fin.CreditLimitBillStatusEnum;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitStatusEnum;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.ICreditLimit;
import com.kingdee.eas.fm.fin.client.AbstractCreditLimitListUI;
import com.kingdee.eas.fm.fin.client.CreditLimitEditUI;
import com.kingdee.eas.fm.fin.client.CreditLimitFilterParam;
import com.kingdee.eas.fm.fin.client.CreditLimitFilterUI;
import com.kingdee.eas.fm.fin.client.CreditLimitRepaireResultUI;
import com.kingdee.eas.fm.fin.client.CreditLimitUsedListUI;
import com.kingdee.eas.fm.fin.client.SetCreditExpiredDateUI;
import com.kingdee.eas.fm.fin.client.SetCreditQuotaAmountUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CreditLimitListUI
extends AbstractCreditLimitListUI {
    private CreditLimitFilterUI filterUI = null;
    private IKDTablePrecisionFormater precFormater = null;
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    FillListener fillListener = new FillListener();
    private static final Logger logger = CoreUIObject.getLogger(CreditLimitListUI.class);
    private Boolean editAtAudit = false;
    static final String tdTemplateFile = "/FM/FIN/CREDITLIMIT";

    public CreditLimitListUI() throws Exception {
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
        this.precFormater = new DefaultKDTablePrecisionFormater();
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
        CreditLimitFactory.getRemoteInstance().updateIsClosed();
    }

    private String getResString(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.kDMenuItemUsed.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.btnCloseCreditLimit.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.actionAntiClosed.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionSetQuotaAmount.setEnabled(true);
        this.actionClosedByHand.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_close"));
        this.actionAntiClosedByHand.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_fclose"));
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        FinClientHelper.setExchangeFmt(this.tblMain.getColumn("ExchangeRate"), 4);
        super.onLoad();
        this.kDMenuItemClose.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnViewUsed.setIcon(EASResource.getIcon((String)"imgTbtn_bill"));
        this.checkBizUnit();
        this.btnAuditResult.setVisible(false);
        CreditLimitFilterParam clParam = (CreditLimitFilterParam)((Object)this.getFilterUI().getParam());
        if (clParam.getStateType() != 1 && clParam.getStateType() != 2 && clParam.getStateType() != 3) {
            this.tblMain.getColumn("newState").getStyleAttributes().setHided(true);
        }
        boolean isMustAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN014", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId().toString()));
        this.actionAudit.setVisible(isMustAudit);
        this.actionAntiAudit.setVisible(isMustAudit);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.menuItemTDPrint.setEnabled(true);
        this.menuItemTDPrintPreview.setEnabled(true);
        this.tblMain.getColumn("IssueDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("ExpiredDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("creditCloseDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    private void seeCreditLimitRepaird() {
        HashMap map = new HashMap();
        map.putAll(this.getUIContext());
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CreditLimitRepaireResultUI.class.getName(), map, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (UIException e) {
            this.handUIException(e);
        }
    }

    protected String[] getNotOrderColumns() {
        return new String[]{"newState"};
    }

    @Override
    protected String getEditUIName() {
        return CreditLimitEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CreditLimitFactory.getRemoteInstance();
    }

    @Override
    public void actionCloseCreditLimit_actionPerformed(ActionEvent e) throws Exception {
        Date now;
        super.actionCloseCreditLimit_actionPerformed(e);
        this.checkBizUnit();
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        Date expiredDate = (Date)row.getCell("ExpiredDate").getValue();
        if (expiredDate == null) {
            this.abort();
        }
        if ((now = DateUtil.getDayBegin()).before(expiredDate) || now.equals(expiredDate)) {
            int msgRet = MsgBox.showConfirm2((String)this.getResString("ConfirmDeleteCreditLimit"));
            if (msgRet == 0) {
                ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
                CreditLimitFactory.getRemoteInstance().close((IObjectPK)pk);
                this.refreshList();
            }
        } else if (now.after(expiredDate) && DateUtil.dateDiff((String)"m", (Date)expiredDate, (Date)now) <= 3L) {
            int msgRet = MsgBox.showConfirm2((String)this.getResString("CreditLimitConfirmClose"));
            if (msgRet == 0) {
                ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
                CreditLimitFactory.getRemoteInstance().close((IObjectPK)pk);
                this.refreshList();
            }
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
            CreditLimitFactory.getRemoteInstance().close((IObjectPK)pk);
            this.refreshList();
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkBizUnit();
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        boolean IsUnion = (Boolean)row.getCell("IsUnion").getValue();
        boolean IsClosed = (Boolean)row.getCell("IsClosed").getValue();
        String id = row.getCell("id").getValue().toString();
        BizEnumValueDTO status = (BizEnumValueDTO)row.getCell("billStatus").getValue();
        if (IsClosed) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ISCLOSEDNOTDEL"));
            return;
        }
        if (IsUnion) {
            CreditLimitFactory.getRemoteInstance().deleteUnionBill((IObjectPK)new ObjectUuidPK(id));
            this.refreshList();
        } else {
            if (this.ifHaveDestBills(this.getSelectedKeyValue())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"HAVEDESTBILL_1"));
                return;
            }
            super.actionRemove_actionPerformed(e);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        String id = row.getCell("id").getValue().toString();
        boolean IsClosed = (Boolean)row.getCell("IsClosed").getValue();
        BizEnumValueDTO status = (BizEnumValueDTO)row.getCell("billStatus").getValue();
        if (IsClosed) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"ISCLOSEDNOTEDIT"));
            return;
        }
        if (1 == status.getInt()) {
            this.editAtAudit = true;
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionViewUsed_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        Object mainUI = null;
        mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)uiContext);
        IUIObject uiObject = mainUI.getUiManager().findUIObject(CreditLimitUsedListUI.class.getName(), (Map)uiContext, this.dataObjects, OprtState.VIEW);
        IUIWindow uiWindowNew = null;
        if (uiObject != null) {
            uiWindowNew = uiObject.getUIWindow();
            uiWindowNew.close();
        }
        HashMap<String, ArrayList> map = new HashMap<String, ArrayList>();
        map.putAll(this.getUIContext());
        map.put("CreditLimitIds", this.getSelectedIdValues());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CreditLimitUsedListUI.class.getName(), map, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void actionCheckOverdue_actionPerformed(ActionEvent e) throws Exception {
        CreditLimitFactory.getRemoteInstance().checkOverdue();
    }

    @Override
    public void actionAntiClosed_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        CreditLimitFactory.getRemoteInstance().anticlose((IObjectPK)pk);
        this.refreshList();
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    protected void checkBizUnit() throws EASBizException, BOSException {
        if (ContextHelperFactory.getRemoteInstance().isOnlyUnion(this.currentCompanyCommon)) {
            this.btnAddNew.setVisible(false);
            this.menuItemAddNew.setVisible(false);
            this.btnEdit.setVisible(false);
            this.menuItemEdit.setVisible(false);
            this.btnRemove.setVisible(false);
            this.menuItemRemove.setVisible(false);
            this.btnCloseCreditLimit.setVisible(false);
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CreditLimitFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[0];
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"QuotaAmount", "Balance", "UsedAmount"};
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        CreditLimitFilterParam clParam = (CreditLimitFilterParam)((Object)this.getFilterUI().getParam());
        if (clParam.getStateType() != 1 && clParam.getStateType() != 2 && clParam.getStateType() != 3) {
            this.tblMain.getColumn("newState").getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn("newState").getStyleAttributes().setHided(false);
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow iRow = this.tblMain.getRow(i);
                if (clParam.getStateType() == 1) {
                    iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.INEFFECTIVE);
                }
                if (clParam.getStateType() == 2) {
                    iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.EFFECTIVE);
                }
                if (clParam.getStateType() != 3) continue;
                iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.EXPIRED);
            }
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        CreditLimitFilterParam clParam = (CreditLimitFilterParam)((Object)this.getFilterUI().getParam());
        if (clParam.getStateType() != 1 && clParam.getStateType() != 2 && clParam.getStateType() != 3) {
            this.tblMain.getColumn("newState").getStyleAttributes().setHided(true);
        } else {
            this.tblMain.getColumn("newState").getStyleAttributes().setHided(false);
            int n = this.tblMain.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow iRow = this.tblMain.getRow(i);
                if (clParam.getStateType() == 1) {
                    iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.INEFFECTIVE);
                }
                if (clParam.getStateType() == 2) {
                    iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.EFFECTIVE);
                }
                if (clParam.getStateType() != 3) continue;
                iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.EXPIRED);
            }
        }
    }

    protected boolean ifHaveDestBills(String billIdString) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)billIdString, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        BOTRelationCollection relations = BOTRelationFactory.getRemoteInstance().getCollection(viewInfo);
        return relations != null && relations.size() != 0;
    }

    private boolean checkeUsedAddNew(String id) throws BOSException {
        String sql = " select *  from T_FIN_CreditLimitUsed where fIsUnionAddnew=0 and FCreditLimitId='" + id + "'";
        ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = exec.executeSQL();
        boolean result = false;
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    protected void execQuery() {
        try {
            CreditLimitFactory.getRemoteInstance().updateIsClosed();
        }
        catch (BOSException e) {
            logger.error((Object)("UPDATE IS ClOSE ERROR " + e.getMessage()));
        }
        super.execQuery();
        this.formatFootRow();
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CreditLimitFilterParam param = (CreditLimitFilterParam)((Object)this.getFilterUI().getParam());
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyId() == null ? company.getBaseCurrency().getId().toString() : param.getCurrencyId();
            String[] columns = new SumFiledsInfo(SumBillEnum.CreditLimit).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    @Override
    public void actionUpdateCloseDate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        boolean flag = true;
        flag = CreditLimitFactory.getRemoteInstance().inspectCreditLimitIsByUnion(row.getCell("id").getValue().toString());
        if (flag) {
            String str = EASResource.getString((String)"com.kingdee.eas.fm.fin.CreditLimitIsBringIntoResource.isBringInto");
            MsgBox.showInfo((String)str);
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SetCreditExpiredDateUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionSetQuotaAmount_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowNumber);
        boolean flag = true;
        flag = CreditLimitFactory.getRemoteInstance().inspectCreditLimitIsByUnion(row.getCell("id").getValue().toString());
        if (flag) {
            String str = EASResource.getString((String)"com.kingdee.eas.fm.fin.CreditLimitIsBringIntoResource.isBringInto");
            MsgBox.showInfo((String)str);
            return;
        }
        CreditLimitInfo info = this.getInfo(row.getCell("id").getValue().toString());
        if (info.getShareType().getValue() == 2) {
            MsgBox.showInfo((String)this.getResString("creditLimitListUI_error01"));
            return;
        }
        if (info.isIsClosed()) {
            MsgBox.showInfo((String)this.getResString("creditLimitListUI_error02"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SetCreditQuotaAmountUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    public CreditLimitInfo getInfo(String creditLimitID) throws EASBizException, BOSException {
        CreditLimitInfo info = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitID));
        return info;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        CasRecPayHandler.checkBillsHasWF((List)idList);
        boolean hasWfInstance = FMHelper.hasWFInstance(null, (String)((String)idList.get(0)));
        if (hasWfInstance) {
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])idList.toArray(new String[idList.size()]));
            return;
        }
        ((ICreditLimit)this.getBizInterface()).audit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.refreshList();
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String id = (String)idList.get(0);
        ICreditLimit iCreditLimit = (ICreditLimit)this.getBizInterface();
        if (iCreditLimit.checkUsed(id)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"163_CreditLimitListUI"));
            return;
        }
        iCreditLimit.antiAudit((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.refreshList();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() == 0) {
            return;
        }
        String id = (String)idList.get(0);
        CreditLimitInfo sourceBill = ((ICreditLimit)this.getBizInterface()).getCreditLimitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        this.actionAudit.setEnabled(sourceBill.getBillStatus().equals((Object)CreditLimitBillStatusEnum.SUBMIT));
        this.actionAntiAudit.setEnabled(sourceBill.getBillStatus().equals((Object)CreditLimitBillStatusEnum.AUDIT));
        this.currentCompanyCommon = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isMustAudit = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN014", (IObjectPK)new ObjectUuidPK(this.currentCompanyCommon.getId()));
        CreditLimitBillStatusEnum status = sourceBill.getBillStatus();
        boolean isClosed = sourceBill.isIsClosed();
        boolean isClosedByHand = sourceBill.isIsClosedByHand();
        if (isClosed) {
            this.actionClosedByHand.setEnabled(false);
        } else if (isMustAudit && status.equals((Object)CreditLimitBillStatusEnum.AUDIT) || !isMustAudit && status.getValue() >= 0) {
            this.actionClosedByHand.setEnabled(true);
        } else {
            this.actionClosedByHand.setEnabled(false);
        }
        if (isClosedByHand && isClosed) {
            this.actionAntiClosedByHand.setEnabled(true);
        } else {
            this.actionAntiClosedByHand.setEnabled(false);
        }
        if (status.getValue() == 1) {
            this.actionRemove.setEnabled(false);
        } else {
            this.actionRemove.setEnabled(true);
            this.actionEdit.setEnabled(true);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.CreditLimitTDQuery");
    }

    @Override
    public void actionClosedByHand_actionPerformed(ActionEvent e) throws Exception {
        Date now;
        this.checkBizUnit();
        this.checkSelected();
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        Date expiredDate = (Date)row.getCell("ExpiredDate").getValue();
        if (expiredDate == null) {
            this.abort();
        }
        if ((now = DateUtil.getDayBegin()).before(expiredDate) || now.equals(expiredDate)) {
            int msgRet = MsgBox.showConfirm2((String)this.getResString("ConfirmDeleteCreditLimit"));
            if (msgRet == 0) {
                ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
                CreditLimitFactory.getRemoteInstance().closeByHand((IObjectPK)pk);
                this.refreshList();
            }
        } else if (now.after(expiredDate) && DateUtil.dateDiff((String)"m", (Date)expiredDate, (Date)now) <= 3L) {
            int msgRet = MsgBox.showConfirm2((String)this.getResString("CreditLimitConfirmClose"));
            if (msgRet == 0) {
                ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
                CreditLimitFactory.getRemoteInstance().closeByHand((IObjectPK)pk);
                this.refreshList();
            }
        } else {
            ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
            CreditLimitFactory.getRemoteInstance().closeByHand((IObjectPK)pk);
            this.refreshList();
        }
    }

    @Override
    public void actionAntiClosedByHand_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        CreditLimitFactory.getRemoteInstance().antiCloseByHand((IObjectPK)pk);
        this.refreshList();
        FMClientHelper.showSuccessMessage((CoreUI)this, (ActionEvent)e);
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "IssueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionAntiAudit"};
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.editAtAudit.booleanValue()) {
            uiContext.put((Object)"editAtAudit", (Object)this.editAtAudit);
            this.editAtAudit = false;
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            if (e == null) {
                return;
            }
            int firstRow = e.getFirstRow();
            int lastRow = e.getLastRow();
            this.setStateType(firstRow, lastRow);
        }

        private void setStateType(int firstRow, int lastRow) {
            IRow iRow = null;
            CreditLimitFilterParam clParam = null;
            try {
                clParam = (CreditLimitFilterParam)((Object)CreditLimitListUI.this.getFilterUI().getParam());
            }
            catch (Exception e) {
                CreditLimitListUI.this.handUIExceptionAndAbort(e);
            }
            if (clParam == null) {
                CreditLimitListUI.this.tblMain.getColumn("newState").getStyleAttributes().setHided(true);
                return;
            }
            if (clParam.getStateType() != 1 && clParam.getStateType() != 2 && clParam.getStateType() != 3) {
                CreditLimitListUI.this.tblMain.getColumn("newState").getStyleAttributes().setHided(true);
            } else {
                CreditLimitListUI.this.tblMain.getColumn("newState").getStyleAttributes().setHided(false);
                for (int i = firstRow; i <= lastRow; ++i) {
                    iRow = CreditLimitListUI.this.tblMain.getRow(i);
                    if (clParam.getStateType() == 1) {
                        iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.INEFFECTIVE);
                    }
                    if (clParam.getStateType() == 2) {
                        iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.EFFECTIVE);
                    }
                    if (clParam.getStateType() != 3) continue;
                    iRow.getCell("newState").setValue((Object)CreditLimitStatusEnum.EXPIRED);
                }
            }
        }
    }
}

