/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.AliasTextValueProvider;
import com.kingdee.eas.fm.common.client.ColumnUserCellDisplayParser;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IValueProvider;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditLimitRepairFacadeFactory;
import com.kingdee.eas.fm.fin.CreditLimitUsedCollection;
import com.kingdee.eas.fm.fin.CreditLimitUsedInfo;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractCreditLimitRepaireResultUI;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditLimitRepaireResultUI
extends AbstractCreditLimitRepaireResultUI {
    private static final Logger logger = CoreUIObject.getLogger(CreditLimitRepaireResultUI.class);
    Map resultMap = new HashMap();
    Set creditLimitSet = new HashSet();

    public CreditLimitRepaireResultUI() throws Exception {
        this.usedTable.checkParsed();
        this.creditLimitTable.checkParsed();
        ColumnUserCellDisplayParser displayParser = new ColumnUserCellDisplayParser(this.usedTable);
        AliasTextValueProvider provider = new AliasTextValueProvider();
        provider.add((Object)new LoanInfo().getBOSType().toString(), this.getResString("Loan"));
        provider.add((Object)new PayableBillInfo().getBOSType().toString(), this.getResString("CommercialDraft"));
        provider.add((Object)new LetterOfCreditInfo().getBOSType().toString(), this.getResString("LetterOfCredit"));
        provider.add((Object)new LetterOfGuaranteeInfo().getBOSType().toString(), this.getResString("LetterOfGuarantee"));
        displayParser.addValueProvider("billType", (IValueProvider)provider);
    }

    private String getResString(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fm.fin.client.FinClientResource", (String)key);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.resultMap = new HashMap();
        try {
            this.resultMap = CreditLimitRepairFacadeFactory.getRemoteInstance().checkCreditLimit();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (this.resultMap.size() > 0) {
            this.creditLimitSet = this.resultMap.keySet();
            this.fillCreditLimit();
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void fillCreditLimit() {
        this.creditLimitTable.removeRows();
        int i = 0;
        for (CreditLimitInfo creditLimit : this.creditLimitSet) {
            this.addCreditLimitRow(creditLimit, EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"510_CreditLimitRepaireResultUI"));
            CreditLimitInfo repairedCreditLimit = this.getRepairedCreditLimit(creditLimit);
            this.addCreditLimitRow(repairedCreditLimit, EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"511_CreditLimitRepaireResultUI"));
            this.creditLimitTable.getMergeManager().mergeBlock(i * 2, 1, i * 2 + 1, 1);
            this.creditLimitTable.getMergeManager().mergeBlock(i * 2, 2, i * 2 + 1, 2);
            this.creditLimitTable.getMergeManager().mergeBlock(i * 2, 3, i * 2 + 1, 3);
            ++i;
        }
    }

    private CreditLimitInfo getRepairedCreditLimit(CreditLimitInfo creditLimit) {
        CreditLimitInfo repairedCreditLimit = (CreditLimitInfo)creditLimit.clone();
        Map creditLimitResult = (Map)this.resultMap.get(creditLimit);
        BigDecimal repairedUsedAmount = (BigDecimal)creditLimitResult.get("sumUsedInFactQuota");
        repairedCreditLimit.setUsedAmount(repairedUsedAmount);
        BigDecimal repairedBalance = repairedCreditLimit.getQuotaAmount().subtract(repairedCreditLimit.getUsedAmount());
        repairedCreditLimit.setBalance(repairedBalance);
        return repairedCreditLimit;
    }

    private void addCreditLimitRow(CreditLimitInfo creditLimit, String state) {
        IRow row1 = this.creditLimitTable.addRow();
        row1.getCell("id").setValue((Object)creditLimit.getId().toString());
        row1.getCell("isRepair").setValue((Object)new Boolean(false));
        row1.getCell("company").setValue((Object)creditLimit.getCompany().getName());
        row1.getCell("number").setValue((Object)creditLimit.getNumber());
        row1.getCell("state").setValue((Object)state);
        row1.getCell("quotaAmount").setValue((Object)creditLimit.getQuotaAmount().setScale(4, 4));
        row1.getCell("usedAmount").setValue((Object)creditLimit.getUsedAmount().setScale(4, 4));
        row1.getCell("balance").setValue((Object)creditLimit.getBalance().setScale(4, 4));
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    protected IObjectValue createNewData() {
        return null;
    }

    @Override
    protected void creditLimitTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.creditLimitTable_tableSelectChanged(e);
        this.usedTable.removeRows();
        int selectedRow = FMClientHelper.getSelectedRow((KDTable)this.creditLimitTable);
        String selectedCreditLimitID = (String)this.creditLimitTable.getRow(selectedRow).getCell("id").getValue();
        CreditLimitInfo selectedCreditLimitInfo = this.getSelectedCreditLimitInfo(selectedCreditLimitID);
        if (selectedCreditLimitInfo == null) {
            return;
        }
        this.fillCreditLimitUsed(selectedCreditLimitInfo);
    }

    private void fillCreditLimitUsed(CreditLimitInfo selectedCreditLimitInfo) {
        Map creditLimitResult = (Map)this.resultMap.get(selectedCreditLimitInfo);
        Map correctMap = (Map)creditLimitResult.get("correctMap");
        if (correctMap == null) {
            return;
        }
        Set newUsedSet = correctMap.keySet();
        int i = 0;
        for (Object newUsedInfo : newUsedSet) {
            if (newUsedInfo instanceof CreditLimitUsedInfo) {
                CreditLimitUsedInfo oldUsedInfo = (CreditLimitUsedInfo)correctMap.get(newUsedInfo);
                if (oldUsedInfo != null) {
                    this.addUsedTableRow(oldUsedInfo, EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"510_CreditLimitRepaireResultUI"));
                } else {
                    this.addNullRow((CreditLimitUsedInfo)newUsedInfo, EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"510_CreditLimitRepaireResultUI"));
                }
                this.addUsedTableRow((CreditLimitUsedInfo)newUsedInfo, EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"511_CreditLimitRepaireResultUI"));
            }
            if (newUsedInfo instanceof CreditLimitUsedCollection) {
                for (int j = 0; j < ((CreditLimitUsedCollection)((Object)newUsedInfo)).size(); ++j) {
                    CreditLimitUsedInfo usedInfo = ((CreditLimitUsedCollection)((Object)newUsedInfo)).get(j);
                    this.addNullRow(usedInfo, EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"510_CreditLimitRepaireResultUI"));
                    this.addUsedTableRow(usedInfo, EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"511_CreditLimitRepaireResultUI"));
                }
            }
            this.usedTable.getMergeManager().mergeBlock(i * 2, 1, i * 2 + 1, 1);
            this.usedTable.getMergeManager().mergeBlock(i * 2, 2, i * 2 + 1, 2);
            ++i;
        }
    }

    private void addNullRow(CreditLimitUsedInfo newUsedInfo, String state) {
        IRow row1 = this.usedTable.addRow();
        row1.getCell("billType").setValue((Object)newUsedInfo.getBillType());
        row1.getCell("billNumber").setValue((Object)newUsedInfo.getBillNumber());
        row1.getCell("state").setValue((Object)state);
    }

    private void addUsedTableRow(CreditLimitUsedInfo newUsedInfo, String state) {
        IRow row1 = this.usedTable.addRow();
        row1.getCell("id").setValue((Object)newUsedInfo.getId());
        row1.getCell("billType").setValue((Object)newUsedInfo.getBillType());
        row1.getCell("billNumber").setValue((Object)newUsedInfo.getBillNumber());
        row1.getCell("state").setValue((Object)state);
        row1.getCell("usedQuota").setValue((Object)newUsedInfo.getUsedQuota().setScale(4, 4));
        row1.getCell("returnedQuota").setValue((Object)newUsedInfo.getReturnedQuota().setScale(4, 4));
        row1.getCell("usedInFactQuota").setValue((Object)newUsedInfo.getUsedQuota().subtract(newUsedInfo.getReturnedQuota()).setScale(4, 4));
    }

    private CreditLimitInfo getSelectedCreditLimitInfo(String selectedCreditLimitID) {
        for (CreditLimitInfo creditLimitInfo : this.creditLimitSet) {
            if (!creditLimitInfo.getId().toString().equals(selectedCreditLimitID)) continue;
            return creditLimitInfo;
        }
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        int msgRet;
        int rowCount = this.creditLimitTable.getRowCount();
        if (rowCount == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"512_CreditLimitRepaireResultUI"));
        }
        if ((msgRet = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"513_CreditLimitRepaireResultUI"))) == 0) {
            HashMap<CreditLimitInfo, List> selectedRepairMap = new HashMap<CreditLimitInfo, List>();
            for (int i = 0; i < rowCount; i += 2) {
                Boolean isRepair = (Boolean)this.creditLimitTable.getRow(i).getCell("isRepair").getValue();
                String id = (String)this.creditLimitTable.getRow(i).getCell("id").getValue();
                if (!isRepair.booleanValue()) continue;
                CreditLimitInfo selectedCreditLimitInfo = this.getSelectedCreditLimitInfo(id);
                CreditLimitInfo repairedCreditLimitInfo = this.getRepairedCreditLimit(selectedCreditLimitInfo);
                selectedRepairMap.put(repairedCreditLimitInfo, null);
                Map creditLimitResult = (Map)this.resultMap.get(selectedCreditLimitInfo);
                Map correctMap = (Map)creditLimitResult.get("correctMap");
                if (correctMap == null) continue;
                Set newUsedSet = correctMap.keySet();
                List newUsedList = FMHelper.set2List(newUsedSet);
                selectedRepairMap.put(repairedCreditLimitInfo, newUsedList);
            }
            if (selectedRepairMap.size() == 0) {
                return;
            }
            CreditLimitRepairFacadeFactory.getRemoteInstance().repairCreditLimit(selectedRepairMap);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"514_CreditLimitRepaireResultUI"));
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }
}

