/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.common.client.AliasTextValueProvider;
import com.kingdee.eas.fm.common.client.ColumnUserCellDisplayParser;
import com.kingdee.eas.fm.common.client.DefaultKDTCurrencyProvider;
import com.kingdee.eas.fm.common.client.DefaultKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IKDTPrecisionProvider;
import com.kingdee.eas.fm.common.client.IKDTablePrecisionFormater;
import com.kingdee.eas.fm.common.client.IValueProvider;
import com.kingdee.eas.fm.ctl.LetterOfGuaranteeInfo;
import com.kingdee.eas.fm.fin.CreditLimitUsedFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.client.AbstractCreditLimitUsedListUI;
import com.kingdee.eas.fm.fin.client.CreditLimitUsedFilterParam;
import com.kingdee.eas.fm.fin.client.CreditLimitUsedFilterUI;
import com.kingdee.eas.fm.ibt.BillRediscountOutInfo;
import com.kingdee.eas.fm.ibt.CreditAssetsTransferOutInfo;
import com.kingdee.eas.fm.ibt.InnerFinancingBorrowingInInfo;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class CreditLimitUsedListUI
extends AbstractCreditLimitUsedListUI {
    public static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    private static final Logger logger = CoreUIObject.getLogger(CreditLimitUsedListUI.class);
    private CommonQueryDialog queryDlg = null;
    private CreditLimitUsedFilterUI filterUI = null;
    private IKDTablePrecisionFormater precFormater = null;
    public static final String CreditLimitIdMap = "CreditLimitIds";
    public static final String UsedCreditLimitBillIds = "UsedCreditLimitBillIds";
    FillListener fillListener = new FillListener();

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        try {
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(300);
            this.queryDlg.setWidth(500);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(EASResource.getString((String)RESOURCE, (String)"filterUITitle"));
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return this.queryDlg;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CreditLimitUsedFilterUI();
        }
        this.filterUI.setListUI((IUIObject)this);
        return this.filterUI;
    }

    public CreditLimitUsedListUI() throws Exception {
        ColumnUserCellDisplayParser displayParser = new ColumnUserCellDisplayParser(this.tblMain);
        AliasTextValueProvider provider = new AliasTextValueProvider();
        provider.add((Object)new LoanInfo().getBOSType().toString(), this.getResString("Loan"));
        provider.add((Object)new PayableBillInfo().getBOSType().toString(), this.getResString("CommercialDraft"));
        provider.add((Object)new LetterOfCreditInfo().getBOSType().toString(), this.getResString("LetterOfCredit"));
        provider.add((Object)new LetterOfGuaranteeInfo().getBOSType().toString(), this.getResString("LetterOfGuarantee"));
        provider.add((Object)new InnerFinancingBorrowingInInfo().getBOSType().toString(), this.getResString("InnerFinancingBorrowingIn"));
        provider.add((Object)new BillRediscountOutInfo().getBOSType().toString(), this.getResString("BillRediscountOut"));
        provider.add((Object)new CreditAssetsTransferOutInfo().getBOSType().toString(), this.getResString("CreditAssetsTransferOut"));
        provider.add((Object)new LoanFetchInfo().getBOSType().toString(), this.getResString("LoanFetch"));
        provider.add((Object)new BondReleaseReportInfo().getBOSType().toString(), this.getResString("bondReleaseReport"));
        displayParser.addValueProvider("BillType", (IValueProvider)provider);
        this.precFormater = new DefaultKDTablePrecisionFormater();
        this.precFormater.setPrecProvider((IKDTPrecisionProvider)new DefaultKDTCurrencyProvider(this.getCurrencyIdColName()));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private String getResString(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CreditLimitUsedFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.precFormater.init(this.getMainTable(), this.getPrecColName());
        super.onLoad();
        CreditLimitUsedFilterParam clParam = (CreditLimitUsedFilterParam)((Object)this.getFilterUI().getParam());
        this.mainQuery.setFilter(clParam.getFilter());
        this.mainQuery.setFilter(new FilterInfo());
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.fin.app", "CreditLimitUsedQuery");
        ArrayList creditLimitIdList = (ArrayList)this.getUIContext().get(CreditLimitIdMap);
        ArrayList UsedCreditLimitBillList = (ArrayList)this.getUIContext().get(UsedCreditLimitBillIds);
        Set creditLimitIdSet = this.getCreditLimitIdSet(creditLimitIdList);
        if (creditLimitIdSet.size() > 0) {
            this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitIdSet, CompareType.INCLUDE));
            this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
        }
        if (UsedCreditLimitBillList != null && UsedCreditLimitBillList.size() > 0) {
            HashSet UsedCreditLimitBillIdSet = new HashSet();
            int n = UsedCreditLimitBillList.size();
            for (int i = 0; i < n; ++i) {
                UsedCreditLimitBillIdSet.add(UsedCreditLimitBillList.get(i));
            }
            this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("BillId", UsedCreditLimitBillIdSet, CompareType.INCLUDE));
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
            FilterInfo companyFilter = new FilterInfo();
            companyFilter.getFilterItems().add(new FilterItemInfo("Company.id", (Object)company.getId().toString()));
            companyFilter.getFilterItems().add(new FilterItemInfo("creditcompany.id", (Object)company.getId().toString()));
            companyFilter.setMaskString("#0 or #1");
            this.mainQuery.getFilter().mergeFilter(companyFilter, "AND");
            this.mainQuery = this.getEntityViewInfo(this.mainQuery);
        }
        SorterItemInfo sc = new SorterItemInfo("BillType");
        this.mainQuery.getSorter().add(sc);
        this.execQuery();
        this.tblMain.getColumn("usingCompany").getStyleAttributes().setHided(true);
        this.tblMain.getColumn("usingBank").getStyleAttributes().setHided(true);
        String dformat = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("IssueDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("ExpiredDate").getStyleAttributes().setNumberFormat(dformat);
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void execQuery() {
        ArrayList creditLimitIdList;
        Set creditLimitIdSet;
        this.sumIt();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fm.fin.app", "CreditLimitUsedQuery");
        if ("FINDVIEW".equals(this.getOprtState()) && (creditLimitIdSet = this.getCreditLimitIdSet(creditLimitIdList = (ArrayList)this.getUIContext().get(CreditLimitIdMap))).size() > 0) {
            this.mainQuery.setFilter(new FilterInfo());
            this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("CreditLimit.id", (Object)creditLimitIdSet, CompareType.INCLUDE));
            this.mainQuery.getFilter().getFilterItems().add(new FilterItemInfo("IsUnioned", (Object)"0"));
            SorterItemCollection sic = new SorterItemCollection();
            sic.add(new SorterItemInfo("CreditLimit.number"));
            sic.add(new SorterItemInfo("BillType"));
            this.mainQuery.setSorter(sic);
        }
        try {
            if (this.getOprtState().equals(OprtState.VIEW)) {
                CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                if (!ContextHelperFactory.getRemoteInstance().isOnlyUnion(company)) {
                    FilterInfo companyFilter = new FilterInfo();
                    companyFilter.getFilterItems().add(new FilterItemInfo("Company.id", (Object)company.getId().toString()));
                    companyFilter.getFilterItems().add(new FilterItemInfo("creditcompany.id", (Object)company.getId().toString()));
                    companyFilter.setMaskString("#0 or #1");
                    this.mainQuery.getFilter().mergeFilter(companyFilter, "AND");
                    this.mainQuery = this.getEntityViewInfo(this.mainQuery);
                }
            }
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
        this.setOprtState(OprtState.VIEW);
        super.execQuery();
        try {
            this.formatSumRow();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    private Set getCreditLimitIdSet(ArrayList creditLimitIdList) {
        HashSet creditLimitIdSet = new HashSet();
        if (creditLimitIdList != null) {
            int n = creditLimitIdList.size();
            for (int i = 0; i < n; ++i) {
                creditLimitIdSet.add(creditLimitIdList.get(i));
            }
        }
        return creditLimitIdSet;
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    private void sumIt() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("CreditLimit").setGroup(true);
        this.tblMain.getColumn("CreditLimit").setStat(true);
        this.tblMain.getGroupManager().setOrientation(1);
        IRow row0 = this.tblMain.getGroupManager().getStatRowTemplate(0);
        row0.getStyleAttributes().setBackground(new Color(16119270));
        row0.getCell("UsedQuota").setExpressions("SUM");
        row0.getCell("ReturnedQuota").setExpressions("SUM");
        row0.getCell("useInFactQuota").setExpressions("SUM");
        row0.getCell("UsedQuota").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("ReturnedQuota").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("useInFactQuota").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row0.getCell("Currency").setValue((Object)EASResource.getString((String)RESOURCE, (String)"SubTotal"));
    }

    private void formatSumRow() throws EASBizException, BOSException {
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            String currencyIdColName;
            IRow row = this.tblMain.getRow(i);
            Object objCurrencyId = row.getCell(currencyIdColName = this.getCurrencyIdColName()).getValue();
            if (objCurrencyId != null) continue;
            Object curencyIdUp = this.tblMain.getRow(i - 1).getCell(currencyIdColName).getValue();
            row.getCell(currencyIdColName).setValue(curencyIdUp);
            CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(curencyIdUp.toString()));
            int prec = cur.getPrecision();
            String formatString = FMClientHelper.getNumberFtm((int)prec);
            String[] cols = this.getPrecColName();
            int m = cols.length;
            for (int j = 0; j < m; ++j) {
                row.getCell(cols[j]).getStyleAttributes().setNumberFormat(formatString);
            }
        }
    }

    protected String getCurrencyIdColName() {
        return "CurrencyId";
    }

    protected String[] getPrecColName() {
        return new String[]{"UsedQuota", "ReturnedQuota", "useInFactQuota", "QuotaAmount", "Balance"};
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(CreditLimitUsedListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                if (row.getCell("creditCompany").getValue() != null) {
                    row.getCell("showValue").setValue(row.getCell("creditCompany").getValue());
                } else {
                    row.getCell("showValue").setValue(row.getCell("creditBank").getValue());
                }
                if (row.getCell("usingCompany").getValue() != null) {
                    row.getCell("usingOrg").setValue(row.getCell("usingCompany").getValue());
                    continue;
                }
                row.getCell("usingOrg").setValue(row.getCell("usingBank").getValue());
            }
        }
    }
}

