/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FeeManageFactory;
import com.kingdee.eas.fm.fin.FeeManageInfo;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.IFeeManage;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.client.AbstractFeeManageEditUI;
import com.kingdee.eas.fm.fin.client.FeeHandler;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class FeeManageEditUI
extends AbstractFeeManageEditUI {
    private BankJournalHandler bankJournalHandler = new BankJournalHandler();
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private static final Logger logger = CoreUIObject.getLogger(FeeManageEditUI.class);
    private LetterOfCreditInfo letterOfCreditInfo;
    private static final String RESOURCE = "com.kingdee.eas.fm.ctl.client.CTLClientResource";
    private static final String resourcePath = "com.kingdee.eas.fm.fin.client.FeeTypeMaintenanceResource";
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private int len = 0;
    private FeeHandler handler = new FeeHandler();

    public FeeManageEditUI() throws Exception {
        this.txtMoneyAmount.setPrecision(2);
        this.txtSxfzbwb.setPrecision(2);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkFinalCheckout();
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        this.checkFinalCheckout();
        String id = this.editData.getId().toString();
        this.isCanBook(id);
        super.actionSubmit_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return FeeManageFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        this.letterOfCreditInfo = (LetterOfCreditInfo)this.getUIContext().get("letterOfCreditID");
        FeeManageInfo objectValue = new FeeManageInfo();
        objectValue.setBusinessNumber(this.letterOfCreditInfo.getNumber());
        objectValue.setLetterCreditID(this.letterOfCreditInfo.getId().toString());
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.txtBusinessNumber.setEditable(false);
        this.txtSxfzbwb.setEditable(false);
        if (this.editData != null && this.editData.isIsCreatorBear()) {
            this.btnRegister.setEnabled(true);
        } else {
            this.btnRegister.setEnabled(false);
        }
        this.prmtFeeName.setQueryInfo("com.kingdee.eas.fm.fin.app.FeeTypeMaintenanceQuery");
        this.prmtFeeName.setEditable(true);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AssociateType", (Object)"3"));
        filter.getFilterItems().add(new FilterItemInfo("enabled", (Object)"1"));
        entityViewInfo.setFilter(filter);
        this.prmtFeeName.setEntityViewInfo(entityViewInfo);
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtBearDept);
        this.prmtCurrency.setQueryInfo("com.kingdee.eas.basedata.assistant.app.CurrencyQuery");
        this.prmtCurrency.setEditable(true);
        this.prmtCurrency.setVisible(true);
        this.prmtCurrency.setDisplayFormat("$name$");
        this.prmtCurrency.setEditFormat("$number$");
        this.prmtCurrency.setCommitFormat("$number$");
        this.prmtAccountBank.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.prmtAccountBank.setEditable(true);
        this.prmtAccountBank.setVisible(true);
        this.prmtAccountBank.setDisplayFormat("$name$");
        this.prmtAccountBank.setEditFormat("$number$");
        this.prmtAccountBank.setCommitFormat("$number$");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        evi.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        this.prmtAccountBank.setEntityViewInfo(evi);
        this.prmtAccountview.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        this.prmtAccountview.setEditable(false);
        this.prmtAccountview.setVisible(true);
        this.prmtAccountview.setDisplayFormat("$name$");
        this.prmtAccountview.setEditFormat("$number$");
        this.prmtAccountview.setCommitFormat("$number$");
        NTHelper.setF7AccountEvi((IUIObject)this, (String)this.CURRENT_COMPANY.getBaseCurrency().getId().toString(), (CompanyOrgUnitInfo)this.CURRENT_COMPANY, (KDBizPromptBox)this.prmtAccountview);
        super.onLoad();
        this.checkIsCreatorBear();
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtMoneyAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtSxfzbwb);
        if (this.getOprtState().equals("VIEW")) {
            // empty if block
        }
        FeeManageInfo info = (FeeManageInfo)this.getDataObject();
        if (!this.company.getBaseCurrency().getId().toString().equals(this.editData.getCurrency().getId().toString())) {
            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, this.company, this.editData.getCurrency(), this.company.getBaseCurrency(), info.getBizDate());
            this.kDexcahange.setPrecision(exchangeRateInfo == null ? 2 : exchangeRateInfo.getPrecision());
        }
        this.kDexcahange.setHorizontalAlignment(4);
        this.kDexcahange.setMinimumValue((Comparable)new BigDecimal(0));
        this.kDexcahange.setRemoveingZeroInDispaly(false);
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!this.isisClearinghouse(currentCompany)) {
            this.contInnerAccount.setEnabled(false);
        }
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionAddNew.setEnabled(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
    }

    protected void initDataStatus() {
        CurrencyInfo currencyinfo;
        super.initDataStatus();
        FeeManageInfo info = (FeeManageInfo)this.getDataObject();
        boolean isBooked = info.getCashier() != null;
        this.actionEdit.setEnabled(!isBooked);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionCreateFrom.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionRegister.setVisible(false);
        if (this.getOprtState().equals(OprtState.EDIT) && (currencyinfo = (CurrencyInfo)this.prmtCurrency.getValue()) != null && this.company.getBaseCurrency() != null && this.company.getBaseCurrency().getId().toString().equals(currencyinfo.getId().toString())) {
            this.kDexcahange.setEditable(false);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("cashier.id");
        return sic;
    }

    public boolean isisClearinghouse(CompanyOrgUnitInfo currentCompany) throws EASBizException, BOSException {
        boolean flag = BankFactory.getRemoteInstance().isClearinghouseCompany(currentCompany.getId().toString());
        return flag;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtCurrency, (String)"CurrencyIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (Object)this.pkBizDate.getText(), (String)"BizDateIsNull");
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtFeeName, (String)"FeeNameIsNull");
        if (this.chkIsCreatorBear.isSelected()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDBizPromptBox)this.prmtBearDept, (String)"BearDeptIsNull");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDFormattedTextField)this.txtMoneyAmount, (String)"AmountIsNull");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)resourcePath, (KDFormattedTextField)this.kDexcahange, (String)"ExchangeRateIsNull");
        }
    }

    @Override
    protected void txtMoneyAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.sxfzbwb();
        super.txtMoneyAmount_dataChanged(e);
    }

    public void sxfzbwb() {
        if (!this.txtMoneyAmount.getText().equals("") && !this.kDexcahange.getText().equals("")) {
            BigDecimal moneyAmount = new BigDecimal(this.txtMoneyAmount.getValue().toString());
            if (moneyAmount != null && moneyAmount.doubleValue() == 0.0) {
                this.txtMoneyAmount.setValue((Object)this.editData.getMoneyAmount());
                return;
            }
            this.editData.setMoneyAmount(moneyAmount);
            BigDecimal exchangeRate = new BigDecimal(String.valueOf(this.kDexcahange.getNumberValue()));
            BigDecimal sxfzbwb = moneyAmount.multiply(exchangeRate);
            this.txtSxfzbwb.setValue((Object)sxfzbwb);
        }
    }

    @Override
    protected void chkIsCreatorBear_actionPerformed(ActionEvent e) throws Exception {
        this.checkIsCreatorBear();
    }

    public void checkIsCreatorBear() {
        if (this.chkIsCreatorBear.isSelected()) {
            FMClientHelper.setEditable((JComponent)this.prmtBearDept, (boolean)true);
            FMClientHelper.setEditable((JComponent)this.prmtAccountBank, (boolean)true);
            FMClientHelper.setEditable((JComponent)this.prmtAccountview, (boolean)true);
            this.btnRegister.setEnabled(true);
        } else {
            FMClientHelper.setEditable((JComponent)this.prmtBearDept, (boolean)false);
            FMClientHelper.setEditable((JComponent)this.prmtAccountBank, (boolean)false);
            FMClientHelper.setEditable((JComponent)this.prmtAccountview, (boolean)false);
            this.prmtBearDept.setValue(null);
            this.prmtAccountBank.setValue(null);
            this.prmtAccountview.setValue(null);
            this.btnRegister.setEnabled(false);
        }
    }

    protected KDTable getDetailTable() {
        return null;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return super.getValue(pk);
    }

    @Override
    protected void prmtCurrency_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currencyinfo = (CurrencyInfo)this.prmtCurrency.getValue();
        if (currencyinfo != null) {
            this.txtMoneyAmount.setPrecision(currencyinfo.getPrecision());
            if (this.company.getBaseCurrency() != null) {
                if (this.company.getBaseCurrency().getId().toString().equals(currencyinfo.getId().toString())) {
                    this.kDexcahange.setValue((Object)Constants.ONE);
                    this.kDexcahange.setPrecision(currencyinfo.getPrecision());
                    this.kDexcahange.setEditable(false);
                } else {
                    try {
                        FeeManageInfo info = (FeeManageInfo)this.getDataObject();
                        if (info != null) {
                            ExchangeRateInfo exchangeRateInfo = FinUtils.getCurrencyExRateInfo(null, this.company, currencyinfo, this.company.getBaseCurrency(), info.getBizDate());
                            if (exchangeRateInfo != null) {
                                this.kDexcahange.setValue((Object)exchangeRateInfo.getConvertRate());
                                this.kDexcahange.setPrecision(exchangeRateInfo.getPrecision());
                            } else {
                                this.kDexcahange.setValue((Object)Constants.ONE);
                                this.kDexcahange.setPrecision(5);
                            }
                        }
                        this.kDexcahange.setEditable(true);
                    }
                    catch (EASBizException e1) {
                        this.prmtCurrency.setValue(null);
                        throw e1;
                    }
                }
            }
            this.sxfzbwb();
        }
        super.prmtCurrency_dataChanged(e);
    }

    @Override
    protected void kDexcahange_dataChanged(DataChangeEvent e) throws Exception {
        this.sxfzbwb();
        super.kDexcahange_dataChanged(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionRegister_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegister_actionPerformed(e);
        HashSet<String> idSet = new HashSet<String>();
        if (this.isModify()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"167_FeeManageEditUI"));
            return;
        }
        if (this.editData.getAccountBank() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"168_FeeManageEditUI"));
            return;
        }
        if (this.prmtAccountBank.getData() != null && this.prmtCurrency.getData() != null) {
            AccountBankInfo bankInfo = (AccountBankInfo)this.prmtAccountBank.getData();
            CurrencyInfo currency1 = (CurrencyInfo)this.prmtCurrency.getData();
            if (bankInfo.isIsByCurrency() && bankInfo.getCurrency() != null) {
                CurrencyInfo currency = bankInfo.getCurrency();
                if (!currency1.getId().equals((Object)currency.getId())) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"169_FeeManageEditUI"));
                    return;
                }
            }
        }
        if (this.editData.getId() != null && !this.isModify()) {
            String id = this.editData.getId().toString();
            if (this.isCanBook(id)) {
                idSet.add(id);
            }
            if (idSet.size() > 0) {
                ArApRecPayHelper.requestMutex((CoreUI)this, idSet);
                try {
                    ((IFeeManage)this.getBizInterface()).book(idSet);
                    this.actionSubmit.setEnabled(false);
                    this.actionEdit.setEnabled(false);
                }
                finally {
                    ArApRecPayHelper.releaseMutex(idSet);
                }
            }
        }
    }

    public boolean isCanBook(String id) {
        boolean flag = false;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        IContextHelper localInstance = ContextHelperFactory.getRemoteInstance();
        int val = localInstance.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        if (logger.isInfoEnabled()) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"170_FeeManageEditUI");
            msg = MessageFormat.format(msg, val);
            logger.info((Object)msg);
        }
        if (this.editData != null && this.editData.isIsCreatorBear() && val == 0) {
            this.btnRegister.setEnabled(true);
            flag = true;
        } else {
            this.btnRegister.setEnabled(false);
        }
        return flag;
    }

    private void checkFinalCheckout() throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentCompany();
        boolean canOp = FMClientHelper.checkFinalCheckout((SystemEnum)SystemEnum.NT_MANAGEMENT, (String)companyInfo.getId().toString(), (Date)this.editData.getBizDate());
        if (!canOp) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.recon.FmSettleResource", (String)"36_SETTLED"));
            SysUtil.abort();
        }
    }
}

