/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingFeeAmortizationEnum;
import com.kingdee.eas.fm.fin.FinancingFeeBillCollection;
import com.kingdee.eas.fm.fin.FinancingFeeBillFactory;
import com.kingdee.eas.fm.fin.FinancingFeeBillInfo;
import com.kingdee.eas.fm.fin.FinancingFeeBillStateEnum;
import com.kingdee.eas.fm.fin.FinancingFeeRourceEnum;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.client.AbstractFinancingFeeBillEditUI;
import com.kingdee.eas.fm.fin.client.F7FinancingProductsTreeUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FinancingFeeBillEditUI
extends AbstractFinancingFeeBillEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingFeeBillEditUI.class);
    F7FinancingProductsTreeUI prmtParent_F7ListUI = null;
    private boolean isFrist = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionAuditResult.setVisible(false);
        this.menuItemSave.setVisible(true);
        this.isFrist = true;
        FMClientHelper.initFundFlowItemF7((IUIObject)this, (KDLabelContainer)this.conBgItem, (KDLabelContainer)this.contFundFlowItem, (FundFlowDirection)FundFlowDirection.OUT);
    }

    @Override
    public void loadFields() {
        FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.editData.getCompany().getId().toString());
        super.loadFields();
        FMClientHelper.loadFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
    }

    @Override
    public void storeFields() {
        FMClientHelper.storeFieldsBgItem((KDBizPromptBox)this.prmtBgItem, (CoreBaseInfo)this.editData, (FMBgItemProp)this.editData.getBgItemProps()[0]);
        super.storeFields();
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        CashHelper.initCombCurrency((KDComboBox)this.comBoCurrency, (boolean)false);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtlocalCurAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtFeeRate);
        this.txtFeeRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRate.setMinimumValue((Comparable)Constants.ZERO);
        int localPrec = FMHelper.getPrecOfCurrency(null, (String)this.baseCurrency.getId().toString());
        this.txtlocalCurAmount.setPrecision(localPrec);
        this.txtFeeRate.setPrecision(2);
        this.pkBizDate.setSupportedEmpty(false);
        this.prmtFinProducts.setQueryInfo("com.kingdee.eas.fm.fin.app.F7FinancingProductsQuery");
        this.prmtFinProducts.setDisplayFormat("$name$");
        this.prmtFinProducts.setEditFormat("$number$");
        this.prmtFinProducts.setCommitFormat("$number$");
        this.prmtFinProducts.setRequired(true);
        this.prmtFinProducts.addSelectorListener(new SelectorListener(){
            F7FinancingProductsTreeUI prmtParent_F7ListUI = null;

            public void willShow(SelectorEvent e) {
                if (this.prmtParent_F7ListUI == null) {
                    try {
                        this.prmtParent_F7ListUI = new F7FinancingProductsTreeUI();
                    }
                    catch (Exception e1) {
                        FinancingFeeBillEditUI.this.handUIExceptionAndAbort(e1);
                    }
                    HashMap<String, Window> ctx = new HashMap<String, Window>();
                    ctx.put("bizUIOwner", SwingUtilities.getWindowAncestor((Component)((Object)this.prmtParent_F7ListUI)));
                    this.prmtParent_F7ListUI.setF7Use(true, ctx);
                    FinancingFeeBillEditUI.this.prmtFinProducts.setSelector((KDPromptSelector)this.prmtParent_F7ListUI);
                }
            }
        });
    }

    protected void initPropEvi() throws Exception {
        super.initPropEvi();
        this.setAcctViewF7(this.prmtPayAccount);
        this.setAcctViewF7(this.prmtOppAccount);
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtProject);
        FMClientHelper.initBgItemF7((KDBizPromptBox)this.prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.output, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        FMClientHelper.setSelectObject((KDComboBox)this.comBoCurrency, (Object)this.editData.getCurrency());
        if (!this.getOprtState().equals(OprtState.ADDNEW) && this.editData.getState().equals((Object)FinancingFeeBillStateEnum.SUBMIT)) {
            this.actionSave.setEnabled(false);
        }
        if (!FMHelper.isEmpty((Object)((Object)this.editData.getSourceBillType())) && !this.editData.getSourceBillType().equals((Object)FinancingFeeRourceEnum.Person)) {
            this.txtSourceBillNm.setEnabled(false);
            this.prmtFinProducts.setEnabled(false);
        } else {
            this.txtSourceBillNm.setEnabled(true);
            this.prmtFinProducts.setEnabled(true);
        }
        if (!FMHelper.isEmpty((Object)((Object)this.editData.getSourceBillType())) && this.editData.getSourceBillType().equals((Object)FinancingFeeRourceEnum.Loan)) {
            this.contloanshare.setVisible(true);
        } else {
            this.contloanshare.setVisible(false);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewBgBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_inquirebudget"));
    }

    protected void initDataStatus() {
        super.initDataStatus();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinancingFeeBillFactory.getRemoteInstance();
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    @Override
    protected IObjectValue createNewData() {
        FinancingFeeBillInfo objectValue = new FinancingFeeBillInfo();
        CurrencyInfo baseCurrency = this.currentCompany.getBaseCurrency();
        objectValue.setCurrency(baseCurrency);
        objectValue.setCompany(SysContext.getSysContext().getCurrentFIUnit());
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        objectValue.setBizDate(DateUtil.getDayBegin());
        objectValue.setRate(Constants.ONE);
        objectValue.setAmount(Constants.ZERO);
        objectValue.setFeeRate(Constants.ZERO);
        objectValue.setLocalCurAmount(Constants.ZERO);
        String sourceBillType = (String)this.getUIContext().get("sourceBillType");
        if (sourceBillType != null && sourceBillType.equals("BondRelReport")) {
            objectValue.setSourceBillType(FinancingFeeRourceEnum.BondRelReport);
            String SourceBillNm = (String)this.getUIContext().get("sourceBillNm");
            objectValue.setSourceBillNm(SourceBillNm);
            FinancingProductsInfo finProduct = (FinancingProductsInfo)this.getUIContext().get("FinancingProduct");
            objectValue.setFinProducts(finProduct);
        } else if (sourceBillType != null && sourceBillType.equals("LoanContract")) {
            objectValue.setSourceBillType(FinancingFeeRourceEnum.LoanContract);
        } else {
            objectValue.setSourceBillType(FinancingFeeRourceEnum.Person);
        }
        String isloanshare = (String)this.getUIContext().get("isloanshare");
        if (isloanshare == null) {
            objectValue.setIsloanshare(FinancingFeeAmortizationEnum.NOAMORTIZATION);
        }
        return objectValue;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (e.getActionCommand().endsWith("ActionSave") && (this.getOprtState().equals(OprtState.EDIT) && this.editData.getState().equals((Object)FinancingFeeBillStateEnum.SAVE) || this.getOprtState().equals(OprtState.ADDNEW))) {
            if (this.txtNumber.required) {
                FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
            }
            return;
        }
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyEmptyAndNoZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("PayeeUnit"));
        sic.add(new SelectorItemInfo("SourceBillType"));
        sic.add(new SelectorItemInfo("SourceBillNm"));
        sic.add(new SelectorItemInfo("FeeRate"));
        sic.add(new SelectorItemInfo("Amount"));
        sic.add(new SelectorItemInfo("Rate"));
        sic.add(new SelectorItemInfo("outBgItemId"));
        sic.add(new SelectorItemInfo("outBgItemNumber"));
        sic.add(new SelectorItemInfo("outBgItemName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("Project.name"));
        sic.add(new SelectorItemInfo("Project.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("FinProducts.name"));
        sic.add(new SelectorItemInfo("FinProducts.number"));
        sic.add(new SelectorItemInfo("FinancingFee.name"));
        sic.add(new SelectorItemInfo("FinancingFee.number"));
        sic.add(new SelectorItemInfo("PayBankAccount.name"));
        sic.add(new SelectorItemInfo("PayBankAccount.number"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("Currency.precision"));
        sic.add(new SelectorItemInfo("OppAccount.name"));
        sic.add(new SelectorItemInfo("OppAccount.number"));
        sic.add(new SelectorItemInfo("localCurAmount"));
        sic.add(new SelectorItemInfo("PayAccount.name"));
        sic.add(new SelectorItemInfo("PayAccount.number"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("isloanshare"));
        sic.add("fundFlowItem.*");
        return sic;
    }

    private void setAcctViewF7(KDBizPromptBox f7Box) throws EASBizException, BOSException {
        String cuId = this.currentCompany.getCU().getId().toString();
        String currencyId = AccessHelper.getId((Object)this.comBoCurrency.getSelectedItem());
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.currentCompany.getId().toString(), (String)currencyId, (boolean)false);
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true);
        f7Box.setSelector((KDPromptSelector)opseelect);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi((String)cuId, (String)this.currentCompany.getId().toString(), (String)currencyId, (boolean)true);
        f7Box.setEntityViewInfo(evi);
        f7Box.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        this.callLocalCurAmount();
    }

    @Override
    protected void txtRate_dataChanged(DataChangeEvent e) throws Exception {
        this.callLocalCurAmount();
    }

    private void callLocalCurAmount() {
        BigDecimal extRate;
        BigDecimal Amount = this.txtAmount.getBigDecimalValue();
        if (Amount == null) {
            Amount = Constants.ZERO;
        }
        if (FMHelper.isEmpty((Object)(extRate = this.txtRate.getBigDecimalValue()))) {
            extRate = Constants.ONE;
        }
        this.txtlocalCurAmount.setValue((Object)FMHelper.getLocalAmount((BigDecimal)Amount, (BigDecimal)extRate));
    }

    @Override
    protected void prmtPayBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        if (!FMHelper.isEmpty((Object)this.prmtPayBankAccount.getValue())) {
            this.prmtPayAccount.setValue((Object)((AccountBankInfo)this.prmtPayBankAccount.getValue()).getAccount());
            this.prmtPayAccount.setEnabled(false);
        } else {
            this.prmtPayAccount.setValue(null);
            this.prmtPayAccount.setEnabled(true);
        }
    }

    @Override
    protected void comBoCurrency_itemStateChanged(ItemEvent e) throws Exception {
        CurrencyInfo currency = (CurrencyInfo)this.comBoCurrency.getSelectedItem();
        if (currency != null) {
            CurrencyInfo baseCurrency = this.currentCompany.getBaseCurrency();
            Date date = this.pkBizDate.getSqlDate();
            if (this.getOprtState() == OprtState.ADDNEW) {
                FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtRate, this.currentCompany, currency, baseCurrency, (java.util.Date)date, null);
            }
            this.txtAmount.setPrecision(currency.getPrecision());
            if (this.isFrist && !FMHelper.isEmpty((Object)this.prmtPayBankAccount.getValue())) {
                this.prmtPayAccount.setValue(null);
                this.prmtPayAccount.setEnabled(true);
            }
            if (this.isFrist) {
                this.prmtPayBankAccount.setValue(null);
            }
        }
    }

    @Override
    public void actionViewBgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        FMClientHelper.viewBgBalance((Component)((Object)this), (String)"com.kingdee.eas.fm.fin.app.FinancingFeeBill", null, (IObjectValue)this.editData);
    }

    @Override
    protected void prmtPayBankAccount_willCommit(CommitEvent e) throws Exception {
        this.setPayBankAccountEvi();
    }

    @Override
    protected void prmtPayBankAccount_willShow(SelectorEvent e) throws Exception {
        this.setPayBankAccountEvi();
    }

    private void setPayBankAccountEvi() {
        String companyId = this.currentCompany.getId().toString();
        String currencyId = ((CurrencyInfo)this.comBoCurrency.getSelectedItem()).getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", null));
        filter.setMaskString("#0 and #1 and (#2 or #3)");
        evi.setFilter(filter);
        this.prmtPayBankAccount.setEntityViewInfo(evi);
        this.prmtPayBankAccount.getQueryAgent().resetRuntimeEntityView();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("account.*");
        this.prmtPayBankAccount.setSelectorCollection(selectors);
    }

    protected boolean isNeedAddToolMenus() {
        return false;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.actionSave.setEnabled(false);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null && this.cheakStatus(this.editData)) {
            throw new FinBizException(FinBizException.STATUS_CHANGED);
        }
        super.actionSave_actionPerformed(e);
    }

    private boolean cheakStatus(FinancingFeeBillInfo editData) throws BOSException {
        boolean changed = false;
        FinancingFeeBillInfo finFeeBillInfo = null;
        FinancingFeeBillCollection coll = null;
        EntityViewInfo query = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        query.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)editData.getId().toString()));
        coll = FinancingFeeBillFactory.getRemoteInstance().getFinancingFeeBillCollection(query);
        if (coll != null && coll.size() == 1 && (finFeeBillInfo = coll.get(0)).getState() != editData.getState()) {
            changed = true;
        }
        return changed;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.IVT_MANAGE;
    }

    protected String getDateField() {
        return "bizDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit", "actionAntiAudit"};
    }
}

