/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMCommonSortedDataProvider;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fin.CompDepositBillStatusEnum;
import com.kingdee.eas.fm.fin.CompIntReceivedBillCollection;
import com.kingdee.eas.fm.fin.CompIntReceivedBillFactory;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.ICompIntReceivedBill;
import com.kingdee.eas.fm.fin.IntReceivedBillFilterParam;
import com.kingdee.eas.fm.fin.TDException;
import com.kingdee.eas.fm.fin.TimeDepositHelper;
import com.kingdee.eas.fm.fin.client.AbstractIntReceivedBillListUI;
import com.kingdee.eas.fm.fin.client.IntReceiveDateChooseUI;
import com.kingdee.eas.fm.fin.client.IntReceivePayDateChooseUI;
import com.kingdee.eas.fm.fin.client.IntReceivedBillEditUI;
import com.kingdee.eas.fm.fin.client.IntReceivedBillFilterUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class IntReceivedBillListUI
extends AbstractIntReceivedBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(IntReceivedBillListUI.class);
    private CompanyOrgUnitInfo currentCompany;
    private String uiParam;
    private LicenseService licenseService = new LicenseService((IUIObject)this);
    FillListener fillListener = new FillListener();
    IntReceivedBillFilterUI filterUI = null;

    public IntReceivedBillListUI() throws Exception {
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("BOTPViewStatus") == null || (Integer)this.getUIContext().get("BOTPViewStatus") != 1 || this.getUIContext().get("BTPCreateMode") != null) {
            FSClientHelper.checkClearingHouseCompany();
            ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        }
        this.uiParam = (String)this.getUIContext().get("UIClassParam");
        if (this.getBOTPViewStatus() != 1) {
            this.licenseService.checkLicence();
            if (this.uiParam.equals("DBCKICKFROMMENU_TD")) {
                this.checkHasNumber();
                Set setIDs = IntReceiveDateChooseUI.showIntReceiveScopeChooseUI(this, this.currentCompany);
                if (setIDs == null || setIDs.size() == 0) {
                    SysUtil.abort();
                }
                this.getUIContext().put("newID", setIDs);
            } else if ("DBCKICKFROMPAYMENU_TD".equals(this.uiParam)) {
                this.checkHasNumber();
                Set setIDs = IntReceivePayDateChooseUI.showIntReceiveScopeChooseUI(this, this.currentCompany);
                if (setIDs == null || setIDs.size() == 0) {
                    SysUtil.abort();
                }
                this.getUIContext().put("newID", setIDs);
            }
        }
        super.onLoad();
        this.actionVoucher.setEnabled(true);
        this.actionDelVoucher.setEnabled(true);
        this.btnVoucher.setVisible(true);
        this.btnDelVoucher.setVisible(true);
        this.menuItemDelVoucher.setVisible(true);
        this.menuItemVoucher.setVisible(true);
        this.btnSubmit.setVisible(true);
        this.btnSubmit.setEnabled(true);
        this.btnViewBg.setVisible(true);
        this.btnViewBg.setEnabled(true);
        this.mentItemViewBg.setVisible(true);
        this.mentItemViewBg.setEnabled(true);
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("acceptedDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    public boolean isNeedShowBOTPRule() {
        return true;
    }

    private void checkHasNumber() {
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new CompIntReceivedBillInfo(), this.currentCompany.getId().toString());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionSubmit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionPreDrawing.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_autocount"));
        this.actionReceiveInt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionPayDrawing.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_releasebymodule"));
        this.actionSubBatch.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionViewBdgBalance.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_check"));
        this.preDraw.setEnabled(true);
        this.actionSubmit.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionAccepted.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_accept"));
        this.actionAntiAccepted.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_cancelcase"));
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    protected String getEditUIName() {
        return IntReceivedBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CompIntReceivedBillFactory.getRemoteInstance();
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new IntReceivedBillFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("timeDepositBillID.timeDepositType"));
        sic.add(new SelectorItemInfo("timeDepositBillID.number"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add("project.name");
        sic.add("project.number");
        sic.add("outBgItemId");
        sic.add("outBgItemNumber");
        sic.add("outBgItemName");
        sic.add("fpItem.id");
        sic.add("fpItem.number");
        sic.add("fpItem.name");
        return sic;
    }

    private void setQueryFilter(Set ids) {
        String includeValue = this.parseValue(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
        this.mainQuery.setFilter(filter);
    }

    @Override
    public void actionPayDrawing_actionPerformed(ActionEvent e) throws Exception {
        Set setIDs = IntReceivePayDateChooseUI.showIntReceiveScopeChooseUI(this, this.currentCompany);
        if (setIDs != null && setIDs.size() != 0) {
            String includeValue = this.parseValue(setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        this.refresh(e);
    }

    @Override
    public void actionPreDrawing_actionPerformed(ActionEvent e) throws Exception {
        Set setIDs = IntReceiveDateChooseUI.showIntReceiveScopeChooseUI(this, this.currentCompany);
        if (setIDs != null && setIDs.size() != 0) {
            String includeValue = this.parseValue(setIDs);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)includeValue, CompareType.INCLUDE));
            this.mainQuery.setFilter(filter);
        }
        this.refresh(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeDelete();
        ArrayList validList = this.getSelectedIdValues();
        boolean idsInProcess = FMHelper.hasWFInstance((Context)null, (List)validList);
        if (idsInProcess) {
            throw new FMException(FMException.ERROR_IN_WORKFLOW);
        }
        super.actionRemove_actionPerformed(e);
    }

    private void checkCanBeDelete() throws Exception {
        CompIntReceivedBillInfo info = this.getSelectObject();
        if (info.getEffectedStatus() == CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.EXCEPTION62);
        }
        if (info.getIntReceiveType() != IntReceivedBillTypeEnum.PRE_DRAWING && info.getIntReceiveType() != IntReceivedBillTypeEnum.INTBILL_PAYINTEREST) {
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC1);
        }
        if (info.isIsChongzhang() && info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC5);
        }
        if (info.isFivouchered()) {
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC2);
        }
        this.checkDate(info);
        this.checkType(info);
    }

    private void checkType(CompIntReceivedBillInfo info) throws BOSException, TDException {
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            Date endate = info.getEndDate();
            CompIntReceivedBillCollection intBillCol = this.getIntCol(info);
            CompIntReceivedBillInfo infoTmp = null;
            for (int i = 0; i < intBillCol.size(); ++i) {
                infoTmp = intBillCol.get(i);
                if (endate.compareTo(infoTmp.getEndDate()) != 0 || !this.isReOrUnDeposit(infoTmp.getIntReceiveType().getValue())) continue;
                throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC4);
            }
        }
    }

    private CompIntReceivedBillInfo getSelectObject() throws Exception {
        this.checkSelected();
        CompIntReceivedBillInfo info = ((ICompIntReceivedBill)this.getBizInterface()).getCompIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        return info;
    }

    private boolean isReOrUnDeposit(String type) {
        return type.equals("2") || type.equals("1");
    }

    private void checkDate(CompIntReceivedBillInfo info) throws BOSException, TDException {
        CompIntReceivedBillCollection intBillCol = this.getIntCol(info);
        Date endate = info.getEndDate();
        CompIntReceivedBillInfo infoTmp = null;
        for (int i = 0; i < intBillCol.size(); ++i) {
            infoTmp = intBillCol.get(i);
            if (endate.compareTo(infoTmp.getEndDate()) >= 0) continue;
            throw new TDException(TDException.INTRECEIVEBILL_DELETE_EXC3);
        }
    }

    private CompIntReceivedBillCollection getIntCol(CompIntReceivedBillInfo info) throws BOSException {
        return CompIntReceivedBillFactory.getRemoteInstance().getCompIntReceivedBillCollection(this.getEntity(info));
    }

    private EntityViewInfo getEntity(CompIntReceivedBillInfo info) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("srcBillID", (Object)info.getSrcBillID()));
        filter.getFilterItems().add(new FilterItemInfo("intReceiveType", (Object)info.getIntReceiveType()));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        view.setFilter(filter);
        return view;
    }

    private String parseValue(Set setIDs) {
        return TimeDepositHelper.getInstance().parseValue(setIDs);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanBeModify();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanBeModify() throws Exception {
        CompIntReceivedBillInfo info = this.getSelectObject();
        if (info.getEffectedStatus() == CompDepositBillStatusEnum.ACCEPTED && info.getIntReceiveType() != IntReceivedBillTypeEnum.PRE_DRAWING) {
            throw new TDException(TDException.INTRECEIVEBILL_MODIFY_EXC1);
        }
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING && info.isFivouchered()) {
            throw new TDException(TDException.INTRECEIVEBILL_MODIFY_EXC2);
        }
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING && info.isIsChongzhang()) {
            throw new TDException(TDException.INTRECEIVEBILL_MODIFY_EXC3);
        }
        boolean idsInProcess = FMHelper.hasWFInstance(null, (String)info.getId().toString());
        if (idsInProcess) {
            throw new FMException(FMException.ERROR_IN_WORKFLOW);
        }
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
    }

    public void actionSumbmit_actionPerformed(ActionEvent e) throws Exception {
        int value = MessageDialog.show((Component)((Object)this), (Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"submitIntReceivaBillConfirm"));
        if (0 == value) {
            int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
            IRow row = this.tblMain.getRow(rowNumber);
            Object fid = row.getCell("id").getValue();
            CompIntReceivedBillInfo info = CompIntReceivedBillFactory.getRemoteInstance().getCompIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(fid.toString()));
            info.setHasEffected(true);
            CompIntReceivedBillFactory.getRemoteInstance().submit((CoreBaseInfo)info);
        }
        this.refresh(e);
    }

    @Override
    public void actionSubBatch_actionPerformed(ActionEvent e) throws EASBizException, BOSException {
        this.subBatch(e);
        try {
            this.refresh(e);
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
        }
    }

    private void subBatch(ActionEvent e) throws EASBizException {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        HashSet idSet = new HashSet(list);
        try {
            CompIntReceivedBillFactory.getRemoteInstance().subBatch(idSet);
        }
        catch (BOSException e1) {
            MsgBox.showWarning((String)e1.getMessage());
            SysUtil.abort();
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private String getTDFileName() {
        return "/FM/IM/INTRECEIVED";
    }

    private IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.IntReceivedBillTDQuery");
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrintPreview_actionPerformed(e);
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0 || this.getTDQueryPK() == null || this.getTDFileName() == null) {
            return;
        }
        FMCommonSortedDataProvider data = new FMCommonSortedDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.getTDFileName(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompIntReceivedBillInfo info = CompIntReceivedBillFactory.getRemoteInstance().getCompIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (IvtModualUtils.getSysParam(null, (String)"FIN010") && info.getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"207_IntReceivedBillListUI"));
            SysUtil.abort();
        }
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompIntReceivedBillInfo info = CompIntReceivedBillFactory.getRemoteInstance().getCompIntReceivedBillInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (info.getIntReceiveType() != IntReceivedBillTypeEnum.PRE_DRAWING && info.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.CREATE_VOUCHER_EXC2);
        }
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING && info.getEffectedStatus() != CompDepositBillStatusEnum.SUBMIT) {
            throw new TDException(TDException.EXCEPTION67);
        }
        if (IvtModualUtils.getSysParam(null, (String)"FIN010") && info.getIntReceiveType() == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"207_IntReceivedBillListUI"));
            SysUtil.abort();
        }
        super.actionVoucher_actionPerformed(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("*");
        String id = this.getSelectedKeyValue();
        if (id == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        CompIntReceivedBillInfo info = (CompIntReceivedBillInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        this.actionVoucher.setEnabled(!info.isFivouchered());
        this.actionDelVoucher.setEnabled(info.isFivouchered());
    }

    protected void execQuery() {
        if (this.getUIContext().get("newID") != null) {
            this.setQueryFilter((Set)this.getUIContext().get("newID"));
        }
        super.execQuery();
        this.getUIContext().remove("newID");
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    protected boolean isFootVisible() {
        return true;
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            IntReceivedBillFilterParam param = (IntReceivedBillFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrency() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrency());
            String[] columns = new SumFiledsInfo(SumBillEnum.ComDepInt).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isDirectShow() {
        if (this.getBOTPViewStatus() != 1) {
            if (this.uiParam.equals("DBCKICKFROMMENU_TD")) {
                return true;
            }
            if ("DBCKICKFROMPAYMENU_TD".equals(this.uiParam)) {
                return true;
            }
        }
        return super.isDirectShow();
    }

    @Override
    public void actionAccepted_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompIntReceivedBillInfo info = this.getSelectObject();
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            throw new TDException(TDException.EXCEPTION65);
        }
        if (info.getEffectedStatus() != CompDepositBillStatusEnum.SUBMIT) {
            throw new TDException(TDException.EXCEPTION63);
        }
        ICompIntReceivedBill iComp = (ICompIntReceivedBill)this.getBizInterface();
        iComp.accepted((IObjectPK)new ObjectStringPK(info.getId().toString()));
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionAntiAccepted_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        CompIntReceivedBillInfo info = this.getSelectObject();
        if (info.getIntReceiveType() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            throw new TDException(TDException.EXCEPTION66);
        }
        if (info.getEffectedStatus() != CompDepositBillStatusEnum.ACCEPTED) {
            throw new TDException(TDException.EXCEPTION64);
        }
        if (info.isFivouchered()) {
            throw new TDException(TDException.EXCEPTION71);
        }
        if (info.isIsreceived()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"downBillWarning"));
            SysUtil.abort();
        }
        if (FinHelper.isExistDownBill(info.getBOSType().toString(), info.getId().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.TdResource", (String)"downBillWarning"));
            SysUtil.abort();
        }
        Date settleDate = FSClientHelper.getClearingHouse().getSettleDate();
        if (null != info.getAcceptedDate() && info.getAcceptedDate().before(settleDate)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fs.SettlementBillUI", (String)"HasDailySettle"));
            SysUtil.abort();
        }
        ICompIntReceivedBill iComp = (ICompIntReceivedBill)this.getBizInterface();
        iComp.antiAccepted((IObjectPK)new ObjectStringPK(info.getId().toString()));
        FMClientHelper.showSuccessMessage((CoreUI)this, (Component)((Component)e.getSource()));
        this.refreshList();
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    public boolean destroyWindow() {
        try {
            this.licenseService.releaseLicense();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return super.destroyWindow();
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(IntReceivedBillListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("currency.id").getValue();
                if (currencyId == null) continue;
                FMClientHelper.setNumberFormat((IRow)row, (String)"depositAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"deInterest", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"creInterest", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"shijiAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"yingjiAmt", (String)currencyId);
                FMClientHelper.setNumberFormat((IRow)row, (String)"yichongxiaoAmt", (String)currencyId);
                this.setAmtCellNumberFormat(row, currencyId);
            }
        }

        private void setNumberFormat(IRow row, String columnKey, int type) {
            String formatString = "";
            formatString = type == 1 ? "%r-[ ]0.2n" : "#,##0.00000\\%";
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            styleAttributes.setNumberFormat(formatString);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }

        private void setAmtCellNumberFormat(IRow row, String currencyId) {
            this.setNumberFormat(row, "depYearRate", 2);
            this.setNumberFormat(row, "creYearRate", 2);
        }
    }
}

