/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankAreaTypeEnum;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.common.util.FilterUtil;
import com.kingdee.eas.fm.fin.CreditFinancingReduceCollection;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.CreditLimitFactory;
import com.kingdee.eas.fm.fin.CreditLimitInfo;
import com.kingdee.eas.fm.fin.CreditUsageFactory;
import com.kingdee.eas.fm.fin.CreditUsageInfo;
import com.kingdee.eas.fm.fin.FinClientHelper;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.GuaranteeTypeInputModeEnum;
import com.kingdee.eas.fm.fin.LetterOfCreditFactory;
import com.kingdee.eas.fm.fin.LetterOfCreditInfo;
import com.kingdee.eas.fm.fin.LetterOperateTypeEnum;
import com.kingdee.eas.fm.fin.LetterStatusEnum;
import com.kingdee.eas.fm.fin.LimitTypeEnum;
import com.kingdee.eas.fm.fin.MarginAlgorithmEnum;
import com.kingdee.eas.fm.fin.ShareTypeEnum;
import com.kingdee.eas.fm.fin.client.AbstractLetterOfCreditEditUI;
import com.kingdee.eas.fm.fin.client.ChooseFinancingProductUI;
import com.kingdee.eas.fm.fin.client.FeeManageFMUI;
import com.kingdee.eas.fm.fin.rpcoptimize.LetterOfCreditEditUIEnvirRpc;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fin.util.FinHorizon;
import com.kingdee.eas.fm.nt.LetterOfCreditApplyInfo;
import com.kingdee.eas.fm.nt.NTHelper;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.CSF7SelectorSupplier;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.fm.nt.client.util.ChequeUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class LetterOfCreditEditUI
extends AbstractLetterOfCreditEditUI {
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";
    public static final String LETTERRESOURCE = "com.kingdee.eas.fm.fin.client.LetterOfCreditResource";
    boolean isCreateFrom = false;
    private static final String AllComponentsListeners = LetterOfCreditEditUI.class.getName();
    private static final Logger logger = CoreUIObject.getLogger(LetterOfCreditEditUI.class);
    private SelfComponents Scomps = new SelfComponents();
    private static final int fluctuateScaleMax = 100;
    private LetterOfCreditEditUIEnvirRpc envirRpc = null;
    boolean Mutex_CreditCurExRate_CreditLimitAmtLocal = false;

    private String getResString(String key) {
        return EASResource.getString((String)RESOURCE, (String)key);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtBalance.setValue((Object)this.editData.getAmount());
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFee.setIcon(EASResource.getIcon((String)"imgTbtn_diathesisaccord"));
        this.menuItemFee.setIcon(EASResource.getIcon((String)"imgTbtn_diathesisaccord"));
        this.actionCopy.setVisible(true);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany())) {
            this.actionAddNew.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.actionAddFee.setEnabled(false);
            this.actionCreateFrom.setEnabled(false);
            this.actionCreateTo.setEnabled(false);
            this.actionCopy.setEnabled(false);
        }
    }

    protected boolean isRpcCacheProcess() {
        return true;
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        LetterOfCreditEditUIEnvirRpc cacheInfo = new LetterOfCreditEditUIEnvirRpc();
        cacheInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        cacheInfo.setBillInfo((CoreBaseInfo)new LetterOfCreditInfo());
        return cacheInfo;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fm.fin.rpcoptimize.LetterOfCreditEditUIEnvirRpcFetcher";
    }

    @Override
    public void onLoad() throws Exception {
        this.onlyOneProcess();
        this.isCreateFrom = this.getBOTPViewStatus() == 1;
        super.onLoad();
        if (this.editData != null && this.editData.getOperateStatus() != null && (this.editData.getOperateStatus().equals((Object)LetterOperateTypeEnum.AUDIT) || this.editData.getOperateStatus().equals((Object)LetterOperateTypeEnum.submit))) {
            this.actionSave.setEnabled(false);
        }
        this.setCurrency();
        IContextHelper contextHelper = ContextHelperFactory.getRemoteInstance();
        CSF7SelectorSupplier arg0 = new CSF7SelectorSupplier((IUIObject)this, this.prmtBeneficiary, contextHelper.getCurrentCtrlUnit());
        this.prmtBeneficiary.setSelector((KDPromptSelector)arg0);
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return LetterOfCreditFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        Map map = this.getUIContext();
        String action = (String)map.get("COPY");
        String id = null;
        if (map.get("ID") != null) {
            id = map.get("ID").toString();
        }
        LetterOfCreditInfo objectValue = new LetterOfCreditInfo();
        FinUtils.initNewFinBill(objectValue, this.txtNumber);
        if (action != null && id != null && action.equals("COPY")) {
            try {
                LetterOfCreditInfo oldInfo = (LetterOfCreditInfo)this.getValue((IObjectPK)new ObjectUuidPK(id));
                objectValue = oldInfo.copy();
                objectValue.setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
                objectValue.setCreator(this.userinfo);
                objectValue.setCreateTime(new Timestamp(System.currentTimeMillis()));
                objectValue.setBalance(objectValue.getAmount());
                objectValue.setGarantee(oldInfo.getGarantee());
                map.remove("COPY");
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        } else {
            objectValue.setIsForward(true);
            objectValue.setNtType((NTTypeInfo)this.comboBillType.getItemAt(0));
            objectValue.setGuaranteeTypeInputMode(GuaranteeTypeInputModeEnum.assure);
            objectValue.setIsInCredit(false);
            objectValue.setAmount(Constants.ZERO);
            objectValue.setAmountLocalCur(Constants.ZERO);
            objectValue.setBalance(Constants.ZERO);
            objectValue.setCreditPercentage(Constants.ZERO);
            objectValue.setUsedCreditAmt(FMHelper.multiply((BigDecimal)objectValue.getAmount(), (BigDecimal)objectValue.getCreditPercentage()));
            objectValue.setCreditLocalAmt(Constants.ZERO);
            objectValue.setNtType((NTTypeInfo)this.comboBillType.getItemAt(0));
            objectValue.setGuaranteeTypeInputMode((GuaranteeTypeInputModeEnum)((Object)this.combGTInputMode.getItemAt(0)));
        }
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("Type.id"));
        sic.add(new SelectorItemInfo("Type.number"));
        sic.add(new SelectorItemInfo("Type.name"));
        sic.add(new SelectorItemInfo("company"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("Currency"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("Currency.name"));
        sic.add(new SelectorItemInfo("company.basecurrency.id"));
        sic.add(new SelectorItemInfo("company.basecurrency.name"));
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("ntType.*"));
        sic.add(new SelectorItemInfo("CreditLimit.*"));
        sic.add(new SelectorItemInfo("CreditLimit.CreditUsage.*"));
        sic.add(new SelectorItemInfo("guaranteeEntrys.lastUpdateTime"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("benefitCustomer.*"));
        sic.add(new SelectorItemInfo("benefitSupplier.*"));
        super.setEntrysSelector(sic);
        return sic;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        LetterOfCreditInfo info = (LetterOfCreditInfo)super.getValue(pk);
        if (info.getCU() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)info.getCurrency());
            FMClientHelper.setSelectObject((KDComboBox)this.kDContractCurrency, (Object)info.getContractCurrenc());
        }
        this.currentCompany = info.getCompany();
        return info;
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.txtNumber.isEnabled()) {
            this.txtNumber.requestFocusInWindow();
        } else {
            this.comboBillType.requestFocusInWindow();
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        try {
            if (this.getUIContext().get(AllComponentsListeners) == null) {
                this.getUIContext().put(AllComponentsListeners, FMClientHelper.removeCompListeners((CoreUI)this));
            }
            this.handleInfo((LetterOfCreditInfo)dataObject);
            super.setDataObject(dataObject);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void handleInfo(LetterOfCreditInfo locInfo) throws Exception {
        this.checkInfo(locInfo);
        this.fillInfoProps(locInfo);
        this.calcInfo(locInfo);
    }

    private void checkInfo(LetterOfCreditInfo locInfo) throws Exception {
        if ("EDIT".equalsIgnoreCase(this.oprtState)) {
            if (locInfo.getId() == null) {
                throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"220_LetterOfCreditEditUI"));
            }
            if (locInfo.getNumber() == null) {
                throw new Exception(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"221_LetterOfCreditEditUI"));
            }
        }
    }

    private void calcInfo(LetterOfCreditInfo locInfo) throws Exception {
    }

    private void fillInfoProps(LetterOfCreditInfo locinfo) throws Exception {
        if (FinHelper.isInStates((EditUI)this, new int[]{2, 6}) && locinfo.getId() != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)locinfo.getId().toString()));
            view.setFilter(filter);
            locinfo.setReduceCol(CreditFinancingReduceFactory.getRemoteInstance().getCreditFinancingReduceCollection(view));
        }
    }

    @Override
    public void loadFields() {
        try {
            super.loadFields();
            this.loadFieldsBySelf();
            this.calcCompsValue();
            if (this.editData.getNtType() != null) {
                for (int i = 0; i < this.comboBillType.getItemCount(); ++i) {
                    NTTypeInfo ntInfo = (NTTypeInfo)this.comboBillType.getItemAt(i);
                    if (!this.editData.getNtType().getId().toString().equals(ntInfo.getId().toString())) continue;
                    this.comboBillType.setSelectedIndex(i);
                    break;
                }
            }
            if (this.editData.getCurrency() != null) {
                FMClientHelper.setSelectObject((KDComboBox)this.kDContractCurrency, (Object)this.editData.getContractCurrenc());
            } else {
                CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                FMClientHelper.setSelectObject((KDComboBox)this.kDContractCurrency, (Object)company.getBaseCurrency());
            }
            FMClientHelper.initNumber((CoreBaseInfo)this.editData, (KDTextField)this.txtNumber, (String)this.currentCompany.getId().toString());
            if (this.editData.getBenefitCustomer() != null) {
                this.prmtBeneficiary.setData((Object)this.editData.getBenefitCustomer());
            } else if (this.editData.getBenefitSupplier() != null) {
                this.prmtBeneficiary.setData((Object)this.editData.getBenefitSupplier());
            } else {
                this.prmtBeneficiary.setValue((Object)this.editData.getBeneficiary());
            }
            this.storeFields();
            this.initOldData((IObjectValue)this.editData);
            if (this.getUIContext().get(AllComponentsListeners) != null) {
                FMClientHelper.addCompListeners((CoreUI)this, (Map)((Map)this.getUIContext().get(AllComponentsListeners)));
                this.getUIContext().put(AllComponentsListeners, null);
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void initDataStatus() {
        try {
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.editData = (LetterOfCreditInfo)this.getDataObject();
            }
            this.initAllCompsValue();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initDataStatus();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSave.setEnabled(false);
            this.actionCreateFrom.setEnabled(false);
            this.actionAddNew.setEnabled(false);
        }
    }

    private void initAllCompsValue() throws Exception {
        this.Scomps.initSelfComponents();
    }

    private void onlyOneProcess() throws Exception {
        this.envirRpc = (LetterOfCreditEditUIEnvirRpc)this.rpcCacheInfo;
        if (this.getUIContext().get("company") != null) {
            this.currentCompany = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        }
        if (this.currentCompany != null && "ADDNEW".equals(this.oprtState)) {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(this.currentCompany.getId()), "fin_LetterOfCredit_addnew");
        }
        FinClientHelper.setExchangeFmt(this.txtLocalCurExRate, 5);
        this.chkIsRelBank.setVisible(true);
        FinUtils.initCurrencyComboBox(this.kDComboBoxCurrency, this.envirRpc.getAllCurrencyColl());
        for (NTTypeInfo element : NTClientHelper.getNTTypesBySuperGroup((NTTypeGroupEnum)NTTypeGroupEnum.ImportCredit)) {
            this.comboBillType.addItem((Object)element);
        }
        FinUtils.initCurrencyComboBox(this.kDContractCurrency, this.envirRpc.getAllCurrencyColl());
        this.txtCreditCurExRate.setPrecision(10);
        this.txtCreditPercentage.setPrecision(5);
        this.txtCreditCurExRate.setHorizontalAlignment(4);
        this.txtCreditPercentage.setHorizontalAlignment(4);
        this.initF7Filter();
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAmountLocalCur);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtBalance);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtUsedCreditAmt);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtCreditLimitAmtLocal);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtRemainAmount);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtlimitMargin);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtmarginEx);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtmarginExRate);
        this.txtmarginExRate.setPrecision(10);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtmarginRate);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtLocalCurExRate);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtmarginBalance);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtcontractAmount);
        this.txtlimitMargin.setNegatived(false);
        this.txtmarginBalance.setNegatived(false);
        this.txtmarginEx.setNegatived(false);
        this.txtmarginExRate.setNegatived(false);
        this.txtmarginRate.setNegatived(false);
        this.txtHorizon.setNegatived(false);
        FMClientHelper.initDecimalField((BasicFormattedTextField)this.txtHorizon);
        this.txtHorizon.setPrecision(1);
        this.txtHorizon.setRemoveingZeroInDispaly(false);
        this.pkBizDate.setSupportedEmpty(false);
        this.pkIssueDate.setSupportedEmpty(false);
        this.pkExpiredDate.setSupportedEmpty(false);
        this.menuSubmitOption.setVisible(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
        this.chkMenuItemSubmitAndPrint.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.MenuItemAttachment.setVisible(false);
        this.txtLetterContent.setCaretPosition(0);
        this.txtcontractAmount.setPrecision(2);
        UIUtil.setAdminAllCU((IUIObject)this, (KDBizPromptBox)this.prmtdepartment);
        ChequeUtil.initPerson((IUIObject)this, (KDBizPromptBox)this.prmtLtterHandler);
        this.txtAmount.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtcontractAmount.setMinimumValue((Comparable)new BigDecimal(0));
        this.txtFluctuateScaleFloor.setMinimumValue((Comparable)new BigDecimal("-100"));
        this.txtFluctuateScaleFloor.setMaximumValue((Comparable)new BigDecimal("100"));
        this.txtFluctuateScale.setMinimumValue((Comparable)new BigDecimal("-100"));
        this.txtFluctuateScale.setMaximumValue((Comparable)new BigDecimal("100"));
        this.txtCreditLimitAmtLocal.setEnabled(false);
        this.txtUsedCreditAmt.setDataType(1);
        this.txtCreditLimitAmtLocal.setDataType(1);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency.*");
        this.prmtmarginAcct.setSelectorCollection(sic);
        this.prmtpayBankAcct.setSelectorCollection(sic);
        this.prmtpayBankAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        this.prmtmarginAcct.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7AccountBankQuery");
        SelectorItemCollection sicPrmtCredit = new SelectorItemCollection();
        sicPrmtCredit.add("*");
        sicPrmtCredit.add("CreditUsage.*");
        sicPrmtCredit.add("finacingProduct.*");
        this.prmtCreditLimit.setSelectorCollection(sicPrmtCredit);
        FinUtils.initBankTree((IUIObject)this, this.prmtNotifyBank, null, true);
        KDBizPromptBox prmt = new KDBizPromptBox();
        ExtendParser parser = new ExtendParser(prmt);
        this.prmtNotifyBank.setCommitParser((IParser)parser);
        this.prmtBeneficiary.setMaxLength(80);
        this.txtNumber.setMaxLength(50);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        int height = 192;
        int wrigth = 664;
        this.kDPanelGuara.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, wrigth, height));
        this.kDPanelPledge.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, wrigth, height));
        this.kDPanelImpawn.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, wrigth, height));
        this.kDPanelCredit.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, wrigth, height));
        this.kDPanelOther.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, wrigth, height));
    }

    private void initF7Filter() throws BOSException {
        this.prmtCreditLimit.setEntityViewInfo(FMClientHelper.getNothingFilter());
        try {
            FinUtils.initBankTree((IUIObject)this, this.prmtInstitution, null, true);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtBeneficiaryStat.setEntityViewInfo(evi);
    }

    private void calcCompsValue() throws Exception {
        GuaranteeTypeInputModeEnum guaranteeTypeInputMode = this.editData.getGuaranteeTypeInputMode();
        if (guaranteeTypeInputMode == null) {
            guaranteeTypeInputMode = GuaranteeTypeInputModeEnum.assure;
        }
        Object tmp = null;
        if (!"ADDNEW".equals(this.oprtState)) {
            tmp = this.prmtMainGT.getValue();
        }
        this.combGTInputMode.setSelectedItem((Object)guaranteeTypeInputMode);
        this.combGTInputMode_itemStateChanged(new ItemEvent((ItemSelectable)this.combGTInputMode, 0, (Object)guaranteeTypeInputMode, 1));
        if (!"ADDNEW".equals(this.oprtState)) {
            this.prmtMainGT.setValue(tmp);
        }
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.editData.getCurrency());
        if ("ADDNEW".equals(this.oprtState)) {
            FMClientHelper.setSelectObject((KDComboBox)this.kDContractCurrency, (Object)this.currentCompany.getBaseCurrency());
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.kDContractCurrency, (Object)this.editData.getContractCurrenc());
        }
        this.kDLabelRegion.setText(this.editData.getRegion() == null ? null : this.editData.getRegion().getAlias());
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)this.prmtproject);
        if (this.editData.isIsInCredit()) {
            this.prmtCreditLimit.setData((Object)this.editData.getCreditLimit());
            this.prmtCreditCurrency.setData((Object)this.editData.getCreditCurrency());
            this.txtCreditCurExRate.setValue((Object)this.editData.getCreditCurExRate());
            try {
                this.txtRemainAmount.setValue((Object)FinUtils.getCreditRemainAmount(null, this.editData.getCreditLimit(), this.currentCompany));
            }
            catch (BOSException e) {
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
        }
        if (this.chkIsDYZ.isSelected()) {
            this.txtFluctuateScaleFloor.setEditable(true);
            this.txtFluctuateScale.setEditable(true);
        } else {
            this.txtFluctuateScale.setEditable(false);
            this.txtFluctuateScaleFloor.setEditable(false);
            this.txtFluctuateScale.setValue((Object)SysConstant.BIGZERO);
            this.txtFluctuateScaleFloor.setValue((Object)SysConstant.BIGZERO);
        }
        this.prmtInstitution.setData((Object)this.editData.getInstitution());
        FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)this.editData.isIsInCredit());
        FMClientHelper.setEditable((JComponent)this.chkIsRelBank, (boolean)this.editData.isIsInCredit());
        this.chkIsInCredit.setSelected(this.editData.isIsInCredit());
        this.chkIsRelBank.setSelected(this.editData.isIsRelBankInCredit());
        this.txtLocalCurExRate.setValue((Object)this.editData.getLocalCurExRate());
        if (FinUtils.isBaseCurrency(this.editData.getCurrency(), this.editData.getCompany())) {
            this.txtLocalCurExRate.setEnabled(false);
        } else {
            this.txtLocalCurExRate.setEnabled(true);
        }
        this.txtCreditCurExRate.setValue((Object)this.editData.getCreditCurExRate());
        this.txtCreditLimitAmtLocal.setValue((Object)this.editData.getCreditLocalAmt());
        this.txtCreditPercentage.setValue((Object)this.editData.getCreditPercentage());
        this.txtforwardDate.setValue((Object)new Integer(this.editData.getForwardDate()));
        this.pkintendPayDate.setValue((Object)this.editData.getIntendPayDate());
        CurrencyInfo currency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        int localPrec = currency.getPrecision();
        if (this.currentCompany != null && this.currentCompany.getBaseCurrency() != null) {
            this.baseCurrency = this.currentCompany.getBaseCurrency();
            localPrec = FMClientHelper.getPrecOfCurrency((BOSUuid)this.baseCurrency.getId());
        }
        this.txtAmountLocalCur.setPrecision(localPrec);
        this.txtAmount.setPrecision(currency.getPrecision());
        this.txtBalance.setPrecision(currency.getPrecision());
        int CreditLimitAmtLocalPre = currency.getPrecision();
        if (this.prmtCreditCurrency.getValue() != null) {
            CreditLimitAmtLocalPre = ((CurrencyInfo)this.prmtCreditCurrency.getValue()).getPrecision();
        }
        this.txtUsedCreditAmt.setPrecision(CreditLimitAmtLocalPre);
        this.txtUsedCreditAmt.setValue((Object)this.editData.getUsedCreditAmt());
        this.txtCreditLimitAmtLocal.setPrecision(CreditLimitAmtLocalPre);
        this.txtCreditLimitAmtLocal.setValue((Object)this.editData.getCreditLocalAmt());
        this.txtRemainAmount.setPrecision(CreditLimitAmtLocalPre);
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            if (!this.editData.isIsInCredit()) {
                this.txtCreditPercentage.setEnabled(false);
                this.txtUsedCreditAmt.setEnabled(false);
            } else {
                this.txtCreditPercentage.setEnabled(true);
                this.txtUsedCreditAmt.setEnabled(true);
            }
        }
        this.txtmarginBalance.setValue((Object)this.editData.getMarginBalance());
        this.txtmarginEx.setValue((Object)this.editData.getMarginEx());
        this.txtmarginExRate.setValue((Object)this.editData.getMarginExRate());
        if (!"ADDNEW".equals(this.getOprtState())) {
            this.btnFee.setEnabled(true);
            this.menuItemFee.setEnabled(true);
        } else {
            this.btnFee.setEnabled(false);
            this.menuItemFee.setEnabled(false);
        }
        this.actionSave.setVisible(true);
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.actionSave.setEnabled(false);
        } else {
            this.actionSave.setEnabled(true);
        }
        LetterOfCreditInfo info = (LetterOfCreditInfo)this.getDataObject();
        if (this.getOprtState().equals(OprtState.EDIT)) {
            JComponent[] ctrls;
            if (info.getBalance().compareTo(info.getAmount()) == 0) {
                ctrls = new JComponent[]{this.pkBizDate, this.comboBillType, this.prmtInstitution, this.kDComboBoxCurrency, this.txtAmount, this.txtLocalCurExRate, this.chkIsInCredit, this.pkIssueDate, this.pkExpiredDate, this.txtRemark, this.prmtBeneficiary};
                FinUtils.setEditable(ctrls, true);
                FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)this.chkIsInCredit.isSelected());
                this.initCreditExRate();
            } else if (info.getBalance().compareTo(SysConstant.BIGZERO) > 0 && info.getBalance().compareTo(info.getAmount()) < 0) {
                JComponent[] ctrls1 = new JComponent[]{this.pkBizDate, this.comboBillType, this.prmtInstitution, this.kDComboBoxCurrency, this.txtAmount, this.txtLocalCurExRate, this.chkIsInCredit, this.pkIssueDate, this.pkExpiredDate, this.txtRemark, this.prmtBeneficiary};
                FinUtils.setEditable(ctrls1, true);
                JComponent[] ctrls2 = new JComponent[]{this.comboBillType, this.prmtInstitution, this.kDComboBoxCurrency, this.txtAmount, this.chkIsInCredit, this.prmtCreditLimit, this.pkIssueDate};
                FinUtils.setEditable(ctrls2, false);
                this.chkIsInCredit.setEnabled(false);
                this.initCreditExRate();
            } else if (info.getBalance().compareTo(SysConstant.BIGZERO) == 0) {
                ctrls = new JComponent[]{this.pkBizDate, this.comboBillType, this.prmtInstitution, this.kDComboBoxCurrency, this.txtAmount, this.txtLocalCurExRate, this.chkIsInCredit, this.pkIssueDate, this.pkExpiredDate, this.txtRemark, this.prmtCreditLimit, this.prmtBeneficiary};
                FinUtils.setEditable(ctrls, false);
                this.chkIsInCredit.setEnabled(false);
            }
            if (info.isFiVouchered()) {
                this.txtAmount.setEnabled(false);
            }
            FMClientHelper.setEditable((JComponent)this.pkIssueDate, (boolean)false);
        } else if (this.getOprtState().equals(OprtState.VIEW)) {
            FMClientHelper.setEditable((JComponent)this.chkIsForward, (boolean)false);
            FMClientHelper.setEditable((JComponent)this.chkIsInCredit, (boolean)false);
        } else if (this.getOprtState().equals(OprtState.ADDNEW)) {
            FMClientHelper.setEditable((JComponent)this.chkIsForward, (boolean)true);
            FMClientHelper.setEditable((JComponent)this.chkIsInCredit, (boolean)true);
            if (this.envirRpc != null && this.envirRpc.get("GuaranteeTypeInfo") != null) {
                this.prmtMainGT.setEnabled(false);
                this.prmtMainGT.setData(this.envirRpc.get("GuaranteeTypeInfo"));
            } else {
                this.combGTInputMode.setSelectedIndex(-1);
                this.combGTInputMode.setSelectedItem((Object)GuaranteeTypeInputModeEnum.assure);
            }
        }
        if (!this.chkIsInCredit.isSelected()) {
            FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)false);
            this.txtCreditCurExRate.setEditable(false);
            this.prmtCreditCurrency.setData(null);
            this.prmtCreditLimit.setData(null);
            this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
            this.txtRemainAmount.setValue((Object)SysConstant.BIGZERO);
            this.txtCreditLimitAmtLocal.setEnabled(false);
        } else {
            FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)true);
            this.txtCreditCurExRate.setEditable(true);
            this.txtCreditLimitAmtLocal.setEditable(true);
        }
        if (this.chkIsForward.isSelected()) {
            this.txtforwardDate.setEditable(true);
            this.txtforwardDate.setEnabled(true);
        } else {
            this.txtforwardDate.setEditable(false);
            this.txtforwardDate.setEnabled(false);
        }
        if ("ADDNEW".equals(this.oprtState)) {
            this.txtDeferReturnCreditLimitDays.setEnabled(this.chkIsInCredit.isSelected());
        } else if ("EDIT".equals(this.oprtState)) {
            boolean isNoRepayed = this.txtAmount.getBigDecimalValue().compareTo(this.txtBalance.getBigDecimalValue()) == 0;
            this.txtDeferReturnCreditLimitDays.setEnabled(isNoRepayed);
        }
        if (this.editData != null && !FMHelper.isEmpty((String)this.editData.getSourceBillId()) && BOSUuid.read((String)this.editData.getSourceBillId()).getType().equals((Object)new LetterOfCreditApplyInfo().getBOSType())) {
            this.comboBillType.setEnabled(false);
            this.kDContractCurrency.setEnabled(false);
            this.txtcontractAmount.setEnabled(false);
            this.prmtInstitution.setEnabled(false);
            this.kDComboBoxCurrency.setEnabled(false);
            this.txtAmount.setEnabled(false);
            this.prmtBeneficiary.setEnabled(false);
            this.prmtBeneficiaryStat.setEnabled(false);
            this.pkIssueDate.setEnabled(true);
        } else {
            this.comboBillType.setEnabled(true);
            this.kDContractCurrency.setEnabled(true);
            this.txtcontractAmount.setEnabled(true);
            this.prmtInstitution.setEnabled(true);
            this.kDComboBoxCurrency.setEnabled(true);
            this.txtAmount.setEnabled(true);
            this.prmtBeneficiary.setEnabled(true);
            this.prmtBeneficiaryStat.setEnabled(true);
            this.pkIssueDate.setEnabled(true);
        }
        if (!this.getOprtState().equals(OprtState.ADDNEW) && this.editData.getCreditLimit() != null && this.editData.getCreditLimit().getLimitType() == LimitTypeEnum.BILLPOOL_LIMIT) {
            this.txtCreditPercentage.setEnabled(false);
            this.txtDeferReturnCreditLimitDays.setEnabled(false);
        }
    }

    private void loadFieldsBySelf() {
        super.loadEntrysFields(this.editData);
        this.Scomps.col = this.editData.getReduceCol();
        this.Scomps.OperateStatus = this.editData.getOperateStatus();
    }

    private void verifyComps(ActionEvent e) throws Exception {
        Date date;
        if (this.txtNumber.isEnabled()) {
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        }
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDComboBox)this.comboBillType);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBizDate);
        FMClientVerifyHelper.verifyComboCurrency((CoreUIObject)this, (KDComboBox)this.kDComboBoxCurrency);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtLocalCurExRate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmountLocalCur);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtBalance);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkExpiredDate);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtHorizon);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtInstitution);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBeneficiary);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
        FMClientVerifyHelper.verifyComboCurrency((CoreUIObject)this, (KDComboBox)this.kDComboBoxCurrency);
        if (this.chkIsInCredit.isSelected()) {
            ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)RESOURCE, (KDBizPromptBox)this.prmtCreditLimit, (String)"mustCredit");
            FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCreditCurrency);
            FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtCreditCurExRate);
        }
        Date dateBegin = DateTimeUtils.truncateDate((Date)this.pkIssueDate.getSqlDate());
        Date dateEnd = DateTimeUtils.truncateDate((Date)this.pkExpiredDate.getSqlDate());
        if (!dateEnd.after(dateBegin)) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResString("LetterOfCreditEndDateLaterThanBeginDate"));
            this.pkExpiredDate.requestFocus();
            this.abort();
        }
        if (!EmptyUtil.isEmpty((Object)(date = DateTimeUtils.truncateDate((Date)this.pkintendPayDate.getSqlDate()))) && date.before(dateBegin)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"515_LetterOfCreditEditUI"));
            this.pkintendPayDate.requestFocus();
            this.abort();
        }
        if (!this.txtFluctuateScale.getText().equals("") || !this.txtFluctuateScaleFloor.getText().equals("")) {
            if (Integer.valueOf(this.txtFluctuateScale.getText()) > 100) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)LETTERRESOURCE, (String)"fluctuate"));
                this.txtFluctuateScale.requestFocus();
                this.abort();
            }
            int ceilInt = Integer.parseInt(this.txtFluctuateScale.getText());
            int floorInt = Integer.parseInt(this.txtFluctuateScaleFloor.getText());
            if (floorInt > ceilInt) {
                Object[] o = new Object[]{new Integer(ceilInt), new Integer(floorInt)};
                String orinWarn = EASResource.getString((String)LETTERRESOURCE, (String)"CeilMustBeGreaterThanFloor");
                MsgBox.showWarning((Component)((Object)this), (String)MessageFormat.format(orinWarn, o));
                SysUtil.abort();
            }
        }
        BigDecimal loanLocalAmt = this.txtAmountLocalCur.getBigDecimalValue();
        FinHelper.checkGuara(loanLocalAmt, this.kdGuara, this.editData.getId());
    }

    private void storeFieldsBySelf() {
        this.editData.setCurrency((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem());
        BankInfo bank = (BankInfo)this.prmtInstitution.getData();
        if (bank != null) {
            this.editData.setRegion(bank.getBankAreaType());
        }
        this.editData.setContractCurrenc((CurrencyInfo)this.kDContractCurrency.getSelectedItem());
        this.setFinanceingSource(this.editData);
        super.storeEntrysFields(this.editData);
        this.editData.setOperateStatus(this.Scomps.OperateStatus);
        this.editData.setReduceCol(this.Scomps.col);
        this.editData.setForwardDate((Integer)this.txtforwardDate.getValue());
        if (this.prmtNotifyBank.getValue() instanceof String || this.prmtNotifyBank.getValue() == null) {
            this.editData.setNotifyBankName((String)this.prmtNotifyBank.getValue());
        } else {
            BankInfo bankINnfo = (BankInfo)this.prmtNotifyBank.getValue();
            this.editData.setNotifyBankName(bankINnfo.getName());
        }
        this.editData.setBenefitCustomer(this.getCustomer(this.prmtBeneficiary.getData()));
        this.editData.setBenefitSupplier(this.getSupplier(this.prmtBeneficiary.getData()));
        this.editData.setBeneficiary(this.getStringName(this.prmtBeneficiary.getValue()));
    }

    @Override
    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        this.verifyComps(e);
        this.verifyInfo(e);
    }

    private void verifyInfo(ActionEvent e) throws Exception {
        CreditUsageInfo uinfo;
        if (this.editData.isIsInCredit() && this.editData.getCreditPercentage().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"222_LetterOfCreditEditUI"));
            this.txtCreditPercentage.requestFocus();
            this.abort();
        }
        if (this.editData.getCreditLimit() != null && this.editData.getCreditLimit().getCreditUsage() != null && this.editData.getCreditLimit().getLimitType().equals((Object)LimitTypeEnum.CREDIT_LIMIT) && (uinfo = CreditUsageFactory.getRemoteInstance().getCreditUsageInfo((IObjectPK)new ObjectUuidPK(this.editData.getCreditLimit().getCreditUsage().getId().toString()))).isColligateCredit() && this.editData.getCreditLimit().getShareType() == ShareTypeEnum.ASSIGN && (this.editData.getReduceCol() == null || this.editData.getReduceCol().size() == 0)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"4_FinancingBillControllerBean"));
            SysUtil.abort();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.storeFieldsBySelf();
    }

    @Override
    protected void chkIsInCredit_actionPerformed(ActionEvent e) throws Exception {
        super.chkIsInCredit_actionPerformed(e);
        if (!this.chkIsInCredit.isSelected()) {
            FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)false);
            this.txtCreditCurExRate.setEditable(false);
            this.txtCreditLimitAmtLocal.setEditable(false);
            this.prmtCreditCurrency.setData(null);
            this.prmtCreditLimit.setData(null);
            this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
            this.txtRemainAmount.setValue((Object)SysConstant.BIGZERO);
            this.chkIsRelBank.setSelected(false);
            this.chkIsRelBank.setEnabled(false);
            this.txtCreditPercentage.setEnabled(false);
            this.txtCreditPercentage.setValue(null);
            this.txtUsedCreditAmt.setEnabled(false);
            this.txtUsedCreditAmt.setValue(null);
        } else {
            FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)true);
            this.txtCreditCurExRate.setEditable(true);
            this.txtCreditLimitAmtLocal.setEditable(true);
            this.chkIsRelBank.setSelected(true);
            this.chkIsRelBank.setEnabled(true);
            this.txtCreditPercentage.setValue((Object)Constants.ONE_HUNDRED);
            this.txtCreditPercentage.setEnabled(true);
            this.txtUsedCreditAmt.setEnabled(false);
        }
        if ("ADDNEW".equals(this.oprtState)) {
            this.txtDeferReturnCreditLimitDays.setEnabled(this.chkIsInCredit.isSelected());
        } else if ("EDIT".equals(this.oprtState)) {
            boolean isNoRepayed = this.txtAmount.getBigDecimalValue().compareTo(this.txtBalance.getBigDecimalValue()) == 0;
            this.txtDeferReturnCreditLimitDays.setEnabled(isNoRepayed && this.chkIsInCredit.isSelected());
        }
        this.reSetFinancingReduce();
    }

    private BigDecimal getLocalAmount() {
        BigDecimal bdAmount = this.txtAmount.getBigDecimalValue();
        BigDecimal bdLocalExRate = this.txtLocalCurExRate.getBigDecimalValue();
        if (bdAmount != null && bdLocalExRate != null) {
            return bdAmount.multiply(bdLocalExRate);
        }
        return Constants.ZERO;
    }

    private void calcCreditLimitExRate() throws EASBizException, BOSException {
        if (!this.chkIsInCredit.isSelected()) {
            this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
        } else {
            CurrencyInfo currencyInfo = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
            CurrencyInfo creditCurrencyInfo = (CurrencyInfo)this.prmtCreditCurrency.getData();
            if (currencyInfo != null && creditCurrencyInfo != null) {
                LetterOfCreditInfo info = (LetterOfCreditInfo)this.getDataObject();
                if (info == null) {
                    return;
                }
                try {
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtCreditCurExRate, this.currentCompany, currencyInfo, creditCurrencyInfo, info.getBizDate(), null);
                }
                catch (EASBizException e) {
                    this.kDComboBoxCurrency.setSelectedItem(null);
                    throw e;
                }
            }
        }
    }

    @Override
    protected void kDComboBoxCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.kDComboBoxCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        if (this.kDComboBoxCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        if (currency != null) {
            this.txtAmount.setPrecision(currency.getPrecision());
            this.txtBalance.setPrecision(currency.getPrecision());
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtAmount, (Number)this.txtAmount.getBigDecimalValue());
            FMClientHelper.setCutValue((KDFormattedTextField)this.txtBalance, (Number)this.txtBalance.getBigDecimalValue());
            this.initKDTPrecesion(currency.getPrecision());
            CompanyOrgUnitInfo company = this.currentCompany;
            try {
                LetterOfCreditInfo info = (LetterOfCreditInfo)this.getDataObject();
                if (info != null) {
                    CurrencyInfo baseCurrency = company.getBaseCurrency();
                    if (baseCurrency == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("baseCurrency.*"));
                        sic.add(new SelectorItemInfo("baseCurrency.id"));
                        sic.add(new SelectorItemInfo("baseCurrency.number"));
                        sic.add(new SelectorItemInfo("baseCurrency.name"));
                        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()), sic);
                        baseCurrency = company.getBaseCurrency();
                    }
                    FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtLocalCurExRate, company, currency, baseCurrency, info.getBizDate(), null);
                    this.txtLocalCurExRate.setPrecision(5);
                }
            }
            catch (EASBizException e1) {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.currentCompany.getBaseCurrency());
                throw e1;
            }
            this.txtAmountLocalCur.setValue((Object)this.getLocalAmount());
            try {
                this.calcCreditLimitExRate();
                this.calcAssureExRate();
            }
            catch (EASBizException e1) {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)this.currentCompany.getBaseCurrency());
                throw e1;
            }
            if (FinUtils.isBaseCurrency(currency, this.currentCompany)) {
                this.txtLocalCurExRate.setEnabled(false);
            } else {
                this.txtLocalCurExRate.setEnabled(true);
            }
            super.updateExchangeRate4kd((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem(), (Date)this.pkIssueDate.getValue());
        }
        if (this.prmtCreditCurrency.getData() != null) {
            boolean isSamaCur = false;
            CurrencyInfo reditCurrency = (CurrencyInfo)this.prmtCreditCurrency.getData();
            isSamaCur = currency.getId().equals((Object)reditCurrency.getId());
            this.txtCreditCurExRate.setEnabled(!isSamaCur);
            this.txtCreditLimitAmtLocal.setEnabled(!isSamaCur);
        }
        this.changeMarginRate();
    }

    private void calcAssureExRate() throws EASBizException, BOSException {
    }

    @Override
    protected void comboBillType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBillType_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        NTTypeInfo selNtTypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
        BankInfo bank = (BankInfo)this.prmtInstitution.getData();
        if (bank != null) {
            this.kDLabelRegion.setText(bank.getBankAreaType().getAlias());
        } else {
            this.kDLabelRegion.setText(BankAreaTypeEnum.In.getAlias());
        }
        if (selNtTypeInfo.getFinanceType() != null && selNtTypeInfo.getFinanceType().getFinancingSource() != null) {
            this.kDLabelFinSource.setText(selNtTypeInfo.getFinanceType().getFinancingSource().getName());
        }
    }

    @Override
    protected void pkExpiredDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkExpiredDate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon(this.pkIssueDate, this.pkExpiredDate));
        this.setPKintendPayDate();
    }

    @Override
    protected void pkIssueDate_dataChanged(DataChangeEvent e) throws Exception {
        super.pkIssueDate_dataChanged(e);
        this.txtHorizon.setValue((Object)FinHorizon.getHorizon(this.pkIssueDate, this.pkExpiredDate));
    }

    @Override
    protected void prmtCreditLimit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCreditLimit_dataChanged(e);
        CreditLimitInfo creditLimitInfo = (CreditLimitInfo)this.prmtCreditLimit.getData();
        if (creditLimitInfo == null) {
            this.txtCreditCurExRate.setEditable(false);
            this.txtCreditLimitAmtLocal.setEditable(false);
            this.prmtCreditCurrency.setData(null);
            this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
            this.txtUsedCreditAmt.setValue((Object)SysConstant.BIGZERO);
            this.txtCreditLimitAmtLocal.setValue((Object)SysConstant.BIGZERO);
            this.txtRemainAmount.setValue((Object)SysConstant.BIGZERO);
            this.Scomps.col = null;
            if (e.getOldValue() != null) {
                CreditLimitInfo oldCredit = (CreditLimitInfo)e.getOldValue();
                this.removeEntrySelectively(oldCredit);
                this.kDCredit.removeRows();
                this.kDOther.removeRows();
            } else {
                this.combGTInputMode.setSelectedItem((Object)GuaranteeTypeInputModeEnum.assure);
                this.kdGuara.removeRows();
                this.kDPledge.removeRows();
                this.kDImpawn.removeRows();
                this.kDCredit.removeRows();
                this.kDOther.removeRows();
            }
            this.txtCreditLimitAmtLocal.setEnabled(false);
            this.txtCreditPercentage.setEnabled(true);
            this.txtDeferReturnCreditLimitDays.setEnabled(true);
            return;
        }
        this.txtCreditLimitAmtLocal.setEnabled(true);
        creditLimitInfo = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitInfo.getId()), FinUtils.getCreditLimitEntityView().getSelector());
        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(creditLimitInfo.getCurrency().getId().toString()));
        if (creditLimitInfo.getLimitType() == LimitTypeEnum.BILLPOOL_LIMIT) {
            this.txtCreditPercentage.setValue((Object)Constants.ONE_HUNDRED);
            this.txtCreditPercentage.setEnabled(false);
            this.txtDeferReturnCreditLimitDays.setValue((Object)new Integer(0));
            this.txtDeferReturnCreditLimitDays.setEnabled(false);
        } else {
            this.txtCreditPercentage.setEnabled(true);
            this.txtDeferReturnCreditLimitDays.setEnabled(true);
        }
        this.prmtCreditCurrency.setData((Object)currency);
        this.txtRemainAmount.setValue((Object)FinUtils.getCreditRemainAmount(null, creditLimitInfo, this.currentCompany));
        if (this.prmtCreditCurrency.getData() != null) {
            boolean isSamaCur = false;
            CurrencyInfo reditCurrency = (CurrencyInfo)this.prmtCreditCurrency.getData();
            isSamaCur = currency.getId().equals((Object)reditCurrency.getId());
            this.txtCreditCurExRate.setEnabled(!isSamaCur);
            this.txtCreditLimitAmtLocal.setEnabled(!isSamaCur);
        }
        this.calcCreditLimitExRate();
        this.reCalUsedAmt();
        if (e.getOldValue() != null) {
            this.removeEntrySelectively((CreditLimitInfo)e.getOldValue());
            this.kDCredit.removeRows();
            this.kDOther.removeRows();
        }
        this.loadGuaranteeTypeOfCreditLimit(creditLimitInfo);
        this.reSetFinancingReduce();
    }

    private void initCreditLimitF7Filter() throws BOSException, EASBizException {
        if (this.prmtInstitution.getData() != null) {
            BankInfo bank = (BankInfo)this.prmtInstitution.getData();
            this.prmtCreditLimit.setEntityViewInfo(FinUtils.getCreditLimitF7Filter(bank.getId().toString(), this.currentCompany.getId().toString()));
        } else {
            this.prmtCreditLimit.setEntityViewInfo(FMClientHelper.getNothingFilter());
        }
    }

    @Override
    protected void prmtInstitution_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtInstitution_dataChanged(e);
        BankInfo bank = (BankInfo)e.getNewValue();
        if (bank != null) {
            bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bank.getId()));
            this.kDLabelRegion.setText(bank.getBankAreaType().getAlias());
        } else {
            this.kDLabelRegion.setText(null);
        }
        this.chkIsInCredit.setSelected(false);
        this.chkIsRelBank.setSelected(false);
        this.chkIsRelBank.setEnabled(false);
        FMClientHelper.setEditable((JComponent)this.prmtCreditLimit, (boolean)false);
        this.prmtCreditLimit.setData(null);
        this.prmtCreditCurrency.setData(null);
        this.txtCreditCurExRate.setValue(null);
        this.txtRemainAmount.setValue(null);
        this.prmtmarginAcct.setValue(null);
        this.prmtpayBankAcct.setValue(null);
        this.getPledgeBillFilter();
        this.initEntrysTable();
    }

    @Override
    protected void txtAmount_dataChanged(DataChangeEvent e) throws Exception {
        super.txtAmount_dataChanged(e);
        this.txtAmountLocalCur.setValue((Object)this.getLocalAmount());
        if (this.getOprtState().equals(OprtState.ADDNEW) || this.getOprtState().equals(OprtState.COPYADDNEW) || this.getOprtState().equals(OprtState.EDIT)) {
            this.txtBalance.setValue((Object)this.txtAmount.getBigDecimalValue());
        }
        this.reCalUsedAmt();
        this.calAllFields();
    }

    @Override
    protected void txtLocalCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtLocalCurExRate_dataChanged(e);
        this.txtAmountLocalCur.setValue((Object)this.getLocalAmount());
    }

    private void showChooseFinProUI() throws Exception {
        CreditLimitInfo creditLimitInfo = (CreditLimitInfo)this.prmtCreditLimit.getData();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("CreditUsage.*");
        sic.add("finacingProduct.*");
        creditLimitInfo = CreditLimitFactory.getRemoteInstance().getCreditLimitInfo((IObjectPK)new ObjectUuidPK(creditLimitInfo.getId()), sic);
        if (creditLimitInfo.getCreditUsage().isColligateCredit() && creditLimitInfo.getShareType() == ShareTypeEnum.ASSIGN) {
            NTTypeInfo selNtTypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
            this.getUIContext().put("creditPK", new ObjectUuidPK(AccessHelper.getId((Object)this.prmtCreditLimit.getValue())));
            this.getUIContext().put("creditLocalAmt", this.txtCreditLimitAmtLocal.getBigDecimalValue());
            this.getUIContext().put("finproID", AccessHelper.getId((Object)selNtTypeInfo.getFinanceType()));
            if (this.getOprtState().equals(OprtState.EDIT)) {
                this.getUIContext().put("billID", this.editData.getId().toString());
                ObjectUuidPK oldCreitLimitPK = this.editData.getCreditLimit() == null ? null : new ObjectUuidPK(this.editData.getCreditLimit().getId());
                this.getUIContext().put("oldCreitLimitPK", oldCreitLimitPK);
                this.getUIContext().put("CONTENT_MONEY", this.editData.getCreditLocalAmt().toString());
            }
            if ("EDIT".equals(OprtState.EDIT) && this.editData.getCreditLimit() != null && this.editData.getCreditLimit().getId().equals((Object)creditLimitInfo.getId())) {
                if (this.txtCreditLimitAmtLocal.getBigDecimalValue().compareTo(creditLimitInfo.getBalance().add(this.editData.getCreditLocalAmt())) == 1) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"116_ChooseFinancingProductUI"));
                    this.prmtCreditLimit.setValue(null);
                    SysUtil.abort();
                }
            } else if (this.txtCreditLimitAmtLocal.getBigDecimalValue().compareTo(creditLimitInfo.getBalance()) == 1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"116_ChooseFinancingProductUI"));
                this.prmtCreditLimit.setValue(null);
                SysUtil.abort();
            }
            if (selNtTypeInfo.getFinanceType() == null) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"115_ChooseFinancingProductUI"));
                this.prmtCreditLimit.setValue(null);
                SysUtil.abort();
            }
            this.Scomps.col = ChooseFinancingProductUI.showChooseFinancingProductUI((CoreUI)this);
            if (this.Scomps.col == null || this.Scomps.col.size() <= 0) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"223_LetterOfCreditEditUI"));
                this.prmtCreditLimit.setValue(null);
            }
        }
    }

    @Override
    protected void kDContractCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.kDContractCurrency_itemStateChanged(e);
        if (e.getStateChange() == 2) {
            return;
        }
        CurrencyInfo currency = this.currentCompany.getBaseCurrency();
        if (this.kDContractCurrency.getSelectedItem() != null) {
            currency = (CurrencyInfo)this.kDContractCurrency.getSelectedItem();
        }
        if (currency != null) {
            this.txtcontractAmount.setPrecision(currency.getPrecision());
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal amt;
        ArrayList outGuarNumberList;
        boolean rs;
        String GTMode = this.combGTInputMode.getSelectedItem().toString();
        if (this.combGTInputMode.getSelectedItem() != null && (this.combGTInputMode.getSelectedItem().equals((Object)GuaranteeTypeInputModeEnum.assure) || this.combGTInputMode.getSelectedItem().equals((Object)GuaranteeTypeInputModeEnum.mix)) && !(rs = FMClientHelper.showConfirmDetailResult((Component)((Object)this), (ArrayList)(outGuarNumberList = FMClientHelper.checkGuaranteeLimit((KDTable)this.kdGuara, (BigDecimal)(amt = this.txtAmountLocalCur.getBigDecimalValue()), this.editData.getId() != null ? this.editData.getId().toString() : null))))) {
            return;
        }
        super.actionSubmit_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal amt;
        ArrayList outGuarNumberList;
        boolean rs;
        String GTMode = this.combGTInputMode.getSelectedItem().toString();
        if (this.combGTInputMode.getSelectedItem() != null && (this.combGTInputMode.getSelectedItem().equals((Object)GuaranteeTypeInputModeEnum.assure) || this.combGTInputMode.getSelectedItem().equals((Object)GuaranteeTypeInputModeEnum.mix)) && !(rs = FMClientHelper.showConfirmDetailResult((Component)((Object)this), (ArrayList)(outGuarNumberList = FMClientHelper.checkGuaranteeLimit((KDTable)this.kdGuara, (BigDecimal)(amt = this.txtAmountLocalCur.getBigDecimalValue()), this.editData.getId() != null ? this.editData.getId().toString() : null))))) {
            return;
        }
        this.editData.setOperateStatus(LetterOperateTypeEnum.temporarily);
        super.actionSave_actionPerformed(e);
    }

    protected void initCreditExRate() {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        CurrencyInfo creditCurrencyInfo = (CurrencyInfo)this.prmtCreditCurrency.getData();
        try {
            FinUtils.initExRateTxtFieldStatus(this.txtCreditCurExRate, this.currentCompany, currencyInfo, creditCurrencyInfo);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    @Override
    protected void prmtCreditCurrency_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCreditCurrency_dataChanged(e);
        CurrencyInfo currency = (CurrencyInfo)e.getNewValue();
        if (currency != null) {
            int prec = currency.getPrecision();
            this.txtUsedCreditAmt.setPrecision(prec);
            this.txtCreditLimitAmtLocal.setPrecision(prec);
            this.txtRemainAmount.setPrecision(prec);
        }
        this.calAllFields();
    }

    @Override
    protected void setExchangeRateRelAss(ICell cell, CompanyOrgUnitInfo company, CurrencyInfo destCurr) {
        try {
            FinUtils.initExchangeRateRelAss(null, cell, company, (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem(), destCurr, (Date)this.pkIssueDate.getValue());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected FilterInfo getPledgeBillFilter() {
        FilterInfo filterInfo = super.getPledgeBillFilter();
        if (this.prmtInstitution.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Institution.id", (Object)((BankInfo)this.prmtInstitution.getData()).getId().toString()));
        }
        return filterInfo;
    }

    @Override
    protected FilterInfo getImpawnBillFilter() {
        FilterInfo filterInfo = super.getImpawnBillFilter();
        if (this.prmtInstitution.getData() != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("Institution.id", (Object)((BankInfo)this.prmtInstitution.getData()).getId().toString()));
        }
        return filterInfo;
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 22;
    }

    public int getHorizontalScrollPolicy() {
        return 32;
    }

    @Override
    protected void chkIsRelBank_itemStateChanged(ItemEvent e) throws Exception {
        super.chkIsRelBank_itemStateChanged(e);
        this.prmtCreditLimit.setData(null);
        this.prmtCreditCurrency.setData(null);
        this.txtCreditCurExRate.setValue((Object)SysConstant.BIGZERO);
        this.txtRemainAmount.setValue((Object)SysConstant.BIGZERO);
    }

    @Override
    protected void prmtCreditLimit_willCommit(CommitEvent e) throws Exception {
        super.prmtCreditLimit_willCommit(e);
        this.setPrmtCreditLimitFilter();
    }

    protected void setPrmtCreditLimitFilter() throws EASBizException, BOSException {
        BankInfo bank = (BankInfo)this.prmtInstitution.getData();
        if (bank == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"224_LetterOfCreditEditUI"));
            this.prmtCreditLimit.setEntityViewInfo(FMClientHelper.getNothingFilter());
        } else {
            NTTypeInfo selNtTypeInfo = (NTTypeInfo)this.comboBillType.getSelectedItem();
            if (selNtTypeInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"225_LetterOfCreditEditUI"));
                SysUtil.abort();
            }
            if (selNtTypeInfo.getFinanceType() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"226_LetterOfCreditEditUI"));
                SysUtil.abort();
            }
            this.prmtCreditLimit.setEntityViewInfo(FinUtils.getCreditLimitF7FilterZsd(this.prmtInstitution.getData(), this.currentCompany.getId().toString(), this.chkIsRelBank.isSelected(), AccessHelper.getId((Object)selNtTypeInfo.getFinanceType())));
            this.prmtCreditLimit.getQueryAgent().resetRuntimeEntityView();
        }
        this.prmtCreditLimit.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtCreditLimit_willShow(SelectorEvent e) throws Exception {
        super.prmtCreditLimit_willShow(e);
        this.setPrmtCreditLimitFilter();
    }

    @Override
    protected void txtCreditCurExRate_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.Mutex_CreditCurExRate_CreditLimitAmtLocal) {
            this.Mutex_CreditCurExRate_CreditLimitAmtLocal = true;
            try {
                this.reCreditLocalAmt();
            }
            finally {
                this.Mutex_CreditCurExRate_CreditLimitAmtLocal = false;
            }
        }
    }

    @Override
    protected void txtCreditLimitAmtLocal_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.Mutex_CreditCurExRate_CreditLimitAmtLocal) {
            this.Mutex_CreditCurExRate_CreditLimitAmtLocal = true;
            try {
                this.reCalRate();
            }
            finally {
                this.Mutex_CreditCurExRate_CreditLimitAmtLocal = false;
            }
        }
        this.reCalLimitMargin();
        this.reCalMaginEx();
        this.reSetFinancingReduce();
    }

    @Override
    protected void txtCreditPercentage_dataChanged(DataChangeEvent e) throws Exception {
        this.reCalUsedAmt();
    }

    @Override
    protected void txtUsedCreditAmt_dataChanged(DataChangeEvent e) throws Exception {
        this.reCreditLocalAmt();
    }

    private void reCalUsedAmt() throws Exception {
        if (this.txtCreditPercentage.getBigDecimalValue() != null && this.txtAmount.getBigDecimalValue() != null) {
            if (this.prmtCreditLimit.getValue() != null) {
                this.txtUsedCreditAmt.setValue((Object)this.txtAmount.getBigDecimalValue().multiply(this.txtCreditPercentage.getBigDecimalValue().divide(Constants.ONE_HUNDRED, this.txtCreditCurExRate.getPrecision(), 4)));
            } else {
                this.txtUsedCreditAmt.setValue((Object)SysConstant.BIGZERO);
            }
        }
    }

    private void reCalRate() {
        CurrencyInfo curencyInfo = (CurrencyInfo)this.prmtCreditCurrency.getValue();
        CurrencyInfo curencyInfoHead = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
        if (curencyInfo == null || curencyInfoHead == null) {
            return;
        }
        if (!curencyInfo.getId().toString().equals(curencyInfoHead.getId().toString()) && this.txtCreditLimitAmtLocal.getBigDecimalValue() != null && this.txtUsedCreditAmt.getBigDecimalValue() != null && this.txtUsedCreditAmt.getBigDecimalValue().compareTo(Constants.ZERO) != 0) {
            this.txtCreditCurExRate.setValue((Object)this.txtCreditLimitAmtLocal.getBigDecimalValue().divide(this.txtUsedCreditAmt.getBigDecimalValue(), this.txtCreditCurExRate.getPrecision(), 4));
        }
    }

    private void reCreditLocalAmt() {
        FMClientHelper.setCutValue((KDFormattedTextField)this.txtCreditLimitAmtLocal, (Number)FMHelper.multiply((BigDecimal)this.txtUsedCreditAmt.getBigDecimalValue(), (BigDecimal)this.txtCreditCurExRate.getBigDecimalValue()));
    }

    private void setFinanceingSource(LetterOfCreditInfo info) {
        if (info.getNtType() != null) {
            info.setSource(info.getNtType().getFinanceType() == null ? null : info.getNtType().getFinanceType().getFinancingSource());
        }
    }

    @Override
    protected void txtmarginExRate_dataChanged(DataChangeEvent e) throws Exception {
        this.reCalMaginEx();
    }

    @Override
    protected void txtmarginRate_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal rate = (BigDecimal)e.getNewValue();
        if (rate == null) {
            return;
        }
        if (rate.compareTo(Constants.ZERO) < 0 || rate.compareTo(new BigDecimal(String.valueOf(100))) > 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"227_LetterOfCreditEditUI"));
            this.txtmarginRate.setValue((Object)Constants.ZERO);
            return;
        }
        this.reCalLimitMargin();
        this.reCalMaginEx();
    }

    @Override
    protected void prmtpayBankAcct_willCommit(CommitEvent e) throws Exception {
        BankInfo bank = (BankInfo)this.prmtInstitution.getValue();
        if (bank == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"228_LetterOfCreditEditUI"));
            this.prmtInstitution.requestFocus();
            e.setCanceled(true);
            return;
        }
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterItemInfo filterItem1 = new FilterItemInfo("company.id", (Object)CURRENT_COMPANY.getId().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("isClosed", (Object)Boolean.FALSE);
        FilterItemInfo filterItem3 = new FilterItemInfo("bank.id", (Object)bank.getId());
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtpayBankAcct, (FilterItemInfo)filterItem1);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtpayBankAcct, (FilterItemInfo)filterItem2);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtpayBankAcct, (FilterItemInfo)filterItem3);
        this.prmtpayBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtpayBankAcct_willShow(SelectorEvent e) throws Exception {
        BankInfo bank = (BankInfo)this.prmtInstitution.getValue();
        if (bank == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"228_LetterOfCreditEditUI"));
            this.prmtInstitution.requestFocus();
            e.setCanceled(true);
            return;
        }
        CompanyOrgUnitInfo CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterItemInfo filterItem1 = new FilterItemInfo("company.id", (Object)CURRENT_COMPANY.getId().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("isClosed", (Object)Boolean.FALSE);
        FilterItemInfo filterItem3 = new FilterItemInfo("bank.id", (Object)bank.getId());
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtpayBankAcct, (FilterItemInfo)filterItem1);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtpayBankAcct, (FilterItemInfo)filterItem2);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtpayBankAcct, (FilterItemInfo)filterItem3);
        this.prmtpayBankAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtmarginAcct_dataChanged(DataChangeEvent e) throws Exception {
        this.setCurrency();
        this.txtmarginExRate.setPrecision(10);
    }

    private void setCurrency() {
        AccountBankInfo mar = (AccountBankInfo)this.prmtmarginAcct.getValue();
        AccountBankInfo pay = (AccountBankInfo)this.prmtpayBankAcct.getValue();
        if (mar == null) {
            if (pay != null) {
                if (pay.getCurrency() != null) {
                    this.prmtmarginCurrency.setValue((Object)pay.getCurrency());
                    this.prmtmarginCurrency.setEnabled(false);
                } else {
                    this.prmtmarginCurrency.setEnabled(true);
                }
            } else {
                this.prmtmarginCurrency.setEnabled(true);
            }
        } else if (mar.getCurrency() != null) {
            this.prmtmarginCurrency.setValue((Object)mar.getCurrency());
            this.prmtmarginCurrency.setEnabled(false);
        } else if (pay != null) {
            if (pay.getCurrency() != null) {
                this.prmtmarginCurrency.setValue((Object)pay.getCurrency());
                this.prmtmarginCurrency.setEnabled(true);
            } else {
                this.prmtmarginCurrency.setEnabled(true);
            }
        } else {
            this.prmtmarginCurrency.setEnabled(true);
        }
    }

    @Override
    protected void prmtpayBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        this.setCurrency();
    }

    @Override
    protected void prmtmarginAcct_willCommit(CommitEvent e) throws Exception {
        BankInfo bank = (BankInfo)this.prmtInstitution.getValue();
        if (bank == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"228_LetterOfCreditEditUI"));
            this.prmtInstitution.requestFocus();
            e.setCanceled(true);
            return;
        }
        FilterItemInfo filterItem1 = new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("isClosed", (Object)Boolean.FALSE);
        FilterItemInfo filterItem3 = new FilterItemInfo("bank.id", (Object)bank.getId());
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtmarginAcct, (FilterItemInfo)filterItem1);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtmarginAcct, (FilterItemInfo)filterItem2);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtmarginAcct, (FilterItemInfo)filterItem3);
        this.prmtmarginAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtmarginAcct_willShow(SelectorEvent e) throws Exception {
        BankInfo bank = (BankInfo)this.prmtInstitution.getValue();
        if (bank == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"228_LetterOfCreditEditUI"));
            this.prmtInstitution.requestFocus();
            e.setCanceled(true);
            return;
        }
        FilterItemInfo filterItem1 = new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString());
        FilterItemInfo filterItem2 = new FilterItemInfo("isClosed", (Object)Boolean.FALSE);
        FilterItemInfo filterItem3 = new FilterItemInfo("bank.id", (Object)bank.getId());
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtmarginAcct, (FilterItemInfo)filterItem1);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtmarginAcct, (FilterItemInfo)filterItem2);
        FilterUtil.mergerFilterItem((KDBizPromptBox)this.prmtmarginAcct, (FilterItemInfo)filterItem3);
        this.prmtmarginAcct.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtmarginCurrency_dataChanged(DataChangeEvent e) throws Exception {
        Object o = e.getNewValue();
        if (o instanceof CurrencyInfo) {
            CurrencyInfo currency = (CurrencyInfo)o;
            int pre = currency.getPrecision();
            if (pre == 0) {
                pre = 2;
            }
            this.txtmarginEx.setPrecision(pre);
            this.txtmarginBalance.setPrecision(pre);
            this.txtlimitMargin.setPrecision(pre);
        }
        this.calAllFields();
    }

    private void changeMarginRate() throws EASBizException, BOSException {
        MarginAlgorithmEnum al = (MarginAlgorithmEnum)((Object)this.marginAlgorithm.getSelectedItem());
        CurrencyInfo source = null;
        if (MarginAlgorithmEnum.CREDITLIMIT == al) {
            source = (CurrencyInfo)this.prmtCreditCurrency.getValue();
            this.txtlimitMargin.setEnabled(true);
        } else if (MarginAlgorithmEnum.LETTEROFCREDIT == al) {
            source = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
            this.txtlimitMargin.setEnabled(false);
            this.txtlimitMargin.setValue(null);
        }
        if (source == null) {
            this.txtmarginExRate.setValue(null);
            this.txtmarginExRate.setEnabled(false);
            return;
        }
        CurrencyInfo dest = (CurrencyInfo)this.prmtmarginCurrency.getValue();
        FinUtils.initExchangeRate(null, (BasicFormattedTextField)this.txtmarginExRate, this.currentCompany, source, dest, DateUtil.getDayBegin(), null);
        this.txtmarginExRate.setPrecision(10);
    }

    @Override
    protected void txtlimitMargin_dataChanged(DataChangeEvent e) throws Exception {
        this.reCalMaginEx();
    }

    @Override
    protected void txtmarginEx_dataChanged(DataChangeEvent e) throws Exception {
        BigDecimal marginEx;
        if ((OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) && (marginEx = this.txtmarginEx.getBigDecimalValue()) != null) {
            this.txtmarginBalance.setValue((Object)marginEx);
            this.txtmarginBalance.setEnabled(false);
        }
    }

    @Override
    protected void marginAlgorithm_itemStateChanged(ItemEvent e) throws Exception {
        super.marginAlgorithm_itemStateChanged(e);
        this.calAllFields();
    }

    private void calAllFields() throws EASBizException, BOSException {
        this.changeMarginRate();
        this.reCalLimitMargin();
        this.reCalMaginEx();
    }

    private void reCalLimitMargin() {
        MarginAlgorithmEnum al = (MarginAlgorithmEnum)((Object)this.marginAlgorithm.getSelectedItem());
        if (MarginAlgorithmEnum.CREDITLIMIT.equals((Object)al)) {
            BigDecimal rate = this.txtmarginRate.getBigDecimalValue();
            BigDecimal creditLimitAmtLocal = this.txtCreditLimitAmtLocal.getBigDecimalValue();
            BigDecimal value = FMHelper.multiply((BigDecimal)rate, (BigDecimal)creditLimitAmtLocal).divide(Constants.ONE_HUNDRED, 4);
            this.txtlimitMargin.setValue((Object)value);
            this.txtlimitMargin.setEnabled(true);
        } else if (MarginAlgorithmEnum.LETTEROFCREDIT.equals((Object)al)) {
            this.txtlimitMargin.setValue(null);
            this.txtlimitMargin.setEnabled(false);
        }
    }

    private void reCalMaginEx() {
        MarginAlgorithmEnum al = (MarginAlgorithmEnum)((Object)this.marginAlgorithm.getSelectedItem());
        if (MarginAlgorithmEnum.CREDITLIMIT.equals((Object)al)) {
            BigDecimal amount = this.txtlimitMargin.getBigDecimalValue();
            BigDecimal rate = this.txtmarginExRate.getBigDecimalValue();
            BigDecimal marginEx = FMHelper.multiply((BigDecimal)amount, (BigDecimal)rate);
            marginEx = marginEx.setScale(this.txtmarginEx.getPrecision(), 4);
            this.txtmarginEx.setValue((Object)marginEx);
        } else if (MarginAlgorithmEnum.LETTEROFCREDIT.equals((Object)al)) {
            BigDecimal amount = this.txtAmount.getBigDecimalValue();
            BigDecimal rate = this.txtmarginRate.getBigDecimalValue();
            BigDecimal rateEx = this.txtmarginExRate.getBigDecimalValue();
            BigDecimal tmp = FMHelper.multiply((BigDecimal)amount, (BigDecimal)rate);
            tmp = FMHelper.multiply((BigDecimal)tmp, (BigDecimal)rateEx);
            BigDecimal value = tmp.divide(Constants.ONE_HUNDRED, 4);
            value = value.setScale(this.txtmarginEx.getPrecision(), 4);
            this.txtmarginEx.setValue((Object)value);
        } else {
            this.txtmarginEx.setValue((Object)Constants.ZERO);
        }
    }

    @Override
    protected void chkIsForward_actionPerformed(ActionEvent e) throws Exception {
        super.chkIsForward_actionPerformed(e);
        if (this.chkIsForward.isSelected()) {
            this.txtforwardDate.setEditable(true);
            this.txtforwardDate.setEnabled(true);
        } else {
            this.txtforwardDate.setEditable(false);
            this.txtforwardDate.setEnabled(false);
            this.txtforwardDate.setValue((Object)new Integer(0));
        }
    }

    protected void setPKintendPayDate() {
        if (this.pkExpiredDate.getValue() != null && this.txtforwardDate.getValue() != null) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)this.pkExpiredDate.getValue());
            c.add(5, (Integer)this.txtforwardDate.getValue());
            this.pkintendPayDate.setValue((Object)c.getTime());
        }
    }

    @Override
    protected void txtforwardDate_stateChanged(ChangeEvent e) throws Exception {
        if ((Integer)this.txtforwardDate.getValue() < 0) {
            this.txtforwardDate.setValue((Object)new Integer(0));
        }
        if (!"VIEW".equals(this.oprtState)) {
            this.setPKintendPayDate();
        }
    }

    @Override
    protected void pkintendPayDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.pkintendPayDate.getValue() == null) {
            return;
        }
    }

    @Override
    protected void chkIsDYZ_actionPerformed(ActionEvent e) throws Exception {
        super.chkIsDYZ_actionPerformed(e);
        if (this.chkIsDYZ.isSelected()) {
            this.txtFluctuateScaleFloor.setEditable(true);
            this.txtFluctuateScale.setEditable(true);
        } else {
            this.txtFluctuateScale.setEditable(false);
            this.txtFluctuateScaleFloor.setEditable(false);
            this.txtFluctuateScale.setValue((Object)SysConstant.BIGZERO);
            this.txtFluctuateScaleFloor.setValue((Object)SysConstant.BIGZERO);
        }
    }

    @Override
    public void actionAddFee_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getId().toString();
        this.checkStatus(id);
        this.checkLetterIsClosed(id);
        LetterOfCreditInfo letterOfCreditInfo = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id));
        this.showLetterOfCreditFeeListUI((CoreUI)this, letterOfCreditInfo);
    }

    public void showLetterOfCreditFeeListUI(CoreUI ui, LetterOfCreditInfo letterOfCreditInfo) {
        try {
            UIContext uiContext = new UIContext((Object)ui);
            uiContext.put((Object)"letterOfCreditID", (Object)letterOfCreditInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(FeeManageFMUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
    }

    public void checkStatus(String id) throws EASBizException, BOSException {
        LetterOfCreditInfo letterOfCreditInfo = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id));
        if (letterOfCreditInfo.getOperateStatus() == LetterOperateTypeEnum.temporarily) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)LETTERRESOURCE, (String)"temporarily"));
            SysUtil.abort();
        }
    }

    public void checkLetterIsClosed(String id) throws EASBizException, BOSException {
        LetterOfCreditInfo letterOfCreditInfo = LetterOfCreditFactory.getRemoteInstance().getLetterOfCreditInfo((IObjectPK)new ObjectUuidPK(id));
        if (letterOfCreditInfo.getLetterStatus() == LetterStatusEnum.close) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)LETTERRESOURCE, (String)"close"));
            SysUtil.abort();
        }
    }

    @Override
    protected void txtDeferReturnCreditLimitDays_stateChanged(ChangeEvent e) throws Exception {
        if ((Integer)this.txtDeferReturnCreditLimitDays.getValue() < 0) {
            this.txtDeferReturnCreditLimitDays.setValue((Object)new Integer(0));
        }
    }

    private boolean isSameBetweenReduceAndCreditLimit() {
        boolean isSameBetweenReduceAndCreditLimit;
        if (this.prmtCreditLimit.getValue() == null) {
            isSameBetweenReduceAndCreditLimit = this.Scomps.col == null || this.Scomps.col.size() == 0;
        } else if (this.Scomps.col == null || this.Scomps.col.size() == 0) {
            isSameBetweenReduceAndCreditLimit = false;
        } else {
            CreditLimitInfo creditLimitInfo = (CreditLimitInfo)this.prmtCreditLimit.getValue();
            isSameBetweenReduceAndCreditLimit = creditLimitInfo.getId().equals((Object)this.Scomps.col.get(0).getCreditLimitID());
        }
        return isSameBetweenReduceAndCreditLimit;
    }

    private boolean isEqualSumReduceAndAmount() {
        if (this.txtCreditLimitAmtLocal.getBigDecimalValue() == null) {
            return this.Scomps.col == null;
        }
        if (this.Scomps.col == null || this.Scomps.col.size() == 0) {
            return false;
        }
        BigDecimal amt = new BigDecimal("0");
        int n = this.Scomps.col.size();
        for (int i = 0; i < n; ++i) {
            if (this.Scomps.col.get(i).getUsedAmt() == null) continue;
            amt = amt.add(this.Scomps.col.get(i).getUsedAmt());
        }
        return amt.compareTo(this.txtCreditLimitAmtLocal.getBigDecimalValue()) == 0;
    }

    private void reSetFinancingReduce() throws Exception {
        if (this.chkIsInCredit.isSelected() && this.prmtCreditLimit.getValue() != null) {
            CreditLimitInfo creditLimitInfo = (CreditLimitInfo)this.prmtCreditLimit.getValue();
            if (creditLimitInfo.getCreditUsage().isColligateCredit() && creditLimitInfo.getLimitType().equals((Object)LimitTypeEnum.CREDIT_LIMIT) && (!this.isSameBetweenReduceAndCreditLimit() || !this.isEqualSumReduceAndAmount())) {
                this.showChooseFinProUI();
            }
        } else {
            this.Scomps.col = null;
        }
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("TargetBillType", "LetterOfCredit");
        this.getBillEdit().createFrom(null, ctx);
    }

    public int getBtpCreateFromType() {
        return 0;
    }

    @Override
    protected void applyDefaultValue(IObjectValue vo) {
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    @Override
    public BOTRelationCollection getMakeRelations() {
        return null;
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.NT_MANAGEMENT;
    }

    protected String getDateField() {
        return "IssueDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionSave", "actionSubmit", "actionAntiAudit"};
    }

    private String getStringName(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    private CustomerInfo getCustomer(Object objCust) {
        if (objCust instanceof CustomerInfo) {
            return (CustomerInfo)objCust;
        }
        return null;
    }

    private SupplierInfo getSupplier(Object obj) {
        if (obj instanceof SupplierInfo) {
            return (SupplierInfo)obj;
        }
        return null;
    }

    @Override
    protected void prmtBeneficiary_dataChanged(DataChangeEvent e) throws Exception {
        Object beneficiary = this.prmtBeneficiary.getData();
        ObjectBaseInfo csInfo = null;
        if (beneficiary instanceof String && (csInfo = NTHelper.getCSInfoByNumber((String)((String)beneficiary))) != null) {
            this.prmtBeneficiary.setData((Object)csInfo);
        }
    }

    class SelfComponents {
        CreditFinancingReduceCollection col;
        LetterOperateTypeEnum OperateStatus;

        SelfComponents() {
        }

        public void initSelfComponents() {
            this.col = null;
            this.OperateStatus = null;
        }
    }
}

