/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.client.AbstractLetterOfCreditFilterUI;
import com.kingdee.eas.fm.fin.client.LetterOfCreditFilterParam;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.nt.NTTypeCollection;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.NTTypeInfo;
import com.kingdee.eas.fm.nt.client.NTClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.sql.Date;
import java.util.Set;

public class LetterOfCreditFilterUI
extends AbstractLetterOfCreditFilterUI {
    public void onLoad() throws Exception {
        super.onLoad();
    }

    public Object getParam() {
        LetterOfCreditFilterParam filterParam = new LetterOfCreditFilterParam();
        if (!(this.kDComboBoxCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setCurrencyId(((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem()).getId().toString());
        } else {
            filterParam.setCurrencyId(null);
        }
        filterParam.setCompanyIdSet(this.getCompanyIdSet());
        filterParam.setBeginDate(DateTimeUtils.truncateDate((java.util.Date)this.dpBeginDate.getSqlDate()));
        filterParam.setEndDate(DateTimeUtils.truncateDate((java.util.Date)this.dpEndDate.getSqlDate()));
        if (this.comboBillType.getSelectedItem() instanceof FMSysDefinedEnum) {
            filterParam.setNtTypeId(null);
        } else {
            filterParam.setNtTypeId(((NTTypeInfo)this.comboBillType.getSelectedItem()).getId().toString());
        }
        Set gtSet = this.getIdSetFromF7(this.prmtGuaranteeType);
        if (gtSet.size() > 0) {
            filterParam.setGuaranteeTypeSet(gtSet);
        }
        return filterParam;
    }

    protected Class getParamClass() {
        return LetterOfCreditFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        LetterOfCreditFilterParam filterParam = (LetterOfCreditFilterParam)((Object)param);
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
        try {
            if (filterParam.getCurrencyId() != null) {
                CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId()));
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            }
            this.dpBeginDate.setValue((Object)filterParam.getBeginDate());
            this.dpEndDate.setValue((Object)filterParam.getEndDate());
            if (filterParam.getNtTypeId() != null) {
                this.comboBillType.setSelectedItem((Object)this.getBaseInfoFromId(filterParam.getNtTypeId()));
            } else {
                this.comboBillType.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
            this.prmtGuaranteeType.setData((Object)this.getBaseInfoFromIdSet(filterParam.getGuaranteeTypeSet()));
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    public void clear() {
        super.clear();
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
        this.prmtGuaranteeType.setData(null);
    }

    protected void init() throws Exception {
        super.init();
        CurrencyUtil.fillCombCurrency((KDComboBox)this.kDComboBoxCurrency);
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)currency);
            NTTypeCollection coll = NTClientHelper.getNTTypesBySuperGroup((NTTypeGroupEnum)NTTypeGroupEnum.ImportCredit);
            this.comboBillType.addItems(coll.toArray());
            this.comboBillType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            FMClientHelper.setSelectObject((KDComboBox)this.comboBillType, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurYear());
        this.dpEndDate.setValue((Object)DateUtil.getDayBegin());
        this.dpBeginDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
    }

    public boolean verify() {
        Date startDate = this.dpBeginDate.getSqlDate();
        Date endDate = this.dpEndDate.getSqlDate();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.client.LetterOfCreditResource", (String)"EndDateMustLaterBeginDate");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return false;
        }
        return super.verify();
    }
}

