/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.BasicFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.fin.LoanAdjustInterestCollection;
import com.kingdee.eas.fm.fin.LoanAdjustInterestFactory;
import com.kingdee.eas.fm.fin.LoanAdjustInterestInfo;
import com.kingdee.eas.fm.fin.LoanCollection;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.client.AbstractLoanAdjustInterestUI;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanAdjustInterestUI
extends AbstractLoanAdjustInterestUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanAdjustInterestUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.LoanOfResource";
    private CompanyOrgUnitInfo CURRENT_COMPANY = null;
    private EntityViewInfo evi = null;
    private FilterItemInfo currencyFilter = null;
    private FilterItemInfo groupLoanFilter = null;
    private FilterItemInfo creditorAsBankFilter = null;
    private FilterItemInfo creditorAsCompanyFilter = null;
    Map hm = new HashMap();
    private Set createdIntReceivedID;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.CURRENT_COMPANY = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        super.onLoad();
        this.dpAdjustDate.setSupportedEmpty(false);
        this.dpFirstRateAdjustDate.setSupportedEmpty(false);
        this.combIsGroupLoan.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.combIsGroupLoan, (Object)((Object)LoanPropertyEnum.OutGroup));
        this.contCreditorAsBank.setVisible(true);
        this.prmtCreditorAsBank.setEnabled(true);
        this.contCreditorAsCompany.setVisible(false);
        this.prmtCreditorAsCompany.setEnabled(false);
        this.txtYearDays.setHorizontalAlignment(4);
        this.txtYearDays.setValue((Object)new Integer(360));
        this.txtYearDays.setRequired(true);
        this.txtYearDays.setMinimumValue((Comparable)Constants.ZERO);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAdjustYieldRate);
        this.txtAdjustYieldRate.setPrecision(8);
        this.txtAdjustYieldRate.setValue((Object)Constants.ZERO);
        this.txtAdjustYieldRate.setRequired(true);
        this.txtAdjustYieldRate.setMinimumValue((Comparable)Constants.ZERO);
        FMClientHelper.initCurrencyField((BasicFormattedTextField)this.txtAdjustPenAccrualRate);
        this.txtAdjustPenAccrualRate.setPrecision(5);
        this.txtAdjustPenAccrualRate.setRequired(true);
        this.txtAdjustPenAccrualRate.setValue((Object)Constants.ZERO);
        this.txtAdjustPenAccrualRate.setMinimumValue((Comparable)Constants.ZERO);
        this.prmtCreditorAsBank.setEnabledMultiSelection(true);
        this.prmtCreditorAsCompany.setEnabledMultiSelection(true);
        this.comboRateTypeExpression.setRequired(true);
        this.comboPenAccrualType.setRequired(true);
        this.txtBasePoints.setValue((Object)Constants.ZERO);
        this.txtBasePoints.setRemoveingZeroInDispaly(false);
        this.txtBasePoints.setRemoveingZeroInEdit(true);
        this.txtBasePoints.setHorizontalAlignment(4);
        this.txtBasePoints.setMinimumValue((Comparable)Constants._ONE_HUNDRED);
        this.txtBasePoints.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
        this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
        this.txtRateAdjustPeriod.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRateAdjustPeriod.setHorizontalAlignment(4);
        CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)"dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC")));
        this.prmtCurrency.setData((Object)currencyInfo);
    }

    public void checkDate() throws Exception {
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        Date firstRateAdjustDate = this.dpFirstRateAdjustDate.getSqlDate();
        Date adjustDate = this.dpAdjustDate.getSqlDate();
        if (intRateModifyType.equals((Object)IntRateModifyType.LPR) && !this.isFixedInterest(intRateType) && adjustDate.getTime() > firstRateAdjustDate.getTime()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"349_LoanAdjustInterestEditUI"));
            SysUtil.abort();
        }
        if (!intRateModifyType.equals((Object)IntRateModifyType.Agreement) && EmptyUtil.isEmpty((CoreBaseInfo)intRateType)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"352_LoanAdjustInterestUI"));
            SysUtil.abort();
        }
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkDate();
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoan));
        HashMap<String, Object> addValueMap = new HashMap<String, Object>();
        addValueMap.put("rateModifyType", (Object)((IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem())));
        addValueMap.put("rateType", (IntRateTypeInfo)this.prmtIntRateType.getData());
        addValueMap.put("floatAction", (Object)((FloatActionEnum)((Object)this.combFloatAction.getSelectedItem())));
        addValueMap.put("basePoints", this.txtBasePoints.getBigDecimalValue());
        addValueMap.put("firstRateAjdust", this.dpFirstRateAdjustDate.getSqlDate());
        addValueMap.put("rateAdjustPeriod", this.txtRateAdjustPeriod.getText());
        if (ids != null && !ids.isEmpty()) {
            ids = LoanAdjustInterestFactory.getRemoteInstance().filterLoanIDSet(ids);
            this.hm = LoanAdjustInterestFactory.getRemoteInstance().batchAdjust(ids, this.dpAdjustDate.getSqlDate(), (IntRateTypeExpressionEnum)this.comboRateTypeExpression.getSelectedItem(), this.txtYearDays.getIntegerValue(), this.txtAdjustYieldRate.getBigDecimalValue(), (PenAccrualTypeEnum)this.comboPenAccrualType.getSelectedItem(), this.txtAdjustPenAccrualRate.getBigDecimalValue(), addValueMap);
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"269_BillNumberIsNull"));
            SysUtil.abort();
        }
        this.createdIntReceivedID = (Set)this.hm.get("createdIdSet");
        if (this.createdIntReceivedID == null || this.createdIntReceivedID.size() == 0) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"188_BondAdjustInterestUI"), (String)((StringBuffer)this.hm.get("errMsg")).toString(), (int)0);
            SysUtil.abort();
        } else if (this.createdIntReceivedID != null && this.createdIntReceivedID.size() > 0 && !EmptyUtil.isEmpty((String)((StringBuffer)this.hm.get("errMsg")).toString())) {
            MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"189_BondAdjustInterestUI"), (String)((StringBuffer)this.hm.get("errMsg")).toString(), (int)2);
            if (this.getUIContext().get("UIClassParam") != null) {
                // empty if block
            }
            this.disposeUIWindow();
        } else {
            if (this.getUIContext().get("UIClassParam") != null) {
                // empty if block
            }
            this.disposeUIWindow();
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        super.disposeUIWindow();
    }

    @Override
    protected void combIsGroupLoan_itemStateChanged(ItemEvent e) throws Exception {
        super.combIsGroupLoan_itemStateChanged(e);
        Object o = this.combIsGroupLoan.getSelectedItem();
        if (o instanceof LoanPropertyEnum) {
            LoanPropertyEnum loanProperty = (LoanPropertyEnum)((Object)o);
            this.prmtCreditorAsBank.setData(null);
            this.prmtCreditorAsCompany.setData(null);
            if (loanProperty.equals((Object)LoanPropertyEnum.OutGroup)) {
                this.contCreditorAsBank.setVisible(true);
                this.prmtCreditorAsBank.setEnabled(true);
                this.contCreditorAsCompany.setVisible(false);
                this.prmtCreditorAsCompany.setEnabled(false);
            } else if (loanProperty.equals((Object)LoanPropertyEnum.InGroup)) {
                this.contCreditorAsCompany.setVisible(true);
                this.prmtCreditorAsCompany.setEnabled(true);
                this.contCreditorAsBank.setVisible(false);
                this.prmtCreditorAsBank.setEnabled(false);
            }
        } else {
            this.contCreditorAsBank.setVisible(true);
            this.prmtCreditorAsBank.setEnabled(false);
            this.contCreditorAsCompany.setVisible(false);
            this.prmtCreditorAsCompany.setEnabled(false);
        }
    }

    protected EntityViewInfo getLoanFilter() {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        String companyId = this.CURRENT_COMPANY.getId().toString();
        evi.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("IntRateType.id", (Object)"lJlpCQEQEADgAAc+wKgSjiR9knQ="));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("entLoanID.id", null));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(0), CompareType.NOTEQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isLPR", (Object)Boolean.FALSE));
        Object loanPropertyObj = this.combIsGroupLoan.getSelectedItem();
        if (loanPropertyObj instanceof LoanPropertyEnum) {
            LoanPropertyEnum loanProperty = (LoanPropertyEnum)((Object)loanPropertyObj);
            Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCreditorAsBank));
            if (loanProperty.equals((Object)LoanPropertyEnum.OutGroup)) {
                this.groupLoanFilter = new FilterItemInfo("isGroupLoan", (Object)Boolean.FALSE);
                evi.getFilter().getFilterItems().add(this.groupLoanFilter);
                if (ids != null && !ids.isEmpty()) {
                    this.creditorAsBankFilter = new FilterItemInfo("institution.id", (Object)ids, CompareType.INCLUDE);
                    evi.getFilter().getFilterItems().add(this.creditorAsBankFilter);
                }
            } else if (loanProperty.equals((Object)LoanPropertyEnum.InGroup)) {
                this.groupLoanFilter = new FilterItemInfo("isGroupLoan", (Object)Boolean.TRUE);
                evi.getFilter().getFilterItems().add(this.groupLoanFilter);
                if (ids != null && !ids.isEmpty()) {
                    this.creditorAsCompanyFilter = new FilterItemInfo("GroupID.id", (Object)ids, CompareType.INCLUDE);
                    evi.getFilter().getFilterItems().add(this.creditorAsCompanyFilter);
                }
            }
        }
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isLPR", (Object)Boolean.FALSE));
        Set currencyIds = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
        if (!EmptyUtil.isEmpty((Collection)currencyIds)) {
            this.currencyFilter = new FilterItemInfo("currency.id", (Object)currencyIds, CompareType.INCLUDE);
            evi.getFilter().getFilterItems().add(this.currencyFilter);
        }
        return evi;
    }

    public static Map showLoanAdjustInterestUI(CoreUI ui) {
        Map returnValue = new HashMap();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(LoanAdjustInterestUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((LoanAdjustInterestUI)uiWindow.getUIObject()).getReturnValueWithMsg();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        Set id = (Set)returnValue.get("createdIdSet");
        if (id == null) {
            SysUtil.abort();
        }
        if (id.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"270_LoanAdjustInterestUI"));
        } else {
            String msg = (String)returnValue.get("failureMsg");
            if (msg != null && msg.length() > 0) {
                MsgBox.showInfo((String)msg);
                Object var3_4 = null;
            }
        }
        return returnValue;
    }

    private Map getReturnValueWithMsg() {
        return this.hm;
    }

    @Override
    protected void comboRateTypeExpression_itemStateChanged(ItemEvent e) throws Exception {
        super.comboRateTypeExpression_itemStateChanged(e);
        IntRateTypeExpressionEnum intRateType = (IntRateTypeExpressionEnum)this.comboRateTypeExpression.getSelectedItem();
        if (intRateType.equals((Object)IntRateTypeExpressionEnum.YEAR)) {
            this.kDLabel1.setText("%");
            this.kDLabel3.setText("%");
            this.txtYearDays.setValue((Object)new Integer(360));
        } else if (intRateType.equals((Object)IntRateTypeExpressionEnum.MONTH)) {
            this.kDLabel1.setText("\u2030");
            this.kDLabel3.setText("\u2030");
            this.txtYearDays.setValue((Object)new Integer(30));
        } else if (intRateType.equals((Object)IntRateTypeExpressionEnum.DAY)) {
            this.kDLabel1.setText("\u2030");
            this.kDLabel3.setText("\u2030");
            this.txtYearDays.setValue((Object)new Integer(1));
        }
    }

    @Override
    protected void comboPenAccrualType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboPenAccrualType_itemStateChanged(e);
        PenAccrualTypeEnum penType = (PenAccrualTypeEnum)this.comboPenAccrualType.getSelectedItem();
        if (penType.equals((Object)PenAccrualTypeEnum.ADD_PERCENT)) {
            this.kDLabel2.setText("%");
        } else if (penType.equals((Object)PenAccrualTypeEnum.ADD_ACCRUAL)) {
            this.kDLabel2.setText("\u2030");
        }
    }

    @Override
    protected void prmtCreditorAsBank_willCommit(CommitEvent e) throws Exception {
        super.prmtCreditorAsBank_willCommit(e);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtCreditorAsBank.setEntityViewInfo(evi);
        this.prmtCreditorAsBank.getQueryAgent().resetRuntimeEntityView();
    }

    @Override
    protected void prmtCreditorAsBank_willShow(SelectorEvent e) throws Exception {
        super.prmtCreditorAsBank_willShow(e);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        this.prmtCreditorAsBank.setEntityViewInfo(evi);
        this.prmtCreditorAsBank.getQueryAgent().resetRuntimeEntityView();
    }

    private void prmtHide(boolean isHide) {
        if (isHide) {
            this.kDLabelContainer7.setBounds(new Rectangle(10, 141, 270, 19));
            super.add((Component)this.kDLabelContainer7, null);
            this.kDLabelContainer8.setBounds(new Rectangle(10, 163, 270, 19));
            super.add((Component)this.kDLabelContainer8, null);
            this.kDLabelContainer9.setBounds(new Rectangle(10, 185, 270, 19));
            super.add((Component)this.kDLabelContainer9, null);
            this.kDLabel1.setBounds(new Rectangle(264, 185, 20, 19));
            super.add((Component)this.kDLabel1, null);
            this.kDLabelContainer3.setBounds(new Rectangle(10, 207, 270, 19));
            super.add((Component)this.kDLabelContainer3, null);
            this.kDLabelContainer4.setBounds(new Rectangle(10, 229, 270, 19));
            super.add((Component)this.kDLabelContainer4, null);
            this.kDLabel2.setBounds(new Rectangle(264, 229, 20, 19));
            super.add((Component)this.kDLabel2, null);
        } else {
            this.kDLabelContainer7.setBounds(new Rectangle(10, 252, 270, 19));
            super.add((Component)this.kDLabelContainer7, null);
            this.kDLabelContainer8.setBounds(new Rectangle(10, 274, 270, 19));
            super.add((Component)this.kDLabelContainer8, null);
            this.kDLabelContainer9.setBounds(new Rectangle(10, 294, 247, 19));
            super.add((Component)this.kDLabelContainer9, null);
            this.kDLabel1.setBounds(new Rectangle(264, 297, 20, 19));
            super.add((Component)this.kDLabel1, null);
            this.kDLabelContainer3.setBounds(new Rectangle(10, 316, 270, 19));
            super.add((Component)this.kDLabelContainer3, null);
            this.kDLabelContainer4.setBounds(new Rectangle(10, 338, 247, 19));
            super.add((Component)this.kDLabelContainer4, null);
            this.kDLabel2.setBounds(new Rectangle(264, 342, 20, 19));
            super.add((Component)this.kDLabel2, null);
        }
    }

    @Override
    protected void combModifyRateType_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        this.prmtLoan.setData(null);
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType)) {
            this.setAgreementLayout();
        } else if (IntRateModifyType.LPR.equals((Object)intRateModifyType)) {
            this.setLPRLayout(intRateType);
        } else if (IntRateModifyType.LPR_Adjustment.equals((Object)intRateModifyType)) {
            this.setLPRAdjustLayout();
        }
    }

    private void setLPRAdjustLayout() {
        this.prmtHide(false);
        this.kDLabel3.setVisible(true);
        this.kDLabel1.setVisible(true);
        this.contIntRateType.setVisible(true);
        this.prmtIntRateType.setRequired(true);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
        evi.setFilter(filter);
        this.prmtIntRateType.setEntityViewInfo(evi);
        this.prmtIntRateType.getEntityViewInfo().getFilter();
        this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
        this.contFloatAction.setVisible(true);
        this.combFloatAction.setEnabled(false);
        this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
        this.contBasePoints.setVisible(true);
        this.txtBasePoints.setRequired(true);
        this.txtBasePoints.setValue((Object)Constants.ZERO);
        this.contFirstRateAdjustDate.setVisible(true);
        this.dpFirstRateAdjustDate.setValue((Object)this.dpAdjustDate.getSqlDate());
        this.dpFirstRateAdjustDate.setEnabled(false);
        this.contRateAdjustPeriod.setVisible(true);
        this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
        this.contMonth.setVisible(true);
        this.comboRateTypeExpression.setEnabled(false);
    }

    private void setLPRLayout(IntRateTypeInfo intRateType) {
        this.prmtHide(false);
        this.kDLabel3.setVisible(true);
        this.kDLabel1.setVisible(true);
        this.contIntRateType.setVisible(true);
        this.prmtIntRateType.setRequired(true);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"QYYAAAAKQTYkfZJ0", CompareType.EQUALS));
        filter.setMaskString("(#0 and #1) or #2");
        evi.setFilter(filter);
        this.prmtIntRateType.setEntityViewInfo(evi);
        this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
        if (this.isFixedInterest(intRateType)) {
            this.txtYearDays.setEnabled(false);
            this.contBasePoints.setVisible(true);
            this.comboRateTypeExpression.setEnabled(false);
        } else {
            this.contFloatAction.setVisible(true);
            this.combFloatAction.setEnabled(false);
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
            this.contBasePoints.setVisible(true);
            this.txtBasePoints.setRequired(true);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(true);
            this.dpFirstRateAdjustDate.setValue((Object)this.dpAdjustDate.getSqlDate());
            this.dpFirstRateAdjustDate.setEnabled(true);
            this.contRateAdjustPeriod.setVisible(true);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(true);
            this.comboRateTypeExpression.setEnabled(false);
        }
    }

    private void setAgreementLayout() {
        this.contIntRateType.setVisible(false);
        this.prmtIntRateType.setRequired(false);
        this.prmtIntRateType.setData(null);
        this.contFloatAction.setVisible(false);
        this.combFloatAction.setSelectedItem(null);
        this.contBasePoints.setVisible(false);
        this.txtBasePoints.setText(null);
        this.contFirstRateAdjustDate.setVisible(false);
        this.dpFirstRateAdjustDate.setValue(null);
        this.contRateAdjustPeriod.setVisible(false);
        this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
        this.contMonth.setVisible(false);
        this.comboRateTypeExpression.setEnabled(true);
        this.comboRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
        this.txtYearDays.setEnabled(true);
        this.txtYearDays.setText("360");
        this.txtAdjustYieldRate.setEnabled(true);
        this.txtAdjustYieldRate.setValue((Object)Constants.ZERO);
        this.prmtHide(true);
        this.kDLabel3.setVisible(false);
        this.kDLabel1.setVisible(false);
    }

    @Override
    protected void prmtIntRateType_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType) || this.isFixedInterest(intRateType)) {
            this.contFloatAction.setVisible(false);
            this.combFloatAction.setSelectedIndex(-1);
            this.comboRateTypeExpression.setEnabled(true);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtAdjustYieldRate.setEnabled(true);
            this.txtAdjustYieldRate.setValue((Object)Constants.ZERO);
            this.contBasePoints.setVisible(false);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.kDLabel3.setVisible(false);
            this.contFirstRateAdjustDate.setVisible(false);
            this.dpFirstRateAdjustDate.setValue(null);
            this.contRateAdjustPeriod.setVisible(false);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(false);
        } else if ((IntRateModifyType.LPR.equals((Object)intRateModifyType) || IntRateModifyType.LPR_Adjustment.equals((Object)intRateModifyType)) && !this.isFixedInterest(intRateType)) {
            this.contFloatAction.setVisible(true);
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
            this.combFloatAction.setEnabled(false);
            this.contBasePoints.setVisible(true);
            this.kDLabel3.setVisible(true);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(true);
            this.dpFirstRateAdjustDate.setValue((Object)this.dpAdjustDate.getSqlDate());
            this.contRateAdjustPeriod.setVisible(true);
            this.txtRateAdjustPeriod.setValue((Object)FinHelper.ZERO_INT);
            this.contMonth.setVisible(true);
            this.comboRateTypeExpression.setEnabled(false);
            this.txtYearDays.setEnabled(false);
            this.txtAdjustYieldRate.setEnabled(false);
            this.txtAdjustYieldRate.setValue((Object)this.getYieldRate(intRateType, (FloatActionEnum)((Object)this.combFloatAction.getSelectedItem())));
            if (intRateType != null) {
                int intRate = intRateType.getFactorDay();
                String RateExpreValue = intRateType.getRateExpression().getValue();
                if (RateExpreValue.equals("year")) {
                    this.comboRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
                    this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
                } else if (RateExpreValue.equals("month")) {
                    this.comboRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.MONTH);
                    this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                } else {
                    this.comboRateTypeExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.DAY);
                    this.txtAdjustYieldRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                }
                this.txtYearDays.setValue((Object)new Integer(intRate));
            }
        }
    }

    @Override
    protected void txtBasePoints_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
        if ((IntRateModifyType.LPR.equals((Object)intRateModifyType) || IntRateModifyType.LPR_Adjustment.equals((Object)intRateModifyType)) && !this.isFixedInterest(intRateType)) {
            BigDecimal yieldRate = this.getYieldRate(intRateType, (FloatActionEnum)((Object)this.combFloatAction.getSelectedItem()));
            this.txtAdjustYieldRate.setValue((Object)yieldRate);
            this.txtAdjustYieldRate.setEnabled(false);
        }
    }

    @Override
    protected void prmtIntRateType_willShow(SelectorEvent e) throws Exception {
        if (this.combModifyRateType.getSelectedItem() != null) {
            IntRateModifyType intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem());
            if (intRateModifyType.equals((Object)IntRateModifyType.LPR)) {
                FilterInfo filter = new FilterInfo();
                EntityViewInfo evi = new EntityViewInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)1, CompareType.EQUALS));
                evi.setFilter(filter);
                this.prmtIntRateType.setEntityViewInfo(evi);
                this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            } else if (intRateModifyType.equals((Object)IntRateModifyType.LPR_Adjustment)) {
                FilterInfo filter = new FilterInfo();
                EntityViewInfo evi = new EntityViewInfo();
                filter.getFilterItems().add(new FilterItemInfo("isLPR", (Object)Boolean.TRUE));
                evi.setFilter(filter);
                this.prmtIntRateType.setEntityViewInfo(evi);
                this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            }
        }
    }

    private BigDecimal getYieldRate(IntRateTypeInfo intRateType, FloatActionEnum floatAction) throws BOSException, EASBizException {
        CurrencyInfo baseCurrency = (CurrencyInfo)this.prmtCurrency.getData();
        java.util.Date date = DateTimeUtils.truncateDate((java.util.Date)this.dpAdjustDate.getSqlDate());
        BigDecimal bdBP = this.txtBasePoints.getBigDecimalValue();
        if (baseCurrency != null && intRateType != null && date != null && bdBP != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), baseCurrency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            BigDecimal bdYieldRate = Constants.ZERO;
            bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(bdBP.divide(Constants.ONE_HUNDRED, 10, 4))) : bdBaseRate.add(bdBP);
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.txtBasePoints.requestFocus();
                SysUtil.abort();
            }
            return bdYieldRate;
        }
        return Constants.ZERO;
    }

    @Override
    protected void prmtLoan_willShow(SelectorEvent e) throws Exception {
        IntRateModifyType intRateModifyType;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String companyId = this.CURRENT_COMPANY.getId().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        Set currencyIds = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
        if (!EmptyUtil.isEmpty((Collection)currencyIds)) {
            this.currencyFilter = new FilterItemInfo("currency.id", (Object)currencyIds, CompareType.INCLUDE);
            filterInfo.getFilterItems().add(this.currencyFilter);
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("balance", (Object)Constants.ZERO, CompareType.GREATER));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(0), CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(3)));
        filterInfo.getFilterItems().add(new FilterItemInfo("entLoanID.id", null));
        boolean hasInstitutionOrGroup = false;
        Object loanPropertyObj = this.combIsGroupLoan.getSelectedItem();
        if (loanPropertyObj instanceof LoanPropertyEnum) {
            Set ids;
            LoanPropertyEnum loanProperty = (LoanPropertyEnum)((Object)loanPropertyObj);
            if (loanProperty.equals((Object)LoanPropertyEnum.OutGroup)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("isGroupLoan", (Object)Boolean.FALSE));
                ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCreditorAsBank));
                if (ids != null && !ids.isEmpty()) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("Institution.id", (Object)ids, CompareType.INCLUDE));
                    hasInstitutionOrGroup = true;
                }
            } else if (loanProperty.equals((Object)LoanPropertyEnum.InGroup)) {
                filterInfo.getFilterItems().add(new FilterItemInfo("isGroupLoan", (Object)Boolean.TRUE));
                ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCreditorAsCompany));
                if (ids != null && !ids.isEmpty()) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("GroupID.id", (Object)ids, CompareType.INCLUDE));
                    hasInstitutionOrGroup = true;
                }
            }
        }
        if (IntRateModifyType.Agreement.equals((Object)(intRateModifyType = (IntRateModifyType)((Object)this.combModifyRateType.getSelectedItem())))) {
            filterInfo.getFilterItems().add(new FilterItemInfo("IntRateType.id", (Object)"lJlpCQEQEADgAAc+wKgSjiR9knQ="));
        }
        if (IntRateModifyType.LPR_Adjustment.equals((Object)intRateModifyType)) {
            Set<String> loanIdSet = this.getAdjustedLoanIds(filterInfo);
            filterInfo.getFilterItems().add(new FilterItemInfo("IntRateType.isLPR", (Object)Boolean.TRUE));
            filterInfo.getFilterItems().add(new FilterItemInfo("floatAction", (Object)0));
            if (loanIdSet.size() > 0) {
                filterInfo.getFilterItems().add(new FilterItemInfo("id", loanIdSet, CompareType.INCLUDE));
                this.addMaskString(filterInfo);
            }
        } else if (IntRateModifyType.LPR.equals((Object)intRateModifyType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isLPR", (Object)Boolean.FALSE));
            filterInfo.getFilterItems().add(new FilterItemInfo("IntRateType.isLPR", (Object)Boolean.FALSE));
            filterInfo.getFilterItems().add(new FilterItemInfo("IntRateType.isLPR", null));
            filterInfo.getFilterItems().add(new FilterItemInfo("floatAction", (Object)0, CompareType.NOTEQUALS));
            this.addMaskStringLPR(filterInfo);
        } else if (IntRateModifyType.Agreement.equals((Object)intRateModifyType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isLPR", (Object)Boolean.FALSE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("isBonds", (Object)Boolean.FALSE));
        evi.setFilter(filterInfo);
        this.prmtLoan.setEntityViewInfo(evi);
        this.prmtLoan.getQueryAgent().resetRuntimeEntityView();
    }

    private void addMaskStringLPR(FilterInfo filterInfo) {
        if (filterInfo.getFilterItems().size() > 0) {
            StringBuffer mask = new StringBuffer().append("(");
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                mask.append("#" + i);
                if (i < filterInfo.getFilterItems().size() - 4) {
                    mask.append(" and ");
                }
                if (i == filterInfo.getFilterItems().size() - 4) {
                    mask.append(" and (");
                }
                if (i == filterInfo.getFilterItems().size() - 3 || i == filterInfo.getFilterItems().size() - 2) {
                    mask.append(" or ");
                }
                if (i != filterInfo.getFilterItems().size() - 1) continue;
                mask.append(" ))");
            }
            filterInfo.setMaskString(mask.toString());
        }
    }

    private void addMaskString(FilterInfo filterInfo) {
        if (filterInfo.getFilterItems().size() > 0) {
            StringBuffer mask = new StringBuffer().append("(");
            for (int i = 0; i < filterInfo.getFilterItems().size(); ++i) {
                mask.append("#" + i);
                if (i < filterInfo.getFilterItems().size() - 2) {
                    mask.append(" and ");
                }
                if (i != filterInfo.getFilterItems().size() - 2) continue;
                mask.append(" ) or ");
            }
            filterInfo.setMaskString(mask.toString());
        }
    }

    private Set<String> getOriginLPRLoanIdSet() throws BOSException {
        HashSet<String> loanIdSet = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IntRateType.isLPR", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("floatAction", (Object)0));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        LoanCollection coll = LoanFactory.getRemoteInstance().getLoanCollection(evi);
        if (coll.size() > 0) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                LoanInfo info = (LoanInfo)it.next();
                loanIdSet.add(info.getId().toString());
            }
        }
        return loanIdSet;
    }

    private boolean isFixedInterest(IntRateTypeInfo intRateType) {
        if (intRateType == null) {
            return false;
        }
        return intRateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }

    private Set<String> getAdjustedLoanIds(FilterInfo filterOfLoan) throws BOSException {
        HashSet<String> loanIds = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("IntRateType.isLPR", (Object)Boolean.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("floatAction", (Object)0));
        filter.getFilterItems().add(new FilterItemInfo("modifyRateType", (Object)"1"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("loan"));
        LoanAdjustInterestCollection coll = LoanAdjustInterestFactory.getRemoteInstance().getLoanAdjustInterestCollection(evi);
        if (coll.size() > 0) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                LoanAdjustInterestInfo adjInfo = (LoanAdjustInterestInfo)it.next();
                if (adjInfo.getLoan() == null) continue;
                loanIds.add(adjInfo.getLoan().getId().toString());
            }
            EntityViewInfo evi4Loan = new EntityViewInfo();
            FilterInfo filter4Loan = (FilterInfo)filterOfLoan.clone();
            filter4Loan.getFilterItems().add(new FilterItemInfo("id", loanIds, CompareType.INCLUDE));
            evi4Loan.setFilter(filter4Loan);
            LoanCollection loanColl = LoanFactory.getRemoteInstance().getLoanCollection(evi4Loan);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)loanColl)) {
                loanIds.clear();
                Iterator it2 = loanColl.iterator();
                while (it2.hasNext()) {
                    LoanInfo info = (LoanInfo)it2.next();
                    loanIds.add(info.getId().toString());
                }
            } else {
                return new HashSet<String>();
            }
        }
        return loanIds;
    }

    @Override
    protected void dpAdjustDate_dataChanged(DataChangeEvent e) throws Exception {
        if (IntRateModifyType.LPR_Adjustment.equals(this.combModifyRateType.getSelectedItem())) {
            this.dpFirstRateAdjustDate.setValue(this.dpAdjustDate.getValue());
        }
    }
}

