/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.fin.FinBillStatusEnum;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.client.AbstractLoanFilterUI;
import com.kingdee.eas.fm.fin.client.LoanFilterParam;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class LoanFilterUI
extends AbstractLoanFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(LoanFilterUI.class);
    CompanyOrgUnitInfo companyInfo;
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    public Object getParam() {
        Set gtSet;
        Set fpSet;
        Set cgSet;
        LoanFilterParam filterParam = new LoanFilterParam();
        if (!(this.kDComboBoxCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setCurrencyId(((CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem()).getId().toString());
        } else {
            filterParam.setCurrencyId(null);
        }
        if (!(this.kDComboBoxStatus.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setStatus((FinBillStatusEnum)((Object)this.kDComboBoxStatus.getSelectedItem()));
        } else {
            filterParam.setStatus(null);
        }
        Set cmpSet = this.getCompanyIdSet();
        if (cmpSet != null && cmpSet.size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.dpIssueDate.getSqlDate() != null) {
            filterParam.setIssueDate(DateTimeUtils.truncateDate((Date)this.dpIssueDate.getSqlDate()));
        }
        if (this.dpExpiredDate.getSqlDate() != null) {
            filterParam.setExpiredDate(DateTimeUtils.truncateDate((Date)this.dpExpiredDate.getSqlDate()));
        }
        if ((cgSet = this.getIdSetFromF7(this.prmtCreditorGroup)) != null && cgSet.size() > 0) {
            filterParam.setFinGroupSet(cgSet);
        }
        if ((fpSet = this.getIdSetFromF7(this.prmtFinProduct)) != null && fpSet.size() > 0) {
            filterParam.setFinProductSet(fpSet);
        }
        if ((gtSet = this.getIdSetFromF7(this.prmtGaranteeType)) != null && gtSet.size() > 0) {
            filterParam.setGtSet(gtSet);
        }
        filterParam.setViewZero(this.isViewZero.isSelected());
        Set loanerSet = this.getIdSetFromF7(this.prmtLoaner);
        if (loanerSet != null && loanerSet.size() > 0) {
            filterParam.setLoanerSet(loanerSet);
        }
        if (!(this.comboLoanerType.getSelectedItem() instanceof FMSysDefinedEnum)) {
            LoanPropertyEnum type = (LoanPropertyEnum)((Object)this.comboLoanerType.getSelectedItem());
            if (type != null) {
                filterParam.setLoanerProperty(type);
            }
        } else {
            filterParam.setLoanerProperty(null);
        }
        return filterParam;
    }

    protected Class getParamClass() {
        return LoanFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return false;
    }

    public void setParam(Object param) {
        LoanFilterParam filterParam;
        block13: {
            if (param == null) {
                return;
            }
            filterParam = (LoanFilterParam)((Object)param);
            this.setCompanyIdSet(filterParam.getCompanyIdSet());
            if (filterParam.getCurrencyId() != null) {
                try {
                    if (filterParam.getCurrencyId() != null) {
                        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(filterParam.getCurrencyId()));
                        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
                        break block13;
                    }
                    FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                this.kDComboBoxCurrency.setSelectedIndex(this.kDComboBoxCurrency.getItemCount() - 1);
            }
        }
        if (filterParam.getStatus() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxStatus, (Object)((Object)filterParam.getStatus()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxStatus, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        this.dpIssueDate.setValue((Object)filterParam.getIssueDate());
        this.dpExpiredDate.setValue((Object)filterParam.getExpiredDate());
        if (filterParam.getLoanerProperty() != null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboLoanerType, (Object)((Object)filterParam.getLoanerProperty()));
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboLoanerType, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        try {
            this.prmtFinProduct.setData((Object)this.getBaseInfoFromIdSet(filterParam.getFinProductSet()));
            this.prmtGaranteeType.setData((Object)this.getBaseInfoFromIdSet(filterParam.getGtSet()));
            this.prmtLoaner.setData((Object)this.getBaseInfoFromIdSet(filterParam.getLoanerSet()));
            this.prmtCreditorGroup.setData((Object)this.getBaseInfoFromIdSet(filterParam.getFinGroupSet()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.isViewZero.setSelected(filterParam.isViewZero());
    }

    public void clear() {
        super.clear();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxStatus, (Object)FMSysDefinedEnum.SELECT_ALL);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.dpIssueDate.setValue((Object)cal.getTime());
        this.dpExpiredDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.prmtCreditorGroup.setData(null);
        this.prmtFinProduct.setData(null);
        this.prmtGaranteeType.setData(null);
    }

    protected void init() throws Exception {
        super.init();
        this.comboLoanerType.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        CurrencyUtil.fillCombCurrency((KDComboBox)this.kDComboBoxCurrency);
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
        FinHelper.fillCombBillStatus(this.kDComboBoxStatus);
        this.kDComboBoxStatus.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxStatus, (Object)FMSysDefinedEnum.SELECT_ALL);
        FinUtils.setFinProductF7(this.prmtFinProduct, FinancingBillTypeEnum.Loan);
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2000);
        cal.set(2, 0);
        cal.set(5, 1);
        this.dpIssueDate.setValue((Object)cal.getTime());
        this.dpExpiredDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.prmtLoaner.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7BankQuery");
        F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtLoaner);
        this.prmtLoaner.setValue(null);
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpIssueDate);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.dpExpiredDate);
        if (DateTimeUtils.truncateDate((Date)((Date)this.dpIssueDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dpExpiredDate.getValue())))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LoanEndDateLaterThanBeginDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    @Override
    protected void comboLoanerType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboLoanerType_itemStateChanged(e);
        this.prmtLoaner.setValue(null);
        if (FMSysDefinedEnum.SELECT_ALL == this.comboLoanerType.getSelectedItem()) {
            this.prmtLoaner.setEnabled(false);
        } else {
            this.prmtLoaner.setEnabled(true);
        }
        this.initPrmtLoaner();
    }

    @Override
    protected void prmtLoaner_willCommit(CommitEvent e) throws Exception {
        super.prmtLoaner_willCommit(e);
    }

    @Override
    protected void prmtLoaner_willShow(SelectorEvent e) throws Exception {
        super.prmtLoaner_willShow(e);
    }

    private void initPrmtLoaner() throws Exception {
        LoanPropertyEnum type;
        if (!(this.comboLoanerType.getSelectedItem() instanceof FMSysDefinedEnum) && (type = (LoanPropertyEnum)((Object)this.comboLoanerType.getSelectedItem())) != null) {
            this.prmtLoaner.getQueryAgent().resetRuntimeEntityView();
            if (LoanPropertyEnum.InGroup.equals((Object)type)) {
                F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtLoaner, (boolean)true);
            } else if (LoanPropertyEnum.OutGroup.equals((Object)type)) {
                F7SelectorFactory.initBankTree((IUIObject)this, (KDBizPromptBox)this.prmtLoaner);
            }
        }
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.prmtFinProduct.setData(null);
        this.prmtCreditorGroup.setData(null);
        this.prmtGaranteeType.setData(null);
        this.comboLoanerType.setSelectedIndex(0);
        this.prmtLoaner.setData(null);
        this.isViewZero.setSelected(false);
    }
}

