/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fin.FromBillType;
import com.kingdee.eas.fm.fin.LoanRepayStatusEnum;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyFactory;
import com.kingdee.eas.fm.fin.LoanRepaymentApplyInfo;
import com.kingdee.eas.fm.fin.client.AbstractLoanRepaymentApplyListUI;
import com.kingdee.eas.fm.fin.client.LoanRepayApplyFilterUI;
import com.kingdee.eas.fm.fin.client.LoanRepaymentApplyEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.CommonDataProvider;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoanRepaymentApplyListUI
extends AbstractLoanRepaymentApplyListUI {
    private static final String RESOURCE_PATH = "com.kingdee.eas.fm.fin.client.LoanRepayResource";
    private LoanRepayApplyFilterUI filterUI;
    private static final Logger logger = CoreUIObject.getLogger(LoanRepaymentApplyListUI.class);
    FillListener fillListener = new FillListener();
    private static final String tdTemplateFile = "/FM/FIN/LOANREPAYMENTAPPLY";

    public void onLoad() throws Exception {
        super.onLoad();
        this.actionCopyTo.setVisible(false);
        this.btnTDPrint.setEnabled(true);
        this.btnTDPrintPreview.setEnabled(true);
        this.menuItemTDPrint.setEnabled(true);
        this.menuItemTDPrintPreview.setEnabled(true);
        this.tblMain.getColumn("lastSettleDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("auditDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("applyDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("repayDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("createTime").getStyleAttributes().setNumberFormat(this.timeFormat);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionQueryScheme_actionPerformed(ActionEvent e) throws Exception {
        super.actionQueryScheme_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        this.checkCreateTo();
        super.actionCreateTo_actionPerformed(e);
    }

    private void checkCreateTo() {
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        int rowNum = this.tblMain.getSelectManager().get().getTop();
        ICell cellStatus = this.tblMain.getRow(rowNum).getCell("status");
        if (cellStatus.getValue() != null && !LoanRepayStatusEnum.AUDITED.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError"));
            SysUtil.abort();
        }
        String id = this.getSelectedKeyValue();
        LoanRepaymentApplyInfo loanRepaymentApplyInfo = new LoanRepaymentApplyInfo();
        try {
            loanRepaymentApplyInfo = LoanRepaymentApplyFactory.getRemoteInstance().getLoanRepaymentApplyInfo((IObjectPK)new ObjectUuidPK(id));
            if (loanRepaymentApplyInfo.getStatus() != LoanRepayStatusEnum.AUDITED && loanRepaymentApplyInfo.getSourceBillType() != FromBillType.Loan) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError"));
                SysUtil.abort();
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyTo_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionWorkFlowG_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkFlowG_actionPerformed(e);
    }

    public void actionSendSmsMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendSmsMessage_actionPerformed(e);
    }

    public void actionSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actionSignature_actionPerformed(e);
    }

    public void actionWorkflowList_actionPerformed(ActionEvent e) throws Exception {
        super.actionWorkflowList_actionPerformed(e);
    }

    public void actoinViewSignature_actionPerformed(ActionEvent e) throws Exception {
        super.actoinViewSignature_actionPerformed(e);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return LoanRepaymentApplyFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectValue createNewData() {
        LoanRepaymentApplyInfo objectValue = new LoanRepaymentApplyInfo();
        return objectValue;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new LoanRepayApplyFilterUI();
        }
        return this.filterUI;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkAntiAudit();
            HashSet IDs = new HashSet(this.getSelectedIdValues());
            LoanRepaymentApplyFactory.getRemoteInstance().batchAntiAudit(IDs);
        }
        catch (Exception ex) {
            if (ex instanceof AbortException) {
                logger.debug((Object)ex.getMessage());
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        this.refreshList();
    }

    private void checkAntiAudit() throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            this.checkAntiAudited(rowNum);
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    this.checkAntiAudited(j);
                }
            }
        }
    }

    private void checkAntiAudited(int rowNum) throws BOSException, EASBizException {
        ICell IdCell = this.tblMain.getRow(rowNum).getCell("id");
        LoanRepaymentApplyInfo loanRepaymentApplyInfo = LoanRepaymentApplyFactory.getRemoteInstance().getLoanRepaymentApplyInfo((IObjectPK)new ObjectUuidPK(IdCell.getValue().toString()));
        if (loanRepaymentApplyInfo == null || loanRepaymentApplyInfo.getStatus() == null || loanRepaymentApplyInfo.getStatus().getName() == null || !LoanRepayStatusEnum.AUDITED.getName().equalsIgnoreCase(loanRepaymentApplyInfo.getStatus().getName())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError"));
            SysUtil.abort();
        }
        if (loanRepaymentApplyInfo.isIsCreateRepayBill()) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"unAuditError_hasCreate"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.checkAudit();
            HashSet IDs = new HashSet(this.getSelectedIdValues());
            boolean idsInProcess = FMHelper.hasWFInstance(null, (List)this.getSelectedIdValues());
            if (idsInProcess) {
                this.actionMultiapprove_actionPerformed(e);
                return;
            }
            LoanRepaymentApplyFactory.getRemoteInstance().batchAudit(IDs);
        }
        catch (Exception ex) {
            if (ex instanceof AbortException) {
                logger.debug((Object)ex.getMessage());
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)ex.getMessage());
            }
            SysUtil.abort((Throwable)ex);
        }
        this.refreshList();
    }

    private void checkAudit() throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cell = this.tblMain.getRow(rowNum).getCell("id");
            this.checkAudited(cell);
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ICell cell = this.tblMain.getRow(j).getCell("id");
                    this.checkAudited(cell);
                }
            }
        }
    }

    private void checkAudited(ICell cell) throws BOSException, EASBizException {
        LoanRepaymentApplyInfo loanRepaymentApplyInfo = LoanRepaymentApplyFactory.getRemoteInstance().getLoanRepaymentApplyInfo((IObjectPK)new ObjectUuidPK(cell.getValue().toString()));
        if (loanRepaymentApplyInfo == null || loanRepaymentApplyInfo.getStatus() == null || loanRepaymentApplyInfo.getStatus().getName() == null || LoanRepayStatusEnum.SAVE.getName().equalsIgnoreCase(loanRepaymentApplyInfo.getStatus().getName())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"auditError"));
            SysUtil.abort();
        } else if (LoanRepayStatusEnum.AUDITED.getName().equalsIgnoreCase(loanRepaymentApplyInfo.getStatus().getName())) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"auditedError"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return super.getSelectors();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cellStatus = this.tblMain.getRow(rowNum).getCell("status");
            if (cellStatus.getValue() != null && LoanRepayStatusEnum.AUDITED.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"removeError"));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ICell cellStatus = this.tblMain.getRow(j).getCell("status");
                    if (cellStatus.getValue() == null || !LoanRepayStatusEnum.AUDITED.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"removeError"));
                    SysUtil.abort();
                }
            }
        }
        super.actionRemove_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock selectBlock = null;
        int size = this.tblMain.getSelectManager().size();
        if (size == 0 || this.tblMain.getSelectManager().getActiveRowIndex() < 0) {
            return;
        }
        if (size == 1 && this.tblMain.getSelectManager().get().getTop() == this.tblMain.getSelectManager().get().getBottom()) {
            int rowNum = this.tblMain.getSelectManager().get().getTop();
            ICell cellStatus = this.tblMain.getRow(rowNum).getCell("status");
            if (cellStatus.getValue() != null && LoanRepayStatusEnum.AUDITED.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) {
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"editError"));
                SysUtil.abort();
            }
        } else {
            for (int i = 0; i < size; ++i) {
                selectBlock = this.tblMain.getSelectManager().get(i);
                for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                    ICell cellStatus = this.tblMain.getRow(j).getCell("status");
                    if (cellStatus.getValue() == null || !LoanRepayStatusEnum.AUDITED.getAlias().equalsIgnoreCase(cellStatus.getValue().toString())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_PATH, (String)"removeError"));
                    SysUtil.abort();
                }
            }
        }
        super.actionEdit_actionPerformed(e);
    }

    protected String getEntityBOSType() throws Exception {
        LoanRepaymentApplyInfo info = new LoanRepaymentApplyInfo();
        return info.getBOSType().toString();
    }

    protected String getEditUIName() {
        return LoanRepaymentApplyEditUI.class.getName();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)"2"));
            filter.getFilterItems().add(new FilterItemInfo("isCreateRepayBill", (Object)"0"));
            Map btpPara = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            if (btpPara.get("fundTransfer") != null) {
                filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"1"));
                filter.getFilterItems().add(new FilterItemInfo("creditors.id", (Object)btpPara.get("CURRENTCOMPANY").toString()));
            } else if (btpPara.get("fromRepayment") != null) {
                filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompanyCommon.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"3"));
            } else if (btpPara.get("showType") != null) {
                filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"2"));
                filter.getFilterItems().add(new FilterItemInfo("creditors.id", (Object)btpPara.get("CURRENTCOMPANY").toString()));
            } else if (btpPara.get("consigen") != null) {
                filter.getFilterItems().add(new FilterItemInfo("sourceBillType", (Object)"0"));
                filter.getFilterItems().add(new FilterItemInfo("creditors.id", (Object)btpPara.get("CURRENTCOMPANY").toString()));
            }
        }
        return filter;
    }

    protected boolean isIgnoreBizUnit() {
        return false;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        CommonDataProvider data = new CommonDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print(tdTemplateFile, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.fin.app.LoanRepaymentApplyTDQuery");
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(LoanRepaymentApplyListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                if (row.getCell("currency.precision").getValue() == null) continue;
                Integer precesion = (Integer)row.getCell("currency.precision").getValue();
                this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
            }
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "loanBalance", format);
            this.setNumberFormat(row, "repayAmount", format);
            this.setNumberFormat(row, "rateAmount", format);
            this.setNumberFormat(row, "punishAmount", format);
            this.setNumberFormat(row, "rate", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            this.setNumberFormat(row, columnKey, format, true);
        }

        private void setNumberFormat(IRow row, String columnKey, String format, boolean doFormat) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            if (doFormat) {
                styleAttributes.setNumberFormat(format);
            } else {
                String formatRate = FMClientHelper.getNumberFtm((int)5);
                styleAttributes.setNumberFormat(formatRate);
            }
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

