/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.util.ComboBoxItemInfo;
import com.kingdee.eas.fm.fin.LoanColumnNameEnum;
import com.kingdee.eas.fm.fin.LoanException;
import com.kingdee.eas.fm.fin.client.AbstractLoanUserDefineFilterUI;
import com.kingdee.eas.fm.fin.util.LoanColumnNameMapping;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;

public class LoanUserDefineFilterUI
extends AbstractLoanUserDefineFilterUI {
    boolean isCanceled = false;
    private ArrayList sqlList = new ArrayList();
    private String sqlString = "";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initkDComboBoxLogic();
        this.initkDComboBoxColu();
        this.initKDComboBoxLogStr();
    }

    private void initkDComboBoxLogic() {
        this.kDComboBoxLogic.setEnabled(false);
        this.kDComboBoxLogic.removeAllItems();
        this.kDComboBoxLogic.insertItemAt((Object)new ComboBoxItemInfo((Object)"AND", (Object)"And "), 0);
        this.kDComboBoxLogic.insertItemAt((Object)new ComboBoxItemInfo((Object)"OR", (Object)"Or  "), 1);
    }

    private void initkDComboBoxColu() {
        this.kDComboBoxColu.removeAllItems();
        this.kDComboBoxColu.addItems(LoanColumnNameEnum.getEnumList().toArray());
    }

    private void initKDComboBoxLogStr() {
        this.kDComboBoxLogStr.removeAllItems();
        this.kDComboBoxLogStr.insertItemAt((Object)new ComboBoxItemInfo((Object)"=", (Object)"="), 0);
        this.kDComboBoxLogStr.insertItemAt((Object)new ComboBoxItemInfo((Object)">", (Object)">"), 1);
        this.kDComboBoxLogStr.insertItemAt((Object)new ComboBoxItemInfo((Object)"<", (Object)"<"), 2);
        this.kDComboBoxLogStr.insertItemAt((Object)new ComboBoxItemInfo((Object)"<>", (Object)"<>"), 3);
        this.kDComboBoxLogStr.insertItemAt((Object)new ComboBoxItemInfo((Object)"<=", (Object)"<="), 4);
        this.kDComboBoxLogStr.insertItemAt((Object)new ComboBoxItemInfo((Object)">=", (Object)">="), 5);
    }

    private StringBuffer getFullSqlCondition() throws FMException, LoanException {
        StringBuffer fullSqlCondition = new StringBuffer("");
        fullSqlCondition.append(this.getLogicValue());
        fullSqlCondition.append(this.getSqlCondition());
        return fullSqlCondition;
    }

    private StringBuffer getFullViewCondition() throws FMException, LoanException {
        StringBuffer fullViewCondition = new StringBuffer("");
        fullViewCondition.append(this.getLogicText());
        fullViewCondition.append(this.getViewCondition());
        return fullViewCondition;
    }

    private StringBuffer getLogicValue() throws FMException, LoanException {
        StringBuffer logicValue = new StringBuffer("");
        if (this.isSelected(this.kDComboBoxLogic)) {
            logicValue.append(this.getKDComboBoxLogicValue());
            logicValue.append(" ");
        }
        return logicValue;
    }

    private StringBuffer getLogicText() throws LoanException {
        StringBuffer logicValue = new StringBuffer("");
        if (this.isSelected(this.kDComboBoxLogic)) {
            logicValue.append(this.getkDComboBoxLogicText());
            logicValue.append(" ");
        }
        return logicValue;
    }

    private StringBuffer getViewCondition() throws FMException, LoanException {
        StringBuffer viewCondition = new StringBuffer("");
        viewCondition.append(this.getNowKDComboBoxColuText());
        viewCondition.append(" ");
        viewCondition.append(this.getKDComboBoxLogStrText());
        viewCondition.append(" ");
        viewCondition.append(this.getConditionControlText());
        return viewCondition;
    }

    private StringBuffer getSqlCondition() throws FMException, LoanException {
        StringBuffer sqlCondition = new StringBuffer("");
        sqlCondition.append(this.getNowKDComboBoxColuValue());
        sqlCondition.append(" ");
        sqlCondition.append(this.getKDComboBoxLogStrValue());
        sqlCondition.append(" ");
        sqlCondition.append(this.formatValue(this.getConditionControlValue()));
        return sqlCondition;
    }

    private String getKDComboBoxLogStrText() throws LoanException {
        return this.getKDComboBoxText(this.kDComboBoxLogStr);
    }

    private String getKDComboBoxLogStrValue() throws FMException, LoanException {
        return this.getKDComboBoxValue(this.kDComboBoxLogStr);
    }

    private String getkDComboBoxLogicText() throws LoanException {
        return this.getKDComboBoxText(this.kDComboBoxLogic);
    }

    private String getKDComboBoxLogicValue() throws FMException, LoanException {
        return this.getKDComboBoxValue(this.kDComboBoxLogic);
    }

    private String getKDComboBoxText(KDComboBox kDComboBox) throws LoanException {
        if (!this.isSelected(kDComboBox)) {
            throw new LoanException(LoanException.SYSTEM_EXCEPTION);
        }
        return ((ComboBoxItemInfo)kDComboBox.getSelectedItem()).toString();
    }

    private String getKDComboBoxValue(KDComboBox kDComboBox) throws FMException, LoanException {
        if (!this.isSelected(kDComboBox)) {
            throw new LoanException(LoanException.SYSTEM_EXCEPTION);
        }
        return ((ComboBoxItemInfo)kDComboBox.getSelectedItem()).getValue().toString();
    }

    @Override
    protected void kDButtonAdd_actionPerformed(ActionEvent e) throws Exception {
        StringBuffer fullSqlCondition;
        StringBuffer fullViewCondition;
        super.kDButtonAdd_actionPerformed(e);
        if (this.checkSel()) {
            fullViewCondition = this.getFullViewCondition();
            fullSqlCondition = this.getFullSqlCondition();
            if (this.isExistRepeatedCondition(this.getViewCondition())) {
                MsgBox.showInfo((String)RptUtil.getResourceSince51((String)"SameFilterExists"));
                return;
            }
        } else {
            return;
        }
        this.kDListResult.addElement((Object)fullViewCondition.toString());
        this.sqlList.add(fullSqlCondition.toString());
        this.logicCtrl();
    }

    @Override
    protected void kDButtonDel_actionPerformed(ActionEvent e) throws Exception {
        int delIndex;
        super.kDButtonDel_actionPerformed(e);
        if (this.sqlList == null) {
            // empty if block
        }
        if ((delIndex = this.kDListResult.getSelectedIndex()) == -1) {
            return;
        }
        this.kDListResult.removeElementAt(delIndex);
        this.sqlList.remove(delIndex);
        int kDListResultCount = this.kDListResult.getElementCount();
        if (kDListResultCount > 0) {
            String topViewCondition = this.kDListResult.getElement(0).toString();
            topViewCondition = this.subLogic(topViewCondition);
            this.kDListResult.setElement((Object)topViewCondition, 0);
            String topSqlCondition = this.sqlList.get(0).toString();
            topSqlCondition = this.subLogic(topSqlCondition);
            this.sqlList.set(0, topSqlCondition);
        }
        this.logicCtrl();
    }

    @Override
    protected void kDButtonOk_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonOk_actionPerformed(e);
        Iterator sqlIterator = this.sqlList.iterator();
        while (sqlIterator.hasNext()) {
            this.sqlString = this.sqlString + sqlIterator.next() + " ";
        }
        this.disposeUIWindow();
    }

    @Override
    protected void kDButtonCancel_actionPerformed(ActionEvent e) throws Exception {
        super.kDButtonCancel_actionPerformed(e);
        this.setCanceled(true);
        this.disposeUIWindow();
    }

    @Override
    protected void kDComboBoxColu_itemStateChanged(ItemEvent e) throws Exception {
        LoanColumnNameEnum loan = (LoanColumnNameEnum)((Object)this.kDComboBoxColu.getSelectedItem());
        LoanColumnNameMapping loanColumnNameMapping = new LoanColumnNameMapping(loan);
        loanColumnNameMapping.mapping();
        if ("F7".equals(loanColumnNameMapping.getControlType())) {
            this.initKDBizPromptBox(loanColumnNameMapping.getInfo());
        } else if ("KDComboBox".equals(loanColumnNameMapping.getControlType())) {
            this.initKDComboBox(loanColumnNameMapping.getInfo());
        } else if ("kDTextField".equals(loanColumnNameMapping.getControlType())) {
            this.initkDTextFieldColVlu();
        }
    }

    private void initKDComboBox(String itmesInfo) throws Exception {
        this.hideValueControl();
        this.kDComboBox.setVisible(true);
        this.kDComboBox.setEnabled(true);
        this.kDComboBox.removeAllItems();
        this.kDComboBox.setSelectedItem(null);
        Class<?> clazz = Class.forName(itmesInfo);
        Method method = clazz.getMethod("getEnumList", null);
        List itmemList = (List)method.invoke(null, null);
        this.kDComboBox.addItems(itmemList.toArray());
    }

    private void initKDBizPromptBox(String queryInfo) {
        this.hideValueControl();
        this.kDBizPromptBox.setVisible(true);
        this.kDBizPromptBox.setEnabled(true);
        this.kDBizPromptBox.setQueryInfo(queryInfo);
        this.kDBizPromptBox.setValue(null);
        this.kDBizPromptBox.setText("");
    }

    private void initkDTextFieldColVlu() {
        this.hideValueControl();
        this.kDTextFieldColVlu.setVisible(true);
        this.kDTextFieldColVlu.setEnabled(true);
        this.kDTextFieldColVlu.setText("");
    }

    private void hideValueControl() {
        this.kDComboBox.setVisible(false);
        this.kDComboBox.setEnabled(false);
        this.kDBizPromptBox.setVisible(false);
        this.kDBizPromptBox.setEnabled(false);
        this.kDTextFieldColVlu.setVisible(false);
        this.kDTextFieldColVlu.setEnabled(false);
    }

    private boolean isExistRepeatedCondition(StringBuffer condition) throws BOSException, FMException {
        if (condition == null) {
            throw new BOSException("");
        }
        if (!this.hasElements(this.kDListResult)) {
            return false;
        }
        int listResultCount = this.kDListResult.getElementCount();
        for (int i = 0; i < listResultCount; ++i) {
            String conditionValue;
            String existValue = this.subLogic(this.kDListResult.getElement(i).toString()).trim();
            if (!existValue.equals(conditionValue = this.subLogic(condition.toString()).trim())) continue;
            return true;
        }
        return false;
    }

    private String subLogic(String fullCondition) throws FMException {
        if (fullCondition == null || fullCondition.length() < 4 || !this.isSelected(this.kDComboBoxLogic)) {
            return "";
        }
        String trimfullCondition = fullCondition.trim();
        ComboBoxItemInfo topLogic = (ComboBoxItemInfo)this.kDComboBoxLogic.getItemAt(0);
        String topLogicText = topLogic.toString().trim();
        String topLogicValue = topLogic.getValue().toString().trim();
        if (trimfullCondition.indexOf(topLogicText) == 0) {
            return trimfullCondition.substring(topLogicText.length());
        }
        if (trimfullCondition.indexOf(topLogicValue) == 0) {
            return trimfullCondition.substring(topLogicValue.length());
        }
        ComboBoxItemInfo nextLogic = (ComboBoxItemInfo)this.kDComboBoxLogic.getItemAt(1);
        String nextLogicText = nextLogic.toString().trim();
        String nextLogicValue = nextLogic.getValue().toString().trim();
        if (trimfullCondition.indexOf(nextLogicText) == 0) {
            return trimfullCondition.substring(nextLogicText.length());
        }
        if (trimfullCondition.indexOf(nextLogicValue.trim()) == 0) {
            return trimfullCondition.substring(nextLogicValue.length());
        }
        return fullCondition;
    }

    private String getNowKDComboBoxColuValue() {
        if (!this.isSelected(this.kDComboBoxColu)) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.FiRptStdCyChooseColu");
            MsgBox.showWarning((String)strMsg);
        }
        return ((LoanColumnNameEnum)((Object)this.kDComboBoxColu.getSelectedItem())).getValue();
    }

    private String getNowKDComboBoxColuText() {
        if (!this.isSelected(this.kDComboBoxColu)) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.FiRptStdCyChooseColu");
            MsgBox.showWarning((String)strMsg);
        }
        return this.kDComboBoxColu.getSelectedItem().toString();
    }

    private String formatValue(Object value) throws LoanException {
        String KDComboBoxColuValue = this.getNowKDComboBoxColuValue();
        StringBuffer formatValue = new StringBuffer("");
        this.checkValue(value);
        if ("loan.FGuaranteeTypeInputMode".equalsIgnoreCase(KDComboBoxColuValue) || "loan.fHorizon".equalsIgnoreCase(KDComboBoxColuValue) || "loan.fRepaymentType".equalsIgnoreCase(KDComboBoxColuValue) || "loan.FSeqMulCon".equalsIgnoreCase(KDComboBoxColuValue)) {
            formatValue.append(" ");
            formatValue.append(value);
            formatValue.append(" ");
        } else if ("FINFEE.FFinFeeID".equalsIgnoreCase(KDComboBoxColuValue)) {
            formatValue.append(" '");
            formatValue.append(this.getFeeId(value.toString()));
            formatValue.append("' ");
        } else {
            formatValue.append(" '");
            formatValue.append(value);
            formatValue.append("' ");
        }
        return formatValue.toString();
    }

    protected void logicCtrl() {
        if (this.kDListResult.getElementCount() < 1) {
            this.kDComboBoxLogic.setEnabled(false);
            this.kDComboBoxLogic.setSelectedIndex(-1);
        } else {
            this.kDComboBoxLogic.setEnabled(true);
        }
    }

    protected boolean checkSel() throws Exception {
        if (this.hasElements(this.kDListResult) && !this.isSelected(this.kDComboBoxLogic)) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.FiRptStdCyChooseLogic");
            MsgBox.showWarning((String)strMsg);
            return false;
        }
        if (!this.isSelected(this.kDComboBoxLogStr)) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.FiRptStdCyChooseLogicStr");
            MsgBox.showWarning((String)strMsg);
            return false;
        }
        if (!this.isSelected(this.kDComboBoxColu)) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.FiRptStdCyChooseColu");
            MsgBox.showWarning((String)strMsg);
            return false;
        }
        if (this.getConditionControlValue() == null || this.getConditionControlValue() == null) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.FiRptStdCyCompareVal");
            MsgBox.showWarning((String)strMsg);
            return false;
        }
        return true;
    }

    private boolean hasElements(KDList kDList) {
        if (kDList == null) {
            return false;
        }
        return kDList.getElementCount() > 0;
    }

    private boolean isSelected(KDComboBox kDComboBox) {
        if (kDComboBox == null || kDComboBox.getSelectedItem() == null) {
            return false;
        }
        return kDComboBox.getSelectedIndex() >= 0;
    }

    private boolean isCanUseThisControl(JComponent jComponent) {
        if (jComponent == null) {
            return false;
        }
        return jComponent.isVisible() && jComponent.isEnabled();
    }

    private String getKDComboBoxText(Object item) throws LoanException {
        this.checkValue(item);
        if (item instanceof CurrencyInfo) {
            CurrencyInfo itemCurrency = (CurrencyInfo)item;
            return itemCurrency.getName();
        }
        if (item instanceof ComboBoxItemInfo) {
            ComboBoxItemInfo itemComboBox = (ComboBoxItemInfo)item;
            return itemComboBox.toString();
        }
        if (item instanceof Enum) {
            Enum itemEnum = (Enum)item;
            this.checkValue(itemEnum);
            return itemEnum.toString();
        }
        throw new LoanException(LoanException.NULL_VALIE);
    }

    private Object getKDComboBoxValue(Object item) throws LoanException, FMException {
        this.checkValue(item);
        if (item instanceof CurrencyInfo) {
            CurrencyInfo itemCurrency = (CurrencyInfo)item;
            return itemCurrency.getNumber();
        }
        if (item instanceof ComboBoxItemInfo) {
            ComboBoxItemInfo itemComboBox = (ComboBoxItemInfo)item;
            return new Integer(itemComboBox.getIntValue());
        }
        if (item instanceof Enum) {
            Enum itemEnum = (Enum)item;
            this.checkValue(itemEnum);
            try {
                Method method = itemEnum.getClass().getMethod("getValue", null);
                Object object = method.invoke((Object)itemEnum, null);
                return object.toString();
            }
            catch (Exception e) {
                throw new LoanException(LoanException.SYSTEM_EXCEPTION, e);
            }
        }
        throw new LoanException(LoanException.NULL_VALIE);
    }

    private Object getKDBizPromptBoxValue(Object info) throws LoanException {
        this.checkValue(info);
        if (info instanceof CoreBaseInfo) {
            try {
                CoreBaseInfo baseInfo = (CoreBaseInfo)info;
                Method method = baseInfo.getClass().getMethod("getNumber", null);
                Object object = method.invoke((Object)baseInfo, null);
                return object.toString();
            }
            catch (Exception e) {
                throw new LoanException(LoanException.SYSTEM_EXCEPTION, e);
            }
        }
        throw new LoanException(LoanException.NULL_VALIE);
    }

    private String getKDBizPromptBoxText(Object info) throws LoanException {
        this.checkValue(info);
        if (info instanceof CoreBaseInfo) {
            try {
                Method method = info.getClass().getMethod("getName", null);
                Object object = method.invoke(info, null);
                return object.toString();
            }
            catch (Exception e) {
                throw new LoanException(LoanException.SYSTEM_EXCEPTION, e);
            }
        }
        throw new LoanException(LoanException.NULL_VALIE);
    }

    private Object getConditionControlValue() throws LoanException, FMException {
        if (this.isCanUseThisControl((JComponent)this.kDComboBox) && this.isSelected(this.kDComboBox)) {
            return this.getKDComboBoxValue(this.kDComboBox.getSelectedItem());
        }
        if (this.isCanUseThisControl((JComponent)this.kDBizPromptBox)) {
            return this.getKDBizPromptBoxValue(this.kDBizPromptBox.getValue());
        }
        if (this.isCanUseThisControl((JComponent)this.kDTextFieldColVlu)) {
            return this.kDTextFieldColVlu.getText();
        }
        throw new LoanException(LoanException.NULL_VALIE);
    }

    private String getConditionControlText() throws LoanException {
        if (this.isCanUseThisControl((JComponent)this.kDComboBox) && this.isSelected(this.kDComboBox)) {
            return this.getKDComboBoxText(this.kDComboBox.getSelectedItem());
        }
        if (this.isCanUseThisControl((JComponent)this.kDBizPromptBox)) {
            return this.getKDBizPromptBoxText(this.kDBizPromptBox.getValue());
        }
        if (this.isCanUseThisControl((JComponent)this.kDTextFieldColVlu)) {
            return this.kDTextFieldColVlu.getText();
        }
        throw new LoanException(LoanException.NULL_VALIE);
    }

    private void checkValue(Object value) throws LoanException {
        if (value == null) {
            throw new LoanException(LoanException.NULL_VALIE);
        }
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    public void setCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setEscAction((CoreUIObject)this, (Action)new Action(){

            @Override
            public boolean isEnabled() {
                return true;
            }

            @Override
            public void setEnabled(boolean b) {
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            @Override
            public Object getValue(String key) {
                return null;
            }

            @Override
            public void putValue(String key, Object value) {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                LoanUserDefineFilterUI.this.isCanceled = true;
                LoanUserDefineFilterUI.this.disposeUIWindow();
            }
        });
    }

    public String getData() {
        return this.sqlString;
    }

    private String getFeeId(String FeeNum) throws LoanException {
        if (FMHelper.isEmpty((String)FeeNum)) {
            return null;
        }
        StringBuffer sql = new StringBuffer(100);
        sql.append("select Fid from T_FIN_FinancingFee where  FNumber = '").append(FeeNum.trim()).append("'");
        String FeeId = "";
        IRowSet rs = null;
        try {
            rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
            if (rs.size() < 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"354_LoanUserDefineFilterUI"));
                SysUtil.abort();
            }
            while (rs.next()) {
                if (rs.getString("Fid") == null) continue;
                FeeId = rs.getString("FID");
            }
        }
        catch (Exception ex) {
            throw new LoanException(LoanException.SYSTEM_EXCEPTION, ex);
        }
        return FeeId;
    }
}

