/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.fin.IWage;
import com.kingdee.eas.fm.fin.WageFactory;
import com.kingdee.eas.fm.fin.WageInfo;
import com.kingdee.eas.fm.fin.client.AbstractRWF7UI;
import com.kingdee.eas.fm.nt.IReceivableBill;
import com.kingdee.eas.fm.nt.ReceivableBillFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RWF7UI
extends AbstractRWF7UI {
    private static final Logger logger = CoreUIObject.getLogger(RWF7UI.class);
    private Object rstData;
    private FilterInfo wageFilter;
    protected boolean isCanceled = true;
    public static final String EV = "ev";
    public static final String IS_ENABLED_MULTI_SELECTION = "isEnabledMultiSelection";
    public static final String WAGEFILTER = "wageFilter";
    protected boolean isWage = false;

    public RWF7UI() throws Exception {
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.buildRstValues();
            this.isCanceled = false;
            this.getUIWindow().close();
        }
    }

    private void buildRstValues() {
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rowID.length < 1) {
            this.abort();
        }
        if (this.tblMain.getRow(rowID[0]) == null) {
            this.abort();
        }
        String id = this.tblMain.getRow(rowID[0]).getCell(0).getValue().toString();
        try {
            if (this.kDRec.isSelected()) {
                IReceivableBill iAdr = ReceivableBillFactory.getRemoteInstance();
                this.rstData = iAdr.getReceivableBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            } else {
                IWage iAdr = WageFactory.getRemoteInstance();
                this.rstData = iAdr.getWageInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
            this.abort();
        }
    }

    private void fillTable(String sfilter) throws BOSException {
        this.tblMain.removeRows(false);
        this.tblMain.checkParsed();
        String sql = "";
        String myFileter = "";
        String sTable = "";
        String sAmount = "";
        String sRemark = "";
        if (this.kDRec.isSelected()) {
            sTable = "T_NT_ReceivableBill";
            sAmount = " FBillAmt ";
            sRemark = " FDigest ";
        } else {
            sTable = "T_FIN_Wage";
            sAmount = " FAmount ";
            sRemark = " FRemark ";
        }
        String loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sql = "select A.fid,A.fnumber,B.fname_" + loc + "  bname,C.fname_" + loc + "  cname," + sAmount + " famount," + sRemark + " fremark  from " + sTable + " A inner join t_org_company B on A.fcompanyid = B.fid  inner join t_bd_currency C on A.fcurrencyid = C.fid  where 1=1 ";
        if (!this.isWage) {
            sql = sql + " and FBillState = 6 ";
        } else {
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            EntityObjectInfo bo = loader.getEntity(new WageInfo().getBOSType());
            for (int i = 0; i < this.wageFilter.getFilterItems().size(); ++i) {
                FilterItemInfo info = this.wageFilter.getFilterItems().get(i);
                if (info.getPropertyName().equals("property")) {
                    sql = sql + " and  FProperty = '" + info.getCompareValue().toString() + "' ";
                    continue;
                }
                if (info.getPropertyName().equals("isAntiWage")) {
                    sql = sql + " and  FisWage = 0 ";
                    continue;
                }
                if (info.getPropertyName().equals("company")) {
                    sql = sql + " and  A.FCompanyID = '" + ((CoreBaseInfo)info.getCompareValue()).getId().toString() + "' ";
                    continue;
                }
                if (info.getPropertyName().equals("Institution")) {
                    if (info.getCompareValue() == null) {
                        MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"442_RWF7UI"));
                        this.abort();
                        continue;
                    }
                    sql = sql + " and  FInstitutionId = '" + ((CoreBaseInfo)info.getCompareValue()).getId().toString() + "' ";
                    continue;
                }
                if (info.getCompareValue() == null) {
                    MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"442_RWF7UI"));
                    this.abort();
                    continue;
                }
                sql = sql + " and  FCustomerCompanyID = '" + ((CoreBaseInfo)info.getCompareValue()).getId().toString() + "' ";
            }
        }
        sql = sql + " " + sfilter;
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        try {
            while (rs.next()) {
                IRow row = this.tblMain.addRow();
                row.getCell("id").setValue((Object)rs.getString("fid"));
                row.getCell("number").setValue((Object)rs.getString("fnumber"));
                row.getCell("company").setValue((Object)rs.getString("bname"));
                row.getCell("currency").setValue((Object)rs.getString("cname"));
                row.getCell("amount").setValue((Object)rs.getString("famount"));
                row.getCell("remark").setValue((Object)rs.getString("fremark"));
            }
        }
        catch (SQLException e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    private void launchQuickFilter() {
        String sfilter = "";
        String sFields = "";
        try {
            sFields = "A.fnumber";
            sfilter = this.chkLike.isSelected() ? sfilter + " and " + sFields + " like '%" + this.txtValue.getText().trim() + "%'" : sfilter + " and " + sFields + " = " + this.txtValue.getText().trim();
            if (this.txtValue.getText().trim().equals("")) {
                sfilter = "";
            }
            this.fillTable(sfilter);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        this.launchQuickFilter();
    }

    @Override
    protected void kDRec_actionPerformed(ActionEvent e) throws Exception {
        this.isWage = false;
        try {
            this.fillTable("");
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
    }

    @Override
    protected void kDWage_actionPerformed(ActionEvent e) throws Exception {
        this.isWage = true;
        try {
            this.fillTable("");
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
    }

    @Override
    public void actionMaintain_actionPerformed(ActionEvent e) throws Exception {
        super.actionMaintain_actionPerformed(e);
    }

    public void onLoad() throws Exception {
        this.wageFilter = (FilterInfo)this.getUIContext().get(WAGEFILTER);
        this.kDRec.setSelected(true);
        this.fillTable("");
        this.kdOk.setEnabled(true);
        this.kdCancel.setEnabled(true);
        this.tblMain.getSelectManager().setSelectMode(10);
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ReceivableBillFactory.getRemoteInstance();
    }

    public Object getRstData() {
        return this.rstData;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.isCanceled = false;
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.isCanceled = true;
        this.getUIWindow().close();
    }
}

