/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.client.AbstractRepaymentFilterUI;
import com.kingdee.eas.fm.fin.client.RepaymentFilterParam;
import com.kingdee.eas.fm.fin.client.RepaymentHandler;
import com.kingdee.eas.fm.fs.client.CurrencyUtil;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import java.util.Collection;
import org.apache.log4j.Logger;

public class RepaymentFilterUI
extends AbstractRepaymentFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RepaymentFilterUI.class);
    CompanyOrgUnitInfo companyInfo;

    public RepaymentFilterUI() throws Exception {
    }

    public RepaymentFilterUI(FinancingBillTypeEnum bizType) throws Exception {
        FMClientHelper.UpdateFilterUITitle((CoreUIObject)this, (String)RepaymentHandler.getUITitle(bizType));
    }

    protected NewCompanyF7 getNewCompanyF7() {
        if (FSClientHelper.isCHUser()) {
            try {
                return super.getAllCompanyOrg();
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return super.getNewCompanyF7();
    }

    protected void init() throws Exception {
        super.init();
        FMClientHelper.initComboCurrency((KDComboBox)this.kDComboBoxCurrency);
        this.kDComboBoxCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        this.dpBeginDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
    }

    public void clear() {
        super.clear();
        this.dpBeginDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)DateUtil.getLastDayOfCurMonth());
        try {
            CurrencyInfo currency = CurrencyUtil.getLocalCurrency();
            FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)currency);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public Object getParam() {
        RepaymentFilterParam param = new RepaymentFilterParam();
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            param.setCompanyIdSet(this.getCompanyIdSet());
        }
        if (this.kDComboBoxCurrency.getSelectedItem() != null && this.kDComboBoxCurrency.getSelectedItem() instanceof CurrencyInfo) {
            CurrencyInfo cur = (CurrencyInfo)this.kDComboBoxCurrency.getSelectedItem();
            param.setCurrencyId(cur.getId().toString());
        }
        if (this.dpBeginDate.getValue() != null) {
            param.setDateBegin((java.util.Date)this.dpBeginDate.getValue());
        }
        if (this.dpEndDate.getValue() != null) {
            param.setDateEnd((java.util.Date)this.dpEndDate.getValue());
        }
        return param;
    }

    protected Class getParamClass() {
        return RepaymentFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        block8: {
            if (param == null) {
                return;
            }
            RepaymentFilterParam repayParam = (RepaymentFilterParam)((Object)param);
            this.dpBeginDate.setValue((Object)repayParam.getDateBegin());
            this.dpEndDate.setValue((Object)repayParam.getDateEnd());
            if (!this.companyInfo.isIsBizUnit() && !EmptyUtil.isEmpty((Collection)repayParam.getCompanyIdSet())) {
                this.setCompanyIdSet(repayParam.getCompanyIdSet());
            }
            if (repayParam.getCurrencyId() != null) {
                try {
                    String curId = repayParam.getCurrencyId();
                    if (curId != null) {
                        CurrencyInfo cur = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(curId));
                        FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)cur);
                        break block8;
                    }
                    FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.kDComboBoxCurrency, (Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
    }

    public boolean verify() {
        Date startDate = this.dpBeginDate.getSqlDate();
        Date endDate = this.dpEndDate.getSqlDate();
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"501_paymentFilterDateException");
            MsgBox.showWarning((Component)((Object)this), (String)msg);
            return false;
        }
        return super.verify();
    }
}

