/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.RptGrantCreditFundDetailFacadeFactory;
import com.kingdee.eas.fm.fin.RptGrantCreditFundDetailFilterParam;
import com.kingdee.eas.fm.fin.client.IRptGrantCreditFundDetailHandler;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public abstract class RptGrantCreditFundDetailHandlerBase
implements IRptGrantCreditFundDetailHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.fin.client.RptGrantCreditFundResource";
    protected RptGrantCreditFundDetailFilterParam filterParam = null;
    protected KDTable kdt = null;
    protected BigDecimal ALLLocalAmountTotal = SysConstant.BIGZERO;
    protected BigDecimal ALLBalanceAmountTotal = SysConstant.BIGZERO;
    protected BigDecimal ALLUsedAmountTotal = SysConstant.BIGZERO;
    protected int amountUnit;
    protected Date startdate = null;
    protected Date enddate = null;
    protected Date issueDate = null;
    protected Date expiredDate = null;
    private HashMap GuaranteeMap = new HashMap();

    public RptGrantCreditFundDetailHandlerBase(RptGrantCreditFundDetailFilterParam param, KDTable kdt) {
        this.filterParam = param;
        this.kdt = kdt;
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void initHeader() {
        this.kdt.removeRows();
        this.kdt.removeHeadRows();
        this.kdt.removeColumns();
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getGroupManager().setOrientation(1);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        IMetaDataPK pk = MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fm.fin.RptCreditFundDetail_2Query");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(this.filterParam.getFilter());
        ev.getSorter().addObjectCollection((IObjectCollection)this.filterParam.getSorterItems());
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    protected void initHeadRows() {
        IRow headRow = this.kdt.addHeadRow();
        headRow.getCell("Company").setValue((Object)this.getResString("Company"));
        headRow.getCell("CreditNo").setValue((Object)this.getResString("CreditNo"));
        headRow.getCell("CreditID").setValue((Object)this.getResString("CreditID"));
        headRow.getCell("CreditType").setValue((Object)this.getResString("CreditType"));
        headRow.getCell("CreditOrganization").setValue((Object)this.getResString("CreditOrganization"));
        headRow.getCell("CreditUsage").setValue((Object)this.getResString("CreditUsage"));
        headRow.getCell("CreditProperty").setValue((Object)this.getResString("CreditProperty"));
        headRow.getCell("IsGroupCredit").setValue((Object)this.getResString("IsGroupCredit"));
        headRow.getCell("ShareType").setValue((Object)this.getResString("ShareType"));
        headRow.getCell("Currency").setValue((Object)this.getResString("Currency"));
        headRow.getCell("QuotaAmount").setValue((Object)this.getResString("QuotaAmount"));
        headRow.getCell("ExchangeRate").setValue((Object)this.getResString("ExchangeRate"));
        headRow.getCell("LocalAmount").setValue((Object)this.getResString("LocalAmount"));
        headRow.getCell("IssueDate").setValue((Object)this.getResString("IssueDate"));
        headRow.getCell("CreditHorizon").setValue((Object)this.getResString("CreditHorizon"));
        headRow.getCell("ExpiredDate").setValue((Object)this.getResString("ExpiredDate"));
        headRow.getCell("UsedAmount").setValue((Object)this.getResString("UsedAmount"));
        headRow.getCell("Balance").setValue((Object)this.getResString("Balance"));
        headRow.getCell("isClosed").setValue((Object)this.getResString("isClosed"));
        headRow.getCell("GuaranteeType").setValue((Object)this.getResString("GuaranteeType"));
        headRow.getCell("Project").setValue((Object)this.getResString("Project"));
        headRow.getCell("Guarantee").setValue((Object)this.getResString("Guarantee"));
        headRow.getCell("Remark").setValue((Object)this.getResString("Remark"));
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        Calendar dateEndCalendar;
        this.amountUnit = this.filterParam.getUnit().getValue();
        this.ALLLocalAmountTotal = SysConstant.BIGZERO;
        this.ALLBalanceAmountTotal = SysConstant.BIGZERO;
        this.ALLUsedAmountTotal = SysConstant.BIGZERO;
        if (this.filterParam.getDateFrom() == null) {
            dateEndCalendar = Calendar.getInstance();
            dateEndCalendar.setTime(this.filterParam.getDateTo());
            dateEndCalendar.add(5, -90);
            this.startdate = dateEndCalendar.getTime();
            this.enddate = this.filterParam.getDateTo();
        } else {
            dateEndCalendar = Calendar.getInstance();
            dateEndCalendar.setTime(this.filterParam.getDateFrom());
            dateEndCalendar.add(5, -90);
            this.startdate = dateEndCalendar.getTime();
            this.enddate = this.filterParam.getDateTo();
        }
        this.kdt.setRefresh(false);
        String dformat = FMHelper.getDateFormatString();
        while (rs.next()) {
            IRow row = this.kdt.addRow();
            BigDecimal exchange = rs.getBigDecimal("Parent.ExchangeRate");
            BigDecimal quotaAmount = rs.getBigDecimal("Parent.QuotaAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4);
            BigDecimal localAmount = rs.getBigDecimal("Parent.LocalAmount").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4);
            BigDecimal balance = rs.getBigDecimal("Parent.Balance").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4);
            this.ALLLocalAmountTotal = this.ALLLocalAmountTotal.add(localAmount);
            this.ALLBalanceAmountTotal = this.ALLBalanceAmountTotal.add(balance);
            this.ALLUsedAmountTotal = this.ALLUsedAmountTotal.add(localAmount.subtract(balance));
            row.getCell("CreditHorizonState").setValue((Object)rs.getString("CreditHorizonState"));
            row.getCell("Company").setValue((Object)rs.getString("ShareOrg.name"));
            if (rs.getString("ISBANKCREDIT").equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"517_RptGrantCreditFundDetailHandlerBase"))) {
                row.getCell("CreditType").setValue((Object)this.getResString("bankCredit"));
            } else if (rs.getString("ISBANKCREDIT").equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"518_RptGrantCreditFundDetailHandlerBase"))) {
                row.getCell("CreditType").setValue((Object)this.getResString("nonBankCredit"));
            } else if (rs.getString("ISBANKCREDIT").equals(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"519_RptGrantCreditFundDetailHandlerBase"))) {
                row.getCell("CreditType").setValue((Object)this.getResString("innerCredit"));
            }
            this.setOrgValue(rs, row);
            row.getCell("CreditUsage").setValue((Object)rs.getString("CreditUsage.name"));
            if (rs.getString("Property").equals("1")) {
                row.getCell("CreditProperty").setValue((Object)this.getResString("Property1"));
            }
            if (rs.getString("Property").equals("2")) {
                row.getCell("CreditProperty").setValue((Object)this.getResString("Property2"));
            }
            if (null == rs.getString("isGroupCredit")) {
                row.getCell("IsGroupCredit").setValue((Object)this.getResString("isGroupCredit0"));
            } else if ("false".equals(rs.getString("isGroupCredit"))) {
                row.getCell("IsGroupCredit").setValue((Object)this.getResString("isGroupCredit0"));
            } else if ("true".equals(rs.getString("isGroupCredit"))) {
                row.getCell("IsGroupCredit").setValue((Object)this.getResString("isGroupCredit1"));
            }
            row.getCell("Currency").setValue((Object)rs.getString("Currency.name"));
            String curID = rs.getString("Currency.id");
            row.getCell("QuotaAmount").setValue((Object)quotaAmount);
            row.getCell("LocalAmount").setValue((Object)localAmount);
            row.getCell("Balance").setValue((Object)balance);
            row.getCell("UsedAmount").setValue((Object)localAmount.subtract(balance));
            FMClientHelper.setNumberFormat((IRow)row, (String)"QuotaAmount", (String)curID);
            FMClientHelper.setNumberFormat((IRow)row, (String)"Balance", (String)curID);
            FMClientHelper.setNumberFormat((IRow)row, (String)"UsedAmount", (String)curID);
            FMClientHelper.setNumberFormat((IRow)row, (String)"LocalAmount", (String)curID);
            row.getCell("CreditHorizon").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)2));
            row.getCell("ExchangeRate").setValue((Object)exchange);
            row.getCell("IssueDate").setValue((Object)rs.getDate("Parent.IssueDate"));
            row.getCell("CreditHorizon").setValue((Object)rs.getBigDecimal("Parent.CreditHorizon"));
            row.getCell("ExpiredDate").setValue((Object)rs.getDate("Parent.ExpiredDate"));
            row.getCell("IssueDate").getStyleAttributes().setNumberFormat(dformat);
            row.getCell("ExpiredDate").getStyleAttributes().setNumberFormat(dformat);
            this.issueDate = DateTimeUtils.truncateDate((Date)rs.getDate("Parent.IssueDate"));
            this.expiredDate = DateTimeUtils.truncateDate((Date)rs.getDate("Parent.ExpiredDate"));
            if (!rs.getBoolean("Parent.IsClosed")) {
                row.getCell("isClosed").setValue((Object)this.getResString("closedState2"));
            } else {
                row.getCell("isClosed").setValue((Object)this.getResString("closedState1"));
            }
            row.getCell("GuaranteeType").setValue((Object)rs.getString("GuaranteeType.name"));
            row.getCell("Project").setValue((Object)rs.getString("project.name"));
            row.getCell("Guarantee").setValue(this.GuaranteeMap.get(rs.getString("CreditID")));
            row.getCell("CreditNo").setValue((Object)rs.getString("Parent.number"));
            row.getCell("CreditID").setValue((Object)rs.getString("CreditID"));
            if (rs.getString("Parent.ShareType").equals("1")) {
                row.getCell("ShareType").setValue((Object)this.getResString("ShareType1"));
            }
            if (rs.getString("Parent.ShareType").equals("2")) {
                row.getCell("ShareType").setValue((Object)this.getResString("ShareType2"));
            }
            if (rs.getString("Parent.ShareType").equals("3")) {
                row.getCell("ShareType").setValue((Object)this.getResString("ShareType3"));
            }
            row.getCell("Remark").setValue((Object)rs.getString("Remark"));
            row.setUserObject((Object)rs.getString("CreditID"));
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    protected void setOrgValue(IRowSet rs, IRow row) throws SQLException {
        row.getCell("CreditOrganization").setValue((Object)rs.getString("fixName"));
    }

    @Override
    public void mergedFlowRow() {
        for (int i = 0; i < this.kdt.getRowCount(); ++i) {
            String cellValue;
            String GetCellValue;
            if (i > 1 && (GetCellValue = (String)this.kdt.getRow(i).getCell("CreditHorizonState").getValue()) == null) {
                String CellBlValue = (String)this.kdt.getRow(i - 2).getCell("CreditHorizonState").getValue();
                String CellValueTotal = (String)this.kdt.getRow(i).getCell("CreditProperty").getValue();
                if (CellValueTotal.contains("EAS20060417")) {
                    if ("0".equals(CellBlValue)) {
                        this.kdt.getRow(i).getCell("CreditProperty").setValue((Object)this.getResString("LittleLocalTotal"));
                    }
                    if ("1".equals(CellBlValue)) {
                        this.kdt.getRow(i).getCell("CreditProperty").setValue((Object)this.getResString("LongLocalTotal"));
                    }
                }
            }
            if ((cellValue = (String)this.kdt.getRow(i).getCell("CreditProperty").getValue()) != null && cellValue.equals(this.getResString("SubTotalLocalAmount"))) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 12);
                this.kdt.getRow(i).getCell(1).setValue((Object)this.getResString("SubTotalLocalAmount"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                this.kdt.getRow(i).getCell("LocalAmount").getStyleAttributes().setBackground(new Color(16119270));
            }
            if (cellValue != null && cellValue.equals(this.getResString("LittleLocalTotal"))) {
                this.kdt.getMergeManager().mergeBlock(i, 1, i, 12);
                this.kdt.getRow(i).getCell(1).setValue((Object)this.getResString("LittleLocalTotal"));
                this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                this.kdt.getRow(i).getCell("LocalAmount").getStyleAttributes().setBackground(new Color(16119270));
            }
            if (cellValue == null || !cellValue.equals(this.getResString("LongLocalTotal"))) continue;
            this.kdt.getMergeManager().mergeBlock(i, 1, i, 12);
            this.kdt.getRow(i).getCell(1).setValue((Object)this.getResString("LongLocalTotal"));
            this.kdt.getRow(i).getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            this.kdt.getRow(i).getCell("LocalAmount").getStyleAttributes().setBackground(new Color(16119270));
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
    }

    @Override
    public void insertAbsractFlowRow() {
        String text = this.getResString("AllTotalLocalAmount");
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell("LocalAmount").setValue((Object)this.ALLLocalAmountTotal);
        row.getCell("UsedAmount").setValue((Object)this.ALLLocalAmountTotal.subtract(this.ALLBalanceAmountTotal));
        row.getCell("Balance").setValue((Object)this.ALLBalanceAmountTotal);
        int r = this.kdt.getRowCount() - 1;
        this.kdt.getMergeManager().mergeBlock(r, 1, r, 12);
        row.getCell(1).setValue((Object)text);
        row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.resetAmount();
    }

    private void resetAmount() {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CurrencyInfo currencyInfo = null;
        try {
            currencyInfo = FMClientHelper.getBaseCurrency((CompanyOrgUnitInfo)currentCompany);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        for (int i = 0; i < this.kdt.getRowCount(); ++i) {
            Object currency = this.kdt.getRow(i).getCell("Currency").getValue();
            if (currency != null && (!currency.equals(this.getResString("SubTotalLocalAmount")) && !currency.equals(this.getResString("LittleLocalTotal")) && !currency.equals(this.getResString("AllTotalLocalAmount")) && !currency.equals(this.getResString("LongLocalTotal")) || currencyInfo == null)) continue;
            FMClientHelper.setNumberFormat((IRow)this.kdt.getRow(i), (String)"QuotaAmount", (String)currencyInfo.getId().toString());
            FMClientHelper.setNumberFormat((IRow)this.kdt.getRow(i), (String)"UsedAmount", (String)currencyInfo.getId().toString());
            FMClientHelper.setNumberFormat((IRow)this.kdt.getRow(i), (String)"Balance", (String)currencyInfo.getId().toString());
            FMClientHelper.setNumberFormat((IRow)this.kdt.getRow(i), (String)"LocalAmount", (String)currencyInfo.getId().toString());
        }
    }

    public HashMap getGurantee() throws BOSException {
        HashMap GuaranteeMap = RptGrantCreditFundDetailFacadeFactory.getRemoteInstance().ReturnGuarantee(this.filterParam.getFilter(), this.filterParam.getSorterItems());
        return GuaranteeMap;
    }
}

