/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.common.client.FMRptBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.common.util.FMBillClientUtil;
import com.kingdee.eas.fm.fin.FinancingProductsCollection;
import com.kingdee.eas.fm.fin.FinancingProductsFactory;
import com.kingdee.eas.fm.fin.FinancingProductsInfo;
import com.kingdee.eas.fm.fin.client.RptInnerFinTotalLimitSumFilterParam;
import com.kingdee.eas.mobile.convert.util.EmptyUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RptInnerFinTotalLimitSumHandler
extends FMDetailRptBaseHandler
implements IFMDetailRptHandler {
    private static final String PART_ = "Part_";
    private static final String UNIT_ = "Unit_";
    private static final String COMPANY_NAME = "companyName";
    private static final String REST_LIMIT = "restLimit";
    private static final String USE_TOTAL = "useTotal";
    private static final String LOAN_IN_GROUP = "loanInGroup";
    private static final String LIMIT_AMT_LOCAL = "limitAmtLocal";
    private CompanyOrgUnitInfo currentCompany;
    private int precision = 2;
    private Set companyIDs;
    private Date date;
    private RptInnerFinTotalLimitSumFilterParam param;
    private LoanStatisticalUnitEnum unitEnum;
    private String unit = "1";
    private String loc;
    private String commonFilter;
    private FinancingProductsCollection finTypeCol;
    private String[] dataColumn;

    public RptInnerFinTotalLimitSumHandler(FilterInfo filterInfo, FMRptBaseUI fmRptUI, RptInnerFinTotalLimitSumFilterParam param) {
        super(filterInfo, fmRptUI);
        this.initParam(param);
    }

    protected void setLocalString() {
        this.loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
    }

    protected void initParam(RptInnerFinTotalLimitSumFilterParam param) {
        this.param = param;
        this.setLocalString();
        this.currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
            baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
            this.precision = baseCurrency.getPrecision();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        try {
            this.finTypeCol = FinancingProductsFactory.getRemoteInstance().getFinancingProductsCollection();
            this.dataColumn = new String[4 + this.finTypeCol.size() * 2];
            this.dataColumn[0] = LIMIT_AMT_LOCAL;
            this.dataColumn[1] = LOAN_IN_GROUP;
            this.dataColumn[2] = USE_TOTAL;
            this.dataColumn[3] = REST_LIMIT;
            for (int i = 0; i < this.finTypeCol.size(); ++i) {
                this.dataColumn[4 + i] = UNIT_ + this.finTypeCol.get(i).getNumber();
            }
            for (int j = 0; j < this.finTypeCol.size(); ++j) {
                this.dataColumn[4 + this.finTypeCol.size() + j] = PART_ + this.finTypeCol.get(j).getNumber();
            }
        }
        catch (BOSException e) {
            this.finTypeCol = null;
        }
        this.unitEnum = param.getUnit();
        this.companyIDs = param.getCompanyIdSet();
        this.commonFilter = FMHelper.buildIn((String)"T_Company.fid", (Object[])this.companyIDs.toArray());
        this.date = param.getDate();
        if (this.unitEnum.equals((Object)LoanStatisticalUnitEnum.THOUSAND)) {
            this.unit = "1000";
        } else if (this.unitEnum.equals((Object)LoanStatisticalUnitEnum.TEN_THOUSAND)) {
            this.unit = "10000";
        } else if (this.unitEnum.equals((Object)LoanStatisticalUnitEnum.MILLION)) {
            this.unit = "1000000";
        } else if (this.unitEnum.equals((Object)LoanStatisticalUnitEnum.HUNDRED_THOUSAND)) {
            this.unit = "10000000";
        } else if (this.unitEnum.equals((Object)LoanStatisticalUnitEnum.HUNDRED_MILLION)) {
            this.unit = "100000000";
        }
    }

    public void initHeader() {
        int colCount;
        this.kdt.removeRows();
        for (int i = colCount = this.kdt.getColumnCount(); i > this.kdt.getColumnIndex(LOAN_IN_GROUP) + 1; --i) {
            this.kdt.removeColumn(i - 1);
        }
        this.kdt.getGroupManager().removeGroup();
        this.kdt.setEditable(false);
        this.kdt.getGroupManager().setGroup(true);
        this.kdt.getHeadRow(0).getStyleAttributes().setWrapText(true);
        IRow row0 = this.kdt.getHeadRow(0);
        IRow row1 = this.kdt.getHeadRow(1);
        IRow row2 = this.kdt.getHeadRow(2);
        String colUnitEnd = "";
        String colPartEnd = "";
        IColumn col = null;
        if (this.finTypeCol != null && this.finTypeCol.size() > 0) {
            for (FinancingProductsInfo finTypeInfo : this.finTypeCol) {
                col = this.kdt.addColumn();
                col.setKey(UNIT_ + finTypeInfo.getNumber());
                row2.getCell(col.getColumnIndex()).setValue((Object)finTypeInfo.getName());
            }
            if (col != null) {
                colUnitEnd = col.getKey();
            }
            for (FinancingProductsInfo finTypeInfo : this.finTypeCol) {
                col = this.kdt.addColumn();
                col.setKey(PART_ + finTypeInfo.getNumber());
                row2.getCell(col.getColumnIndex()).setValue((Object)finTypeInfo.getName());
                row1.getCell(col.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"411_RptInnerFinTotalLimitSumHandler"));
            }
            if (col != null) {
                colPartEnd = col.getKey();
            }
        }
        col = this.kdt.addColumn();
        col.setKey(USE_TOTAL);
        row1.getCell(col.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"412_RptInnerFinTotalLimitSumHandler"));
        col = this.kdt.addColumn();
        col.setKey(REST_LIMIT);
        row0.getCell(col.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"413_RptInnerFinTotalLimitSumHandler"));
        KDTMergeManager mergeManager = this.kdt.getHeadMergeManager();
        mergeManager.mergeBlock(0, this.kdt.getColumnIndex(COMPANY_NAME), 2, this.kdt.getColumnIndex(COMPANY_NAME));
        mergeManager.mergeBlock(0, this.kdt.getColumnIndex(LIMIT_AMT_LOCAL), 2, this.kdt.getColumnIndex(LIMIT_AMT_LOCAL));
        mergeManager.mergeBlock(0, this.kdt.getColumnIndex(LOAN_IN_GROUP), 0, this.kdt.getColumnIndex(USE_TOTAL));
        mergeManager.mergeBlock(1, this.kdt.getColumnIndex(LOAN_IN_GROUP), 1, this.kdt.getColumnIndex(colUnitEnd));
        mergeManager.mergeBlock(1, this.kdt.getColumnIndex(colUnitEnd) + 1, 1, this.kdt.getColumnIndex(colPartEnd));
        mergeManager.mergeBlock(1, this.kdt.getColumnIndex(USE_TOTAL), 2, this.kdt.getColumnIndex(USE_TOTAL));
        mergeManager.mergeBlock(0, this.kdt.getColumnIndex(REST_LIMIT), 2, this.kdt.getColumnIndex(REST_LIMIT));
    }

    protected String getQueryPath() {
        return "";
    }

    public void setTableStateRow() {
    }

    public IRowSet getRowSet() throws BOSException {
        String sql = this.getTotalLimitData().toString();
        return SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
    }

    private StringBuffer getTotalLimitData() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT ").append(COMPANY_NAME).append(", ").append("SUM(").append(LIMIT_AMT_LOCAL).append(")/").append(this.unit).append(" AS ").append(LIMIT_AMT_LOCAL).append(" FROM (").append(" SELECT T_Company.fname_").append(this.loc).append(" AS ").append(COMPANY_NAME).append(",").append(" T_TotalLimitEntry.FLimitAmt*(case when T_TotalLimit.FExchangeRate is null then 1 else T_TotalLimit.FExchangeRate end) AS ").append(LIMIT_AMT_LOCAL).append(" FROM T_FIN_InnerFinTotalLimit AS T_TotalLimit ").append(" LEFT OUTER JOIN T_FIN_InnerFinTotalLimitEntrys AS T_TotalLimitEntry ON T_TotalLimit.fid=T_TotalLimitEntry.fparentid ").append(" LEFT OUTER JOIN T_ORG_Company AS T_Company ON T_TotalLimitEntry.fcompanyid=T_Company.fid ").append(" INNER JOIN (SElECT  T_Company2.FNAME_").append(this.loc).append("  AS companyName,MAX(T_TotalLimit2.feffectDate) as effectDate ").append(" FROM  T_FIN_InnerFinTotalLimit AS T_TotalLimit2  ").append(" LEFT OUTER JOIN T_FIN_InnerFinTotalLimitEntrys AS T_TotalLimitEntry2 ON T_TotalLimit2.fid=T_TotalLimitEntry2.fparentid ").append(" LEFT OUTER JOIN T_ORG_Company AS T_Company2 ON T_TotalLimitEntry2.fcompanyid=T_Company2.fid ").append(" WHERE  T_TotalLimit2.feffectDate<={").append(FMConstants.FORMAT_DAY.format(this.date)).append("} ").append(" GROUP BY T_Company2.FNAME_").append(this.loc).append("  ) limit_uni ").append(" on T_Company.FNAME_").append(this.loc).append(" =limit_uni.companyName and T_TotalLimit.feffectDate=limit_uni.effectDate  ").append(" WHERE 1=1 AND ").append(this.commonFilter).append(") allTotal GROUP BY ").append(COMPANY_NAME);
        return sql;
    }

    private String getGroupLoanData() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T_Company.fname_").append(this.loc).append(" AS ").append(COMPANY_NAME).append(",").append(" SUM(loan.Fbalance*loan.FLocalCurExRate)/").append(this.unit).append(" AS ").append(LOAN_IN_GROUP).append(" FROM T_FIN_Loan AS loan ").append(" LEFT OUTER JOIN T_ORG_Company AS T_Company ON loan.fcompanyid=T_Company.fid ").append(" WHERE 1=1 ").append(" and loan.FIsGroupLoan=1 ").append(" and").append(this.commonFilter).append(" and loan.FIssueDate<={").append(FMConstants.FORMAT_DAY.format(this.date)).append("} ").append(" GROUP BY  T_Company.fname_").append(this.loc);
        return sql.toString();
    }

    private String getUnitData() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ").append(COMPANY_NAME).append(",").append(" finType,").append(" SUM(amt)/").append(this.unit).append(" AS amt").append(" FROM ( ").append(this.getUnitLoanData()).append(" UNION ALL ").append(this.getUnitLetterOfCreditData()).append(" UNION ALL ").append(this.getUnitPayablebillData()).append(" UNION ALL ").append(this.getUnitLetterOfGuaranteeData()).append(") EE GROUP BY ").append(COMPANY_NAME).append(",finType ");
        return sql.toString();
    }

    private StringBuffer getUnitLoanData() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T_Company.fname_").append(this.loc).append(" AS ").append(COMPANY_NAME).append(",").append(" type.fnumber AS finType,").append(" SUM(loan.Fbalance*loan.FLocalCurExRate) AS amt").append(" FROM T_FIN_Loan AS loan ").append(" LEFT OUTER JOIN T_ORG_Company AS T_Company ON loan.fcompanyid=T_Company.fid ").append(" LEFT OUTER JOIN T_FIN_CreditLimit AS creditLimit ON loan.FCreditLimitId=creditLimit.fid ").append(" INNER JOIN T_FIN_FinancingProducts AS type ON loan.ftypeid=type.fid ").append(" WHERE 1=1 ").append(" and loan.FIsGroupLoan=0 ").append(" and loan.FIsInCredit=1 ").append(" and creditLimit.FIsGroupCredit=1 ").append(" and").append(this.commonFilter).append(" and loan.FIssueDate<={").append(FMConstants.FORMAT_DAY.format(this.date)).append("} ").append(" GROUP BY  T_Company.fname_").append(this.loc).append(",type.fnumber ");
        return sql;
    }

    private StringBuffer getUnitLetterOfCreditData() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T_Company.fname_").append(this.loc).append(" AS ").append(COMPANY_NAME).append(",").append(" type.fnumber AS finType,").append(" SUM(letterOfCredit.Fbalance*letterOfCredit.FLocalCurExRate) AS amt").append(" FROM T_FIN_LetterOfCredit AS letterOfCredit ").append(" LEFT OUTER JOIN T_ORG_Company AS T_Company ON letterOfCredit.fcompanyid=T_Company.fid ").append(" LEFT OUTER JOIN T_FIN_CreditLimit AS creditLimit ON letterOfCredit.FCreditLimitId=creditLimit.fid ").append(" INNER JOIN T_FIN_FinancingProducts AS type ON letterOfCredit.ftypeid=type.fid ").append(" WHERE 1=1 ").append(" and letterOfCredit.FIsInCredit=1 ").append(" and creditLimit.FIsGroupCredit=1 ").append(" and").append(this.commonFilter).append(" and letterOfCredit.FIssueDate<={").append(FMConstants.FORMAT_DAY.format(this.date)).append("} ").append(" GROUP BY  T_Company.fname_").append(this.loc).append(",type.fnumber ");
        return sql;
    }

    private String getUnitPayablebillData() {
        return this.getUnitLetterOfCreditData().toString().replaceAll("T_FIN_LetterOfCredit", "T_NT_PayableBill");
    }

    private String getUnitLetterOfGuaranteeData() {
        return this.getUnitLetterOfCreditData().toString().replaceAll("T_FIN_LetterOfCredit", "T_CTL_LetterOfGuarantee");
    }

    private String getPartData() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT ").append(COMPANY_NAME).append(",").append(" finType,").append(" SUM(amt)/").append(this.unit).append(" AS amt").append(" FROM ( ").append(this.getPartLoanData()).append(" UNION ALL ").append(this.getPartLetterOfCreditData()).append(" UNION ALL ").append(this.getPartPayablebillData()).append(" UNION ALL ").append(this.getPartLetterOfGuaranteeData()).append(") A GROUP BY ").append(COMPANY_NAME).append(",finType ");
        return sql.toString();
    }

    private StringBuffer getPartLoanData() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T_Company.fname_").append(this.loc).append(" AS ").append(COMPANY_NAME).append(",").append(" type.fnumber AS finType,").append(" SUM(loan.Fbalance*loan.FLocalCurExRate) AS amt").append(" FROM T_FIN_Loan AS loan ").append(" LEFT OUTER JOIN T_ORG_Company AS T_Company ON loan.fcompanyid=T_Company.fid ").append(" LEFT OUTER JOIN T_FIN_CreditLimit AS creditLimit ON loan.FCreditLimitId=creditLimit.fid ").append(" INNER JOIN T_FIN_FinancingProducts AS type ON loan.ftypeid=type.fid ").append(" WHERE 1=1 ").append(" and loan.FIsGroupLoan=0 ").append(" and ((loan.FIsInCredit=0)").append(" or (creditLimit.FIsGroupCredit=0 and loan.FIsInCredit=1))").append(" and").append(this.commonFilter).append(" and loan.FIssueDate<={").append(FMConstants.FORMAT_DAY.format(this.date)).append("} ").append(" GROUP BY  T_Company.fname_").append(this.loc).append(",type.fnumber ");
        return sql;
    }

    private StringBuffer getPartLetterOfCreditData() {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT T_Company.fname_").append(this.loc).append(" AS ").append(COMPANY_NAME).append(",").append(" type.fnumber AS finType,").append(" SUM(letterOfCredit.Fbalance*letterOfCredit.FLocalCurExRate) AS amt").append(" FROM T_FIN_LetterOfCredit AS letterOfCredit ").append(" LEFT OUTER JOIN T_ORG_Company AS T_Company ON letterOfCredit.fcompanyid=T_Company.fid ").append(" LEFT OUTER JOIN T_FIN_CreditLimit AS creditLimit ON letterOfCredit.FCreditLimitId=creditLimit.fid ").append(" INNER JOIN T_FIN_FinancingProducts AS type ON letterOfCredit.ftypeid=type.fid ").append(" WHERE 1=1 ").append(" and ((letterOfCredit.FIsInCredit=0)").append(" or (creditLimit.FIsGroupCredit=0 and letterOfCredit.FIsInCredit=1))").append(" and").append(this.commonFilter).append(" and letterOfCredit.FIssueDate<={").append(FMConstants.FORMAT_DAY.format(this.date)).append("} ").append(" GROUP BY  T_Company.fname_").append(this.loc).append(",type.fnumber ");
        return sql;
    }

    private String getPartPayablebillData() {
        return this.getPartLetterOfCreditData().toString().replaceAll("T_FIN_LetterOfCredit", "T_NT_PayableBill");
    }

    private String getPartLetterOfGuaranteeData() {
        return this.getPartLetterOfCreditData().toString().replaceAll("T_FIN_LetterOfCredit", "T_CTL_LetterOfGuarantee");
    }

    private IRowSet getAllCompany() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(COMPANY_NAME).append(" from (").append(this.getTotalLimitData()).append(") A").append(" union ").append("select ").append(COMPANY_NAME).append(" from (").append(this.getGroupLoanData()).append(") B").append(" union ").append("select ").append(COMPANY_NAME).append(" from (").append(this.getUnitData()).append(") C").append(" union ").append("select ").append(COMPANY_NAME).append(" from (").append(this.getPartData()).append(") D");
        return SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        if (rs == null) {
            return;
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (int i = 0; i < this.dataColumn.length; ++i) {
            map.put(this.dataColumn[i], new BigDecimal("0"));
        }
        IRowSet allCompany = this.getAllCompany();
        IRowSet loanInGroupData = SQLExecutorFactory.getRemoteInstance((String)this.getGroupLoanData()).executeSQL();
        IRowSet unionData = SQLExecutorFactory.getRemoteInstance((String)this.getUnitData()).executeSQL();
        IRowSet partData = SQLExecutorFactory.getRemoteInstance((String)this.getPartData()).executeSQL();
        while (allCompany.next()) {
            String type;
            String cName;
            IRow row = this.kdt.addRow();
            String companyName = allCompany.getString(COMPANY_NAME);
            FMBillClientUtil.showMessage((String)companyName);
            row.getCell(COMPANY_NAME).setValue((Object)companyName);
            BigDecimal limitAmt = null;
            while (rs.next()) {
                String cName2 = rs.getString(COMPANY_NAME);
                if (!cName2.equals(companyName)) continue;
                limitAmt = rs.getBigDecimal(LIMIT_AMT_LOCAL);
                row.getCell(LIMIT_AMT_LOCAL).setValue((Object)limitAmt);
                map.put(LIMIT_AMT_LOCAL, ((BigDecimal)map.get(LIMIT_AMT_LOCAL)).add(limitAmt));
                break;
            }
            rs.beforeFirst();
            BigDecimal userAmt = new BigDecimal("0");
            while (loanInGroupData.next()) {
                cName = loanInGroupData.getString(COMPANY_NAME);
                if (EmptyUtil.isEmpty((String)cName) || !cName.equals(companyName)) continue;
                BigDecimal loanInGroup_amt = loanInGroupData.getBigDecimal(LOAN_IN_GROUP);
                row.getCell(LOAN_IN_GROUP).setValue((Object)loanInGroup_amt);
                map.put(LOAN_IN_GROUP, ((BigDecimal)map.get(LOAN_IN_GROUP)).add(loanInGroup_amt));
                userAmt = userAmt.add(loanInGroup_amt);
                break;
            }
            loanInGroupData.beforeFirst();
            while (unionData.next()) {
                cName = unionData.getString(COMPANY_NAME);
                if (EmptyUtil.isEmpty((String)cName) || !cName.equals(companyName)) continue;
                type = unionData.getString("finType");
                row.getCell(UNIT_ + type).setValue((Object)unionData.getBigDecimal("amt"));
                map.put(UNIT_ + type, ((BigDecimal)map.get(UNIT_ + type)).add(unionData.getBigDecimal("amt")));
                userAmt = userAmt.add(unionData.getBigDecimal("amt"));
            }
            unionData.beforeFirst();
            while (partData.next()) {
                cName = partData.getString(COMPANY_NAME);
                FMBillClientUtil.showMessage((String)cName);
                if (EmptyUtil.isEmpty((String)cName) || !cName.equals(companyName)) continue;
                type = partData.getString("finType");
                row.getCell(PART_ + type).setValue((Object)partData.getBigDecimal("amt"));
                map.put(PART_ + type, ((BigDecimal)map.get(PART_ + type)).add(partData.getBigDecimal("amt")));
                userAmt = userAmt.add(partData.getBigDecimal("amt"));
            }
            partData.beforeFirst();
            if (userAmt.compareTo(Constants.ZERO) != 0) {
                row.getCell(USE_TOTAL).setValue((Object)userAmt);
            }
            BigDecimal restAmt = Constants.ZERO;
            if (limitAmt != null || userAmt.compareTo(Constants.ZERO) != 0) {
                if (limitAmt == null) {
                    limitAmt = Constants.ZERO;
                }
                restAmt = limitAmt.subtract(userAmt);
                row.getCell(REST_LIMIT).setValue((Object)restAmt);
            }
            map.put(USE_TOTAL, ((BigDecimal)map.get(USE_TOTAL)).add(userAmt));
            map.put(REST_LIMIT, ((BigDecimal)map.get(REST_LIMIT)).add(restAmt));
        }
        if (this.kdt.getRowCount3() > 0) {
            IRow rowTotal = this.kdt.addRow();
            for (Map.Entry entry : map.entrySet()) {
                if (((BigDecimal)entry.getValue()).compareTo(Constants.ZERO) != 0) {
                    rowTotal.getCell((String)entry.getKey()).setValue(entry.getValue());
                } else {
                    String colKey = (String)entry.getKey();
                    if (colKey.equals(COMPANY_NAME) || colKey.equals(LIMIT_AMT_LOCAL) || colKey.equals(USE_TOTAL) || colKey.equals(REST_LIMIT)) {
                        this.kdt.getColumn(colKey).getStyleAttributes().setHided(false);
                    } else {
                        this.kdt.getColumn(colKey).getStyleAttributes().setHided(true);
                    }
                }
                rowTotal.getCell(COMPANY_NAME).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"384_RptCreditLimitUsedUIHandler"));
            }
        }
    }

    public void endDataFill() {
        String formatSting = FMClientHelper.getNumberFtm((int)this.precision);
        if (this.kdt.getColumnCount() > 0) {
            for (int i = 0; i < this.dataColumn.length; ++i) {
                this.kdt.getColumn(this.dataColumn[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                this.kdt.getColumn(this.dataColumn[i]).getStyleAttributes().setNumberFormat(formatSting);
            }
        }
        if (this.kdt.getRowCount3() > 0) {
            this.kdt.getRow(this.kdt.getRowCount3() - 1).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        }
        this.kdt.getColumn(USE_TOTAL).getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        super.endDataFill();
    }
}

