/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMDetailRptBaseHandler;
import com.kingdee.eas.fm.ctl.RptLetterOfGuaranteeDetailFacadeFactory;
import com.kingdee.eas.fm.fin.FinBaseDataException;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.RptLoanDetailFilterParam;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntRateStateEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class RptLoanDetailBaseHandler
extends FMDetailRptBaseHandler {
    public static final String resourcePath = "com.kingdee.eas.fm.fin.client.RptLoanDetailResource";
    private static String yes = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"Yes");
    private static String no = EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"No");
    protected BigDecimal amountUnit = null;
    protected boolean isViewLongTime = false;
    protected static boolean FIN022 = false;
    protected RptLoanDetailFilterParam param;
    protected BigDecimal totalBankLocalAmount = SysConstant.BIGZERO;
    protected BigDecimal totalBankReturnAmount = SysConstant.BIGZERO;
    protected BigDecimal totalBankBalanceAmount = SysConstant.BIGZERO;
    protected BigDecimal totalNoBankLocalAmount = SysConstant.BIGZERO;
    protected BigDecimal totalNoBankReturnAmount = SysConstant.BIGZERO;
    protected BigDecimal totalNoBankBalanceAmount = SysConstant.BIGZERO;
    protected BigDecimal longTotalBankLocalAmount = SysConstant.BIGZERO;
    protected BigDecimal longTotalBankReturnAmount = SysConstant.BIGZERO;
    protected BigDecimal longTotalBankBalanceAmount = SysConstant.BIGZERO;
    protected BigDecimal longTotalNoBankLocalAmount = SysConstant.BIGZERO;
    protected BigDecimal longTotalNoBankReturnAmount = SysConstant.BIGZERO;
    protected BigDecimal longTotalNoBankBalanceAmount = SysConstant.BIGZERO;
    protected BigDecimal noLongShortLoanTotalLocalAmt = Constants.ZERO;
    protected BigDecimal noLongShortReturnTotalLocalAmt = Constants.ZERO;
    protected BigDecimal noLongShortBalanceTotalLocalAmt = Constants.ZERO;
    private HashMap GuaranteeMap = new HashMap();
    private CurrencyInfo rateCurrency = null;

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    public RptLoanDetailBaseHandler(RptLoanDetailFilterParam param, KDTable kdt) {
        super(param.getFilter(), kdt);
        this.amountUnit = new BigDecimal(String.valueOf(param.getUnit().getValue()));
        this.isViewLongTime = param.isIsViewLongTime();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FIN022 = ContextHelperFactory.getRemoteInstance().getBooleanParam("FIN022", (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()));
        this.param = param;
        try {
            this.GuaranteeMap = this.getGurantee();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rateCurrency = param.getCurrency();
    }

    protected String getQueryPath() {
        return "com.kingdee.eas.fm.fin.app.RptLoanDetailQuery";
    }

    public void endDataFill() {
        super.endDataFill();
        this.setTotalString();
        this.kdt.getSelectManager().setSelectMode(2);
        this.kdt.getColumn("intRateTypeExpression").getStyleAttributes().setHided(true);
    }

    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        super.filldata(rs);
        String preID = "";
        java.util.Date dateTo = this.param.getDateTo();
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        String dformat = FMHelper.getDateFormatString();
        this.kdt.getColumn("issueDate").getStyleAttributes().setNumberFormat(dformat);
        this.kdt.getColumn("expiredDate").getStyleAttributes().setNumberFormat(dformat);
        this.kdt.getColumn("repaymentDate").getStyleAttributes().setNumberFormat(dformat);
        HashSet<String> loanIdSet = new HashSet<String>();
        while (rs.next()) {
            String loanId = rs.getString("id");
            loanIdSet.add(loanId);
        }
        Map<Object, Object> newRateMap = new HashMap(rs.size() << 2);
        if (loanIdSet.size() > 0) {
            newRateMap = FinHelper.getRateMap(loanIdSet);
        }
        rs.beforeFirst();
        while (rs.next()) {
            String tmpID = rs.getString("id");
            IRow row = this.kdt.addRow();
            String isLongTime = "";
            String isBankLoan = "";
            if (!this.isViewLongTime) {
                isLongTime = rs.getString("isLongTime");
                row.getCell("isLongTime").setValue((Object)isLongTime);
                isBankLoan = rs.getString("IsBankLoan");
                row.getCell("isBankLoan").setValue((Object)isBankLoan);
            }
            row.getCell("acBankAct").setValue((Object)rs.getString("bankacctName"));
            row.getCell("acAmt").setValue((Object)rs.getBigDecimal("cautionAmt").divide(this.amountUnit, 10, 4));
            row.getCell("acAmtPre").setValue((Object)rs.getBigDecimal("auctionPerc"));
            row.getCell("acAmtRepay").setValue((Object)rs.getBigDecimal("cautionAmtRepay").divide(this.amountUnit, 10, 4));
            row.getCell("company").setValue((Object)rs.getString("CompanyName"));
            row.getCell("bank").setValue((Object)rs.getString("InstitutionName"));
            row.getCell("creditorGroup").setValue((Object)rs.getString("CreditorGroupName"));
            row.getCell("financingProductsType").setValue((Object)rs.getString("financingProductsType"));
            row.getCell("currency").setValue((Object)rs.getString("CurrencyName"));
            row.getCell("number").setValue((Object)rs.getString("number"));
            row.getCell("contractNum").setValue((Object)rs.getString("contractNum"));
            BigDecimal contractAmt = EmptyUtil.isEmpty((Object)rs.getBigDecimal("contractAmt")) ? Constants.ZERO : rs.getBigDecimal("contractAmt");
            row.getCell("contractAmt").setValue((Object)contractAmt.divide(this.amountUnit, 10, 4));
            row.getCell("amount").setValue((Object)rs.getBigDecimal("Amount").divide(this.amountUnit, 10, 4));
            BigDecimal localAmount = Constants.ZERO;
            BigDecimal localBalance = Constants.ZERO;
            BigDecimal returnAmount = Constants.ZERO;
            if (!EmptyUtil.isEmpty((CoreBaseInfo)this.rateCurrency)) {
                String currencyid = rs.getString("currencyid");
                BigDecimal rate = null;
                if (rateMap.containsKey(currencyid)) {
                    rate = (BigDecimal)rateMap.get(currencyid);
                } else {
                    if (currencyid.equals(this.rateCurrency.getId().toString())) {
                        rate = Constants.ONE;
                    } else {
                        CurrencyInfo currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
                        ExchangeRateInfo rateInfo = FMHelper.getExRateInfo((CurrencyInfo)currency, (CurrencyInfo)this.rateCurrency, (CompanyOrgUnitInfo)company, (java.util.Date)dateTo);
                        if (EmptyUtil.isEmpty((CoreBaseInfo)rateInfo)) {
                            throw new FinBaseDataException(FinBaseDataException.EXCEPTIONEXHANGERATE, new Object[]{currency.getName(), this.rateCurrency.getName()});
                        }
                        rate = ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)rateInfo.getConvertMode()) ? Constants.ONE.divide(rateInfo.getConvertRate(), 20, 4) : rateInfo.getConvertRate();
                    }
                    rateMap.put(currencyid, rate);
                }
                row.getCell("localCurExRate").setValue((Object)rate);
                localAmount = rs.getBigDecimal("Amount").multiply(rate).divide(this.amountUnit, 10, 4);
                row.getCell("amountLocalCur").setValue((Object)localAmount);
                localBalance = rs.getBigDecimal("Balance").multiply(rate).divide(this.amountUnit, 10, 4);
                row.getCell("localCurBalance").setValue((Object)localBalance);
                returnAmount = rs.getBigDecimal("returnAmount").multiply(rate).divide(this.amountUnit, 10, 4);
                row.getCell("returnAmount").setValue((Object)returnAmount);
            } else {
                row.getCell("localCurExRate").setValue((Object)rs.getBigDecimal("LocalCurExRate"));
                localAmount = rs.getBigDecimal("AmountLocalCur").divide(this.amountUnit, 10, 4);
                row.getCell("amountLocalCur").setValue((Object)localAmount);
                localBalance = rs.getBigDecimal("localCurBalance").divide(this.amountUnit, 10, 4);
                row.getCell("localCurBalance").setValue((Object)localBalance);
                returnAmount = rs.getBigDecimal("returnAmount").multiply(rs.getBigDecimal("LocalCurExRate")).divide(this.amountUnit, 10, 4);
                row.getCell("returnAmount").setValue((Object)returnAmount);
            }
            row.getCell("balance").setValue((Object)rs.getBigDecimal("Balance").divide(this.amountUnit, 10, 4));
            row.getCell("issueDate").setValue((Object)rs.getDate("IssueDate"));
            row.getCell("expiredDate").setValue((Object)rs.getDate("ExpiredDate"));
            row.getCell("horizon").setValue((Object)rs.getString("Horizon"));
            row.getCell("planRepayment").setValue((Object)rs.getString("FPlanRepay"));
            row.getCell("repaymentDate").setValue((Object)rs.getDate("repaymentDate"));
            if (rs.getBigDecimal("repaymentAmount") != null) {
                row.getCell("repaymentAmount").setValue((Object)rs.getBigDecimal("repaymentAmount").divide(this.amountUnit, 10, 4));
            }
            row.getCell("yieldRate").setValue((Object)rs.getBigDecimal("YieldRate"));
            if (newRateMap.get(tmpID) != null) {
                row.getCell("newYieldRate").setValue(newRateMap.get(tmpID));
            } else {
                row.getCell("newYieldRate").setValue((Object)rs.getBigDecimal("YieldRate"));
            }
            row.getCell("intRateTypeExpression").setValue((Object)rs.getString("intRateTypeExpression"));
            row.getCell("intRateType").setValue((Object)rs.getString("IntRateTypeName"));
            row.getCell("basePoints").setValue((Object)rs.getBigDecimal("BasePoints"));
            row.getCell("garanteeType").setValue((Object)rs.getString("GaranteeTypeName"));
            row.getCell("garantee").setValue(this.GuaranteeMap.get(tmpID));
            row.getCell("isInCredit").setValue((Object)(rs.getBoolean("IsInCredit") ? yes : no));
            if (rs.getBigDecimal("finFee") != null) {
                row.getCell("finFee").setValue((Object)rs.getBigDecimal("finFee").divide(this.amountUnit, 10, 4));
            }
            row.getCell("project").setValue((Object)rs.getString("project"));
            row.getCell("remark").setValue((Object)rs.getString("remark"));
            row.getCell("RepaymentSource").setValue((Object)rs.getString("RepaymentSource"));
            row.getCell("handlerRemark").setValue((Object)rs.getString("handlerRemark"));
            row.getCell("description").setValue((Object)rs.getString("description"));
            row.getCell("floatAction").setValue((Object)FloatActionEnum.getEnum(Integer.parseInt(rs.getString("FloatAction"))));
            row.getCell("rateAdjustPeriod").setValue((Object)(rs.getBigDecimal("rateAdjustPeriod") + this.getResString("month")));
            row.getCell("payIntMode").setValue((Object)rs.getString("intSchme"));
            row.getCell("bankAccountNum").setValue((Object)rs.getString("bankAccountNum"));
            row.getCell("lastintDate").setValue((Object)rs.getDate("lastintDate"));
            row.setUserObject((Object)tmpID);
            preID = this.setTotalAmount(preID, tmpID, isLongTime, isBankLoan, localAmount, localBalance, returnAmount);
            if (!FIN022) continue;
            if (rs.getBigDecimal("conAddAmount") != null) {
                row.getCell("addAmount").setValue((Object)rs.getBigDecimal("conAddAmount").divide(this.amountUnit, 10, 4));
            }
            if (rs.getBigDecimal("conRemainAmount") == null) continue;
            row.getCell("remainAmount").setValue((Object)rs.getBigDecimal("conRemainAmount").divide(this.amountUnit, 10, 4));
        }
    }

    private String setTotalAmount(String preID, String tmpID, String isLongTime, String isBankLoan, BigDecimal localAmount, BigDecimal localBalance, BigDecimal returnAmount) {
        if (!preID.equals(tmpID)) {
            preID = tmpID;
            if (isLongTime.equals(this.getResString("shortLoan"))) {
                if (isBankLoan.equals(this.getResString("bankLoan"))) {
                    this.totalBankLocalAmount = this.totalBankLocalAmount.add(localAmount);
                    this.totalBankBalanceAmount = this.totalBankBalanceAmount.add(localBalance);
                    this.totalBankReturnAmount = this.totalBankReturnAmount.add(returnAmount);
                } else {
                    this.totalNoBankLocalAmount = this.totalNoBankLocalAmount.add(localAmount);
                    this.totalNoBankBalanceAmount = this.totalNoBankBalanceAmount.add(localBalance);
                    this.totalNoBankReturnAmount = this.totalNoBankReturnAmount.add(returnAmount);
                }
            } else if (isLongTime.equals(this.getResString("zcqloan"))) {
                if (isBankLoan.equals(this.getResString("bankLoan"))) {
                    this.longTotalBankLocalAmount = this.longTotalBankLocalAmount.add(localAmount);
                    this.longTotalBankBalanceAmount = this.longTotalBankBalanceAmount.add(localBalance);
                    this.longTotalBankReturnAmount = this.longTotalBankReturnAmount.add(returnAmount);
                } else {
                    this.longTotalNoBankLocalAmount = this.longTotalNoBankLocalAmount.add(localAmount);
                    this.longTotalNoBankBalanceAmount = this.longTotalNoBankBalanceAmount.add(localBalance);
                    this.longTotalNoBankReturnAmount = this.longTotalNoBankReturnAmount.add(returnAmount);
                }
            }
        }
        return preID;
    }

    private void setTotalString() {
        String preId = "";
        String tmpId = "";
        BigDecimal noLongShortLoanSubTotalLocalAmt = Constants.ZERO;
        BigDecimal noLongShortReturnSubTotalLocalAmt = Constants.ZERO;
        BigDecimal noLongShortBalanceSubTotalLocalAmt = Constants.ZERO;
        BigDecimal noLongShortLoanTotalLocalAmt = Constants.ZERO;
        BigDecimal noLongShortReturnTotalLocalAmt = Constants.ZERO;
        BigDecimal noLongShortBalanceTotalLocalAmt = Constants.ZERO;
        BigDecimal amt = Constants.ZERO;
        int n = this.kdt.getRowCount();
        for (int i = 0; i < n; ++i) {
            String rateExpression;
            IRow iRow = this.kdt.getRow(i);
            tmpId = (String)iRow.getUserObject();
            if (!preId.equals(tmpId) && !iRow.isStat()) {
                amt = (BigDecimal)iRow.getCell("amountLocalCur").getValue();
                noLongShortLoanSubTotalLocalAmt = noLongShortLoanSubTotalLocalAmt.add(amt);
                noLongShortLoanTotalLocalAmt = noLongShortLoanTotalLocalAmt.add(amt);
                amt = (BigDecimal)iRow.getCell("returnAmount").getValue();
                noLongShortReturnSubTotalLocalAmt = noLongShortReturnSubTotalLocalAmt.add(amt);
                noLongShortReturnTotalLocalAmt = noLongShortReturnTotalLocalAmt.add(amt);
                amt = (BigDecimal)iRow.getCell("localCurBalance").getValue();
                noLongShortBalanceSubTotalLocalAmt = noLongShortBalanceSubTotalLocalAmt.add(amt);
                noLongShortBalanceTotalLocalAmt = noLongShortBalanceTotalLocalAmt.add(amt);
                preId = tmpId;
            }
            Object s = null;
            if (iRow.isStat()) {
                if (iRow.getTreeLevel() == 1) {
                    String isLongTime2 = "";
                    String isBankLoan2 = "";
                    if (this.kdt.getRow(i - 2) != null && !this.isViewLongTime) {
                        isLongTime2 = (String)this.kdt.getRow(i - 2).getCell("isLongTime").getValue();
                        isBankLoan2 = (String)this.kdt.getRow(i - 2).getCell("isBankLoan").getValue();
                    }
                    if (isLongTime2.equals(this.getResString("zcqloan"))) {
                        if (isBankLoan2.equals(this.getResString("bankLoan"))) {
                            iRow.getCell("amountLocalCur").setValue((Object)this.longTotalBankLocalAmount);
                            iRow.getCell("returnAmount").setValue((Object)this.longTotalBankReturnAmount);
                            iRow.getCell("localCurBalance").setValue((Object)this.longTotalBankBalanceAmount);
                        }
                        if (isBankLoan2.equals(this.getResString("nonBankLoan"))) {
                            iRow.getCell("amountLocalCur").setValue((Object)this.longTotalNoBankLocalAmount);
                            iRow.getCell("returnAmount").setValue((Object)this.longTotalNoBankReturnAmount);
                            iRow.getCell("localCurBalance").setValue((Object)this.longTotalNoBankBalanceAmount);
                        }
                    } else if (isLongTime2.equals(this.getResString("shortLoan"))) {
                        if (isBankLoan2.equals(this.getResString("bankLoan"))) {
                            iRow.getCell("amountLocalCur").setValue((Object)this.totalBankLocalAmount);
                            iRow.getCell("returnAmount").setValue((Object)this.totalBankReturnAmount);
                            iRow.getCell("localCurBalance").setValue((Object)this.totalBankBalanceAmount);
                        }
                        if (isBankLoan2.equals(this.getResString("nonBankLoan"))) {
                            iRow.getCell("amountLocalCur").setValue((Object)this.totalNoBankLocalAmount);
                            iRow.getCell("returnAmount").setValue((Object)this.totalNoBankReturnAmount);
                            iRow.getCell("localCurBalance").setValue((Object)this.totalNoBankBalanceAmount);
                        }
                    } else {
                        iRow.getCell("amountLocalCur").setValue((Object)noLongShortLoanSubTotalLocalAmt);
                        iRow.getCell("returnAmount").setValue((Object)noLongShortReturnSubTotalLocalAmt);
                        iRow.getCell("localCurBalance").setValue((Object)noLongShortBalanceSubTotalLocalAmt);
                        noLongShortLoanSubTotalLocalAmt = Constants.ZERO;
                        noLongShortReturnSubTotalLocalAmt = Constants.ZERO;
                        noLongShortBalanceSubTotalLocalAmt = Constants.ZERO;
                    }
                }
                if (iRow.getTreeLevel() == 0) {
                    String isLongTime3 = "";
                    if (this.kdt.getRow(i - 3) != null && !this.isViewLongTime) {
                        isLongTime3 = (String)this.kdt.getRow(i - 3).getCell("isLongTime").getValue();
                    }
                    if (isLongTime3.equals(this.getResString("zcqloan"))) {
                        iRow.getCell("amountLocalCur").setValue((Object)this.longTotalNoBankLocalAmount.add(this.longTotalBankLocalAmount));
                        iRow.getCell("returnAmount").setValue((Object)this.longTotalNoBankReturnAmount.add(this.longTotalBankReturnAmount));
                        iRow.getCell("localCurBalance").setValue((Object)this.longTotalNoBankBalanceAmount.add(this.longTotalBankBalanceAmount));
                    } else if (isLongTime3.equals(this.getResString("shortLoan"))) {
                        iRow.getCell("amountLocalCur").setValue((Object)this.totalNoBankLocalAmount.add(this.totalBankLocalAmount));
                        iRow.getCell("returnAmount").setValue((Object)this.totalNoBankReturnAmount.add(this.totalBankReturnAmount));
                        iRow.getCell("localCurBalance").setValue((Object)this.totalNoBankBalanceAmount.add(this.totalBankBalanceAmount));
                    } else {
                        iRow.getCell("amountLocalCur").setValue((Object)noLongShortLoanTotalLocalAmt);
                        iRow.getCell("returnAmount").setValue((Object)noLongShortReturnTotalLocalAmt);
                        iRow.getCell("localCurBalance").setValue((Object)noLongShortBalanceTotalLocalAmt);
                    }
                }
            }
            if (iRow.getCell("intRateTypeExpression").getValue() == null || (rateExpression = iRow.getCell("intRateTypeExpression").getValue().toString()) == null) continue;
            if (rateExpression.equals("year")) {
                iRow.getCell("yieldRate").getStyleAttributes().setNumberFormat("###,##0.00000\\%");
                iRow.getCell("newYieldRate").getStyleAttributes().setNumberFormat("###,##0.00000\\%");
                continue;
            }
            iRow.getCell("yieldRate").getStyleAttributes().setNumberFormat("###,##0.00000\\\u2030");
            iRow.getCell("newYieldRate").getStyleAttributes().setNumberFormat("###,##0.00000\\\u2030");
        }
    }

    public void initHeader() {
        super.initHeader();
        this.insertHeadRow();
        this.formatHeadRow();
    }

    protected abstract void insertHeadRow();

    protected void formatHeadRow() {
        IRow headRow = this.kdt.addHeadRow();
        if (!this.isViewLongTime) {
            headRow.getCell("isLongTime").setValue((Object)this.getResString("isLongTime"));
            headRow.getCell("isBankLoan").setValue((Object)this.getResString("isBankLoan"));
        }
        headRow.getCell("acBankAct").setValue((Object)this.getResString("assureAccount"));
        headRow.getCell("acAmt").setValue((Object)this.getResString("assureAmount"));
        headRow.getCell("company").setValue((Object)this.getResString("company"));
        headRow.getCell("bank").setValue((Object)this.getResString("bank"));
        headRow.getCell("creditorGroup").setValue((Object)this.getResString("creditorGroup"));
        headRow.getCell("financingProductsType").setValue((Object)this.getResString("financingProductsType"));
        headRow.getCell("currency").setValue((Object)this.getResString("currency"));
        headRow.getCell("number").setValue((Object)this.getResString("number"));
        headRow.getCell("contractNum").setValue((Object)this.getResString("contractNum"));
        headRow.getCell("contractAmt").setValue((Object)this.getResString("contractAmt"));
        headRow.getCell("amount").setValue((Object)this.getResString("amount"));
        headRow.getCell("localCurExRate").setValue((Object)this.getResString("localCurExRate"));
        headRow.getCell("amountLocalCur").setValue((Object)this.getResString("amountLocalCur"));
        headRow.getCell("balance").setValue((Object)this.getResString("balance"));
        headRow.getCell("localCurBalance").setValue((Object)this.getResString("localCurBalance"));
        headRow.getCell("returnAmount").setValue((Object)this.getResString("returnAmount"));
        headRow.getCell("issueDate").setValue((Object)this.getResString("issueDate"));
        headRow.getCell("expiredDate").setValue((Object)this.getResString("expiredDate"));
        headRow.getCell("horizon").setValue((Object)this.getResString("horizon"));
        headRow.getCell("intRateTypeExpression").setValue((Object)this.getResString("intRateTypeExpression"));
        headRow.getCell("yieldRate").setValue((Object)this.getResString("yieldRate"));
        headRow.getCell("newYieldRate").setValue((Object)this.getResString("newYieldRate"));
        headRow.getCell("intRateType").setValue((Object)this.getResString("intRateType"));
        headRow.getCell("basePoints").setValue((Object)this.getResString("basePoints"));
        headRow.getCell("garanteeType").setValue((Object)this.getResString("garanteeType"));
        headRow.getCell("garantee").setValue((Object)this.getResString("garantee"));
        headRow.getCell("isInCredit").setValue((Object)this.getResString("isInCredit"));
        headRow.getCell("finFee").setValue((Object)this.getResString("finFee"));
        headRow.getCell("project").setValue((Object)this.getResString("project"));
        headRow.getCell("remark").setValue((Object)this.getResString("loanUse"));
        headRow.getCell("RepaymentSource").setValue((Object)this.getResString("repaySource"));
        headRow.getCell("handlerRemark").setValue((Object)this.getResString("handlerRemark"));
        headRow.getCell("description").setValue((Object)this.getResString("description"));
        headRow.getCell("planRepayment").setValue((Object)this.getResString("planRepayment"));
        headRow.getCell("repaymentDate").setValue((Object)this.getResString("repaymentDate"));
        headRow.getCell("repaymentAmount").setValue((Object)this.getResString("repaymentAmount"));
        headRow.getCell("acAmtPre").setValue((Object)this.getResString("assureRate"));
        headRow.getCell("acAmtRepay").setValue((Object)this.getResString("assureRepay"));
        headRow.getCell("floatAction").setValue((Object)this.getResString("floatAction"));
        headRow.getCell("rateAdjustPeriod").setValue((Object)this.getResString("rateAdjustPeriod"));
        headRow.getCell("payIntMode").setValue((Object)this.getResString("payIntMode"));
        headRow.getCell("bankAccountNum").setValue((Object)this.getResString("bankAccountNumber"));
        headRow.getCell("lastintDate").setValue((Object)this.getResString("lastintDate"));
        if (FIN022) {
            headRow.getCell("addAmount").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"390_RptLoanDetailBaseHandler"));
            headRow.getCell("remainAmount").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"391_RptLoanDetailBaseHandler"));
        }
    }

    protected static void initDecimalCol(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    protected static void initDecimalCol4Pre(IColumn col) {
        col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        col.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.##########");
    }

    protected static void initDecimalCell(ICell cell) {
        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        cell.getStyleAttributes().setNumberFormat("##,###,###,###,###,##0.00");
    }

    public IRowSet getRowSet() throws BOSException {
        String orderBy;
        BigDecimal unitValue;
        String debteeState;
        StringBuffer sb = new StringBuffer();
        StringBuffer sb1 = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        StringBuffer sb3 = new StringBuffer();
        StringBuffer sb4 = new StringBuffer();
        StringBuffer sb5 = new StringBuffer();
        StringBuffer sb6 = new StringBuffer();
        String billState = IntRateStateEnum.AUDITED.getValue();
        sb1.append("select loan.FHorizon,ints.fname_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as intSchme,loan.FRateAdjustPeriod as rateAdjustPeriod ,loan.FFloatAction as FloatAction,");
        sb1.append("  loan.FID as id,case when loan.FHorizon >12 then '").append(this.getResString("zcqloan")).append("' else '").append(this.getResString("shortLoan")).append("' end as isLongTime, \n");
        sb1.append(" bankaccount.FBankAccountNumber as bankAccountNum,loan.FLastintDate as lastintDate, ");
        sb1.append(" case when loan.FHorizon >12 then '1' else '2' end as isLongTimeCount, \n");
        sb1.append(" bankacct.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as bankacctName,loan.FCautionAmt as cautionAmt,\n");
        sb1.append(" loan.FAuctionPerc as auctionPerc,case when loan.FcautionAmtRepay is null then 0 else loan.FcautionAmtRepay end as cautionAmtRepay,\n");
        sb1.append(" case when loan.FIsBankLoan = 1 then '").append(this.getResString("bankLoan")).append("' else '").append(this.getResString("nonBankLoan")).append("' end as IsBankLoan,");
        sb1.append(" case when loan.FIsBankLoan = 1 then '1' else '2' end as IsBankLoanCount,");
        sb1.append(" company.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as CompanyName,isnull (bank.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(",groupid.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(") as InstitutionName,\n");
        sb1.append(" ctGroup.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as CreditorGroupName,finProducts.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as financingProductsType,currency.Fid as currencyid, currency.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as currencyName,loan.FNumber as number,\n");
        sb1.append(" loan.FContractNum as contractNum,");
        if (FIN022) {
            sb1.append("contract.FAMOUNT as contractAmt,");
        } else {
            sb1.append("MainConLoan.FConAmount as contractAmt,");
        }
        sb1.append("loan.FAmount as Amount,loan.FLocalCurExRate as LocalCurExRate,\n");
        sb1.append(" GuaranteeType.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as GaranteeTypeName,");
        sb1.append(" loan.FAmountLocalCur as AmountLocalCur,\n");
        sb1.append(" (loan.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and loan.fid=B.FLoanID)) as Balance,\n");
        sb1.append(" (loan.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and loan.fid=B.FLoanID))*loan.FLocalCurExRate as localCurBalance,\n");
        sb1.append(" (loan.famount - loan.fbalance - (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate > ? and loan.fid=B.FLoanID)) as returnAmount,\n");
        sb1.append(" loan.FIssueDate as IssueDate,loan.FExpiredDate as ExpiredDate,\n");
        sb1.append(" loan.FHorizon as Horizon,loan.FYieldRate as YieldRate,loan.FIntRateTypeExpression as intRateTypeExpression,\n");
        sb1.append(" intRateType.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" as IntRateTypeName,loan.FBasePoints as BasePoints,loan.FIsInCredit as IsInCredit,\n");
        sb1.append(" loan.FRemark remark,project.FName_").append(SysContext.getSysContext().getLocale().getLanguage()).append(" project,finFeeBill.finFee as finFee,\n");
        sb1.append(" loan.FHandlerRemark as handlerRemark,loan.FDescription as description,\n");
        sb1.append(" case when loan.FFLOATACTION = 1 then isnull((case when loan.FIntRateTypeID ='lJlpCQEQEADgAAc+wKgSjiR9knQ=' then XIEXIRate.FAdjustAfterRate else IntRate.FYearRate end),loan.FYieldRate)*(1+loan.FBasePoints/100)   else isnull((case when loan.FIntRateTypeID ='lJlpCQEQEADgAAc+wKgSjiR9knQ=' then XIEXIRate.FAdjustAfterRate else IntRate.FYearRate end),loan.FYieldRate) +loan.FBasePoints end as newYieldRate, \n");
        sb1.append(" loan.FRepaymentSource as RepaymentSource, \n");
        if (FIN022) {
            sb1.append("contract.FConAddAmount as conAddAmount,");
            sb1.append("contract.FConRemainAmount as conRemainAmount, \n");
        }
        sb2.append(" loanEntry.FDate as repaymentDate,loanEntry.FAmount as repaymentAmount,'").append(this.getResString("repayPlan")).append("' FPlanRepay \n");
        sb3.append(" repayment.FBizDate as repaymentDate,repayment.FAmount as repaymentAmount,'").append(this.getResString("actualRepay")).append("' FPlanRepay \n");
        sb4.append(" from t_fin_loan as loan left join t_org_company as company on loan.FCompanyID = company.FID \n");
        sb4.append(" left join t_bd_bank as bank on loan.FInstitutionID = bank.FID \n");
        sb4.append(" left join T_BD_AccountBanks as bankacct on loan.FCautionAcctBankID = bankacct.FID \n");
        sb4.append(" left join T_BD_AccountBanks as bankaccount on loan.FBankAcctid = bankaccount.FID \n");
        sb4.append(" left join t_org_company as groupid on loan.FGroupId = groupid.FID \n");
        sb4.append(" left join t_fin_CreditorGroup as ctGroup on loan.FCreditorGroupID = ctGroup.FID \n");
        sb4.append(" left join t_bd_currency as currency on loan.FCurrencyID = currency.FID \n");
        sb4.append(" left join t_fin_GuaranteeType as GuaranteeType on loan.FGaranteeTypeID = GuaranteeType.FID \n");
        sb4.append(" left join t_int_IntRateType as intRateType on loan.FIntRateTypeID = intRateType.FID \n");
        sb4.append(" left join t_bd_Project as project on loan.FProjectID = project.FID \n");
        if (FIN022) {
            sb4.append(" left join T_FIN_LoanContract as contract on loan.FLOANCONTRACTID = contract.fid \n");
        } else {
            sb4.append(" left join t_fin_MainConLoan as MainConLoan on loan.FMainConLoanID = MainConLoan.FID \n");
        }
        sb4.append(" left join (select FSourceBillID, sum(FLocalCurAmount) as finFee from t_fin_financingFeeBill group by FSourceBillID) as finFeeBill on loan.FID = finFeeBill.FSourceBillID \n");
        sb4.append(" left join ( \n");
        sb4.append(" select A.FID,C.FAdjustAfterRate \n");
        sb4.append(" from T_Fin_Loan as A ,(select  max(FAdjustSeq)  as FAdjustSeq ,A.FID from T_Fin_LoanAdjustInterest as B, T_Fin_Loan as A \n");
        sb4.append(" where A.FID = B.FLoanId and B.FADJUSTDATE <= CURDATE() group by A.FID) as B ,T_Fin_LoanAdjustInterest as C \n");
        sb4.append(" where A.FID = B.FID and C.FAdjustSeq = B.FAdjustSeq and C.FLoanID = B.FID \n");
        sb4.append(" ) as XIEXIRate on loan.FID = XIEXIRate.FID \n");
        sb4.append(" left join ( \n");
        sb4.append(" select A.FID,C.FYearRate from T_Fin_Loan as A,( \n");
        sb4.append(" select max(Base.FEffectiveDate) as FEffectiveDate,Base.FCurrencyID,Type.FID from T_INT_IntRateBase as Base,T_INT_IntRateType as Type \n");
        sb4.append(" where Base.FTypeID = Type.FID and Base.FEffectiveDate <= CURDATE() ");
        sb4.append(" and Base.FbillState = '" + billState + "'");
        sb4.append(" group by Base.FCurrencyID,Type.FID) as B,T_INT_IntRateBase as C \n");
        sb4.append(" where A.FIntRateTypeID = B.FID and A.FCurrencyID = B.FCurrencyID \n");
        sb4.append(" and C.FbillState = '" + billState + "'");
        sb4.append("\tand C.FTypeID = B.FID and C.FEffectiveDate = B.FEffectiveDate and A.FcurrencyId = c.FcurrencyId \n");
        sb4.append(" ) as IntRate on loan.FID = IntRate.FID \n");
        sb4.append(" left join t_fin_FinancingProducts as finProducts on loan.FTypeID = finProducts.FID \n");
        sb5.append(" left join t_fin_loanEntry as loanEntry on loan.FID = loanEntry.FParentID \n");
        sb5.append("   left join T_INT_IntScheme as ints on loan.FPayIntModeID = ints.FID   \n");
        sb6.append(" left join t_fin_repayment as repayment on loan.FID = repayment.FSourceBillID \n");
        sb6.append("   left join T_INT_IntScheme as ints on loan.FPayIntModeID = ints.FID   \n");
        StringBuffer sbWhere = new StringBuffer();
        sbWhere.append(" where 1=1  ");
        ArrayList<Comparable<java.util.Date>> paramList = new ArrayList<Comparable<java.util.Date>>();
        Set companyIdSet = this.param.getCompanyIdSet();
        Set bankIdSet = this.param.getBankIdSet();
        Set finProductTypeIdSet = this.param.getFinProductTypeIdSet();
        java.util.Date dateFrom = this.param.getDateFrom();
        if (dateFrom == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(1, 1900);
            cal.set(2, 0);
            cal.set(5, 1);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            dateFrom = Date.valueOf(sdf.format(cal.getTime()));
        }
        java.util.Date dateTo = this.param.getDateTo();
        paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
        paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
        paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
        AmountUnitEnum amountUnit = this.param.getUnit();
        BigDecimal amount = this.param.getAmount();
        boolean isViewZeroOfBalance = this.param.isIsViewZeroOfBalance();
        if (companyIdSet != null && companyIdSet.size() > 0) {
            sbWhere.append(" and ").append(FMHelper.buildIn((String)" loan.FCompanyID ", (Object[])companyIdSet.toArray()));
        }
        if ((debteeState = this.param.getDebteeState()) != null && !debteeState.equals("1")) {
            if (debteeState.equals("2")) {
                if (bankIdSet != null && bankIdSet.size() >= 1) {
                    sbWhere.append(" and ").append(FMHelper.buildIn((String)" loan.FInstitutionID ", (Object[])bankIdSet.toArray()));
                }
                sbWhere.append(" and loan.FGroupID is null  ");
            } else if (debteeState.equals("3")) {
                if (bankIdSet != null && bankIdSet.size() >= 1) {
                    sbWhere.append(" and ").append(FMHelper.buildIn((String)" loan.FGroupID ", (Object[])bankIdSet.toArray()));
                }
                sbWhere.append(" and loan.FInstitutionID is null ");
            }
        }
        if (this.param.getHorize() != -1) {
            if (this.param.getHorize() == 0) {
                sbWhere.append(" and loan.FHorizon <=12 ");
            } else {
                sbWhere.append(" and loan.FHorizon >12  ");
            }
        }
        if (finProductTypeIdSet != null && finProductTypeIdSet.size() > 0) {
            sbWhere.append(" and ").append(FMHelper.buildIn((String)" loan.FTypeID ", (Object[])finProductTypeIdSet.toArray()));
        }
        this.param.setJoinQuery(false);
        if (this.param.isJoinQuery()) {
            if (dateTo != null) {
                java.util.Date toParam = DateUtil.getNextDay((java.util.Date)this.param.getDateTo());
                sbWhere.append(" and loan.FIssueDate < ? ");
                paramList.add(FMHelper.formatSqlDate((java.util.Date)toParam, (String)"yyyy-MM-dd"));
            }
        } else if (dateTo != null) {
            sbWhere.append(" and loan.FIssueDate<=? ");
            paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
        }
        if (dateFrom != null) {
            sbWhere.append(" and loan.FIssueDate>=? ");
            paramList.add(FMHelper.formatSqlDate((java.util.Date)dateFrom, (String)"yyyy-MM-dd"));
        }
        if (amount != null) {
            sbWhere.append(" and loan.FAmount>=?");
            unitValue = new BigDecimal(String.valueOf(amountUnit.getValue()));
            paramList.add(amount.multiply(unitValue));
        }
        if (!isViewZeroOfBalance) {
            sbWhere.append(" and (loan.FBalance + (select isnull(sum(B.FAmount), 0) from T_FIN_Repayment B where B.FbizDate>? and loan.fid=B.FLoanID))>0");
            paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
        }
        sbWhere.append(" and loan.FISBONDS = 0");
        if (this.param.isIsViewRepayment()) {
            paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
            paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
            paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
            if (dateTo != null) {
                paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
            }
            if (dateFrom != null) {
                paramList.add(FMHelper.formatSqlDate((java.util.Date)dateFrom, (String)"yyyy-MM-dd"));
            }
            if (amount != null) {
                unitValue = new BigDecimal(String.valueOf(amountUnit.getValue()));
                paramList.add(amount.multiply(unitValue));
            }
            if (!isViewZeroOfBalance) {
                paramList.add(FMHelper.formatSqlDate((java.util.Date)dateTo, (String)"yyyy-MM-dd"));
            }
        }
        sb.append(sb1).append(sb3).append(sb4).append(sb6).append(sbWhere);
        if (this.param.isIsViewRepayment()) {
            sb.append(" union all ").append(sb1).append(sb2).append(sb4).append(sb5).append(sbWhere);
        }
        if (!StringUtils.isEmpty((String)(orderBy = this.getOrderByClause()))) {
            sb.append("\n").append(orderBy);
        }
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sb.toString(), paramList.toArray());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
            return null;
        }
    }

    protected abstract String getOrderByClause();

    public HashMap getGurantee() throws BOSException {
        HashMap GuaranteeMap = RptLetterOfGuaranteeDetailFacadeFactory.getRemoteInstance().ReturnGuarantee(this.filterInfo, this.sorter, "t_fin_loan", this.getQueryPath());
        return GuaranteeMap;
    }
}

