/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fin.CycleTypeEnum;
import com.kingdee.eas.fm.fin.LoanPropertyEnum;
import com.kingdee.eas.fm.fin.RptRepaymentDetailFilterParam;
import com.kingdee.eas.fm.fin.client.IRptRepaymentDetailHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Set;

public abstract class RptRepaymentDetailHandlerBase
implements IRptRepaymentDetailHandler {
    protected static final String resourcePath = "com.kingdee.eas.fm.fin.client.RptRepaymentResource";
    protected RptRepaymentDetailFilterParam filterParam = null;
    protected KDTable kdt = null;
    protected BigDecimal localRepaymentAmountTotal = SysConstant.BIGZERO;
    protected int amountUnit;
    private final CompanyOrgUnitInfo companyif = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private Date[] edgeDates;
    private String[] title;
    private int[] ids;
    private String sort;
    private String locale;

    public RptRepaymentDetailHandlerBase(RptRepaymentDetailFilterParam param, KDTable kdt) {
        this.filterParam = param;
        this.kdt = kdt;
    }

    @Override
    public IRowSet getRowSet() throws BOSException {
        int intUnit;
        int i;
        this.prepareForQuery();
        StringBuffer sql = new StringBuffer(4096);
        StringBuffer selector1 = new StringBuffer(2048);
        StringBuffer selector2 = new StringBuffer(2048);
        StringBuffer from1 = new StringBuffer(2048);
        StringBuffer from2 = new StringBuffer(2048);
        StringBuffer filter = new StringBuffer(128);
        StringBuffer filter1 = new StringBuffer(128);
        StringBuffer filter2 = new StringBuffer(256);
        ArrayList paramList = new ArrayList();
        String amount = EASResource.getString((String)resourcePath, (String)"Amount");
        String balance = EASResource.getString((String)resourcePath, (String)"Balance");
        CycleTypeEnum type = this.filterParam.getTimeType();
        boolean isContainBond = this.filterParam.isContainBond();
        if (isContainBond) {
            selector1.append("SELECT \n");
            selector1.append("KEYID, \n");
            selector1.append("CASE WHEN LOANER_ID IS NULL THEN 'XXXXXXXXX' ELSE LOANER_ID END AS LOANER_ID, \n");
            selector1.append("CASE WHEN LOANER_NAME IS NULL THEN N'\u503a\u5238' ELSE LOANER_NAME END AS LOANER_NAME, \n");
            selector1.append("COMPANY_ID,COMPANY_NAME,PARENT_ID,PARENT_NUMBER,PARENT_CONTRACTNUM,TYPE_ID,TYPE_NAME,BANK_NAME,PROJECT_ID, PROJECT_NAME,PARENT_ISSUEDATE, PARENT_EXPIREDDATE,CURRENCY_ID,CURRENCY_NAME, \n");
            selector1.append("PARENT_AMOUNT,PARENT_BALANCE, FORCASTTYPE, REPAYMENTDATE,YYYY,MM,DD,REPAYMENTAMOUNT, LOCALREPAYMENTAMOUNT from ( \n");
        }
        selector1.append("SELECT \n");
        selector1.append("DISTINCT LOANENTRY.FID AS KEYID, \n");
        selector1.append("ISNULL(PARENT.FInstitutionId, PARENT.FGroupId) AS LOANER_ID, \n");
        selector1.append("ISNULL(INSTITUTION.FName_" + this.locale + ", GROUPID.FName_" + this.locale + ") AS LOANER_NAME, \n");
        selector1.append("PARENT.FCompanyID AS COMPANY_ID, \n");
        selector1.append("COMPANY.FName_" + this.locale + " AS COMPANY_NAME, \n");
        selector1.append("PARENT.FID AS PARENT_ID, \n");
        selector1.append("PARENT.FNumber AS PARENT_NUMBER, \n");
        selector1.append("PARENT.FContractNum AS PARENT_CONTRACTNUM, \n");
        selector1.append("PARENT.FTypeID AS TYPE_ID, \n");
        selector1.append("TYPE.FName_" + this.locale + " AS TYPE_NAME, \n");
        selector1.append("Depositary.FName_" + this.locale + " AS BANK_NAME, \n");
        selector1.append("PARENT.FProjectID AS PROJECT_ID, \n");
        selector1.append("PROJECT.FName_" + this.locale + " AS PROJECT_NAME, \n");
        selector1.append("PARENT.FIssueDate AS PARENT_ISSUEDATE, \n");
        selector1.append("PARENT.FExpiredDate AS PARENT_EXPIREDDATE, \n");
        selector1.append("PARENT.FCurrencyID AS CURRENCY_ID, \n");
        selector1.append("CURRENCY.FName_" + this.locale + " AS CURRENCY_NAME, \n");
        selector1.append("PARENT.FAmount AS PARENT_AMOUNT, \n");
        selector1.append("PARENT.FBalance AS PARENT_BALANCE, \n");
        selector1.append("PARENT.FLocalCurExRate AS PARENT_LOCALCUREXRATE,");
        selector1.append("'" + amount + "' AS FORCASTTYPE, \n");
        selector1.append("LOANENTRY.FDate AS REPAYMENTDATE,\n");
        selector1.append("YEAR(LOANENTRY.FDate) AS YYYY,\n");
        if (type == CycleTypeEnum.QUARTER) {
            selector1.append("(FLOOR((MONTH(LOANENTRY.FDate)-1)/3)+1) AS MM,\n");
        } else if (type == CycleTypeEnum.WEEK) {
            selector1.append("case ");
            for (i = 1; i < this.edgeDates.length; ++i) {
                selector1.append("when LOANENTRY.FDate >= {").append(this.date2String(this.edgeDates[i - 1])).append("} and LOANENTRY.FDate < {").append(this.date2String(this.edgeDates[i])).append("} ").append("then '").append(this.ids[i - 1]).append("' ");
            }
            selector1.append("end as MM,\n");
        } else {
            selector1.append("MONTH(LOANENTRY.FDate) AS MM,\n");
        }
        selector1.append("DAYOFYEAR(LOANENTRY.FDate) AS DD,\n");
        selector1.append("LOANENTRY.FAmount AS REPAYMENTAMOUNT, \n");
        selector1.append("(LOANENTRY.FAmount * PARENT.FLocalCurExRate) AS LOCALREPAYMENTAMOUNT \n");
        if (isContainBond) {
            selector2.append("SELECT \n");
            selector2.append("KEYID, \n");
            selector2.append("CASE WHEN LOANER_ID IS NULL THEN 'XXXXXXXXX' ELSE LOANER_ID END AS LOANER_ID, \n");
            selector2.append("CASE WHEN LOANER_NAME IS NULL THEN N'\u503a\u5238' ELSE LOANER_NAME END AS LOANER_NAME, \n");
            selector2.append("COMPANY_ID,COMPANY_NAME,PARENT_ID,PARENT_NUMBER,PARENT_CONTRACTNUM,TYPE_ID,TYPE_NAME,BANK_NAME,PROJECT_ID, PROJECT_NAME,PARENT_ISSUEDATE, PARENT_EXPIREDDATE,CURRENCY_ID,CURRENCY_NAME, \n");
            selector2.append("PARENT_AMOUNT,PARENT_BALANCE, FORCASTTYPE, REPAYMENTDATE,YYYY,MM,DD,REPAYMENTAMOUNT, LOCALREPAYMENTAMOUNT from ( \n");
        }
        selector2.append("SELECT \n");
        selector2.append("DISTINCT INTEREST.FID AS KEYID,\n");
        selector2.append("ISNULL(PARENT.FInstitutionId, PARENT.FGroupId) AS LOANER_ID, \n");
        selector2.append("ISNULL(INSTITUTION.FName_" + this.locale + ", GROUPID.FName_" + this.locale + ") AS LOANER_NAME, \n");
        selector2.append("PARENT.FCompanyID AS COMPANY_ID, \n");
        selector2.append("COMPANY.FName_" + this.locale + " AS COMPANY_NAME, \n");
        selector2.append("PARENT.FID AS PARENT_ID, \n");
        selector2.append("PARENT.FNumber AS PARENT_NUMBER, \n");
        selector2.append("PARENT.FContractNum AS PARENT_CONTRACTNUM, \n");
        selector2.append("PARENT.FTypeID AS TYPE_ID, \n");
        selector2.append("TYPE.FName_" + this.locale + " AS TYPE_NAME, \n");
        selector2.append("Depositary.FName_" + this.locale + " AS BANK_NAME, \n");
        selector2.append("PARENT.FProjectID AS PROJECT_ID, \n");
        selector2.append("PROJECT.FName_" + this.locale + " AS PROJECT_NAME, \n");
        selector2.append("PARENT.FIssueDate AS PARENT_ISSUEDATE, \n");
        selector2.append("PARENT.FExpiredDate AS PARENT_EXPIREDDATE, \n");
        selector2.append("PARENT.FCurrencyID AS CURRENCY_ID, \n");
        selector2.append("CURRENCY.FName_" + this.locale + " AS CURRENCY_NAME, \n");
        selector2.append("PARENT.FAmount AS PARENT_AMOUNT, \n");
        selector2.append("PARENT.FBalance AS PARENT_BALANCE, \n");
        selector2.append("PARENT.FLocalCurExRate AS PARENT_LOCALCUREXRATE,");
        selector2.append("'" + balance + "' AS FORCASTTYPE, \n");
        selector2.append("INTEREST.FBizDate AS REPAYMENTDATE,\n");
        selector2.append("YEAR(INTEREST.FBizDate) AS YYYY,\n");
        if (type == CycleTypeEnum.QUARTER) {
            selector2.append("(FLOOR((MONTH(INTEREST.FBizDate)-1)/3)+1) AS MM,\n");
        } else if (type == CycleTypeEnum.WEEK) {
            selector2.append("case ");
            for (i = 1; i < this.edgeDates.length; ++i) {
                selector2.append("when INTEREST.FBizDate >= {").append(this.date2String(this.edgeDates[i - 1])).append("} and INTEREST.FBizDate < {").append(this.date2String(this.edgeDates[i])).append("} ").append("then '").append(this.ids[i - 1]).append("' ");
            }
            selector2.append("end as MM,\n");
        } else {
            selector2.append("MONTH(INTEREST.FBizDate) AS MM,\n");
        }
        selector2.append("DAYOFYEAR(INTEREST.FBizDate) AS DD,\n");
        selector2.append("INTEREST.FInterest AS REPAYMENTAMOUNT, \n");
        selector2.append("(INTEREST.FInterest * PARENT.FLocalCurExRate) AS LOCALREPAYMENTAMOUNT \n");
        from1.append("FROM T_FIN_LoanEntry AS LOANENTRY");
        from1.append(" \n");
        from1.append("RIGHT OUTER JOIN T_FIN_Loan AS PARENT \n");
        from1.append("ON LOANENTRY.FParentId = PARENT.FID");
        from1.append(" \n");
        from1.append("LEFT OUTER JOIN T_BD_BANK AS Depositary \n");
        from1.append("ON PARENT.FDepositaryID = Depositary.FID ");
        from1.append(" \n");
        from1.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY \n");
        from1.append("ON PARENT.FCompanyID = COMPANY.FID");
        from1.append(" \n");
        from1.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY \n");
        from1.append("ON PARENT.FCurrencyID = CURRENCY.FID");
        from1.append(" \n");
        from1.append("LEFT OUTER JOIN T_ORG_Company AS GROUPID \n");
        from1.append("ON PARENT.FGroupId = GROUPID.FID");
        from1.append(" \n");
        from1.append("LEFT OUTER JOIN T_BD_Bank AS INSTITUTION \n");
        from1.append("ON PARENT.FInstitutionId = INSTITUTION.FID");
        from1.append(" \n");
        from1.append("LEFT OUTER JOIN T_FIN_FinancingProducts AS TYPE \n");
        from1.append("ON PARENT.FTypeID = TYPE.FID");
        from1.append(" \n");
        from1.append("LEFT OUTER JOIN T_BD_Project AS PROJECT \n");
        from1.append("ON PARENT.FProjectID = PROJECT.FID \n");
        from2.append("FROM T_FIN_LoanInterest AS INTEREST,T_FIN_LoanEntry AS LOANENTRY \n");
        from2.append(" \n");
        from2.append("RIGHT OUTER JOIN T_FIN_Loan AS PARENT \n");
        from2.append("ON LOANENTRY.FParentId = PARENT.FID");
        from2.append(" \n");
        from2.append("LEFT OUTER JOIN T_BD_BANK AS Depositary \n");
        from2.append("ON PARENT.FDepositaryID = Depositary.FID ");
        from2.append(" \n");
        from2.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY \n");
        from2.append("ON PARENT.FCompanyID = COMPANY.FID");
        from2.append(" \n");
        from2.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY \n");
        from2.append("ON PARENT.FCurrencyID = CURRENCY.FID");
        from2.append(" \n");
        from2.append("LEFT OUTER JOIN T_ORG_Company AS GROUPID \n");
        from2.append("ON PARENT.FGroupId = GROUPID.FID");
        from2.append(" \n");
        from2.append("LEFT OUTER JOIN T_BD_Bank AS INSTITUTION \n");
        from2.append("ON PARENT.FInstitutionId = INSTITUTION.FID");
        from2.append(" \n");
        from2.append("LEFT OUTER JOIN T_FIN_FinancingProducts AS TYPE \n");
        from2.append("ON PARENT.FTypeID = TYPE.FID");
        from2.append(" \n");
        from2.append("LEFT OUTER JOIN T_BD_Project AS PROJECT \n");
        from2.append("ON PARENT.FProjectID = PROJECT.FID \n");
        filter.append(" WHERE \n");
        filter2.append("AND INTEREST.FLoanID = PARENT.FID\n");
        if (this.companyif != null && GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.companyif) && this.filterParam.getCompanyIdSet() != null && this.filterParam.getCompanyIdSet().size() > 0) {
            filter.append("PARENT.FCompanyID IN ");
            filter.append(FMHelper.setTran2String((Set)this.filterParam.getCompanyIdSet()));
            filter.append(" \n");
        } else if (this.filterParam.getCompanyIdSet() != null && this.filterParam.getCompanyIdSet().size() > 0) {
            filter.append("PARENT.FCompanyID = '");
            filter.append(this.companyif.getId().toString());
            filter.append("' \n");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = this.filterParam.getCurrentDate();
        filter1.append(" AND \n");
        filter1.append("LOANENTRY.FDate >= {ts'" + sdf.format(startDate) + "'}");
        filter1.append(" AND \n");
        filter1.append("LOANENTRY.FDate < {ts'" + sdf.format(this.edgeDates[this.edgeDates.length - 1]) + "'}");
        filter2.append(" AND \n");
        filter2.append("INTEREST.FBizDate >= {ts'" + sdf.format(startDate) + "'}");
        filter2.append(" AND \n");
        filter2.append("INTEREST.FBizDate < {ts'" + sdf.format(this.edgeDates[this.edgeDates.length - 1]) + "'}");
        if (!isContainBond) {
            if (this.filterParam.getLoanProperty() == LoanPropertyEnum.InGroup) {
                if (this.filterParam.getLoanerIds() != null && this.filterParam.getLoanerIds().size() > 0) {
                    filter.append(" AND \n");
                    filter.append("PARENT.FGroupId IN ");
                    filter.append(FMHelper.setTran2String((Set)this.filterParam.getLoanerIds()));
                    filter.append(" \n");
                } else {
                    filter.append(" AND \n");
                    filter.append("PARENT.FGroupId is not null \n");
                }
            } else if (this.filterParam.getLoanProperty() == LoanPropertyEnum.OutGroup) {
                if (this.filterParam.getLoanerIds() != null && this.filterParam.getLoanerIds().size() > 0) {
                    filter.append(" AND \n");
                    filter.append("PARENT.FInstitutionId IN ");
                    filter.append(FMHelper.setTran2String((Set)this.filterParam.getLoanerIds()));
                    filter.append(" \n");
                } else {
                    filter.append(" AND \n");
                    filter.append("PARENT.FInstitutionId is not null \n");
                }
            } else if (this.filterParam.getLoanerIds() != null && this.filterParam.getLoanerIds().size() > 0) {
                filter.append(" AND \n(");
                filter.append("PARENT.FInstitutionId IN ");
                filter.append(FMHelper.setTran2String((Set)this.filterParam.getLoanerIds()));
                filter.append(" \n");
                filter.append(" OR \n");
                filter.append("PARENT.FGroupId IN ");
                filter.append(FMHelper.setTran2String((Set)this.filterParam.getLoanerIds()));
                filter.append(" )\n");
            }
        }
        if (this.filterParam.getFinancingProductIds() != null && this.filterParam.getFinancingProductIds().size() > 0) {
            filter.append(" AND \n");
            filter.append("TYPE.FID IN ");
            filter.append(FMHelper.setTran2String((Set)this.filterParam.getFinancingProductIds()));
            filter.append(" \n");
        }
        if (this.filterParam.getProjectIds() != null && this.filterParam.getProjectIds().size() > 0) {
            filter.append(" AND \n");
            filter.append("PROJECT.FID IN ");
            filter.append(FMHelper.setTran2String((Set)this.filterParam.getProjectIds()));
            filter.append(" \n");
        }
        if (this.filterParam.getAmount() != null) {
            intUnit = this.filterParam.getUnit().getValue();
            filter1.append(" AND \n");
            filter1.append("LOANENTRY.FAmount * PARENT.FLocalCurExRate >= ");
            filter1.append(this.filterParam.getAmount().multiply(new BigDecimal(String.valueOf(intUnit))));
            filter1.append(" \n");
        }
        if (!isContainBond) {
            filter1.append("AND PARENT.FIsBonds = 0\n");
        }
        if (this.filterParam.getAmount() != null) {
            intUnit = this.filterParam.getUnit().getValue();
            filter2.append(" AND \n");
            filter2.append("INTEREST.FRealInterest * PARENT.FLocalCurExRate >= ");
            filter2.append(this.filterParam.getAmount().multiply(new BigDecimal(String.valueOf(intUnit))));
            filter2.append(" \n");
        }
        filter.append(" AND \n");
        filter.append("PARENT.FBalance > 0\n");
        filter2.append(" AND \n");
        filter2.append("INTEREST.FIsPrediction = 1\n");
        if (isContainBond) {
            if (this.filterParam.getForcastType() == 0) {
                sql.append(selector1).append(from1).append(filter).append(filter1).append(this.sort).append(")");
            } else if (this.filterParam.getForcastType() == 1) {
                sql.append(selector2).append(from2).append(filter).append(filter2).append(this.sort).append(")");
            } else if (this.filterParam.getForcastType() == 2) {
                sql.append("(");
                sql.append(selector1).append(from1).append(filter).append(filter1).append(")");
                sql.append(") UNION ALL (");
                sql.append(selector2).append(from2).append(filter).append(filter2).append(")");
                sql.append(")");
                sql.append(this.sort);
            }
        } else if (this.filterParam.getForcastType() == 0) {
            sql.append(selector1).append(from1).append(filter).append(filter1).append(this.sort);
        } else if (this.filterParam.getForcastType() == 1) {
            sql.append(selector2).append(from2).append(filter).append(filter2).append(this.sort);
        } else if (this.filterParam.getForcastType() == 2) {
            sql.append("(");
            sql.append(selector1).append(from1).append(filter).append(filter1);
            sql.append(") UNION ALL (");
            sql.append(selector2).append(from2).append(filter).append(filter2);
            sql.append(")");
            sql.append(this.sort);
        }
        try {
            return FMIsqlFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), paramList.toArray());
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
            SysUtil.abort();
            return null;
        }
    }

    private String date2String(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    @Override
    public void filldata(IRowSet rs) throws SQLException, EASBizException, BOSException {
        this.amountUnit = this.filterParam.getUnit().getValue();
        this.localRepaymentAmountTotal = Constants.ZERO;
        this.kdt.setRefresh(false);
        int modelIndex = -1;
        int currentIndex = -1;
        BigDecimal subSum = Constants.ZERO;
        BigDecimal subsubSum = Constants.ZERO;
        if (rs.next()) {
            ParameterInfo model = this.readData(rs);
            modelIndex = this.getSubIndex(model.getRepayDate());
            boolean hasOutputSubRow = false;
            while (rs.next()) {
                ParameterInfo v1 = model;
                ParameterInfo v2 = this.readData(rs);
                currentIndex = this.getSubIndex(v2.getRepayDate());
                if (modelIndex == currentIndex) {
                    if (this.compareValues(v1, v2)) {
                        do {
                            subSum = subSum.add(model.getLocalRepayAmount());
                            subsubSum = subsubSum.add(model.getLocalRepayAmount());
                            this.writeData(model);
                            v1 = model = v2;
                            if (rs.next()) {
                                v2 = this.readData(rs);
                                currentIndex = this.getSubIndex(v2.getRepayDate());
                                continue;
                            }
                            v2 = null;
                            currentIndex = -1;
                        } while (modelIndex == currentIndex && this.compareValues(v1, v2));
                        if (v2 != null) {
                            this.writeData(model);
                            if (model != null) {
                                subsubSum = subsubSum.add(model.getLocalRepayAmount());
                                this.insertSubSubRow(model.getLoanerName(), subsubSum);
                                subsubSum = Constants.ZERO;
                                subSum = subSum.add(model.getLocalRepayAmount());
                                if (modelIndex != currentIndex) {
                                    this.insertSubRow(subSum, modelIndex);
                                    subSum = Constants.ZERO;
                                    modelIndex = currentIndex;
                                }
                            }
                            model = v2;
                        } else {
                            subSum = subSum.add(model.getLocalRepayAmount());
                            subsubSum = subsubSum.add(model.getLocalRepayAmount());
                            this.writeData(model);
                            this.insertSubSubRow(model.getLoanerName(), subsubSum);
                            this.insertSubRow(subSum, modelIndex);
                            subSum = Constants.ZERO;
                            subsubSum = Constants.ZERO;
                        }
                        if (v2 != null) {
                            hasOutputSubRow = false;
                            continue;
                        }
                        hasOutputSubRow = true;
                        continue;
                    }
                    this.writeData(model);
                    subSum = subSum.add(model.getLocalRepayAmount());
                    model = v2;
                    hasOutputSubRow = false;
                    continue;
                }
                this.writeData(model);
                subSum = subSum.add(model.getLocalRepayAmount());
                model = v2;
                modelIndex = currentIndex;
                this.insertSubRow(subSum, this.getSubIndex(v1.getRepayDate()));
                subSum = Constants.ZERO;
                hasOutputSubRow = false;
            }
            if (!hasOutputSubRow) {
                this.writeData(model);
                subSum = subSum.add(model.getLocalRepayAmount());
                this.insertSubRow(subSum, this.getSubIndex(model.getRepayDate()));
            }
        }
        this.kdt.setRefresh(true);
        this.kdt.repaint();
        this.kdt.getGroupManager().group();
        this.kdt.getGroupManager().setGroup(false);
    }

    private void writeData(ParameterInfo v) {
        IRow row = this.kdt.addRow();
        row.getCell("Institution").setValue((Object)v.getLoanerName());
        row.getCell("Company").setValue((Object)v.getCompanyName());
        row.getCell("RepaymentNO").setValue((Object)v.getRepaymentNum());
        row.getCell("ContractNum").setValue((Object)v.getContractNum());
        row.getCell("FinProduct").setValue((Object)v.getFinProduct());
        row.getCell("Depositary").setValue((Object)v.getDepositary());
        row.getCell("Project").setValue((Object)v.getProject());
        row.getCell("IssueDate").setValue((Object)v.getIssurDate());
        row.getCell("ExpireDate").setValue((Object)v.getExpireDate());
        row.getCell("Currency").setValue((Object)v.getCurrency());
        row.getCell("LoanAmount").setValue((Object)v.getLoanAmount());
        row.getCell("LoanBalance").setValue((Object)v.getLoanBalance());
        row.getCell("LoanProperty").setValue((Object)v.getLoanProperty());
        row.getCell("PlanRepaymentDate").setValue((Object)v.getRepayDate());
        row.getCell("RepaymentAmount").setValue((Object)v.repayAmount);
        row.getCell("LocalRepaymentAmount").setValue((Object)v.getLocalRepayAmount());
        row.setUserObject((Object)v.getId());
        this.localRepaymentAmountTotal = this.localRepaymentAmountTotal.add(v.getLocalRepayAmount());
    }

    private ParameterInfo readData(IRowSet rs) throws SQLException {
        ParameterInfo v = new ParameterInfo();
        v.setLoanerName(rs.getString("LOANER_NAME"));
        v.setCompanyName(rs.getString("COMPANY_NAME"));
        v.setRepaymentNum(rs.getString("PARENT_NUMBER"));
        v.setContractNum(rs.getString("PARENT_CONTRACTNUM"));
        v.setFinProduct(rs.getString("TYPE_NAME"));
        v.setDepositary(rs.getString("BANK_NAME"));
        v.setProject(rs.getString("PROJECT_NAME"));
        v.setIssurDate(rs.getDate("PARENT_ISSUEDATE"));
        v.setExpireDate(rs.getDate("PARENT_EXPIREDDATE"));
        v.setCurrency(rs.getString("CURRENCY_NAME"));
        v.setLoanAmount(rs.getBigDecimal("PARENT_AMOUNT").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
        v.setLoanBalance(rs.getBigDecimal("PARENT_BALANCE").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
        v.setLoanProperty(rs.getString("FORCASTTYPE"));
        v.setRepayDate(rs.getDate("REPAYMENTDATE"));
        v.setRepayAmount(rs.getBigDecimal("REPAYMENTAMOUNT").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
        v.setLocalRepayAmount(rs.getBigDecimal("LOCALREPAYMENTAMOUNT").divide(new BigDecimal(String.valueOf(this.amountUnit)), 10, 4));
        v.setId(rs.getString("PARENT_ID"));
        return v;
    }

    private boolean compareValues(ParameterInfo v1, ParameterInfo v2) {
        return v1.getLoanerName().equals(v2.getLoanerName());
    }

    private int getSubIndex(Date date) {
        if (date == null) {
            return -1;
        }
        Date startDate = DateTimeUtils.truncateDate((Date)this.filterParam.getCurrentDate());
        date = DateTimeUtils.truncateDate((Date)date);
        CycleTypeEnum type = this.filterParam.getTimeType();
        if (type == CycleTypeEnum.MONTH) {
            int yearDiff = DateTimeUtils.getYear((Date)date) - DateTimeUtils.getYear((Date)startDate);
            if (yearDiff == 0) {
                return DateTimeUtils.getMonth((Date)date) - DateTimeUtils.getMonth((Date)startDate);
            }
            return yearDiff * 12 - DateTimeUtils.getMonth((Date)startDate) + DateTimeUtils.getMonth((Date)date);
        }
        if (type == CycleTypeEnum.QUARTER) {
            int yearDiff = DateTimeUtils.getYear((Date)date) - DateTimeUtils.getYear((Date)startDate);
            if (yearDiff == 0) {
                return DateTimeUtils.getQuarter((Date)date) - DateTimeUtils.getQuarter((Date)startDate);
            }
            return yearDiff * 4 - DateTimeUtils.getQuarter((Date)startDate) + DateTimeUtils.getQuarter((Date)date);
        }
        if (type == CycleTypeEnum.YEAR) {
            return DateTimeUtils.getYear((Date)date) - DateTimeUtils.getYear((Date)startDate);
        }
        if (type == CycleTypeEnum.WEEK) {
            startDate = DateUtil.getFirstDayOfWeek((Date)startDate);
            long dayDiff = DateTimeUtils.dateDiff((Date)startDate, (Date)date) / 24L / 60L / 60L / 1000L;
            return (int)dayDiff / 7;
        }
        return -1;
    }

    private void insertSubSubRow(String loanerName, BigDecimal sum) {
        IRow subRow = this.kdt.addRow();
        subRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        subRow.getCell("LocalRepaymentAmount").setValue((Object)sum);
        subRow.getCell(0).setValue((Object)loanerName);
        subRow.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"302_LoanEditUI"));
        int r = this.kdt.getRowCount() - 1;
        this.kdt.getMergeManager().mergeBlock(r, 1, r, 13);
        subRow.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }

    private void insertSubRow(BigDecimal sum, int totalIndex) {
        IRow totalRow = this.kdt.addRow();
        totalRow.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        totalRow.getCell("LocalRepaymentAmount").setValue((Object)sum);
        int r = this.kdt.getRowCount() - 1;
        this.kdt.getMergeManager().mergeBlock(r, 0, r, 13);
        totalRow.getCell(0).setValue((Object)this.title[totalIndex]);
        totalRow.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }

    private void prepareForQuery() {
        CycleTypeEnum type = this.filterParam.getTimeType();
        int addNumber = this.filterParam.getTimeNumber();
        Date startDate = this.filterParam.getCurrentDate();
        String year = EASResource.getString((String)resourcePath, (String)"Year");
        String month = EASResource.getString((String)resourcePath, (String)"Month");
        String quarter = EASResource.getString((String)resourcePath, (String)"Quarter");
        String day = EASResource.getString((String)resourcePath, (String)"Day");
        String no = EASResource.getString((String)resourcePath, (String)"NO");
        String total = EASResource.getString((String)resourcePath, (String)"AllLocalRepaymentAmount");
        this.edgeDates = new Date[addNumber + 1];
        this.title = new String[addNumber];
        this.ids = new int[addNumber];
        this.locale = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        if (type == CycleTypeEnum.MONTH) {
            this.edgeDates[0] = DateUtil.getFirstDayOfMonth((Date)startDate);
            this.sort = "ORDER BY YYYY ASC,\n MM ASC,\n LOANER_ID ASC,\n PARENT_ID ASC,\n DD ASC";
        } else if (type == CycleTypeEnum.QUARTER) {
            this.edgeDates[0] = DateUtil.getFirstDayOfMonth((Date)DateUtil.getFirstSeasonDate((Date)startDate));
            this.sort = "ORDER BY YYYY ASC,\n MM ASC,\n LOANER_ID ASC,\n PARENT_ID ASC,\n DD ASC";
        } else if (type == CycleTypeEnum.YEAR) {
            this.edgeDates[0] = DateUtil.getFirstYearDate((Date)startDate);
            this.sort = "ORDER BY YYYY ASC,\n LOANER_ID ASC,\n PARENT_ID ASC,\n DD ASC";
        } else if (type == CycleTypeEnum.WEEK) {
            this.edgeDates[0] = DateUtil.getFirstDayOfWeek((Date)startDate);
            this.sort = "ORDER BY MM ASC,\n LOANER_ID ASC,\n PARENT_ID ASC,\n DD ASC";
        }
        boolean forEn = this.locale.equals("l1");
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy");
        for (int i = 1; i <= addNumber; ++i) {
            String formatDate = FMConstants.FORMAT_DAY.format(this.edgeDates[i - 1]);
            if (type == CycleTypeEnum.MONTH) {
                this.edgeDates[i] = DateTimeUtils.addMonth((Date)this.edgeDates[i - 1], (int)1);
                if (forEn) {
                    this.title[i - 1] = formatDate.substring(0, 7);
                    continue;
                }
                this.title[i - 1] = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern1"), formatDate.substring(0, 4), formatDate.substring(5, 7));
                continue;
            }
            if (type == CycleTypeEnum.QUARTER) {
                this.edgeDates[i] = DateTimeUtils.addMonth((Date)this.edgeDates[i - 1], (int)3);
                Object[] args = new String[]{String.valueOf(DateTimeUtils.getYear((Date)this.edgeDates[i - 1])), String.valueOf(DateUtil.getSeason((int)DateTimeUtils.getMonth((Date)this.edgeDates[i - 1])))};
                this.title[i - 1] = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"QuarterResource"), args);
                continue;
            }
            if (type == CycleTypeEnum.YEAR) {
                this.edgeDates[i] = DateTimeUtils.addYear((Date)this.edgeDates[i - 1], (int)1);
                if (forEn) {
                    this.title[i - 1] = formatDate.substring(0, 4);
                    continue;
                }
                this.title[i - 1] = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern2"), formatDate.substring(0, 4));
                continue;
            }
            if (type != CycleTypeEnum.WEEK) continue;
            this.edgeDates[i] = DateTimeUtils.addDay((Date)this.edgeDates[i - 1], (long)6L);
            String formatDate_ = FMConstants.FORMAT_DAY.format(this.edgeDates[i]);
            String fromStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern3"), formatDate.substring(0, 4), formatDate.substring(5, 7), formatDate.substring(8, 10));
            String toStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"format_pattern3"), formatDate_.substring(0, 4), formatDate_.substring(5, 7), formatDate_.substring(8, 10));
            String msgStr = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"529_RptRepaymentDetailHandlerBase"), fromStr, toStr);
            this.title[i - 1] = forEn ? MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"529_RptRepaymentDetailHandlerBase"), df.format(this.edgeDates[i - 1]), df.format(this.edgeDates[i])) : msgStr;
            this.edgeDates[i] = DateTimeUtils.addDay((Date)this.edgeDates[i - 1], (long)7L);
            this.ids[i - 1] = DateTimeUtils.getYear((Date)this.edgeDates[i - 1]) * 100 + this.getWeek(this.edgeDates[i - 1]);
        }
    }

    private int getWeek(Date vDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(vDate);
        cal.setMinimalDaysInFirstWeek(7);
        int week = cal.get(3);
        return week;
    }

    @Override
    public void insertAbsractFlowRow() {
        String text = this.getResString("AllLocalRepaymentAmount");
        IRow row = this.kdt.addRow();
        row.getStyleAttributes().setBackground(new Color(0xF6F6B6));
        row.getCell("LocalRepaymentAmount").setValue((Object)this.localRepaymentAmountTotal);
        int r = this.kdt.getRowCount() - 1;
        this.kdt.getMergeManager().mergeBlock(r, 0, r, 13);
        row.getCell(0).setValue((Object)text);
        row.getCell(0).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }

    protected String getResString(String key) {
        return EASResource.getString((String)resourcePath, (String)key);
    }

    class ParameterInfo {
        private String id;
        private String loanerName;
        private String companyName;
        private String repaymentNum;
        private String contractNum;
        private String finProduct;
        private String depositary;
        private String project;
        private Date issurDate;
        private Date expireDate;
        private String currency;
        private BigDecimal loanAmount;
        private BigDecimal loanBalance;
        private String loanProperty;
        private Date repayDate;
        private BigDecimal repayAmount;
        private BigDecimal localRepayAmount;

        ParameterInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getLoanerName() {
            return this.loanerName;
        }

        public void setLoanerName(String loanerName) {
            this.loanerName = loanerName;
        }

        public String getCompanyName() {
            return this.companyName;
        }

        public void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        public String getRepaymentNum() {
            return this.repaymentNum;
        }

        public void setRepaymentNum(String repaymentNum) {
            this.repaymentNum = repaymentNum;
        }

        public String getContractNum() {
            return this.contractNum;
        }

        public void setContractNum(String contractNum) {
            this.contractNum = contractNum;
        }

        public String getFinProduct() {
            return this.finProduct;
        }

        public void setFinProduct(String finProduct) {
            this.finProduct = finProduct;
        }

        public String getDepositary() {
            return this.depositary;
        }

        public void setDepositary(String depositary) {
            this.depositary = depositary;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }

        public Date getIssurDate() {
            return this.issurDate;
        }

        public void setIssurDate(Date issurDate) {
            this.issurDate = issurDate;
        }

        public Date getExpireDate() {
            return this.expireDate;
        }

        public void setExpireDate(Date expireDate) {
            this.expireDate = expireDate;
        }

        public String getCurrency() {
            return this.currency;
        }

        public void setCurrency(String currency) {
            this.currency = currency;
        }

        public BigDecimal getLoanAmount() {
            return this.loanAmount;
        }

        public void setLoanAmount(BigDecimal loanAmount) {
            this.loanAmount = loanAmount;
        }

        public BigDecimal getLoanBalance() {
            return this.loanBalance;
        }

        public void setLoanBalance(BigDecimal loanBalance) {
            this.loanBalance = loanBalance;
        }

        public String getLoanProperty() {
            return this.loanProperty;
        }

        public void setLoanProperty(String loanProperty) {
            this.loanProperty = loanProperty;
        }

        public Date getRepayDate() {
            return this.repayDate;
        }

        public void setRepayDate(Date repayDate) {
            this.repayDate = repayDate;
        }

        public BigDecimal getRepayAmount() {
            return this.repayAmount;
        }

        public void setRepayAmount(BigDecimal repayAmount) {
            this.repayAmount = repayAmount;
        }

        public BigDecimal getLocalRepayAmount() {
            return this.localRepayAmount;
        }

        public void setLocalRepayAmount(BigDecimal localRepayAmount) {
            this.localRepayAmount = localRepayAmount;
        }
    }
}

