/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.fin.CycleTypeEnum;
import com.kingdee.eas.fm.fin.RptRepaymentDetailFilterParam;
import com.kingdee.eas.fm.fin.RptRepaymentSumFacadeFactory;
import com.kingdee.eas.fm.fin.client.AbstractRptRepaymentSumMainUI;
import com.kingdee.eas.fm.fin.client.RptRepaymentMainUI;
import com.kingdee.eas.fm.fin.client.RptRepaymentSumFilterUI;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RptRepaymentSumMainUI
extends AbstractRptRepaymentSumMainUI {
    private final String resource = "com.kingdee.eas.fm.fin.client.RptRepaymentResource";

    protected BireportBaseFilterUI getQueryDialogUserPanel() throws Exception {
        return new RptRepaymentSumFilterUI();
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionJoinQuery.setEnabled(true);
        this.actionJoinQuery.setVisible(true);
        this.btnJoinQuery.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
        this.kDMenuItemJoinQuery.setIcon(EASResource.getIcon((String)"imgTbtn_linkviewlist"));
    }

    protected IBireportBaseFacade getRemoteInstance() throws BOSException {
        return RptRepaymentSumFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected void onBeforeQuery() throws Exception {
        this.jlAmountUnit.setText(this.params.getObject("unit").toString());
        if (this.params.getObjectElement("prmtCurrency.value") != null) {
            this.kDLabel1.setVisible(true);
            this.kDLabel2.setVisible(true);
            this.kDLabel2.setText(this.params.getObjectElement("prmtCurrency.value").toString());
        } else {
            this.kDLabel1.setVisible(false);
            this.kDLabel2.setVisible(false);
        }
        if (this.params.getBoolean("isContainBond")) {
            this.actionJoinQuery.setVisible(false);
        } else {
            this.actionJoinQuery.setVisible(true);
        }
    }

    protected void onAfterQuery() throws Exception {
        boolean forcastByLoaner = this.params.getBoolean("forcastByLoaner");
        boolean forcastByCompany = this.params.getBoolean("forcastByCompany");
        boolean forcastByCurrency = this.params.getBoolean("forcastByCurrency");
        if (forcastByLoaner) {
            this.addChart().setTitle(EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"RptRepaymentSum")).setChartType(ChartType.CT_COLUMNCLUSTERED3D).addShowMember("Measures", "FBalance").addShowMember("Loaner", EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI")).addNotShowMember("Measures", "FAmount").addOnlyLeafVisibleHandler("Loaner").finishDataSet();
        } else if (forcastByCompany) {
            this.addChart().setTitle(EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"RptRepaymentSum")).setChartType(ChartType.CT_COLUMNCLUSTERED3D).addShowMember("Measures", "FBalance").addShowMember("Company", EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI")).addNotShowMember("Measures", "FAmount").addOnlyLeafVisibleHandler("Company").finishDataSet();
        } else if (forcastByCurrency) {
            this.addChart().setTitle(EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"RptRepaymentSum")).setChartType(ChartType.CT_COLUMNCLUSTERED3D).addShowMember("Measures", "FBalance").addShowMember("Currency", EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"313_LoanEditUI")).addNotShowMember("Measures", "FAmount").addOnlyLeafVisibleHandler("Currency").finishDataSet();
        }
        if (this.params.getObjectElement("prmtCurrency.value") != null) {
            int headRowCount = this.tblMain.getHeadRowCount();
            int columnCount = this.tblMain.getColumnCount();
            for (int i = 0; i < headRowCount; ++i) {
                IRow headRow = this.tblMain.getHeadRow(i);
                for (int j = 0; j < columnCount; ++j) {
                    Object headValue = headRow.getCell(j).getValue();
                    if (headValue == null || headValue.toString().indexOf(EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"NativeCurrency")) <= 0) continue;
                    String replace = headValue.toString().replace(EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"NativeCurrency"), EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"NativeQueryCurrency"));
                    headRow.getCell(j).setValue((Object)replace);
                }
            }
        }
    }

    protected void afterModelChanged() throws Exception {
        super.afterModelChanged();
        if (this.params.getObjectElement("prmtCurrency.value") != null) {
            int headRowCount = this.tblMain.getHeadRowCount();
            int columnCount = this.tblMain.getColumnCount();
            for (int i = 0; i < headRowCount; ++i) {
                IRow headRow = this.tblMain.getHeadRow(i);
                for (int j = 0; j < columnCount; ++j) {
                    Object headValue = headRow.getCell(j).getValue();
                    if (headValue == null || headValue.toString().indexOf(EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"NativeCurrency")) <= 0) continue;
                    String replace = headValue.toString().replace(EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"NativeCurrency"), EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"NativeQueryCurrency"));
                    headRow.getCell(j).setValue((Object)replace);
                }
            }
        }
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer(128);
        sb.append(RptRepaymentSumMainUI.getRes((String)"print_label_datetime")).append("&[DateTime]&|").append(RptRepaymentSumMainUI.getRes((String)"print_label_company")).append("&[Company]&| ").append(RptRepaymentSumMainUI.getRes((String)"print_label_amountunit")).append("&[AmountUnit]");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("AmountUnit", this.jlAmountUnit.getText());
        map.put("DateTime", this.params.getObject("currentDate"));
        return map;
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionJoinQuery_actionPerformed(e);
        Member[] mm = this.getSelectedDataCellItemInfo();
        if (mm == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"ChooseDetail"));
            return;
        }
        Set<Object> companySet = new HashSet();
        Set<Object> loanerSet = new HashSet();
        int year = 0;
        int month = 0;
        for (Member m : mm) {
            if (!m.isLeaf()) continue;
            String dimName = m.getDimension().getName();
            if ("Company".equals(dimName)) {
                if (m.getKey() == null) {
                    return;
                }
                companySet.add(m.getKey());
            }
            if ("Loaner".equals(dimName)) {
                if (m.getKey() == null) {
                    return;
                }
                loanerSet.add(m.getKey());
            }
            if (!"PeriodRType".equals(dimName)) continue;
            int key = Integer.parseInt(m.getKey().toString());
            year = key / 100;
            month = key % 100;
        }
        boolean forcastByCurrency = this.params.getBoolean("forcastByCurrency");
        if (!forcastByCurrency) {
            if (companySet.size() <= 0 || loanerSet.size() <= 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.client.RptRepaymentResource", (String)"ChooseDetail"));
                return;
            }
        } else {
            companySet = (Set)this.params.getObject("companyIdSet");
            loanerSet = (Set)this.params.getObject("loaner");
        }
        CycleTypeEnum timeType = (CycleTypeEnum)((Object)this.params.getObject("timeType"));
        Date currentDate = new Date();
        Calendar c = Calendar.getInstance();
        if (timeType == CycleTypeEnum.MONTH) {
            c.set(1, year);
            c.set(2, month - 1);
            c.set(5, 1);
            c.set(9, 0);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            currentDate = c.getTime();
        } else if (timeType == CycleTypeEnum.QUARTER) {
            c.set(1, year);
            c.set(2, month * 3);
            c.set(5, 1);
            c.set(9, 0);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            currentDate = c.getTime();
        } else if (timeType == CycleTypeEnum.YEAR) {
            c.set(1, year);
            c.set(2, 0);
            c.set(5, 1);
            c.set(9, 0);
            c.set(10, 0);
            c.set(12, 0);
            c.set(13, 0);
            currentDate = c.getTime();
        } else if (timeType == CycleTypeEnum.WEEK) {
            currentDate = this.getFirstDayByWeekNum(year, month);
        }
        Date currentD = (Date)this.params.getObject("currentDate");
        if (currentD != null && currentD.compareTo(currentDate) > 0) {
            currentDate = currentD;
        }
        RptRepaymentDetailFilterParam param = new RptRepaymentDetailFilterParam();
        param.setCompanyIdSet(companySet);
        param.setLoanProperty(null);
        param.setLoanerIds((Set)this.params.getObject("loaner"));
        param.setProjectIds((Set)this.params.getObject("project"));
        param.setFinancingProductIds((Set)this.params.getObject("financingProduct"));
        param.setCurrentDate(currentDate);
        param.setTimeType(timeType);
        param.setTimeNumber(new Integer(1));
        param.setForcastType(this.params.getInt("forcastType"));
        param.setAmount(Constants.ZERO);
        param.setUnit((AmountUnitEnum)this.params.getObject("unit"));
        param.setContainBond(this.params.getBoolean("isContainBond"));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptRepaymentMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public Date getFirstDayByWeekNum(int year, int week) {
        if (year < 0 || week < 0) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        int dayofweek = cal.get(7);
        cal.add(5, 7 * week - dayofweek + 2);
        return cal.getTime();
    }
}

