/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.fin.client.AbstractRptTimeDepositBalanceUI;
import com.kingdee.eas.fm.fin.client.RptTimeDepositBalanceByCurrencyHandler;
import com.kingdee.eas.fm.fin.client.RptTimeDepositBalanceByDepCompHandler;
import com.kingdee.eas.fm.fin.client.RptTimeDepositBalanceFilterParam;
import com.kingdee.eas.fm.fin.client.RptTimeDepositBalanceFilterUI;
import com.kingdee.eas.fm.fin.client.RptTimeDepositHandlerAdapter;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RptTimeDepositBalanceUI
extends AbstractRptTimeDepositBalanceUI {
    private static final Logger logger = CoreUIObject.getLogger(RptTimeDepositBalanceUI.class);
    private FMFilterBaseUI filterUI;

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        super.onLoad();
        this.pkEndDate.setEnabled(false);
        this.txtUnit.setEnabled(false);
        this.tblMain.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSequenceCheck.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("id").getValue();
        if (id == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        this.tblMain.checkParsed();
        RptTimeDepositBalanceFilterParam filterParam = (RptTimeDepositBalanceFilterParam)this.getFilterParam();
        this.showHead(filterParam);
        int groupType = filterParam.getType();
        IFMDetailRptHandler handler = this.getBizHander(filterParam, groupType);
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        handler.endDataFill();
        this.tblMain.setColumnMoveable(false);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptTimeDepositBalanceFilterUI();
        }
        return this.filterUI;
    }

    private IFMDetailRptHandler getBizHander(RptTimeDepositBalanceFilterParam filterParam, int groupType) {
        RptTimeDepositHandlerAdapter handler = null;
        switch (groupType) {
            case 0: {
                handler = new RptTimeDepositBalanceByDepCompHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            case 2: {
                handler = new RptTimeDepositBalanceByCurrencyHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            default: {
                handler = new RptTimeDepositBalanceByDepCompHandler(this.tblMain, filterParam.getFilter(), filterParam);
            }
        }
        return handler;
    }

    private void showHead(RptTimeDepositBalanceFilterParam filterParam) {
        this.pkEndDate.setValue((Object)filterParam.getEndDate());
        this.txtUnit.setText(filterParam.getStatisticalUnit().getAlias());
    }
}

