/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.ColInfo;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import java.math.BigDecimal;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class LoanRepayBatchCaculator
implements ICalculator,
IMethodBatchQuery {
    private ICalculateContextProvider context = null;
    private Context serverCtx = null;

    public BigDecimal loanRepay(String companyNumber, String bankNumber, String finProducts, Date repayDateFrom, Date repayDateTo, String dataType) throws BOSException, EASBizException {
        return null;
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.serverCtx = context.getServerContext();
    }

    public boolean batchQuery(Map methods) {
        for (Map.Entry e : methods.entrySet()) {
            String method = (String)e.getKey();
            SortedParameterArray param = (SortedParameterArray)e.getValue();
            this.execute(param);
        }
        return true;
    }

    public void execute(SortedParameterArray params) {
        for (int i = 0; i < params.size(); ++i) {
            Parameter param = params.getParameter(i);
            Object[] args = param.getArgs();
            try {
                BigDecimal valueReturn = this.getInAccBatch(args);
                param.setValue((Object)valueReturn);
                continue;
            }
            catch (Exception e) {
                param.setValue((Object)e.getMessage());
            }
        }
    }

    private BigDecimal getInAccBatch(Object[] args) throws BOSException, EASBizException, SQLException {
        BigDecimal result = Constants.ZERO;
        String sql = this.getSQL(args);
        IRowSet rs = this.getResultBySQL(this.serverCtx, sql);
        while (rs.next()) {
            result = rs.getBigDecimal(1);
        }
        return result;
    }

    private IRowSet getResultBySQL(Context ctx, String sql) throws SQLDataException, BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        DynamicRowSet drs = null;
        try {
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int colCount = rsmd.getColumnCount();
            drs = new DynamicRowSet(colCount);
            String[] columnNameArray = new String[colCount];
            for (i = 0; i < colCount; ++i) {
                String columnName = rsmd.getColumnName(i + 1);
                int columnClz = rsmd.getColumnType(i + 1);
                String columnlbl = rsmd.getColumnLabel(i + 1);
                columnNameArray[i] = columnName;
                ColInfo ciId = new ColInfo(columnName, columnlbl, columnClz, null);
                drs.setColInfo(i + 1, ciId);
            }
            while (rs.next()) {
                drs.moveToInsertRow();
                for (i = 0; i < colCount; ++i) {
                    drs.updateObject(columnNameArray[i], rs.getObject(columnNameArray[i]));
                }
                drs.insertRow();
            }
            drs.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    private String getSQL(Object[] args) {
        StringBuffer joinSQL = new StringBuffer();
        joinSQL.append("inner join t_org_company company on loan.fcompanyid = company.fid ");
        joinSQL.append("left join t_bd_bank bank on loan.finstitutionid = bank.fid ");
        joinSQL.append("left join t_fin_financingProducts product on loan.ftypeid = product.fid ");
        StringBuffer principalSQL = new StringBuffer();
        if ("All".equals(args[5].toString()) || "Principal".equals(args[5].toString())) {
            principalSQL.append("select isnull(sum(isnull(entry.famount, 0)), 0) amount from t_fin_loan loan ");
            principalSQL.append("inner join t_fin_loanEntry entry on loan.fid = entry.fparentid ");
            principalSQL.append(joinSQL).append(this.getWhereSQL(args, true));
        }
        StringBuffer interestSQL = new StringBuffer();
        if ("All".equals(args[5].toString()) || "Interest".equals(args[5].toString())) {
            interestSQL.append("select isnull(sum(isnull(int.finterest, 0)), 0) amount from t_fin_loan loan ");
            interestSQL.append("inner join t_fin_loaninterest int on loan.fid = int.floanid ");
            interestSQL.append(joinSQL).append(this.getWhereSQL(args, false));
        }
        StringBuffer sql = new StringBuffer();
        if ("All".equals(args[5].toString())) {
            sql.append("select sum(amount) from (").append(principalSQL).append(" union all ").append(interestSQL).append(") a ");
        } else if ("Principal".equals(args[5].toString())) {
            sql.append(principalSQL);
        } else if ("Interest".equals(args[5].toString())) {
            sql.append(interestSQL);
        }
        return sql.toString();
    }

    private String getWhereSQL(Object[] args, boolean isPrincipal) {
        StringBuffer whereSQL = new StringBuffer();
        whereSQL.append("where loan.fbalance > 0 ");
        String companyNumber = null;
        companyNumber = args[0] != null && !args[0].equals("") ? args[0].toString() : this.getReportCompany(this.context, this.serverCtx);
        whereSQL.append("and company.fnumber = '").append(companyNumber).append("' ");
        if (args[1] != null && !args[1].equals("")) {
            whereSQL.append("and bank.fnumber = '").append(args[1].toString()).append("' ");
        }
        if (args[2] != null && !args[2].equals("")) {
            String productFnumber = args[2].toString();
            if (productFnumber.indexOf(";") > 0) {
                whereSQL.append("and product.fnumber in (");
                String[] nums = productFnumber.split(";");
                for (int i = 0; i < nums.length; ++i) {
                    if (i > 0) {
                        whereSQL.append(",");
                    }
                    whereSQL.append(" '").append(nums[i].trim()).append("'");
                }
                whereSQL.append(") ");
            } else {
                whereSQL.append("and product.fnumber = '").append(productFnumber.trim()).append("' ");
            }
        }
        String repayDateFrom = null;
        repayDateFrom = args[3] != null && !args[3].equals("") ? this.getPickerDate(args[3]) : this.getReportStartDate(this.context, this.serverCtx).toString();
        if (isPrincipal) {
            whereSQL.append("and entry.fdate >= {").append(repayDateFrom).append("} ");
        } else {
            whereSQL.append("and int.fbizdate >= {").append(repayDateFrom).append("} ");
        }
        String repayDateTo = null;
        repayDateTo = args[4] != null && !args[4].equals("") ? this.getPickerDate(args[4]) : this.getReportEndDate(this.context, this.serverCtx).toString();
        if (isPrincipal) {
            whereSQL.append("and entry.fdate <= {").append(repayDateTo).append("} ");
        } else {
            whereSQL.append("and int.fbizdate <= {").append(repayDateTo).append("} ");
        }
        return whereSQL.toString();
    }

    private String getPickerDate(Object obj) {
        String strDate = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DateFormat format = FMHelper.getNationalDateFormat((Context)this.serverCtx);
        try {
            strDate = dateFormat.format(format.parse(obj.toString()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return strDate;
    }

    private String getReportCompany(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getCompany_Number();
    }

    private Date getReportStartDate(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getReport_StartDate();
    }

    private Date getReportEndDate(ICalculateContextProvider context, Context ctx) {
        BatchHelper batchHelper = new BatchHelper(context, ctx);
        return batchHelper.getReport_EndDate();
    }
}

