/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.rpcoptimize;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillFactory;
import com.kingdee.eas.fm.cl.ConsignmentLoanBillInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.app.BatchFetcher;
import com.kingdee.eas.fm.fin.CreditFinancingReduceFactory;
import com.kingdee.eas.fm.fin.FinBizException;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LoanApplyBillFactory;
import com.kingdee.eas.fm.fin.LoanApplyBillInfo;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.rpcoptimize.LoanEditUIDataRpc;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.ft.FundTransferBillFactory;
import com.kingdee.eas.fm.ft.FundTransferBillInfo;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import java.math.BigDecimal;

public class LoanEditUIDataRpcFetcher
extends BatchFetcher {
    protected void appendCacheValue(Context ctx, FmRpcCacheInfo paramInfo) throws EASBizException, BOSException {
        LoanEditUIDataRpc dataRpc = (LoanEditUIDataRpc)paramInfo;
        int uiState = dataRpc.getUiState();
        int BotpState = dataRpc.getBOTPState();
        LoanInfo loanInfo = dataRpc.getLoanInfo();
        if (loanInfo.getEntLoanID() != null) {
            this.setChLoan(ctx, dataRpc, loanInfo.getEntLoanID().getId().toString());
        }
        if (loanInfo.getLoanApplyBill() != null) {
            this.setLoanApplyBill(ctx, dataRpc, loanInfo.getLoanApplyBill().getId().toString());
        }
        if (loanInfo.getTransBill() != null) {
            this.setTransBill(ctx, dataRpc, loanInfo.getTransBill().getId().toString());
        }
        if (loanInfo.getConsignLoan() != null) {
            this.setConsignBill(ctx, dataRpc, loanInfo.getConsignLoan().getId().toString());
        }
        if (loanInfo.getSourceBillId() != null) {
            this.setSourceBill(ctx, dataRpc, loanInfo.getSourceBillId());
        }
        if (loanInfo.getId() != null) {
            this.setReduceCol(ctx, dataRpc, loanInfo.getId().toString());
            this.setIntCollPrediction(ctx, dataRpc, loanInfo.getId().toString());
            if (FinHelper.isInStates(uiState, new int[]{6, 2})) {
                this.setCanEdit(ctx, dataRpc, loanInfo.getId().toString());
                this.setCanEditConAmount(ctx, dataRpc, loanInfo.getId().toString());
            }
        }
        this.setRemainAmount(ctx, dataRpc, loanInfo);
        this.setExchangeRate(ctx, dataRpc, loanInfo);
    }

    private void setExchangeRate(Context ctx, LoanEditUIDataRpc dataRpc, LoanInfo loanInfo) throws FinBizException, EASBizException, BOSException {
        ExchangeRateInfo retRate = FinUtils.getCurrencyExRateInfo(ctx, dataRpc.getCurrentCompany(), loanInfo.getCurrency(), dataRpc.getCurrentCompany().getBaseCurrency(), loanInfo.getBizDate());
        dataRpc.setRateInfo(retRate);
    }

    private void setRemainAmount(Context ctx, LoanEditUIDataRpc dataRpc, LoanInfo loanInfo) throws BOSException {
        if (loanInfo.isIsInCredit() && loanInfo.getCreditLimit() != null) {
            BigDecimal retRemainAmount = FinUtils.getCreditRemainAmount(ctx, loanInfo.getCreditLimit(), dataRpc.getCurrentCompany());
            dataRpc.setRemainAmount(retRemainAmount);
        }
    }

    private void setCanEditConAmount(Context ctx, LoanEditUIDataRpc dataRpc, String loanId) throws EASBizException, BOSException {
        if (loanId == null) {
            return;
        }
        dataRpc.setCanEditConAmount(LoanFactory.getLocalInstance(ctx).isEditConAmount((IObjectPK)new ObjectUuidPK(loanId)));
    }

    private void setCanEdit(Context ctx, LoanEditUIDataRpc dataRpc, String loanId) throws EASBizException, BOSException {
        if (loanId == null) {
            return;
        }
        dataRpc.setCanEdit(LoanFactory.getLocalInstance(ctx).canEditLoan(loanId));
    }

    private void setReduceCol(Context ctx, LoanEditUIDataRpc dataRpc, String loanId) throws BOSException {
        if (loanId == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billID", (Object)loanId));
        view.setFilter(filter);
        dataRpc.setReduceCol(CreditFinancingReduceFactory.getLocalInstance(ctx).getCreditFinancingReduceCollection(view));
    }

    private void setIntCollPrediction(Context ctx, LoanEditUIDataRpc dataRpc, String loanId) throws BOSException {
        FilterInfo filter2 = new FilterInfo();
        filter2.getFilterItems().add(new FilterItemInfo("loan.id", (Object)loanId));
        filter2.getFilterItems().add(new FilterItemInfo("isPrediction", (Object)new Boolean(true)));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter2);
        evi.getSorter().add(new SorterItemInfo("bizDate"));
        dataRpc.setIntCollPrediction(LoanInterestFactory.getLocalInstance(ctx).getLoanInterestCollection(evi));
    }

    private void setSourceBill(Context ctx, LoanEditUIDataRpc dataRpc, String sourceBillId) throws EASBizException, BOSException {
        if (FMHelper.isInstanceof((String)sourceBillId, ChLoanInfo.class)) {
            this.setChLoan(ctx, dataRpc, sourceBillId);
        } else if (FMHelper.isInstanceof((String)sourceBillId, LoanApplyBillInfo.class)) {
            this.setLoanApplyBill(ctx, dataRpc, sourceBillId);
        } else if (FMHelper.isInstanceof((String)sourceBillId, FundTransferBillInfo.class)) {
            this.setTransBill(ctx, dataRpc, sourceBillId);
        }
    }

    private void setChLoan(Context ctx, LoanEditUIDataRpc dataRpc, String entLoanId) throws BOSException, EASBizException {
        ChLoanInfo retChLoan = ChLoanFactory.getLocalInstance((Context)ctx).getChLoanInfo((IObjectPK)new ObjectStringPK(entLoanId));
        dataRpc.setEntLoanID(retChLoan);
        this.setAccountBankInfo(ctx, dataRpc, retChLoan);
    }

    private void setAccountBankInfo(Context ctx, LoanEditUIDataRpc dataRpc, ChLoanInfo retChLoan) throws BOSException {
        String innerAccountId = retChLoan.getLoanAccount().getId().toString();
        AccountBankInfo accountBankInfo = null;
        AccountBankCollection accountBankCollection = null;
        EntityViewInfo vi = new EntityViewInfo();
        FilterInfo fInfo = new FilterInfo();
        fInfo.getFilterItems().add(new FilterItemInfo("InnerAcct.id", (Object)innerAccountId));
        vi.setFilter(fInfo);
        accountBankCollection = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(vi);
        accountBankInfo = accountBankCollection.size() >= 1 ? accountBankCollection.get(0) : null;
        dataRpc.setAccountBankInfo(accountBankInfo);
    }

    private void setTransBill(Context ctx, LoanEditUIDataRpc dataRpc, String tranBillId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("transCompany.name");
        sic.add("customer.name");
        sic.add("finacingProduct.name");
        sic.add("settleAcctView.name");
        sic.add("opAcctView.name");
        sic.add("currency.name");
        sic.add("currency.precision");
        sic.add("exchangeRate");
        sic.add("rateType.name");
        sic.add("accountant.name");
        sic.add("creator.name");
        sic.add("project.name");
        sic.add("guaranteeType.name");
        sic.add("guaranteeType.property");
        sic.add("distributeAcctBank.name");
        sic.add("voucherType.id");
        sic.add("voucherType.name");
        sic.add("isGenLoan");
        sic.add("company.id");
        sic.add("company.number");
        sic.add("company.name");
        sic.add("distributeAcctBank.id");
        sic.add("distributeAcctBank.number");
        sic.add("distributeAcctBank.name");
        sic.add("intFreeAmt");
        sic.add("lastRepayDate");
        sic.add("extTimes");
        sic.add("repayTimes");
        sic.add("finacingProduct.FinancingSource.id");
        FundTransferBillInfo transferBill = FundTransferBillFactory.getLocalInstance((Context)ctx).getFundTransferBillInfo((IObjectPK)new ObjectUuidPK(tranBillId), sic);
        dataRpc.setTransferBill(transferBill);
    }

    private void setConsignBill(Context ctx, LoanEditUIDataRpc dataRpc, String consignBillId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("repayEntries.*");
        sic.add("loanCompanyBank.id");
        sic.add("loanCompanyBank.number");
        sic.add("loanCompanyBank.name");
        sic.add("depositary.id");
        sic.add("depositary.number");
        sic.add("depositary.name");
        sic.add("finacingProduct.*");
        sic.add("guaranteeType.id");
        sic.add("guaranteeType.number");
        sic.add("guaranteeType.name");
        ConsignmentLoanBillInfo consignBill = ConsignmentLoanBillFactory.getLocalInstance((Context)ctx).getConsignmentLoanBillInfo((IObjectPK)new ObjectUuidPK(consignBillId), sic);
        dataRpc.setConsignBill(consignBill);
    }

    private void setLoanApplyBill(Context ctx, LoanEditUIDataRpc dataRpc, String applyBillId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("currency");
        sic.add("accountBank");
        sic.add("accountBank.account");
        sic.add("accountBank.account.name");
        sic.add("purpose");
        sic.add("loanProperty");
        sic.add("loanType");
        sic.add("bank.*");
        sic.add("financingOrg");
        sic.add("maturityDate");
        sic.add("loanProperty");
        LoanApplyBillInfo retloanApplyBill = LoanApplyBillFactory.getLocalInstance(ctx).getLoanApplyBillInfo((IObjectPK)new ObjectStringPK(applyBillId), sic);
        dataRpc.setLoanApplyBill(retloanApplyBill);
    }
}

