/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.rpcoptimize;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.app.BatchFetcher;
import com.kingdee.eas.fm.fin.FinUtils;
import com.kingdee.eas.fm.fin.LoanFactory;
import com.kingdee.eas.fm.fin.LoanInfo;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.RepaymentCollection;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fin.rpcoptimize.RepaymentEditUIDataRpc;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.util.client.EASResource;

public class RepaymentEditUIDataRpcFetcher
extends BatchFetcher {
    protected void appendCacheValue(Context ctx, FmRpcCacheInfo paramInfo) throws EASBizException, BOSException {
        RepaymentEditUIDataRpc dataRpc = (RepaymentEditUIDataRpc)paramInfo;
        int uiState = dataRpc.getUiState();
        int BotpState = dataRpc.getBOTPState();
        RepaymentInfo rpInfo = dataRpc.getRepaymentInfo();
        if (FinHelper.isInStates(uiState, new int[]{6, 2})) {
            if (rpInfo.getId() == null) {
                FinUtils.throwFMCommonException(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"456_RepaymentEditUIDataRpcFetcher"));
            }
            if (FMHelper.isInstanceof((String)rpInfo.getSourceBillId(), LoanInfo.class)) {
                this.fillExistLoanInt(ctx, dataRpc, rpInfo);
                this.fillExistInterst(ctx, dataRpc, rpInfo);
            }
        }
        if (rpInfo.getSourceBillId() != null) {
            this.fillPreRepaymentInfo(ctx, dataRpc, rpInfo);
            this.fillNextRepaymentInfo(ctx, dataRpc, rpInfo);
            if (FMHelper.isInstanceof((String)rpInfo.getSourceBillId(), LoanInfo.class)) {
                this.fillSrcLoanInfo(ctx, dataRpc, rpInfo.getSourceBillId());
            }
        }
    }

    private void fillNextRepaymentInfo(Context ctx, RepaymentEditUIDataRpc dataRpc, RepaymentInfo rpInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)rpInfo.getSourceBillId()));
        filter.getFilterItems().add(new FilterItemInfo("repaySeq", (Object)new Integer(rpInfo.getRepaySeq() + 1)));
        view.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        if (col == null || col.size() == 0) {
            dataRpc.setNextRepayment(null);
        } else {
            dataRpc.setNextRepayment(col.get(0));
        }
    }

    private void fillPreRepaymentInfo(Context ctx, RepaymentEditUIDataRpc dataRpc, RepaymentInfo rpInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)rpInfo.getSourceBillId()));
        filter.getFilterItems().add(new FilterItemInfo("repaySeq", (Object)new Integer(rpInfo.getRepaySeq() - 1)));
        view.setFilter(filter);
        RepaymentCollection col = RepaymentFactory.getLocalInstance(ctx).getRepaymentCollection(view);
        if (col == null || col.size() == 0) {
            dataRpc.setPreRepayment(null);
        } else {
            dataRpc.setPreRepayment(col.get(0));
        }
    }

    private void fillSrcLoanInfo(Context ctx, RepaymentEditUIDataRpc dataRpc, String loanId) throws BOSException, EASBizException {
        LoanInfo ret = LoanFactory.getLocalInstance(ctx).getLoanInfo((IObjectPK)new ObjectStringPK(loanId));
        dataRpc.setSrcLoanInfo(ret);
    }

    private void fillExistInterst(Context ctx, RepaymentEditUIDataRpc dataRpc, RepaymentInfo rpInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("interestType", (Object)new Integer(0)));
        filter.getFilterItems().add(new FilterItemInfo("interestType", (Object)new Integer(4)));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)rpInfo.getBizDate(), CompareType.GREATER_EQUALS));
        dataRpc.setExistIntAfterBizDate(LoanInterestFactory.getLocalInstance(ctx).exists(filter));
    }

    private void fillExistLoanInt(Context ctx, RepaymentEditUIDataRpc dataRpc, RepaymentInfo rpInfo) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("repayment", (Object)rpInfo.getId().toString()));
        dataRpc.setExistLoanInterest(LoanInterestFactory.getLocalInstance(ctx).exists(filter));
    }

    public FmRpcCacheInfo fetchData(Context ctx, FmRpcCacheInfo paramInfo) throws BOSException, EASBizException {
        FmRpcCacheInfo cacheInfo = (FmRpcCacheInfo)paramInfo.clone();
        CompanyOrgUnitInfo currentCompany = this.getCurrentCompany(ctx, paramInfo);
        cacheInfo.setCurrentCompany(currentCompany);
        boolean isClearingHourse = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(currentCompany.getId().toString());
        cacheInfo.setClearingHouse(isClearingHourse);
        this.appendCacheValue(ctx, cacheInfo);
        return cacheInfo;
    }
}

