/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.rpcoptimize;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.app.BatchFetcher;
import com.kingdee.eas.fm.fin.rpcoptimize.RepaymentEditUIEnvirRpc;
import java.util.Set;

public class RepaymentEditUIEnvirRpcFetcher
extends BatchFetcher {
    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx, FmRpcCacheInfo paramInfo) throws BOSException, EASBizException {
        if (paramInfo.getCurrentCompany() == null) {
            return ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        return paramInfo.getCurrentCompany();
    }

    protected void appendCacheValue(Context ctx, FmRpcCacheInfo paramInfo) throws EASBizException, BOSException {
        RepaymentEditUIEnvirRpc pinfo = (RepaymentEditUIEnvirRpc)paramInfo;
        String permissionItem = "fin_Repayment_addnew";
        CompanyOrgUnitCollection orgs = RepaymentEditUIEnvirRpcFetcher.getUserOrgRangesWithRange(ctx, permissionItem);
        pinfo.setUserOrgRang(orgs);
    }

    public static CompanyOrgUnitCollection getUserOrgRangesWithRange(Context ctx, String permissionItem) throws BOSException, EASBizException {
        IPermission permission;
        UserInfo userInfo = null;
        if (ctx == null) {
            userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
            permission = PermissionFactory.getRemoteInstance();
        } else {
            userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            permission = PermissionFactory.getLocalInstance((Context)ctx);
        }
        Set idSet = permission.getAuthorizedOrgIds((IObjectPK)new ObjectUuidPK(userInfo.getId()), OrgType.Company, null, permissionItem);
        if (idSet.size() == 0) {
            return new CompanyOrgUnitCollection();
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter2 = new FilterInfo();
        view.setTopCount(100);
        view.setFilter(filter2);
        filter2.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("baseCurrency.name");
        sic.add("accountTable.id");
        sic.add("accountTable.name");
        view.setSelector(sic);
        if (ctx == null) {
            return CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        }
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
    }

    public FmRpcCacheInfo fetchData(Context ctx, FmRpcCacheInfo paramInfo) throws BOSException, EASBizException {
        FmRpcCacheInfo cacheInfo = (FmRpcCacheInfo)paramInfo.clone();
        CompanyOrgUnitInfo currentCompany = this.getCurrentCompany(ctx, paramInfo);
        cacheInfo.setCurrentCompany(currentCompany);
        cacheInfo.setHasCodeRule(super.hasNumber(ctx, cacheInfo.getBillInfo(), currentCompany.getId().toString()));
        String number = "not getting number";
        try {
            number = super.getNumber(ctx, cacheInfo);
        }
        catch (EASBizException e) {
            if (e.getMessage().contains("\u987a\u5e8f\u53f7\u5df2\u7ecf\u7528\u5b8c")) {
                number = "number sequence has used up";
            }
            throw e;
        }
        cacheInfo.setNumber(number);
        boolean isClearingHourse = BankFactory.getLocalInstance((Context)ctx).isClearinghouseCompany(currentCompany.getId().toString());
        cacheInfo.setClearingHouse(isClearingHourse);
        CurrencyInfo currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(currentCompany);
        cacheInfo.setCurrentCurrency(currency);
        this.appendCacheValue(ctx, cacheInfo);
        return cacheInfo;
    }
}

