/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.IntReceivedBillTypeEnum;
import com.kingdee.eas.fm.common.UnDepositTypeEnum;
import com.kingdee.eas.fm.common.util.AccrualCalculatorElementNeededInfo;
import com.kingdee.eas.fm.common.util.AccrualResultInfo;
import com.kingdee.eas.fm.fin.CompDepositAccountBillInfo;
import com.kingdee.eas.fm.fin.CompIntReceivedBillInfo;
import com.kingdee.eas.fm.fin.CompUnTimeDepositBillInfo;
import com.kingdee.eas.fm.fin.IntReceiveHelper;
import com.kingdee.eas.fm.im.IIntRateBase;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.math.BigDecimal;
import java.util.Date;

public class AccrualCalculatorPropertyUtil {
    public static void copyPropertiesValue(Context ctx, AccrualCalculatorElementNeededInfo aceni, CoreBaseInfo info, IntReceivedBillTypeEnum intReceiveType) {
        if (info instanceof CompDepositAccountBillInfo) {
            aceni.setIntReceivedBillTypeEnum(intReceiveType);
            AccrualCalculatorPropertyUtil.copyPropertiesValueFromTimeDepositInfo(ctx, aceni, (CompDepositAccountBillInfo)info);
        } else if (info instanceof CompUnTimeDepositBillInfo) {
            aceni.setIntReceivedBillTypeEnum(intReceiveType);
            if (intReceiveType == IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT) {
                AccrualCalculatorPropertyUtil.copyPropertiesValueFromUnTimeDepositInfo(ctx, aceni, (CompUnTimeDepositBillInfo)info);
            }
        }
    }

    private static void copyPropertiesValueFromUnTimeDepositInfo(Context ctx, AccrualCalculatorElementNeededInfo aceni, CompUnTimeDepositBillInfo info) {
        CompDepositAccountBillInfo timeDepositBill = info.getTimeDepositBill();
        aceni.setUnDepositAmt(info.getUnDepositAmt());
        aceni.setUnDepositDate(info.getUntimeDate());
        aceni.setUnDepositTypeEnum(info.getUnDepositType());
        aceni.setIntRateTypeExpressionEnum(timeDepositBill.getIntRateTypeExpression());
        aceni.setEffectedDate(timeDepositBill.getLastPayDate());
        aceni.setIntTerm(timeDepositBill.getInterm());
        if (info.getUnDepositType() == UnDepositTypeEnum.MATURE_UNDEPOSIT) {
            aceni.setMaturityDate(DateUtil.getBeforeDay((Date)timeDepositBill.getMaturityDay()));
        } else {
            aceni.setMaturityDate(DateUtil.getBeforeDay((Date)info.getBizDate()));
        }
        aceni.setYearRate(AccrualCalculatorPropertyUtil.getYearRate(ctx, timeDepositBill, aceni));
        aceni.setCurYearRate(info.getYearRate());
        aceni.setYearDays(new BigDecimal(String.valueOf(timeDepositBill.getYearDays())));
    }

    private static void copyPropertiesValueFromTimeDepositInfo(Context ctx, AccrualCalculatorElementNeededInfo aceni, CompDepositAccountBillInfo info) {
        aceni.setDepositBalance(info.getBalance());
        aceni.setMaturityDate(info.getMaturityDay());
        aceni.setEffectedDate(info.getLastPayDate());
        aceni.setFloorAmt(info.getIntFreeAmt());
        aceni.setIntRateType(info.getIntRateTable());
        aceni.setFloatting(info.getBasePoints());
        aceni.setCurrency(info.getCurrency());
        aceni.setBizDate(info.getBizDate());
        aceni.setIntRateTypeExpressionEnum(info.getIntRateTypeExpression());
        aceni.setTimeDepositType(info.getDepositType());
        aceni.setYearDays(new BigDecimal(String.valueOf(info.getYearDays())));
        if (aceni.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.INTBILL_REDEPOSIT) {
            aceni.setDepositBalance(info.getBalance());
        } else if (aceni.getIntReceivedBillTypeEnum() == IntReceivedBillTypeEnum.PRE_DRAWING) {
            aceni.setDepositBalance(info.getBalance());
            aceni.setLastPreDate(info.getLastIntDate());
        }
        aceni.setYearRate(AccrualCalculatorPropertyUtil.getYearRate(ctx, info, aceni));
        aceni.setIntTerm(info.getInterm());
    }

    private static BigDecimal getYearRate(Context ctx, CompDepositAccountBillInfo info, AccrualCalculatorElementNeededInfo aceni) {
        return IntReceiveHelper.calcuYearRate_Redeposit(ctx, info, info.getBizDate());
    }

    public static void copyResultToIntBillInfo(CoreBaseInfo info, AccrualResultInfo accrualResultInfo) {
        if (accrualResultInfo != null && info instanceof CompIntReceivedBillInfo) {
            CompIntReceivedBillInfo intBill = (CompIntReceivedBillInfo)info;
            if (IntReceivedBillTypeEnum.PRE_DRAWING.equals((Object)intBill.getIntReceiveType())) {
                AccrualCalculatorPropertyUtil.copyResultToIntReceiveInfo_Bank(accrualResultInfo, intBill);
            } else if (IntReceivedBillTypeEnum.INTBILL_PAYINTEREST.equals((Object)intBill.getIntReceiveType())) {
                AccrualCalculatorPropertyUtil.copyResultToIntReceivePayInfo_Bank(accrualResultInfo, intBill);
            } else if (IntReceivedBillTypeEnum.INTBILL_UNTIMEDEPOSIT.equals((Object)intBill.getIntReceiveType())) {
                AccrualCalculatorPropertyUtil.copyResultToUntimeDeposit_Bank(accrualResultInfo, intBill);
            } else {
                AccrualCalculatorPropertyUtil.copyResultToIntReceiveInfo_Bank(accrualResultInfo, intBill);
            }
            intBill.setIntervalDays(accrualResultInfo.getDays().intValue());
        }
    }

    private static BigDecimal calcYearRate(Context ctx, IntRateTypeInfo intType, BigDecimal floating, CurrencyInfo currency, Date date) {
        if (floating == null || intType == null) {
            return null;
        }
        IntRateBaseInfo intratebase = null;
        try {
            IIntRateBase iir = null;
            iir = ctx == null ? IntRateBaseFactory.getRemoteInstance() : IntRateBaseFactory.getLocalInstance((Context)ctx);
            intratebase = iir.getCurRateByCond(intType.getId().toString(), currency.getId().toString(), date);
        }
        catch (EASBizException e) {
            SysUtil.abort((Throwable)e);
        }
        catch (BOSException e) {
            SysUtil.abort((Throwable)e);
        }
        if (intratebase == null) {
            return Constants.ZERO;
        }
        return intratebase.getYearRate().add(floating.divide(Constants.ONE_HUNDRED, 5, 4));
    }

    private static void copyResultToIntReceiveInfo_Bank(AccrualResultInfo accrualResultInfo, CompIntReceivedBillInfo objectValue) {
        objectValue.setDeInterest(accrualResultInfo.getPeriodicalAccrual());
        if (objectValue.getIntReceiveType().equals((Object)IntReceivedBillTypeEnum.PRE_DRAWING)) {
            objectValue.setCreInterest(accrualResultInfo.getCurrentAccrual());
        }
        objectValue.setYingjiAmt(objectValue.getDeInterest().add(objectValue.getCreInterest()));
        objectValue.setShijiAmt(objectValue.getYingjiAmt());
        objectValue.setWeixiaoheAmt(accrualResultInfo.getUnVerifyAmt());
        objectValue.setYichongxiaoAmt(accrualResultInfo.getStrikedAmt());
    }

    private static void copyResultToIntReceivePayInfo_Bank(AccrualResultInfo accrualResultInfo, CompIntReceivedBillInfo objectValue) {
        objectValue.setDeInterest(accrualResultInfo.getPeriodicalAccrual());
        objectValue.setCreInterest(accrualResultInfo.getCurrentAccrual());
        objectValue.setYingjiAmt(accrualResultInfo.getPeriodicalAccrual().add(accrualResultInfo.getCurrentAccrual()));
        objectValue.setShijiAmt(objectValue.getYingjiAmt());
        objectValue.setWeixiaoheAmt(accrualResultInfo.getUnVerifyAmt());
        objectValue.setYichongxiaoAmt(accrualResultInfo.getStrikedAmt());
    }

    private static void copyResultToUntimeDeposit_Bank(AccrualResultInfo accrualResultInfo, CompIntReceivedBillInfo objectValue) {
        objectValue.setDeInterest(accrualResultInfo.getPeriodicalAccrual());
        objectValue.setCreInterest(accrualResultInfo.getCurrentAccrual());
        objectValue.setYingjiAmt(accrualResultInfo.getPeriodicalAccrual().add(accrualResultInfo.getCurrentAccrual()));
        objectValue.setShijiAmt(objectValue.getYingjiAmt());
        objectValue.setWeixiaoheAmt(accrualResultInfo.getUnVerifyAmt());
        objectValue.setYichongxiaoAmt(accrualResultInfo.getStrikedAmt());
    }
}

