/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.fin.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.fin.FinancingBillTypeEnum;
import com.kingdee.eas.fm.fin.LoanInterestCollection;
import com.kingdee.eas.fm.fin.LoanInterestFactory;
import com.kingdee.eas.fm.fin.LoanInterestInfo;
import com.kingdee.eas.fm.fin.RepaymentFactory;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.util.client.EASResource;
import java.text.MessageFormat;

public class FinBizTools {
    public static void setPaymentBill4FinSrcBill(PaymentBillInfo info, String srcID, String ownerUiName) throws EASBizException, BOSException {
        BOSUuid bisid;
        BOSObjectType idType;
        if (srcID == null) {
            srcID = info.getSourceBillId();
        }
        if ((idType = (bisid = BOSUuid.read((String)srcID)).getType()).equals((Object)RepaymentInfo.BOSTYPE)) {
            FinBizTools.setDataObjectWhenRepayment(info, bisid, ownerUiName);
        } else if (idType.equals((Object)new LoanInterestInfo().getBOSType())) {
            FinBizTools.setDataObjectWhenInterest(info, bisid);
        }
        info.setIsNeedPay(true);
    }

    private static void setDataObjectWhenInterest(PaymentBillInfo info, BOSUuid bisid) throws EASBizException, BOSException {
        LoanInterestInfo srcIntLoan = LoanInterestFactory.getRemoteInstance().getLoanInterestInfo((IObjectPK)new ObjectUuidPK(bisid), FinBizTools.getSrcInterestSelector());
        info.setOppAccount(srcIntLoan.getIntFeeAcctView());
        if (info.getPayerAccountBank() != null && info.getPayerAccountBank().getAccount() != null) {
            BOSUuid bankID;
            BOSUuid accountViewID = info.getPayerAccountBank().getAccount().getId();
            if (accountViewID != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                AccountViewInfo avInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountViewID), sic);
                info.setPayerAccount(avInfo);
            }
            if ((bankID = info.getPayerAccountBank().getBank().getId()) != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("number"));
                BankInfo bank = BankFactory.getRemoteInstance().getBankInfo((IObjectPK)new ObjectUuidPK(bankID), sic);
                info.setPayerBank(bank);
                info.getPayerAccountBank().setBank(bank);
            }
        } else {
            info.setPayerAccount(null);
            info.setPayerBank(null);
        }
        if (info.getPayeeBank() == null && srcIntLoan.getAccount() != null && srcIntLoan.getAccount().getBank() != null) {
            info.setPayeeBank(srcIntLoan.getAccount().getBank().getName());
        }
        info.setSourceBillId(srcIntLoan.getId().toString());
        if (info.getPayeeName() == null) {
            if (!srcIntLoan.getLoan().isIsGroupLoan()) {
                if (null != srcIntLoan.getLoan().getInstitution()) {
                    info.setPayeeName(srcIntLoan.getLoan().getInstitution().getName());
                    info.setPayeeNumber(srcIntLoan.getLoan().getInstitution().getNumber());
                }
            } else if (null != srcIntLoan.getLoan().getGroupID()) {
                info.setPayeeName(srcIntLoan.getLoan().getGroupID().getName());
                info.setPayeeNumber(srcIntLoan.getLoan().getGroupID().getNumber());
            }
        }
        if (srcIntLoan.getDescription() != null && srcIntLoan.getDescription().trim().length() > 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"520_FinBizTools");
            msg = MessageFormat.format(msg, srcIntLoan.getDescription());
            info.setDescription(msg);
        }
    }

    private static SelectorItemCollection getSrcInterestSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loan.*"));
        sic.add(new SelectorItemInfo("account.id"));
        sic.add(new SelectorItemInfo("account.number"));
        sic.add(new SelectorItemInfo("account.name"));
        sic.add(new SelectorItemInfo("account.accountType"));
        sic.add(new SelectorItemInfo("account.account.id"));
        sic.add(new SelectorItemInfo("account.account.number"));
        sic.add(new SelectorItemInfo("account.account.name"));
        sic.add(new SelectorItemInfo("account.bank.id"));
        sic.add(new SelectorItemInfo("account.bank.number"));
        sic.add(new SelectorItemInfo("account.bank.name"));
        sic.add(new SelectorItemInfo("intFeeAcctView.id"));
        sic.add(new SelectorItemInfo("intFeeAcctView.number"));
        sic.add(new SelectorItemInfo("intFeeAcctView.name"));
        sic.add(new SelectorItemInfo("loan.Institution.id"));
        sic.add(new SelectorItemInfo("loan.Institution.number"));
        sic.add(new SelectorItemInfo("loan.Institution.name"));
        sic.add(new SelectorItemInfo("loan.GroupID.id"));
        sic.add(new SelectorItemInfo("loan.GroupID.number"));
        sic.add(new SelectorItemInfo("loan.GroupID.name"));
        return sic;
    }

    private static void setDataObjectWhenRepayment(PaymentBillInfo info, BOSUuid bisid, String ownerUiName) throws EASBizException, BOSException {
        RepaymentInfo srcLoan = RepaymentFactory.getRemoteInstance().getRepaymentInfo((IObjectPK)new ObjectUuidPK(bisid), FinBizTools.getSrcRepaymentSelector());
        info.setSourceBillId(srcLoan.getId().toString());
        LoanInterestInfo intRe = FinBizTools.findLoanInterestBillInfo((IObjectPK)new ObjectUuidPK(bisid));
        if (!"com.kingdee.eas.fm.nt.client.PayableCashBillListUI".equals(ownerUiName) && !FinancingBillTypeEnum.Loan.equals((Object)srcLoan.getSourceType())) {
            if (intRe == null) {
                info.getEntries().get(0).setActualAmt(srcLoan.getSourceAmount().add(srcLoan.getInterest()));
            } else {
                info.getEntries().get(0).setActualAmt(srcLoan.getSourceAmount());
            }
        }
        if (null != srcLoan.getLoan() && !srcLoan.isIsBondsRepayment()) {
            if (!srcLoan.getLoan().isIsGroupLoan()) {
                info.setPayeeName(srcLoan.getLoan().getInstitution().getName());
                info.setPayeeNumber(srcLoan.getLoan().getInstitution().getNumber());
            } else {
                info.setPayeeName(srcLoan.getLoan().getGroupID().getName());
                info.setPayeeNumber(srcLoan.getLoan().getGroupID().getNumber());
            }
        }
    }

    private static LoanInterestInfo findLoanInterestBillInfo(IObjectPK srcBillPK) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("repayment.id", (Object)srcBillPK.toString()));
        evi.setFilter(f);
        LoanInterestCollection intCol = LoanInterestFactory.getRemoteInstance().getLoanInterestCollection(evi);
        if (intCol != null && intCol.size() > 0) {
            return intCol.get(0);
        }
        return null;
    }

    private static SelectorItemCollection getSrcRepaymentSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("loan.IsBankLoan"));
        sic.add(new SelectorItemInfo("loan.IsGroupLoan"));
        sic.add(new SelectorItemInfo("BankAcct.id"));
        sic.add(new SelectorItemInfo("BankAcct.name"));
        sic.add(new SelectorItemInfo("BankAcct.number"));
        sic.add(new SelectorItemInfo("BankAcct.bank.id"));
        sic.add(new SelectorItemInfo("BankAcct.bank.number"));
        sic.add(new SelectorItemInfo("BankAcct.bank.name"));
        sic.add(new SelectorItemInfo("BankAcct.accountType"));
        sic.add(new SelectorItemInfo("BankAcct.company.id"));
        sic.add(new SelectorItemInfo("LoanAcct.id"));
        sic.add(new SelectorItemInfo("LoanAcct.name"));
        sic.add(new SelectorItemInfo("LoanAcct.number"));
        sic.add(new SelectorItemInfo("loan.Institution.id"));
        sic.add(new SelectorItemInfo("loan.Institution.number"));
        sic.add(new SelectorItemInfo("loan.Institution.name"));
        sic.add(new SelectorItemInfo("loan.GroupID.id"));
        sic.add(new SelectorItemInfo("loan.GroupID.number"));
        sic.add(new SelectorItemInfo("loan.GroupID.name"));
        return sic;
    }
}

