/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.ivt.client.AbstractChLoanExtendBillFilterUI;
import com.kingdee.eas.fm.ivt.client.ChLoanExtendBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ChLoanExtendBillFilterUI
extends AbstractChLoanExtendBillFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ChLoanExtendBillFilterUI.class);
    private boolean isBOTP;

    public ChLoanExtendBillFilterUI(boolean isBOTP) throws Exception {
        this.isBOTP = isBOTP;
    }

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
        this.prmtLoanCompany.setSelector((KDPromptSelector)F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)true));
    }

    private void customInit() {
        this.initDate();
        this.initCurrency();
        this.prmtLoanCompany.setValue(null);
        this.radioSubmit.setSelected(true);
    }

    private void initDate() {
        Date now = new Date();
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    private void initCurrency() {
        CashHelper.initCombCurrency((KDComboBox)this.comboCurrency, (boolean)false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public Object getParam() {
        Object obj;
        ChLoanExtendBillFilterParam chLoanFilterParam = new ChLoanExtendBillFilterParam();
        if (null != this.dpStartDate.getValue()) {
            chLoanFilterParam.setStartDate(DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())));
        }
        if (null != this.dpEndDate.getValue()) {
            chLoanFilterParam.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())));
        }
        if (null != this.comboCurrency.getSelectedItem() && (obj = this.comboCurrency.getSelectedItem()) instanceof CurrencyInfo) {
            chLoanFilterParam.setCurrencyInfo((CurrencyInfo)this.comboCurrency.getSelectedItem());
        }
        if (this.prmtLoanCompany.isEnabled()) {
            if (null != this.prmtLoanCompany.getValue()) {
                chLoanFilterParam.setLoanCompany(AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoanCompany));
            }
        } else {
            CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            String[] ids = new String[]{company.getId().toString()};
            chLoanFilterParam.setLoanCompany(ids);
        }
        if (this.radioSave.isSelected()) {
            chLoanFilterParam.setStatus(new Integer(1));
        } else if (this.radioSubmit.isSelected()) {
            chLoanFilterParam.setStatus(new Integer(2));
        } else {
            chLoanFilterParam.setStatus(null);
        }
        chLoanFilterParam.setBOTP(this.isBOTP);
        return chLoanFilterParam;
    }

    protected Class getParamClass() {
        return ChLoanExtendBillFilterParam.class;
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }

    public void setParam(Object param) {
        ChLoanExtendBillFilterParam filterParam;
        block13: {
            if (null == param || !(param instanceof ChLoanExtendBillFilterParam)) {
                return;
            }
            filterParam = (ChLoanExtendBillFilterParam)param;
            this.dpStartDate.setValue((Object)filterParam.getStartDate());
            this.dpEndDate.setValue((Object)filterParam.getEndDate());
            if (filterParam.getCurrencyInfo() == null) {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
            } else {
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)filterParam.getCurrencyInfo());
            }
            if (this.prmtLoanCompany.isEnabled()) {
                try {
                    if (!FMHelper.isEmpty((Object[])filterParam.getLoanCompany())) {
                        EntityViewInfo ev = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])filterParam.getLoanCompany()), CompareType.INCLUDE));
                        ev.setFilter(filter);
                        CompanyOrgUnitCollection com = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
                        this.prmtLoanCompany.setValue((Object)com.toArray());
                        break block13;
                    }
                    this.prmtLoanCompany.setValue(null);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
                }
            } else {
                CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
                this.prmtLoanCompany.setValue((Object)new Object[]{company});
            }
        }
        if (filterParam.getStatus() == null) {
            this.radioAll.setSelected(true);
        } else if (filterParam.getStatus() == 1) {
            this.radioSave.setSelected(true);
        } else if (filterParam.getStatus() == 2) {
            this.radioSubmit.setSelected(true);
        }
    }

    public boolean verify() {
        if (DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())))) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"enddate_error"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    public void clear() {
        super.clear();
        this.customInit();
        this.radioSubmit.setSelected(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
    }
}

