/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.cl.modelutils.ResourceFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.SumBillEnum;
import com.kingdee.eas.fm.common.SumFiledsInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.erec.client.EReceiptInnerClientHelper;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.ivt.CHLoanException;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanIntPreFacadeFactory;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.IvtBillStatusEnum;
import com.kingdee.eas.fm.ivt.client.AbstractChLoanListUI;
import com.kingdee.eas.fm.ivt.client.ChLoanDataProvider;
import com.kingdee.eas.fm.ivt.client.ChLoanEditUI;
import com.kingdee.eas.fm.ivt.client.ChLoanFilterParam;
import com.kingdee.eas.fm.ivt.client.ChLoanFilterUI;
import com.kingdee.eas.fm.ivt.client.ChLoanFinancingProductor;
import com.kingdee.eas.fm.ivt.client.ChLoanRateAdjustBillEditUI;
import com.kingdee.eas.fm.ivt.client.CreditLevelChosserUI;
import com.kingdee.eas.fm.ivt.client.EntRepaymentBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ChLoanListUI
extends AbstractChLoanListUI {
    private String LOANINTBILL_FILENAME = "/FM/INVEST/IVT/CHLOAN";
    private static final Logger logger = CoreUIObject.getLogger(ChLoanListUI.class);
    ISortManager sm;
    private BankInfo clearingHouse;
    private ChLoanFilterUI filterUI;
    FillListener fillListener = new FillListener();

    protected CommonQueryProcessor getQueryProcessor() {
        return new ChLoanFinancingProductor((IUIObject)this);
    }

    public void onLoad() throws Exception {
        Map hm = (Map)this.getUIContext().get("BTPEDITPARAMETER");
        if (hm == null || hm.get("fromBankLoan") == null) {
            if (this.getOprtState() == null) {
                FSClientHelper.checkClearingHouseCompany();
                this.clearingHouse = FSClientHelper.getClearingHouse();
                if (this.clearingHouse == null || !this.clearingHouse.isUsed()) {
                    throw new CHLoanException(CHLoanException.USE_CLEARING_HOUSE_FIRST);
                }
            } else if (!this.getOprtState().equals("FINDVIEW")) {
                this.clearingHouse = FSClientHelper.getClearingHouse();
                if (this.clearingHouse == null || !this.clearingHouse.isUsed()) {
                    throw new CHLoanException(CHLoanException.USE_CLEARING_HOUSE_FIRST);
                }
            }
        }
        super.onLoad();
        this.actionTDPrint.setVisible(true);
        this.actionTDPrintPreview.setVisible(true);
        this.actionAuditResult.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionTraceUp.setVisible(true);
        this.actionTraceUp.setEnabled(true);
        this.actionViewBdgBalance.setVisible(true);
        this.actionWorkFlowG.setVisible(true);
        this.actionWorkFlowG.setEnabled(true);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnTDPrint.setVisible(false);
        this.btnTDPrePrintView.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnAntiAudit.setVisible(false);
        this.btnCancelBook.setVisible(false);
        this.initSortManager();
        this.tblMain.getColumn("bizdate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("lastSettleDate").getStyleAttributes().setNumberFormat(this.dformat);
        this.tblMain.getColumn("lastPreIntDate").getStyleAttributes().setNumberFormat(this.dformat);
    }

    private void initSortManager() {
        this.sm = new KDTSortManager(this.tblMain){

            public void sort(int colIndex, int sortType) {
                if (ChLoanListUI.this.tblMain.getColumn(colIndex).getKey().equals("rate")) {
                    ChLoanListUI.this.tblMain.getColumn("yearRate").setSortable(true);
                    int tmpColIndex = ChLoanListUI.this.tblMain.getColumn("yearRate").getColumnIndex();
                    super.setSortAuto(true);
                    super.sort(tmpColIndex, sortType);
                    super.setSortAuto(false);
                    super.sort(colIndex, sortType);
                } else {
                    super.sort(colIndex, sortType);
                }
            }
        };
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    ChLoanListUI.this.sm.sort(e.getColIndex());
                }
            }
        });
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            Map hm = (Map)this.getUIContext().get("BTPEDITPARAMETER");
            boolean flag = hm != null && hm.get("fromBankLoan") != null;
            this.filterUI = new ChLoanFilterUI(flag);
        }
        return this.filterUI;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        ItemAction action = this.getActionFromActionEvent(e);
        if (action.equals((Object)this.actionAddNewHis)) {
            uiContext.put((Object)"addType", (Object)Boolean.TRUE);
        }
        if (action.equals(this.actionAddNew)) {
            uiContext.put((Object)"addType", (Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ChLoanFactory.getRemoteInstance().editCheck(this.getSelectedKeyValue());
        ChLoanInfo chLoanInfo = this.getSelectedObject(this.getSelectedKeyValue());
        if (!(chLoanInfo.isIsHistoryLoan() || chLoanInfo.getBillStatus() != IvtBillStatusEnum.AUDIT && chLoanInfo.getBillStatus() != IvtBillStatusEnum.BOOK)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"61_ChLoanListUI"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        sic.add("currency.id");
        sic.add("currency.number");
        sic.add("currency.name");
        sic.add("company.*");
        sic.add("fpItem.id");
        sic.add("fpItem.number");
        sic.add("fpItem.name");
        sic.add("outBgItemId");
        sic.add("oUtBgItemName");
        sic.add("outBgItemNumber");
        return sic;
    }

    private void preEdit(String selectedKeyValue) throws Exception {
        ChLoanInfo chLoanInfo = this.getSelectedObject(selectedKeyValue);
        if (chLoanInfo.getBillStatus() != IvtBillStatusEnum.SAVE) {
            throw new CHLoanException(CHLoanException.EDIT_ERROR1);
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.deleteCheck(this.getSelectedKeyValue());
        super.actionRemove_actionPerformed(e);
    }

    private void deleteCheck(String selectedKeyValue) throws Exception {
        boolean canBeDelete;
        boolean isBooked;
        ChLoanInfo chLoanInfo = this.getSelectedObject(selectedKeyValue);
        if (!(chLoanInfo.isIsHistoryLoan() || chLoanInfo.getBillStatus() != IvtBillStatusEnum.AUDIT && chLoanInfo.getBillStatus() != IvtBillStatusEnum.BOOK)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"62_ChLoanListUI"));
            SysUtil.abort();
        }
        boolean isReturn = chLoanInfo.isIsReturned();
        boolean isOverDue = chLoanInfo.isIsOverdue();
        boolean isPosponed = chLoanInfo.isIsPostponed();
        boolean isVouched = chLoanInfo.isFivouchered();
        boolean isDownLoaded = chLoanInfo.isIsDownLoaded();
        boolean isSettled = this.isSettled(chLoanInfo);
        boolean isPreInt = this.isPreIntd(chLoanInfo);
        boolean bl = isBooked = chLoanInfo.getBillStatus() == IvtBillStatusEnum.BOOK;
        if (chLoanInfo.isIsHistoryLoan()) {
            isBooked = false;
        }
        boolean isAudited = chLoanInfo.getBillStatus() == IvtBillStatusEnum.AUDIT;
        boolean bl2 = canBeDelete = !isReturn && !isOverDue && !isPosponed && !isVouched && !isSettled && !isPreInt && !isDownLoaded && !isBooked && !isAudited;
        if (!canBeDelete) {
            throw new CHLoanException(CHLoanException.DELETE_ERROR1);
        }
    }

    private ChLoanInfo getSelectedObject(String selectedKeyValue) throws BOSException, EASBizException {
        ChLoanInfo chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(selectedKeyValue));
        return chLoanInfo;
    }

    private boolean isPreIntd(ChLoanInfo chLoanInfo) {
        if (chLoanInfo.getLastPreIntDate() == null) {
            return false;
        }
        Date startDate = chLoanInfo.getStartDate();
        Date lastPreIntDate = chLoanInfo.getLastPreIntDate();
        return lastPreIntDate.compareTo(startDate) > 0;
    }

    private boolean isSettled(ChLoanInfo chLoanInfo) throws Exception {
        return chLoanInfo.getLoanBalance().compareTo(chLoanInfo.getInitBalanceOfHistoryBill()) < 0;
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(0);
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanVoucher(1);
        super.actionDelVoucher_actionPerformed(e);
    }

    @Override
    protected String getEditUIName() {
        return ChLoanEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return ChLoanFactory.getRemoteInstance();
    }

    private void checkCanVoucher(int type) throws Exception {
        this.checkSelected();
        ChLoanInfo chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (0 == type) {
            if (chLoanInfo.isIsHistoryLoan() || chLoanInfo.isFivouchered() || chLoanInfo.getBillStatus() != IvtBillStatusEnum.BOOK) {
                throw new CHLoanException(CHLoanException.VOUCHER_ERROR1);
            }
        } else if (1 == type) {
            // empty if block
        }
    }

    @Override
    public void actionPostpone_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ChLoanInfo chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()), this.getSelectors());
        this.checkCanPostpone(chLoanInfo);
        ChLoanFactory.getRemoteInstance().postPoneCheck(chLoanInfo);
        ChLoanHelper.getInstance().showExtendBillEditUI((CoreUI)this, chLoanInfo);
    }

    private void checkCanPostpone(ChLoanInfo chLoanInfo) throws Exception {
        if (chLoanInfo.isIsOverdue() || chLoanInfo.getLoanBalance().compareTo(Constants.ZERO) <= 0) {
            throw new CHLoanException(CHLoanException.POSTPONE_ERROR1);
        }
        if (chLoanInfo.getBillStatus() != IvtBillStatusEnum.BOOK) {
            throw new CHLoanException(CHLoanException.POSTPONE_ERROR5);
        }
    }

    private Map overDueCheck() throws Exception {
        HashMap returnValue = new HashMap();
        HashSet<String> canBePostpone = new HashSet<String>();
        HashSet<String> cannotBePostpone = new HashSet<String>();
        ArrayList ids = this.getSelectedIdValues();
        ChLoanInfo chLoanInfo = null;
        String id = "";
        for (int i = 0; i < ids.size(); ++i) {
            id = (String)ids.get(i);
            chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)new ObjectUuidPK(id));
            if (!chLoanInfo.isIsOverdue() && chLoanInfo.getLoanBalance().compareTo(Constants.ZERO) > 0 && !this.isMature(chLoanInfo)) {
                canBePostpone.add(chLoanInfo.getId().toString());
                continue;
            }
            cannotBePostpone.add(chLoanInfo.getNumber());
        }
        returnValue.put("canBePostpone", canBePostpone);
        returnValue.put("cannotBePostpone", cannotBePostpone);
        return returnValue;
    }

    private boolean isMature(ChLoanInfo chLoanInfo) {
        return chLoanInfo.getEndDate().after(DateUtil.getDayBegin());
    }

    @Override
    public void actionAddNewHis_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionReturn_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ObjectUuidPK pk = new ObjectUuidPK(this.getSelectedKeyValue());
        ChLoanListUI.checkCanBeReturn(pk);
        EntRepaymentBillEditUI.showRepayEdidUI((CoreUIObject)this, (IObjectPK)pk);
    }

    private static void checkCanBeReturn(ObjectUuidPK pk) throws Exception {
        ChLoanInfo chLoanInfo = ChLoanFactory.getRemoteInstance().getChLoanInfo((IObjectPK)pk);
        if (chLoanInfo.getLoanBalance().compareTo(Constants.ZERO) <= 0) {
            throw new CHLoanException(CHLoanException.REPAY_ERROR);
        }
        if (chLoanInfo.getBillStatus() != IvtBillStatusEnum.BOOK) {
            throw new CHLoanException(CHLoanException.REPAY_ERROR1);
        }
    }

    @Override
    public void actionBatchSumbit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        StringBuffer sb = new StringBuffer("select fid from t_ivt_chloan where 1=1 and  ");
        sb.append(FMHelper.buildIn((String)"fid", (Object[])ids.toArray()));
        sb.append("and  fbillstatus = 1 ");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
        HashSet<String> IDs = new HashSet<String>();
        while (rs.next()) {
            IDs.add(rs.getString(1));
        }
        if (IDs == null || IDs.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"no_bill_sumbit"));
            return;
        }
        String msg = ChLoanFactory.getRemoteInstance().batchSubmit(IDs);
        this.refresh(e);
        if (!msg.equals("")) {
            throw new CHLoanException(CHLoanException.BATCN_OVERDUE_ERROR, new Object[]{msg});
        }
        boolean IVT003_Value = IvtModualUtils.getSysParam(null, (String)"IVT003");
        if (IVT003_Value) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"submitandbook_success"));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"submit_successfully"));
        }
    }

    @Override
    public void actionOverDue_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet ids = new HashSet();
        ids.addAll(this.getSelectedIdValues());
        String msg = ChLoanFactory.getRemoteInstance().transOverDueBatch(ids);
        this.refresh(e);
        if (msg.length() != 0) {
            throw new CHLoanException(CHLoanException.BATCN_OVERDUE_ERROR, new Object[]{msg});
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"overdue_successfuly"));
    }

    @Override
    public void actionCancelOverDue_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        HashSet idsSet = new HashSet();
        idsSet.addAll(ids);
        String msg = ChLoanFactory.getRemoteInstance().cancelOverDueBatch(idsSet);
        this.refresh(e);
        if (msg.length() != 0) {
            throw new CHLoanException(CHLoanException.BATCN_CANCEL_OVERDUE_ERROR, new Object[]{msg});
        }
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"cancel_overdue_successfully"));
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        ChLoanDataProvider data = new ChLoanDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(this.LOANINTBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        ChLoanDataProvider data = new ChLoanDataProvider(idList);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(this.LOANINTBILL_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return super.getDefaultFilterForQuery();
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void executeQuery(FilterParam param) throws BOSException {
        super.executeQuery(param);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionBatchSumbit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_submit"));
        this.actionReturn.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_requite"));
        this.actionOverDue.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_showbusiness"));
        this.actionCancelOverDue.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_undo"));
        this.actionPostpone.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_movedata"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionAddNewHis.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_dysz"));
        this.actionRateAdj.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_backwarddepreciat"));
        this.actionBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_post"));
        this.actionCancelBook.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_versapost"));
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionCreditLevel.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_gradeconversion"));
        boolean IVT005_Value = IvtModualUtils.getSysParam(null, (String)"IVT005");
        this.actionAudit.setVisible(IVT005_Value);
        this.actionAntiAudit.setVisible(IVT005_Value);
        this.actionNavInnerEreceipt.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.btnNavInnerEreceipt.setEnabled(true);
    }

    protected boolean showViewBdgBalanceBtn() {
        return true;
    }

    public void actionViewBdgBalance_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedKeyValue();
        if (id != null) {
            FMClientHelper.viewBgBalance4ListUI((Component)((Object)this), (String)id);
        }
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = super.getFilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null) {
            Object targetBillType = ((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType");
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("filterInfo") != null) {
                return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("filterInfo");
            }
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("isCreateLoan") != null) {
                Map btpmap;
                String companyid;
                if (null == filter) {
                    filter = new FilterInfo();
                }
                if ((companyid = (String)(btpmap = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("CurrencyID")) == null) {
                    companyid = this.currentCompanyCommon.getId().toString();
                }
                filter.getFilterItems().add(new FilterItemInfo("loanCompany.id", (Object)companyid));
                filter.getFilterItems().add(new FilterItemInfo("isDownLoaded", (Object)new Integer(0)));
                filter.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)new Integer(0), CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4), CompareType.EQUALS));
                return filter;
            }
            if ("LoanRepaymentApply".equals(targetBillType) || "LoanExhibition".equals(targetBillType)) {
                if (null == filter) {
                    filter = new FilterInfo();
                }
                filter.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)"0", CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)"4", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("loanCompany.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                filter.getFilterItems().add(new FilterItemInfo("isDownLoaded", (Object)new Integer(1)));
                return filter;
            }
            if ("LoanExhibition".equals(((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBillType"))) {
                if (null == filter) {
                    filter = new FilterInfo();
                }
                filter.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)"0", CompareType.GREATER));
                filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)"4", CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("loanCompany.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId()));
                filter.getFilterItems().add(new FilterItemInfo("isDownLoaded", (Object)new Integer(1)));
                return filter;
            }
            if (((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter") != null) {
                return (FilterInfo)((Map)this.getUIContext().get("BTPEDITPARAMETER")).get("DefaultQueryFilter");
            }
        }
        return filter;
    }

    @Override
    public String[] getMergeColumnKeys() {
        return new String[]{"id"};
    }

    @Override
    public void actionRateAdj_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.adjustRateCheck();
        ChLoanRateAdjustBillEditUI.show((CoreUIObject)this, (IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        this.refresh(e);
    }

    public void actionAdjustRate_actionPerformed(ActionEvent e) throws Exception {
        this.adjustRateCheck();
        ChLoanRateAdjustBillEditUI.show((CoreUIObject)this, (IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        this.refresh(e);
    }

    private void adjustRateCheck() throws Exception {
        this.checkSelected();
        ChLoanInfo info = this.getSelectedObject(this.getSelectedKeyValue());
        this.checkStatus_adjst(info);
        this.checkBalance(info);
        this.checkIsLPR(info);
    }

    private void checkIsLPR(ChLoanInfo info) {
        if (info.isIsLPR()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"421_ChLoanListUI"));
            SysUtil.abort();
        }
    }

    private void checkBalance(ChLoanInfo info) {
        if (info.getLoanBalance().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"not_consultive_ratetype"));
            SysUtil.abort();
        }
    }

    private void checkStatus_adjst(ChLoanInfo loanInfo) {
        if (!loanInfo.getBillStatus().equals((Object)IvtBillStatusEnum.BOOK)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"422_ChLoanListUI"));
            SysUtil.abort();
        }
    }

    private void checkRateType(ChLoanInfo info) {
        if (!this.isConsultiveRateType(info.getRateType())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"not_consultive_ratetype"));
            SysUtil.abort();
        }
    }

    private boolean isConsultiveRateType(IntRateTypeInfo rateType) {
        return rateType.getId().toString().equals(ResourceFactory.getConsultativeRate());
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.formatFootRow();
    }

    @Override
    protected boolean isFootVisible() {
        return true;
    }

    private FilterInfo getBillCanbeReceived() {
        Map btpeditparameter;
        String targetBillType;
        FilterInfo filterInfo = new FilterInfo();
        if (this.getUIContext().get("BTPEDITPARAMETER") != null && (targetBillType = (String)(btpeditparameter = (Map)this.getUIContext().get("BTPEDITPARAMETER")).get("TargetBill")) != null && "Loan".equals(targetBillType)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)Constants.ZERO, CompareType.GREATER));
            filterInfo.getFilterItems().add(new FilterItemInfo("effectedStatus", (Object)new Integer(2)));
            filterInfo.getFilterItems().add(new FilterItemInfo("loanCompany.id", (Object)((String)btpeditparameter.get("CurrencyID"))));
            filterInfo.getFilterItems().add(new FilterItemInfo("isDownLoaded", (Object)new Boolean(false)));
        }
        return filterInfo;
    }

    protected void execQuery() {
        FilterInfo extFilter = this.getBillCanbeReceived();
        if (extFilter != null && extFilter.getFilterItems().size() > 0) {
            try {
                this.mainQuery.getFilter().mergeFilter(extFilter, "AND");
            }
            catch (BOSException e) {
                ExceptionHandler.handle((Throwable)e.getCause());
            }
        }
        super.execQuery();
        this.formatFootRow();
    }

    protected IRow appendFootRow() {
        IRow sumRow = super.appendFootRow();
        this.formatFootRow();
        return sumRow;
    }

    private void formatFootRow() {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            ChLoanFilterParam param = (ChLoanFilterParam)this.getFilterUI().getParam();
            IRow row = this.tblMain.getFootManager().getFootRow(0);
            String curID = null;
            curID = param.getCurrencyInfo() == null ? company.getBaseCurrency().getId().toString() : AccessHelper.getId((Object)param.getCurrencyInfo());
            String[] columns = new SumFiledsInfo(SumBillEnum.ChLoan).getSumFileds();
            for (int i = 0; i < columns.length; ++i) {
                FMClientHelper.setNumberFormat((IRow)row, (String)columns[i], (String)curID);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doAntiAudit();
        this.refresh(e);
    }

    private void doAntiAudit() throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toAntiBeAudited = this.getToBeAntiAuditIdSet(allSelected);
        if (toAntiBeAudited.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"63_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toAntiBeAudited.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toAntiBeAudited.size() == allSelected.size()) {
            ChLoanFactory.getRemoteInstance().antiAudit(toAntiBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_antiaudit"));
        } else if (toAntiBeAudited.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"antiauditoption"))) == 0) {
            ChLoanFactory.getRemoteInstance().antiAudit(toAntiBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_antiaudit"));
        }
    }

    private Set getToBeAntiAuditIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.AUDIT));
        evi.setFilter(f);
        ChLoanCollection toBeAudit = ChLoanFactory.getRemoteInstance().getChLoanCollection(evi);
        HashSet<String> toBeAuditIDSet = new HashSet<String>();
        int size = toBeAudit.size();
        if (toBeAudit != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeAuditIDSet.add(toBeAudit.get(i).getId().toString());
            }
        }
        return toBeAuditIDSet;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doAudit();
        this.refresh(e);
    }

    private void doAudit() throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toBeAudited = this.getToBeAuditIdSet(allSelected);
        if (toBeAudited.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"63_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toBeAudited.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeAudited.size() == allSelected.size()) {
            ChLoanFactory.getRemoteInstance().audit(toBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_audit"));
        } else if (toBeAudited.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"auditoption"))) == 0) {
            ChLoanFactory.getRemoteInstance().audit(toBeAudited);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_audit"));
        }
    }

    private Set getToBeAuditIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.SUBMIT));
        evi.setFilter(f);
        ChLoanCollection toBeAudit = ChLoanFactory.getRemoteInstance().getChLoanCollection(evi);
        HashSet<String> toBeAuditIDSet = new HashSet<String>();
        int size = toBeAudit.size();
        if (toBeAudit != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeAuditIDSet.add(toBeAudit.get(i).getId().toString());
            }
        }
        return toBeAuditIDSet;
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        boolean IVT005_Value = IvtModualUtils.getSysParam(null, (String)"IVT005");
        Set toBeBooked = this.getToBeBookedIdSet(allSelected, IVT005_Value);
        this.doBook(toBeBooked);
        this.refresh(e);
    }

    private void doBook(Set toBeBooked) throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        if (toBeBooked.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"64_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toBeBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeBooked.size() == allSelected.size()) {
            boolean IVT005_Value = IvtModualUtils.getSysParam(null, (String)"IVT005");
            boolean IVT003_Value = IvtModualUtils.getSysParam(null, (String)"IVT003");
            if (IVT003_Value) {
                ChLoanFactory.getRemoteInstance().audit(toBeBooked);
            } else if (!IVT005_Value) {
                ChLoanFactory.getRemoteInstance().audit(toBeBooked);
            }
            ChLoanFactory.getRemoteInstance().book(toBeBooked);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_book"));
        } else if (toBeBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"bookoption"))) == 0) {
            ChLoanFactory.getRemoteInstance().audit(toBeBooked);
            ChLoanFactory.getRemoteInstance().book(toBeBooked);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_book"));
        }
    }

    private Set getToBeBookedIdSet(Set allSelected, boolean needAuditFirst) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        boolean IVT003 = false;
        if (!IVT003) {
            if (needAuditFirst) {
                f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.AUDIT));
            } else {
                f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.SUBMIT));
                f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.AUDIT));
                f.setMaskString("#0 and (#1 or #2)");
            }
        }
        evi.setFilter(f);
        ChLoanCollection toBeBooked = ChLoanFactory.getRemoteInstance().getChLoanCollection(evi);
        HashSet<String> toBeBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                toBeBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeBookIDSet;
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.doCancelBook();
        this.refresh(e);
    }

    private void doCancelBook() throws Exception {
        int result;
        HashSet allSelected = new HashSet(this.getSelectedIdValues());
        Set toBeBooked = this.getToBeCancelBookedIdSet(allSelected);
        if (toBeBooked.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"65_ChLoanListUI"));
            SysUtil.abort();
        }
        if (toBeBooked.size() > allSelected.size()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"unkownerror"));
            SysUtil.abort();
        } else if (toBeBooked.size() == allSelected.size()) {
            ChLoanFactory.getRemoteInstance().cancelBook(toBeBooked);
            if (IvtModualUtils.getSysParam(null, (String)"IVT003") || !IvtModualUtils.getSysParam(null, (String)"IVT005")) {
                ChLoanFactory.getRemoteInstance().antiAudit(toBeBooked);
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_cancelbook"));
        } else if (toBeBooked.size() < allSelected.size() && (result = MsgBox.showConfirm2New((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"cancelbookoption"))) == 0) {
            ChLoanFactory.getRemoteInstance().cancelBook(toBeBooked);
            if (IvtModualUtils.getSysParam(null, (String)"IVT003") || !IvtModualUtils.getSysParam(null, (String)"IVT005")) {
                ChLoanFactory.getRemoteInstance().antiAudit(toBeBooked);
            }
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"operSucess_cancelbook"));
        }
    }

    private Set getToBeCancelBookedIdSet(Set allSelected) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)allSelected, CompareType.INCLUDE));
        f.getFilterItems().add(new FilterItemInfo("id", (Object)this.getHasIntRecord(allSelected), CompareType.NOTINNER));
        f.getFilterItems().add(new FilterItemInfo("billStatus", (Object)IvtModualUtils.BOOK));
        f.getFilterItems().add(new FilterItemInfo("isReturned", (Object)Boolean.FALSE));
        f.getFilterItems().add(new FilterItemInfo("isHistoryLoan", (Object)Boolean.FALSE));
        evi.setFilter(f);
        ChLoanCollection toBeBooked = ChLoanFactory.getRemoteInstance().getChLoanCollection(evi);
        HashSet<String> toBeCancelBookIDSet = new HashSet<String>();
        int size = toBeBooked.size();
        if (toBeBooked != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                if (!this.checkHasDestBill(toBeBooked, i)) continue;
                toBeCancelBookIDSet.add(toBeBooked.get(i).getId().toString());
            }
        }
        return toBeCancelBookIDSet;
    }

    private boolean checkHasDestBill(ChLoanCollection toBeBooked, int i) throws BTPException, BOSException {
        return BOTPUtil.getDestBillIdSet(null, (String)toBeBooked.get(i).getId().toString()).size() == 0;
    }

    private String getHasIntRecord(Set allSelected) {
        String sql = "select FLoanBillId from T_IVT_LoanInterestBill where FIsPrediction = 0 and FLoanBillId in " + this.getValues(allSelected.toArray(new String[allSelected.size()]));
        return sql;
    }

    private String getValues(Object[] objects) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < objects.length; ++i) {
            sb.append("'").append(objects[i].toString()).append("'");
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return "(" + sb.toString() + ")";
    }

    @Override
    public void actionCreditLevel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        String creditLevelName = (String)this.tblMain.getRow(rowNumber).getCell("creditLevel").getValue();
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"creditLevelName", (Object)creditLevelName);
        uiContext.put((Object)"chloanID", (Object)new ObjectUuidPK(this.getSelectedKeyValue()));
        uiContext.put((Object)"fatherUI", (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CreditLevelChosserUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected SystemEnum getSystemEnum() {
        return SystemEnum.FIN_MANAGE;
    }

    protected String getDateField() {
        return "startDate";
    }

    protected String[] getControlActions() {
        return new String[]{"actionEdit", "actionRemove", "actionCancelBook", "actionAntiAudit"};
    }

    @Override
    public void actionNavInnerEreceipt_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        EReceiptInnerClientHelper.viewInnerEreceiptByBillIdList((List)idList, (Component)((Object)this));
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.Chloan";
        param.alias = "\u4f01\u4e1a\u8d37\u6b3e";
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        DatataskCaller task = new DatataskCaller();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fm.Chloan";
        param.alias = "\u4f01\u4e1a\u8d37\u6b3e";
        param.putContextParam((Object)"filter", (Object)this.getMainQuery().getFilter());
        param.datataskMode = 1;
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        task.setParentComponent((Component)((Object)this));
        task.invoke(paramList, 1, false);
    }

    @Override
    public void actionPrediction_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList == null || idList.size() <= 0) {
            return;
        }
        HashSet idSet = new HashSet(idList);
        Set intIDSet = ChLoanIntPreFacadeFactory.getRemoteInstance().genChloanIntPreFromListUI(idSet);
        if (intIDSet == null || intIDSet != null && intIDSet.size() <= 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"346_LoanListUI"));
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"347_LoanListUI"));
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ChLoanListUI.this.tblMain, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            String currencyId = null;
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            String rateDisplay = "";
            String penaRateDisplay = "";
            HashSet<String> idSet = new HashSet<String>();
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                idSet.add(tblMain.getRow(i).getCell("id").getValue().toString());
            }
            Map intRateMap = FinHelper.getChLoanRateMap(idSet);
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                BigDecimal intRate;
                row = tblMain.getRow(i);
                currencyId = (String)row.getCell("currencyid").getValue();
                this.setRow(row, rateDisplay, penaRateDisplay);
                String ID = row.getCell("id").getValue().toString();
                Object o = intRateMap.get(ID);
                String rateType = (String)row.getCell("rateType.name").getValue();
                BigDecimal peneRate = new BigDecimal(row.getCell("floorAmt").getValue().toString());
                row.getCell("floorAmt").setValue((Object)peneRate);
                if (currencyId != null) {
                    this.setAmtCellNumberFormat(row, currencyId);
                }
                row.getCell("horizon").getStyleAttributes().setNumberFormat("###.#");
                if (companyInfo != null && companyInfo.getBaseCurrency() != null) {
                    String baseCurrency = companyInfo.getBaseCurrency().getId().toString();
                    FMClientHelper.setNumberFormat((IRow)row, (String)"localAmt", (String)baseCurrency);
                }
                if (o != null) {
                    intRate = (BigDecimal)o;
                    row.getCell("newRate").setValue((Object)intRate);
                } else {
                    intRate = (BigDecimal)row.getCell("rate").getValue();
                    row.getCell("newRate").setValue((Object)intRate);
                }
                BigDecimal rate = (BigDecimal)row.getCell("rate").getValue();
                BigDecimal newRate = (BigDecimal)row.getCell("newRate").getValue();
                int ratePrec = this.getRatePrecision(rate);
                int newRatePrec = this.getRatePrecision(newRate);
                StringBuffer sbRateFormat = new StringBuffer(FMClientHelper.getNumberFtm((int)ratePrec));
                StringBuffer sbNewRateFormat = new StringBuffer(FMClientHelper.getNumberFtm((int)newRatePrec));
                if (row.getCell("intExpression").getValue() == null) continue;
                if (row.getCell("intExpression").getValue().toString().equals(IntRateTypeExpressionEnum.YEAR.toString())) {
                    sbRateFormat.append("\\%");
                    row.getCell("rate").getStyleAttributes().setNumberFormat(sbRateFormat.toString());
                    sbNewRateFormat.append("\\%");
                    row.getCell("newRate").getStyleAttributes().setNumberFormat(sbNewRateFormat.toString());
                    continue;
                }
                sbRateFormat.append("\\\u2030");
                row.getCell("rate").getStyleAttributes().setNumberFormat(sbRateFormat.toString());
                sbNewRateFormat.append("\\\u2030");
                row.getCell("newRate").getStyleAttributes().setNumberFormat(sbNewRateFormat.toString());
            }
        }

        private int getRatePrecision(BigDecimal rate) {
            int prec = 0;
            if (rate == null) {
                return prec;
            }
            String strRate = rate.toString();
            int len = strRate.length();
            int index = strRate.indexOf(".");
            if (index < 0) {
                return prec;
            }
            prec = len - index - 1;
            return prec;
        }

        private void setRow(IRow row, String rateDisplay, String penaRateDisplay) {
            BigDecimal rate = new BigDecimal(row.getCell("yearRate").getValue().toString());
            row.getCell("rate").setValue((Object)rate);
            BigDecimal peneRate = new BigDecimal(row.getCell("panaAccrualRate").getValue().toString());
            row.getCell("penerate").setValue((Object)peneRate);
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("intExpression").getValue();
            Object enu = exp.getValue();
            if ("year".equalsIgnoreCase(enu.toString())) {
                row.getCell("rate").getStyleAttributes().setNumberFormat("#,##0.000000000\\%");
            } else {
                row.getCell("rate").getStyleAttributes().setNumberFormat("#,##0.000000000\\\u2030");
            }
            row.getCell("rate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            exp = (BizEnumValueInfo)row.getCell("panaAccrualWay").getValue();
            enu = exp.getValue();
            if ("addPercent".equalsIgnoreCase(enu.toString())) {
                row.getCell("penerate").getStyleAttributes().setNumberFormat("#,##0.000000000\\%");
            } else {
                row.getCell("penerate").getStyleAttributes().setNumberFormat("#,##0.000000000\\\u2030");
            }
            row.getCell("penerate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("exchangeRate").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            Object exchangeRate = row.getCell("exchangeRate").getValue();
            if (exchangeRate != null) {
                BigDecimal exchangeRateDe = new BigDecimal(exchangeRate.toString());
                row.getCell("exchangeRate").setValue((Object)exchangeRateDe);
                row.getCell("exchangeRate").getStyleAttributes().setNumberFormat("%r{#,##0.000000000}f");
            }
        }

        private void setAmtCellNumberFormat(IRow row, String currencyId) {
            FMClientHelper.setNumberFormat((IRow)row, (String)"totalLoanAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"loadRemainAmt", (String)currencyId);
            FMClientHelper.setNumberFormat((IRow)row, (String)"floorAmt", (String)currencyId);
        }
    }
}

