/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.ivt.client.AbstractChLoanRateAdjustBillFilterUI;
import com.kingdee.eas.fm.ivt.client.ChLoanRateAdjustBillFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;

public class ChLoanRateAdjustBillFilterUI
extends AbstractChLoanRateAdjustBillFilterUI {
    public Object getParam() {
        ChLoanRateAdjustBillFilterParam cbfp = new ChLoanRateAdjustBillFilterParam();
        cbfp.setCompanyIDSet(this.getCompanyIdSet());
        if (null != this.dpStartDate.getValue()) {
            cbfp.setStartDate(DateTimeUtils.truncateDate((Date)((Date)this.dpStartDate.getValue())));
        }
        if (null != this.dpEndDate.getValue()) {
            cbfp.setEndDate(DateTimeUtils.truncateDate((Date)((Date)this.dpEndDate.getValue())));
        }
        if (this.p.getValue() != null) {
            cbfp.setLoanCompanys(AccessHelper.getF7Ids((KDBizPromptBox)this.p));
        }
        cbfp.setCompanyIDSet(this.getCompanyIdSet());
        cbfp.setBOTP(false);
        return cbfp;
    }

    public void setParam(Object param) {
        ChLoanRateAdjustBillFilterParam filterParam = (ChLoanRateAdjustBillFilterParam)param;
        this.dpStartDate.setValue((Object)filterParam.getStartDate());
        this.dpEndDate.setValue((Object)filterParam.getEndDate());
        if (filterParam.getLoanCompanys() != null) {
            try {
                this.setBizPromtValues(filterParam.getLoanCompanys(), 3);
            }
            catch (BOSException e) {
                MsgBox.showWarning((String)e.getMessage());
                SysUtil.abort();
            }
        }
    }

    private void setBizPromtValues(String[] ids, int paraType) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (ids != null && ids.length > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])ids), CompareType.INCLUDE));
        }
        ev.setFilter(filter);
        this.setLoanCompany(ev);
    }

    private void setLoanCompany(EntityViewInfo ev) throws BOSException {
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev);
        this.p.setValue((Object)companyCol.toArray());
    }

    protected void init() throws Exception {
        super.init();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.customInit();
    }

    private void customInit() {
        this.initDate();
        this.p.setValue(null);
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.p, (boolean)true);
    }

    private void initDate() {
        Date now = new Date();
        this.dpStartDate.setValue((Object)this.getStartDate(now));
        this.dpEndDate.setValue((Object)now);
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public boolean verify() {
        if (((Date)this.dpStartDate.getValue()).after((Date)this.dpEndDate.getValue())) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"dateError"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        return true;
    }

    protected Class getParamClass() {
        return ChLoanRateAdjustBillFilterParam.class;
    }
}

