/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.IvtModuleResourceReader;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.fin.FloatActionEnum;
import com.kingdee.eas.fm.fin.IntRateModifyType;
import com.kingdee.eas.fm.fin.util.FinHelper;
import com.kingdee.eas.fm.im.IntRateBaseFactory;
import com.kingdee.eas.fm.im.IntRateBaseInfo;
import com.kingdee.eas.fm.im.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.im.IntRateTypeInfo;
import com.kingdee.eas.fm.im.PenAccrualTypeEnum;
import com.kingdee.eas.fm.ivt.ChLoanCollection;
import com.kingdee.eas.fm.ivt.ChLoanFactory;
import com.kingdee.eas.fm.ivt.ChLoanInfo;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillCollection;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillFactory;
import com.kingdee.eas.fm.ivt.ChLoanRateAdjustBillInfo;
import com.kingdee.eas.fm.ivt.client.AbstractChloanRateAdjBillChooseUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ChloanRateAdjBillChooseUI
extends AbstractChloanRateAdjBillChooseUI {
    private Set createdIntReceivedID;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() {
        this.initCurrecny();
        this.initDate();
        this.initRateExpression();
        this.initPenaType();
        this.initNumberFormat();
        this.initNumberValue();
        this.prmtChLoan.setEnabledMultiSelection(true);
        this.prmtLoanCompany.setValue(null);
        this.prmtLoanCompany.setEnabledMultiSelection(true);
        this.prmtLoanCompany.setDisplayFormat("$name$");
        this.prmtLoanCompany.setCommitFormat("$number$");
        this.prmtLoanCompany.setEditFormat("$name$");
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtLoanCompany, (boolean)true);
        this.txtBasePoints.setValue((Object)Constants.ZERO);
        this.txtBasePoints.setRemoveingZeroInDispaly(false);
        this.txtBasePoints.setRemoveingZeroInEdit(true);
        this.txtBasePoints.setHorizontalAlignment(4);
        this.txtBasePoints.setMinimumValue((Comparable)Constants._ONE_HUNDRED);
        this.txtBasePoints.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
        this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
        this.txtRateAdjustPeriod.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRateAdjustPeriod.setHorizontalAlignment(4);
    }

    private void initCurrecny() {
        IvtModualUtils.fillCboCurrency((KDComboBox)this.cboCurrency);
    }

    private void initDate() {
        this.dpAdjDate.setSupportedEmpty(false);
        this.dpAdjDate.setValue((Object)DateUtil.getDayBegin());
    }

    private void initRateExpression() {
        this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
    }

    private void initPenaType() {
        this.comboPenaType.setSelectedItem((Object)PenAccrualTypeEnum.ADD_PERCENT);
    }

    private void initNumberValue() {
        this.txtRate.setValue((Object)Constants.ZERO);
        this.txtPenaRate.setValue((Object)Constants.ZERO);
        this.txtYearDays.setValue((Object)IvtModualUtils.VALUE_360);
    }

    private void initNumberFormat() {
        this.txtRate.setPrecision(5);
        this.txtRate.setHorizontalAlignment(4);
        this.txtRate.setRemoveingZeroInDispaly(false);
        this.txtRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtRate.setMaximumValue((Comparable)Constants.ONE_HUNDRED);
        this.txtPenaRate.setPrecision(5);
        this.txtPenaRate.setHorizontalAlignment(4);
        this.txtPenaRate.setRemoveingZeroInDispaly(false);
        this.txtPenaRate.setRequired(true);
        this.txtPenaRate.setValue((Object)Constants.ZERO);
        this.txtPenaRate.setMinimumValue((Comparable)Constants.ZERO);
        this.txtYearDays.setHorizontalAlignment(4);
        this.txtRate.setSupportedEmpty(false);
        this.txtPenaRate.setSupportedEmpty(false);
        this.txtYearDays.setSupportedEmpty(false);
    }

    private EntityViewInfo setAllLoanView() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        this.setFilterItmes(filter);
        evi.setFilter(filter);
        return evi;
    }

    private void setFilterItmes(FilterInfo filter) {
        this.setCurrencyFilterItem(filter);
        this.setBalanceFilterItem(filter);
        this.setAdjustDateFilterItem(filter);
        this.setStatusFilter(filter);
        this.setRateTypeFilter(filter);
        this.setCompanyFilter(filter);
        this.setLoanCompanyFilter(filter);
        Object[] info = (Object[])this.prmtLoanCompany.getValue();
        Set companySet = this.getcompanyId(info);
        Object obj = this.cboCurrency.getSelectedItem();
        if (companySet != null && !companySet.isEmpty()) {
            if (obj instanceof CurrencyInfo) {
                filter.setMaskString("#0 and #1  and (#2 or #3) and  #4 and #5 and #6 and #7");
            } else {
                filter.setMaskString("#0  and (#1 or #2) and  #3 and #4 and #5 and #6");
            }
        } else if (obj instanceof CurrencyInfo) {
            filter.setMaskString("#0 and #1  and (#2 or #3) and  #4 and #5 and #6 ");
        } else {
            filter.setMaskString("#0  and (#1 or #2) and  #3 and #4 and #5 ");
        }
    }

    private void setRateTypeFilter(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("rateType.id", (Object)"lJlpCQEQEADgAAc+wKgSjiR9knQ="));
    }

    private void setCompanyFilter(FilterInfo filter) {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (currentCompany != null) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentCompany.getId(), CompareType.EQUALS));
        }
    }

    private void setLoanCompanyFilter(FilterInfo filter) {
        Object[] info = (Object[])this.prmtLoanCompany.getValue();
        Set companySet = this.getcompanyId(info);
        if (companySet != null && !companySet.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("loanCompany.id", (Object)companySet, CompareType.INCLUDE));
        }
    }

    private Set getcompanyId(Object[] info) {
        HashSet<String> destBillIdSet = new HashSet<String>();
        CompanyOrgUnitInfo tmpInfo = null;
        if (!EmptyUtil.isEmpty((Object[])info)) {
            for (int i = 0; i < info.length; ++i) {
                tmpInfo = (CompanyOrgUnitInfo)info[i];
                if (tmpInfo == null) continue;
                destBillIdSet.add(tmpInfo.getId().toString());
            }
        }
        return destBillIdSet;
    }

    private void setStatusFilter(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(4), CompareType.EQUALS));
    }

    private void setAdjustDateFilterItem(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("lastAdjustDate", (Object)DateTimeUtils.truncateDate((Date)((Date)this.dpAdjDate.getValue())), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("lastAdjustDate", null, CompareType.IS));
    }

    private void setBalanceFilterItem(FilterInfo filter) {
        filter.getFilterItems().add(new FilterItemInfo("loanBalance", (Object)Constants.ZERO, CompareType.GREATER));
    }

    private void setCurrencyFilterItem(FilterInfo filter) {
        Object obj = this.cboCurrency.getSelectedItem();
        if (obj instanceof CurrencyInfo) {
            CurrencyInfo info = (CurrencyInfo)obj;
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)info.getId().toString()));
        }
    }

    private SelectorItemCollection getCustomSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    public boolean verify() {
        String[] loanids = AccessHelper.getF7Ids((KDBizPromptBox)this.prmtChLoan);
        if (loanids == null || loanids.length <= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"choose_loan"));
            SysUtil.abort();
        }
        if (this.txtYearDays.getBigDecimalValue().compareTo(Constants.ZERO) <= 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"yearday_error"));
            SysUtil.abort();
        }
        return true;
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.verify();
        this.createdIntReceivedID = new HashSet();
        this.createdIntReceivedID.clear();
        ChLoanRateAdjustBillCollection col = this.createRateAdjustBillCollection();
        HashMap<String, Object> addValueMap = new HashMap<String, Object>();
        addValueMap.put("rateModifyType", (IntRateModifyType)this.combModifyRateType.getSelectedItem());
        addValueMap.put("rateType", (IntRateTypeInfo)this.prmtIntRateType.getData());
        addValueMap.put("floatAction", (FloatActionEnum)this.combFloatAction.getSelectedItem());
        addValueMap.put("basePoints", this.txtBasePoints.getBigDecimalValue());
        addValueMap.put("firstRateAjdust", this.dpFirstRateAdjustDate.getSqlDate());
        addValueMap.put("rateAdjustPeriod", this.txtRateAdjustPeriod.getText());
        this.createdIntReceivedID = ChLoanRateAdjustBillFactory.getRemoteInstance().batchAdjustRate(col, addValueMap);
        if (this.createdIntReceivedID == null || this.createdIntReceivedID.size() == 0) {
            MsgBox.showInfo((String)IvtModuleResourceReader.getMsg((String)"no_adjust_rate_bill_created"));
            SysUtil.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    private ChLoanRateAdjustBillCollection createRateAdjustBillCollection() throws BOSException {
        ChLoanCollection loanCol = null;
        if (this.prmtChLoan.getValue() == null) {
            loanCol = ChLoanFactory.getRemoteInstance().getChLoanCollection(this.setAllLoanView());
        } else {
            Set ids = AccessHelper.getIds((Object[])AccessHelper.getF7Ids((KDBizPromptBox)this.prmtChLoan));
            loanCol = ChLoanFactory.getRemoteInstance().getChLoanCollection(this.setSelectLoanView(ids));
        }
        return this.createCLRateAdjustBills(loanCol);
    }

    private ChLoanRateAdjustBillCollection createCLRateAdjustBills(ChLoanCollection loanCol) {
        ChLoanRateAdjustBillCollection col = new ChLoanRateAdjustBillCollection();
        int size = loanCol.size();
        for (int i = 0; i < size; ++i) {
            ChLoanInfo loanInfo = loanCol.get(i);
            col.add(this.createNewData(loanInfo));
        }
        return col;
    }

    private ChLoanRateAdjustBillInfo createNewData(ChLoanInfo loanInfo) {
        ChLoanRateAdjustBillInfo rateAdjustInfo = new ChLoanRateAdjustBillInfo();
        this.setValues(rateAdjustInfo, loanInfo);
        return rateAdjustInfo;
    }

    private void setValues(ChLoanRateAdjustBillInfo rateAdjustInfo, ChLoanInfo loanInfo) {
        this.copyValueFromLoanInfo(rateAdjustInfo, loanInfo);
        this.copyValueFromUI(rateAdjustInfo);
        this.copyValueFromOther(rateAdjustInfo);
    }

    private void copyValueFromLoanInfo(ChLoanRateAdjustBillInfo rateAdjustInfo, ChLoanInfo loanInfo) {
        rateAdjustInfo.setLoan(loanInfo);
        rateAdjustInfo.setAdjustSeq(loanInfo.getAdjustRateTimes() + 1);
        rateAdjustInfo.setLastAdjustDate(loanInfo.getLastAdjustDate());
        rateAdjustInfo.setCurrency(loanInfo.getCurrency());
    }

    private void copyValueFromOther(ChLoanRateAdjustBillInfo rateAdjustInfo) {
        IContextHelper iContextHelp = ContextHelperFactory.getRemoteInstance();
        rateAdjustInfo.setCompany(iContextHelp.getCurrentCompany());
        rateAdjustInfo.setCU(iContextHelp.getCurrentCtrlUnit());
        rateAdjustInfo.setCreator(iContextHelp.getCurrentUser());
    }

    private EntityViewInfo setSelectLoanView(Set ids) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        evi.setFilter(filter);
        return evi;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.disposeUIWindow();
    }

    public static Set show(CoreUI ui) {
        Set returnValue = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)ui);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ChloanRateAdjBillChooseUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            returnValue = ((ChloanRateAdjBillChooseUI)uiWindow.getUIObject()).getReturnValue();
        }
        catch (BOSException e) {
            SysUtil.abort();
        }
        return returnValue;
    }

    private Set getReturnValue() {
        return this.createdIntReceivedID;
    }

    protected void clearPrmtValue() {
        this.prmtChLoan.setValue(null);
    }

    @Override
    protected void prmtChLoan_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void prmtChLoan_willCommit(CommitEvent e) throws Exception {
        this.filterChLoanBill();
    }

    @Override
    protected void prmtChLoan_willShow(SelectorEvent e) throws Exception {
        this.filterChLoanBill();
    }

    private void filterChLoanBill() {
        this.prmtChLoan.getQueryAgent().resetRuntimeEntityView();
        this.prmtChLoan.setEntityViewInfo(this.setAllLoanView());
        this.prmtChLoan.setSelectorCollection(this.getCustomSelectors());
    }

    @Override
    protected void prmtLoanCompany_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtChLoan.setValue(null);
    }

    @Override
    protected void prmtLoanCompany_willCommit(CommitEvent e) throws Exception {
    }

    @Override
    protected void prmtLoanCompany_willShow(SelectorEvent e) throws Exception {
        this.prmtChLoan.setValue(null);
    }

    private void prmtHide(boolean isHide) {
        if (isHide) {
            this.kDLabelContainer3.setBounds(new Rectangle(9, 114, 360, 19));
            super.add((Component)this.kDLabelContainer3, null);
            this.kDLabelContainer5.setBounds(new Rectangle(9, 135, 360, 19));
            super.add((Component)this.kDLabelContainer5, null);
            this.contRate.setBounds(new Rectangle(9, 156, 360, 19));
            super.add((Component)this.contRate, null);
            this.kDLabelContainer4.setBounds(new Rectangle(9, 177, 360, 19));
            super.add((Component)this.kDLabelContainer4, null);
            this.contPenaRate.setBounds(new Rectangle(9, 198, 360, 19));
            super.add((Component)this.contPenaRate, null);
        } else {
            this.kDLabelContainer3.setBounds(new Rectangle(9, 219, 360, 19));
            super.add((Component)this.kDLabelContainer3, null);
            this.kDLabelContainer5.setBounds(new Rectangle(9, 240, 360, 19));
            super.add((Component)this.kDLabelContainer5, null);
            this.contRate.setBounds(new Rectangle(9, 261, 360, 19));
            super.add((Component)this.contRate, null);
            this.kDLabelContainer4.setBounds(new Rectangle(9, 282, 360, 19));
            super.add((Component)this.kDLabelContainer4, null);
            this.contPenaRate.setBounds(new Rectangle(9, 303, 360, 19));
            super.add((Component)this.contPenaRate, null);
        }
    }

    @Override
    protected void combModifyRateType_itemStateChanged(ItemEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem();
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType)) {
            this.contIntRateType.setVisible(false);
            this.prmtIntRateType.setRequired(false);
            this.prmtIntRateType.setData(null);
            this.contFloatAction.setVisible(false);
            this.combFloatAction.setSelectedItem(null);
            this.contBasePoints.setVisible(false);
            this.txtBasePoints.setText(null);
            this.contFirstRateAdjustDate.setVisible(false);
            this.dpFirstRateAdjustDate.setValue(null);
            this.contRateAdjustPeriod.setVisible(false);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(false);
            this.comboRateExpression.setEnabled(true);
            this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtRate.setEnabled(true);
            this.txtRate.setValue((Object)Constants.ZERO);
            this.prmtHide(true);
        } else {
            this.prmtHide(false);
            this.contIntRateType.setVisible(true);
            this.prmtIntRateType.setRequired(true);
            FilterInfo filter = new FilterInfo();
            EntityViewInfo evi = new EntityViewInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
            evi.setFilter(filter);
            this.prmtIntRateType.setEntityViewInfo(evi);
            this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
            if (this.isFixedInterest(intRateType)) {
                this.txtYearDays.setEnabled(false);
                this.contBasePoints.setVisible(true);
                this.comboRateExpression.setEnabled(false);
            } else {
                this.contFloatAction.setVisible(true);
                this.combFloatAction.setEnabled(false);
                this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
                this.contBasePoints.setVisible(true);
                this.txtBasePoints.setRequired(true);
                this.txtBasePoints.setValue((Object)Constants.ZERO);
                this.contFirstRateAdjustDate.setVisible(true);
                this.dpFirstRateAdjustDate.setValue((Object)this.dpAdjDate.getSqlDate());
                this.contRateAdjustPeriod.setVisible(true);
                this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
                this.contMonth.setVisible(true);
                this.comboRateExpression.setEnabled(false);
            }
        }
    }

    protected void comboRateExpression_itemStateChanged(ItemEvent e) throws Exception {
        super.comboRateExpression_itemStateChanged(e);
        IntRateTypeExpressionEnum intRateType = (IntRateTypeExpressionEnum)this.comboRateExpression.getSelectedItem();
        if (intRateType.equals((Object)IntRateTypeExpressionEnum.YEAR)) {
            this.txtYearDays.setValue((Object)new Integer(360));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"589_LoanEditUI"));
        } else if (intRateType.equals((Object)IntRateTypeExpressionEnum.MONTH)) {
            this.txtYearDays.setValue((Object)new Integer(30));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        } else if (intRateType.equals((Object)IntRateTypeExpressionEnum.DAY)) {
            this.txtYearDays.setValue((Object)new Integer(1));
            this.contBasePoints.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"590_LoanEditUI"));
        }
    }

    @Override
    protected void prmtIntRateType_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem();
        if (IntRateModifyType.Agreement.equals((Object)intRateModifyType) || this.isFixedInterest(intRateType)) {
            this.contFloatAction.setVisible(false);
            this.combFloatAction.setSelectedIndex(-1);
            this.comboRateExpression.setEnabled(true);
            this.txtYearDays.setEnabled(true);
            this.txtYearDays.setText("360");
            this.txtRate.setEnabled(true);
            this.txtRate.setValue((Object)Constants.ZERO);
            this.contBasePoints.setVisible(false);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(false);
            this.dpFirstRateAdjustDate.setValue(null);
            this.contRateAdjustPeriod.setVisible(false);
            this.txtRateAdjustPeriod.setValue((Object)Constants.ZERO);
            this.contMonth.setVisible(false);
            this.prmtHide(true);
        } else if (IntRateModifyType.LPR.equals((Object)intRateModifyType) && !this.isFixedInterest(intRateType)) {
            this.prmtHide(false);
            this.contFloatAction.setVisible(true);
            this.combFloatAction.setSelectedItem((Object)FloatActionEnum.LPR);
            this.combFloatAction.setEnabled(false);
            this.contBasePoints.setVisible(true);
            this.txtBasePoints.setValue((Object)Constants.ZERO);
            this.contFirstRateAdjustDate.setVisible(true);
            this.dpFirstRateAdjustDate.setValue((Object)this.dpAdjDate.getSqlDate());
            this.contRateAdjustPeriod.setVisible(true);
            this.txtRateAdjustPeriod.setValue((Object)FinHelper.ZERO_INT);
            this.contMonth.setVisible(true);
            this.comboRateExpression.setEnabled(false);
            this.txtYearDays.setEnabled(false);
            this.txtRate.setEnabled(false);
            this.txtRate.setValue((Object)this.getYieldRate(intRateType, (FloatActionEnum)this.combFloatAction.getSelectedItem()));
            if (intRateType != null) {
                int intRate = intRateType.getFactorDay();
                String RateExpreValue = intRateType.getRateExpression().getValue();
                if (RateExpreValue.equals("year")) {
                    this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.YEAR);
                    this.txtRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"257_LoanAdjustInterestEditUI"));
                } else if (RateExpreValue.equals("month")) {
                    this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.MONTH);
                    this.txtRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                } else {
                    this.comboRateExpression.setSelectedItem((Object)IntRateTypeExpressionEnum.DAY);
                    this.txtRate.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"258_LoanAdjustInterestEditUI"));
                }
                this.txtYearDays.setValue((Object)new Integer(intRate));
            }
        }
    }

    @Override
    protected void txtBasePoints_dataChanged(DataChangeEvent e) throws Exception {
        IntRateTypeInfo intRateType = (IntRateTypeInfo)this.prmtIntRateType.getData();
        IntRateModifyType intRateModifyType = (IntRateModifyType)this.combModifyRateType.getSelectedItem();
        if (IntRateModifyType.LPR.equals((Object)intRateModifyType) && !this.isFixedInterest(intRateType)) {
            BigDecimal yieldRate = this.getYieldRate(intRateType, (FloatActionEnum)this.combFloatAction.getSelectedItem());
            this.txtRate.setValue((Object)yieldRate);
            this.txtRate.setEnabled(false);
        }
    }

    @Override
    protected void prmtIntRateType_willShow(SelectorEvent e) throws Exception {
        FilterInfo filter = new FilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"AgreementRate", CompareType.NOTEQUALS));
        evi.setFilter(filter);
        this.prmtIntRateType.setEntityViewInfo(evi);
        this.prmtIntRateType.getQueryAgent().resetRuntimeEntityView();
    }

    private BigDecimal getYieldRate(IntRateTypeInfo intRateType, FloatActionEnum floatAction) throws BOSException, EASBizException {
        CurrencyInfo baseCurrency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        Date date = DateTimeUtils.truncateDate((Date)this.dpAdjDate.getSqlDate());
        BigDecimal bdBP = this.txtBasePoints.getBigDecimalValue();
        if (baseCurrency != null && intRateType != null && date != null && bdBP != null) {
            IntRateBaseInfo intRateBase = IntRateBaseFactory.getRemoteInstance().getCurRateByCond(intRateType.getId().toString(), baseCurrency.getId().toString(), date);
            BigDecimal bdBaseRate = null;
            bdBaseRate = intRateBase != null ? intRateBase.getYearRate() : Constants.ZERO;
            BigDecimal bdYieldRate = Constants.ZERO;
            bdYieldRate = floatAction.equals((Object)FloatActionEnum.BASEINTRATE_FLOAT) ? bdBaseRate.multiply(new BigDecimal(String.valueOf(1)).add(bdBP.divide(Constants.ONE_HUNDRED, 10, 4))) : bdBaseRate.add(bdBP);
            if (bdYieldRate.compareTo(Constants.ZERO) < 0) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.fin.FINAutoGenerateResource", (String)"283_LoanEditUI"));
                this.txtBasePoints.requestFocus();
                SysUtil.abort();
            }
            return bdYieldRate;
        }
        return Constants.ZERO;
    }

    private boolean isFixedInterest(IntRateTypeInfo intRateType) {
        if (intRateType == null) {
            return false;
        }
        return intRateType.getId().toString().equals("QYYAAAAKQTYkfZJ0");
    }
}

