/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingAccountApplyFilterUI;
import com.kingdee.eas.fm.ivt.client.FinancingAccountApplyFilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;
import java.util.Set;
import org.apache.log4j.Logger;

public class FinancingAccountApplyFilterUI
extends AbstractFinancingAccountApplyFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingAccountApplyFilterUI.class);
    private static final String RESOURCE = "com.kingdee.eas.fm.fin.client.FinClientResource";

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        this.pkBeginDatefrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkBeginDateto.setValue((Object)new Date());
        this.checkcreate.setSelected(false);
        this.combostate.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
        this.combostate.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public Object getParam() {
        Set bankIds;
        Set financeFinancingIds;
        FinancingAccountApplyFilterParam filterParam = new FinancingAccountApplyFilterParam();
        if (this.pkBeginDatefrom.getValue() != null) {
            filterParam.setFrom((Date)this.pkBeginDatefrom.getValue());
        }
        if (this.pkBeginDateto.getValue() != null) {
            filterParam.setTo((Date)this.pkBeginDateto.getValue());
        }
        if ((financeFinancingIds = this.getIdSetFromF7(this.prmtFinanceFinancing)) != null && financeFinancingIds.size() > 0) {
            filterParam.setFinanceFinancingIds(financeFinancingIds);
        }
        if ((bankIds = this.getIdSetFromF7(this.prmtbank)) != null && bankIds.size() > 0) {
            filterParam.setBankIds(bankIds);
        }
        if (!(this.combostate.getSelectedItem() instanceof FMSysDefinedEnum)) {
            filterParam.setState((BillStateEnum)((Object)this.combostate.getSelectedItem()));
        } else {
            filterParam.setState(null);
        }
        if (this.checkcreate.isSelected()) {
            filterParam.setIscreate(Boolean.TRUE);
        } else {
            filterParam.setIscreate(Boolean.FALSE);
        }
        if (this.getCompanyIdSet() != null && this.getCompanyIdSet().size() > 0) {
            filterParam.setCompanyIdSet(this.getCompanyIdSet());
        }
        return filterParam;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        FinancingAccountApplyFilterParam filterParam = (FinancingAccountApplyFilterParam)((Object)param);
        this.pkBeginDatefrom.setValue((Object)filterParam.getFrom());
        this.pkBeginDateto.setValue((Object)filterParam.getTo());
        if (filterParam.getState() == null) {
            this.combostate.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.combostate.setSelectedItem((Object)filterParam.getState());
        }
        this.checkcreate.setSelected(filterParam.isIscreate());
        try {
            this.prmtFinanceFinancing.setData((Object)this.getBaseInfoFromIdSet(filterParam.getFinanceFinancingIds()));
            this.prmtbank.setData((Object)this.getBaseInfoFromIdSet(filterParam.getBankIds()));
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.setCompanyIdSet(filterParam.getCompanyIdSet());
    }

    protected Class getParamClass() {
        return FinancingAccountApplyFilterParam.class;
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBeginDatefrom);
        FMClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDDatePicker)this.pkBeginDateto);
        if (DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDatefrom.getValue())).after(DateTimeUtils.truncateDate((Date)((Date)this.pkBeginDateto.getValue())))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"LoanEndDateLaterThanBeginDate"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected void setDefaultValue() {
        super.setDefaultValue();
        this.pkBeginDatefrom.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.pkBeginDateto.setValue((Object)new Date());
        this.checkcreate.setSelected(false);
        this.prmtbank.setValue(null);
        this.prmtFinanceFinancing.setValue(null);
        this.combostate.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    protected boolean isNeedEachSerializable() {
        return true;
    }
}

