/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMCommonSortedDataProvider;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.MutexUtils;
import com.kingdee.eas.fm.common.util.FMARAPUtil;
import com.kingdee.eas.fm.ivt.BillStateEnum;
import com.kingdee.eas.fm.ivt.FinancingRedeemCollection;
import com.kingdee.eas.fm.ivt.FinancingRedeemFactory;
import com.kingdee.eas.fm.ivt.FinancingRedeemInfo;
import com.kingdee.eas.fm.ivt.IFinancingRedeem;
import com.kingdee.eas.fm.ivt.client.AbstractFinancingRedeemListUI;
import com.kingdee.eas.fm.ivt.client.FinancingRedeemFilterUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class FinancingRedeemListUI
extends AbstractFinancingRedeemListUI {
    private static final Logger logger = CoreUIObject.getLogger(FinancingRedeemListUI.class);
    FMFilterBaseUI filterUI = null;
    private CompanyOrgUnitInfo currentCompany;
    protected static final String IVT_RES = "com.kingdee.eas.fm.ivt.IVTFINANCINGResource";
    FillListener fillListener = new FillListener();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return FinancingRedeemFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        FinancingRedeemInfo objectValue = new FinancingRedeemInfo();
        return objectValue;
    }

    public void onLoad() throws Exception {
        this.currentCompany = this.currentCompanyCommon;
        super.onLoad();
        this.init();
    }

    private void init() {
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        int cs001 = ctxHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(this.currentCompany.getId().toString()));
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    public void setListUITable(KDTable tblMain, KDTDataRequestEvent e) {
        IRow row = null;
        String currencyId = null;
        if (e == null) {
            return;
        }
        for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
            row = tblMain.getRow(i);
            currencyId = (String)row.getCell("currency.id").getValue();
            if (currencyId != null) {
                String[] formatCol = this.getPrecColName();
                for (int j = 0; j < formatCol.length; ++j) {
                    FMClientHelper.setNumberFormat((IRow)row, (String)formatCol[j], (String)currencyId);
                }
            }
            int prec = CasRecPayHandler.getExRatePrec((String)row.getCell("currency.id").getValue().toString(), null, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany(), (Date)((Date)row.getCell("bizDate").getValue()));
            FMARAPUtil.setPrecision((ICell)row.getCell("exchangeRate"), (int)prec);
            if (row.getCell("intRateTypeExpression").getValue() == null) continue;
            BizEnumValueInfo exp = (BizEnumValueInfo)row.getCell("intRateTypeExpression").getValue();
            Object enu = exp.getValue();
            if ("year".equalsIgnoreCase(enu.toString())) {
                row.getCell("predictYield").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                row.getCell("practicalYield").getStyleAttributes().setNumberFormat("#,##0.00000\\%");
                continue;
            }
            row.getCell("predictYield").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
            row.getCell("practicalYield").getStyleAttributes().setNumberFormat("#,##0.00000\\\u2030");
        }
    }

    protected String[] getPrecColName() {
        return new String[]{"redeemAmount", "redeemSumAmount", "practicalWinAmount"};
    }

    protected void initWorkButton() {
        super.initWorkButton();
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        int val = ctxHelper.getIntParam("CS001", (IObjectPK)new ObjectUuidPK(ctxHelper.getCurrentCompany().getId()));
        boolean isBillBook = val == 0;
        this.actionBook.setEnabled(isBillBook);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompanyCommon)) {
            this.actionAddNew.setVisible(false);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (null == this.filterUI) {
            this.filterUI = new FinancingRedeemFilterUI();
        }
        return this.filterUI;
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList wrong = new ArrayList();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList<String> lst = new ArrayList<String>();
        IFinancingRedeem iFinancingRedeem = (IFinancingRedeem)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingRedeemInfo info = iFinancingRedeem.getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(id));
                if (!BillStateEnum.SUBMITED.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"046_AUDIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            iFinancingRedeem.audit(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"005_AUDIT_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"006_AUDIT_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionunAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        ArrayList<String> lst = new ArrayList<String>();
        IFinancingRedeem iFinancingRedeem = (IFinancingRedeem)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingRedeemInfo info = iFinancingRedeem.getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(id));
                if (!BillStateEnum.AUDITED.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"043_UNAUDIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsBook()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"025_UNAUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsGeneGaterBill()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"045_UNAUDIT_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isFiVouchered()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"083_UNAUDIT_ERRO", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            iFinancingRedeem.antiaudit(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"007_UNAUDIT_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"008_UNAUDIT_SUCCESS"));
        }
        this.refreshList();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"031_SELECT_ONE"));
            SysUtil.abort();
        }
        this.checkDelete();
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        if (idList.size() > 1) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"031_SELECT_ONE"));
            SysUtil.abort();
        }
        String id = (String)idList.get(0);
        FinancingRedeemInfo info = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(id));
        if (info.getState() != BillStateEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"050_GATHER_ERROR"));
            SysUtil.abort();
        } else if (info.isIsBook()) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"051_GATHER_ERROR"));
            SysUtil.abort();
        } else {
            FMClientHelper.generateDestBill((CoreBillListUI)this, (String)FinancingRedeemInfo.BOSTYPE.toString(), (String)new ReceivingBillInfo().getBOSType().toString(), (String)this.getSelectedKeyValue());
        }
        this.refreshList();
    }

    @Override
    public void actionBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList wrong = new ArrayList();
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingRedeem redeem = (IFinancingRedeem)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingRedeemInfo info = redeem.getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(id));
                if (!BillStateEnum.AUDITED.equals((Object)info.getState())) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"028_BOOK_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsBook()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"030_BOOK_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                if (info.isIsGeneGaterBill()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"053_BOOK_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            redeem.book(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"002_BOOK_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"004_BOOK_SUCCESS"));
        }
        this.refreshList();
    }

    @Override
    public void actionCancelBook_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = this.getSelectedIdValues();
        ArrayList<String> lst = new ArrayList<String>();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        IFinancingRedeem redeem = (IFinancingRedeem)this.getBizInterface();
        StringBuffer str = new StringBuffer();
        if (idList != null && idList.size() > 0) {
            for (int i = 0; i < idList.size(); ++i) {
                String id = (String)idList.get(i);
                boolean hasWf = FMHelper.hasWFInstance(null, (String)id);
                if (hasWf) {
                    MultiApproveUtil.multiapproveBills((CoreUIObject)this, (String)userID, (String[])new String[]{id});
                    continue;
                }
                FinancingRedeemInfo info = redeem.getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(id));
                if (!info.isIsBook()) {
                    str.append(EASResource.getString((String)IVT_RES, (String)"034_CANCELREDEM_ERROR", (Object[])new String[]{info.getNumber()}));
                    str.append("\r\n");
                    continue;
                }
                lst.add(id);
            }
        }
        if (lst.size() != 0) {
            redeem.cancelbook(lst);
        }
        if (str.length() > 0) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)IVT_RES, (String)"001_CANCELBOOK_RESULT", (Object[])new String[]{String.valueOf(lst.size()), String.valueOf(idList.size() - lst.size())}), (String)str.toString(), (int)1);
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"003_CANCELBOOK_SUCCESS"));
        }
        this.refreshList();
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        FinancingRedeemInfo redeemInfo = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(this.getSelectedKeyValue()));
        if (redeemInfo.getState() == BillStateEnum.AUDITED) {
            MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"042_EDIT_ERROR"));
            SysUtil.abort();
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
    }

    private void tdPrint(boolean isPreview) {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        FMCommonSortedDataProvider data = new FMCommonSortedDataProvider((List)idList, this.getTDQueryPK());
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPreview) {
            appHlp.printPreview("/FM/INVEST/FINIVT/FINREDEEM", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.print("/FM/INVEST/FINIVT/FINREDEEM", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    protected IMetaDataPK getTDQueryPK() {
        return new MetaDataPK("com.kingdee.eas.fm.ivt.app.FinancingRedeemTDQuery");
    }

    private void checkDelete() throws Exception {
        String id;
        ArrayList idList = this.getSelectedIdValues();
        IFinancingRedeem iFinancingRedeem = (IFinancingRedeem)this.getBizInterface();
        FinancingRedeemInfo info = iFinancingRedeem.getFinancingRedeemInfo((IObjectPK)new ObjectUuidPK(id = (String)idList.get(0)));
        if (info.getSourceBillId() != null) {
            if (info.getState() == BillStateEnum.AUDITED) {
                MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"048_DELETE_ERROR"));
                SysUtil.abort();
            }
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            SorterItemCollection sc = new SorterItemCollection();
            SorterItemInfo sorterItem = new SorterItemInfo("seq");
            sorterItem.setSortType(SortType.DESCEND);
            sc.add(sorterItem);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("sourceBillId", (Object)info.getSourceBillId(), CompareType.EQUALS));
            entityViewInfo.setSorter(sc);
            entityViewInfo.setFilter(filter);
            FinancingRedeemCollection collection = FinancingRedeemFactory.getRemoteInstance().getFinancingRedeemCollection(entityViewInfo);
            if (!collection.get(0).getId().toString().equals(id)) {
                MsgBox.showInfo((String)EASResource.getString((String)IVT_RES, (String)"054_DELETE_ERROR"));
                SysUtil.abort();
            }
        }
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        MutexUtils.requestMutex((CoreUI)this, (List)idList);
        try {
            super.actionVoucher_actionPerformed(e);
        }
        finally {
            MutexUtils.releaseMutex((List)idList);
        }
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        ArrayList idList = this.getSelectedIdValues();
        MutexUtils.requestMutex((CoreUI)this, (List)idList);
        try {
            super.actionDelVoucher_actionPerformed(e);
        }
        finally {
            MutexUtils.releaseMutex((List)idList);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int rowNumber = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        if (rowNumber == -1) {
            return;
        }
        IRow row = this.tblMain.getRow(rowNumber);
        String id = row.getCell("id").getValue().toString();
        SelectorItemCollection select = new SelectorItemCollection();
        select.add("state");
        select.add("fiVouchered");
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)id));
        FinancingRedeemInfo info = (FinancingRedeemInfo)this.getBizInterface().getValue((IObjectPK)pk, select);
        if (info.isFiVouchered()) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(true);
        } else if (BillStateEnum.AUDITED.equals((Object)info.getState())) {
            this.actionVoucher.setEnabled(true);
            this.actionDelVoucher.setEnabled(false);
        } else if (!BillStateEnum.AUDITED.equals((Object)info.getState())) {
            this.actionVoucher.setEnabled(false);
            this.actionDelVoucher.setEnabled(false);
        }
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            FinancingRedeemListUI.this.setListUITable(FinancingRedeemListUI.this.tblMain, e);
        }
    }
}

