/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fm.common.FMBgItemProp;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.IvtModualUtils;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.ChLoanHelper;
import com.kingdee.eas.fm.ivt.IntCalTypeEnum;
import com.kingdee.eas.fm.ivt.LoanInterestBillCollection;
import com.kingdee.eas.fm.ivt.LoanInterestBillFactory;
import com.kingdee.eas.fm.ivt.LoanInterestBillInfo;
import com.kingdee.eas.fm.ivt.client.AbstractModifyFpItemsUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.FpCashDirectionEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ModifyFpItemsUI
extends AbstractModifyFpItemsUI {
    private static final Logger logger = CoreUIObject.getLogger(ModifyFpItemsUI.class);
    private Set createdIntReceivedID;
    private LoanInterestBillCollection intCol;
    FillListener fillListener = new FillListener();

    public static Set showModifyFpItemsUI(CoreUI chooserUI, LoanInterestBillCollection loanIntCol) {
        Set idsSet = new HashSet();
        try {
            UIContext uiContext = new UIContext((Object)chooserUI);
            uiContext.putAll(chooserUI.getUIContext());
            uiContext.put((Object)"loanIntCol", (Object)loanIntCol);
            uiContext.put((Object)"type", (Object)uiContext.get((Object)"type").toString());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ModifyFpItemsUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
            idsSet = ((ModifyFpItemsUI)uiWindow.getUIObject()).getReturnIdSet();
            uiWindow.close();
        }
        catch (Exception e) {
            SysUtil.abort();
        }
        return idsSet;
    }

    private Set getReturnIdSet() {
        return this.createdIntReceivedID;
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.intCol = (LoanInterestBillCollection)((Object)this.getUIContext().get("loanIntCol"));
        this.verify();
        boolean isNumberInputed = !this.tbl.getColumn("interestNumber").getStyleAttributes().isLocked();
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            LoanInterestBillInfo intInfo = this.intCol.get(BOSUuid.read((String)row.getCell("ID").getValue().toString()));
            if (intInfo == null) continue;
            intInfo.setInterestAcctual((BigDecimal)row.getCell("shijiAmt").getValue());
            intInfo.setPunishInterestActual((BigDecimal)row.getCell("shijiPenaAmt").getValue());
            intInfo.setIntAccount((InnerAccountInfo)row.getCell(3).getValue());
            intInfo.setInterestToPay(intInfo.getPunishInterestActual().add(intInfo.getInterestAcctual()));
            FMClientHelper.storeFieldsBgItem((ICell)row.getCell("bgItem"), (CoreBaseInfo)intInfo, (FMBgItemProp)intInfo.getBgItemProps()[0]);
            intInfo.setProject((ProjectInfo)row.getCell("project").getValue());
            intInfo.setInterestActual(FMHelper.add((BigDecimal)intInfo.getInterestAcctual(), (BigDecimal)intInfo.getPunishInterestActual()));
            intInfo.setFundFlowItem((FundFlowItemInfo)row.getCell("fundFlowItem").getValue());
            intInfo.setBizDate((Date)row.getCell("bizDate").getValue());
            if (isNumberInputed) {
                intInfo.setNumber((String)row.getCell("interestNumber").getValue());
                continue;
            }
            if (row.getCell("interestNumber").getValue() != null) continue;
            intInfo.setNumber(null);
        }
        this.createdIntReceivedID = LoanInterestBillFactory.getRemoteInstance().batchSubmitWithFmItem(this.intCol, this.chkIsBook.isSelected());
        this.disposeUIWindow();
    }

    private SelectorItemCollection getAccountMgrStrategySelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("overdraftCtrl");
        sic.add("overDraftAmount");
        sic.add("lowestBalance");
        sic.add("remind");
        return sic;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.createdIntReceivedID = null;
        super.disposeUIWindow();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTable();
        this.loadTable();
        String type = this.getUIContext().get("type").toString();
        if ("Pre".equals(type)) {
            this.chkIsBook.setSelected(false);
            this.chkIsBook.setEnabled(false);
        } else {
            boolean ivt003 = IvtModualUtils.getSysParam(null, (String)"IVT003");
            this.chkIsBook.setSelected(ivt003);
            this.chkIsBook.setEnabled(!ivt003);
        }
    }

    protected void initTable() throws Exception {
        this.tbl.checkParsed();
        String[] backgroundCols = this.getBackgroundColName();
        for (int j = 0; j < backgroundCols.length; ++j) {
            this.tbl.getColumn(backgroundCols[j]).getStyleAttributes().setBackground(new Color(16579551));
        }
        this.tbl.getColumn("startDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.tbl.getColumn("endDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.tbl.getColumn("bizDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        KDDatePicker bizDte = new KDDatePicker();
        bizDte.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                ModifyFpItemsUI.this.bizDate_dateChaned(eventObj);
            }
        });
        this.tbl.getColumn("bizDate").setEditor((ICellEditor)new KDTDefaultCellEditor(bizDte));
        ChLoanHelper.getInstance().setTableCellEditorByFormattedTextField(this.tbl, "shijiAmt", 5);
        ChLoanHelper.getInstance().setTableCellEditorByFormattedTextField(this.tbl, "shijiPenaAmt", 5);
        ChLoanHelper.getInstance().setTableCellEditorByFormattedTextField(this.tbl, "yingjiPenaAmt", 5);
        ChLoanHelper.getInstance().setTableCellEditorByFormattedTextField(this.tbl, "yingjiAmt", 5);
        KDBizPromptBox prmtBgItem = new KDBizPromptBox();
        FMClientHelper.initBgItemF7((KDBizPromptBox)prmtBgItem, (FpCashDirectionEnum[])new FpCashDirectionEnum[]{FpCashDirectionEnum.input, FpCashDirectionEnum.other}, (boolean)true, (boolean)true);
        this.tbl.getColumn("bgItem").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtBgItem));
        FMClientHelper.initEntryFundFlowItemF7((IUIObject)this, (IColumn)this.tbl.getColumn("bgItem"), (IColumn)this.tbl.getColumn("fundFlowItem"), (FundFlowDirection)FundFlowDirection.IN);
        KDBizPromptBox prmtProject = new KDBizPromptBox();
        F7SelectorFactory.initProject((IUIObject)this, (KDBizPromptBox)prmtProject);
        this.tbl.getColumn("project").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtProject));
        this.tbl.getColumn("accountBank").getStyleAttributes().setLocked(false);
        if (!this.checkHasNumber()) {
            this.tbl.getColumn("interestNumber").getStyleAttributes().setLocked(false);
            this.tbl.getColumn("interestNumber").getStyleAttributes().setBackground(new Color(16579551));
        } else {
            this.tbl.getColumn("interestNumber").getStyleAttributes().setLocked(true);
        }
        this.tbl.getColumn("intCalType").getStyleAttributes().setLocked(true);
        this.tbl.getSelectManager().setSelectMode(2);
        this.tbl.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
        this.tbl.checkParsed();
    }

    private void bizDate_dateChaned(DataChangeEvent eventObj) {
        int rowIndex = this.tbl.getSelectManager().getActiveRowIndex();
        if (rowIndex < 0) {
            return;
        }
        if (rowIndex == 0 && this.tbl.getRowCount() > 1) {
            IRow row = this.tbl.getRow(rowIndex);
            Date newBizDate = (Date)eventObj.getNewValue();
            Date oldBizDate = (Date)row.getCell("bizDate").getValue();
            if (EmptyUtil.isEmpty((Object)newBizDate) || EmptyUtil.isEmpty((Object)oldBizDate)) {
                return;
            }
            if (newBizDate.equals(oldBizDate)) {
                return;
            }
            for (int i = 1; i < this.tbl.getRowCount(); ++i) {
                row = this.tbl.getRow(i);
                row.getCell("bizDate").setValue((Object)newBizDate);
            }
        }
    }

    private FilterInfo getInnerAccountFilter(String loanCompanyid) throws EASBizException, BOSException {
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("closed", (Object)"0"));
        filter.getFilterItems().add(new FilterItemInfo("isUsed", (Object)"1"));
        BankInfo clearingHouse = FSClientHelper.getClearingHouse();
        filter.getFilterItems().add(new FilterItemInfo("clearingHouse.id", (Object)clearingHouse.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("type.property", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)loanCompanyid));
        return filter;
    }

    private boolean checkHasNumber() {
        ICodingRuleManager codingRuleManager = null;
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        try {
            codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            codingRuleManager.readNumber((IObjectValue)new LoanInterestBillInfo(), currentCompany.getId().toString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String[] getBackgroundColName() {
        return new String[]{"shijiAmt", "shijiPenaAmt"};
    }

    public void setTableCellEditorByF7(IRow row, String f7, FilterInfo fi, String property) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setDisplayFormat("$name$");
        promptBox.setEditFormat("$name$");
        promptBox.setCommitFormat("$name$");
        promptBox.setQueryInfo(f7);
        if (fi != null) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(fi);
            promptBox.setEntityViewInfo(evi);
        }
        row.getCell(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    protected void loadTable() {
        this.tbl.checkParsed();
        this.tbl.removeRows();
        IRow row = null;
        this.intCol = (LoanInterestBillCollection)((Object)this.getUIContext().get("loanIntCol"));
        for (int i = 0; i < this.intCol.size(); ++i) {
            LoanInterestBillInfo intInfo = this.intCol.get(i);
            row = this.tbl.addRow();
            try {
                this.setTableCellEditorByF7(row, "com.kingdee.eas.fm.fs.F7InnerAccountQuery", this.getInnerAccountFilter(intInfo.getLoanCompany().getId() + ""), "accountBank");
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
            row.getCell("intCalType").setValue((Object)intInfo.getIntCalType().getAlias());
            if (com.kingdee.eas.fm.common.IntCalTypeEnum.PRE_INT.equals((Object)intInfo.getIntCalType())) {
                row.getCell("intCalType").getStyleAttributes().setBackground(new Color(0));
            } else {
                row.getCell("intCalType").getStyleAttributes().setBackground(new Color(16579551));
            }
            row.getCell("loanNumber").setValue((Object)intInfo.getLoanBill().getNumber());
            row.getCell("interestNumber").setValue((Object)intInfo.getNumber());
            if (intInfo.getIntAccount() != null) {
                row.getCell("accountBank").setValue((Object)intInfo.getIntAccount());
                ObjectValueRender render = new ObjectValueRender();
                render.setFormat((IDataFormat)new BizDataFormat("$name$"));
                row.getCell("accountBank").setRenderer((IBasicRender)render);
            }
            row.getCell("startDate").setValue((Object)intInfo.getBeginDate());
            row.getCell("endDate").setValue((Object)intInfo.getEndDate());
            row.getCell("currency").setValue((Object)intInfo.getCurrency().getName());
            row.getCell("amount").setValue((Object)intInfo.getAmount());
            row.getCell("yingjiAmt").setValue((Object)intInfo.getInterest());
            row.getCell("shijiAmt").setValue((Object)intInfo.getInterestAcctual());
            row.getCell("yingjiPenaAmt").setValue((Object)intInfo.getPunishInterest());
            row.getCell("shijiPenaAmt").setValue((Object)intInfo.getPunishInterestActual());
            row.getCell("project").setValue((Object)intInfo.getProject());
            FMClientHelper.loadFieldsBgItem((ICell)row.getCell("bgItem"), (CoreBaseInfo)intInfo, (FMBgItemProp)intInfo.getBgItemProps()[0]);
            row.getCell("presicion").setValue((Object)new Integer(intInfo.getCurrency().getPrecision()));
            row.getCell("ID").setValue((Object)intInfo.getId().toString());
            this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)intInfo.getCurrency().getPrecision()));
            row.getCell("bizDate").setValue((Object)new Date());
            Integer precesion = (Integer)row.getCell("presicion").getValue();
            this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
        }
    }

    private void setAmtCellNumberFormat(IRow row, String numberFtm) {
        this.setNumberFormat(row, "amount", numberFtm);
        this.setNumberFormat(row, "yingjiAmt", numberFtm);
        this.setNumberFormat(row, "shijiAmt", numberFtm);
        this.setNumberFormat(row, "yingjiPenaAmt", numberFtm);
        this.setNumberFormat(row, "shijiPenaAmt", numberFtm);
    }

    private void setNumberFormat(IRow row, String columnKey, String format) {
        StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
        styleAttributes.setNumberFormat(format);
        styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private boolean verify() throws EASBizException, BOSException {
        if (!this.checkHasNumber()) {
            for (int i = 0; i < this.tbl.getRowCount(); ++i) {
                IRow row = this.tbl.getRow(i);
                if (row.getCell("interestNumber").getValue() == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"101_ModifyFpItemsUI"));
                    this.abort();
                }
                if (row.getCell("intCalType").getValue().equals(com.kingdee.eas.fm.common.IntCalTypeEnum.PRE_INT.toString()) || row.getCell("accountBank").getValue() != null) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"notPreintIntAccountNotnull"));
                this.abort();
            }
        }
        int overDraftCount = 0;
        int remindCount = 0;
        StringBuffer msgDetail = new StringBuffer();
        StringBuffer overDraftDetail = new StringBuffer();
        HashSet<String> remindIDSet = new HashSet<String>();
        StringBuffer str = new StringBuffer();
        CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean overDraftControl = ContextHelperFactory.getRemoteInstance().getBooleanParam("INT005", (IObjectPK)new ObjectUuidPK(currentCompany.getId()));
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)this.intCol)) {
            Iterator it = this.intCol.iterator();
            while (it.hasNext()) {
                LoanInterestBillInfo intInfo = (LoanInterestBillInfo)it.next();
                if (intInfo.getIntCalType().equals((Object)IntCalTypeEnum.PRE_INT)) continue;
                IRow row = this.getRowByID(intInfo.getId().toString());
                BigDecimal interestActual = FMHelper.add((BigDecimal)((BigDecimal)row.getCell("shijiAmt").getValue()), (BigDecimal)((BigDecimal)row.getCell("shijiPenaAmt").getValue()));
                InnerAccountInfo innerAccountInfo = InnerAccountFactory.getRemoteInstance().getInnerAccountInfo((IObjectPK)new ObjectUuidPK(intInfo.getIntAccount().getId()));
                BigDecimal payeeInnerAcctBalance = FMHelper.getAcctRealBalance(null, (CurrencyInfo)intInfo.getCurrency(), (InnerAccountInfo)innerAccountInfo);
                AccountMgrStrategyInfo accountMgrStrategyInfo = innerAccountInfo.getCtrlParam();
                accountMgrStrategyInfo = AccountMgrStrategyFactory.getRemoteInstance().getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(accountMgrStrategyInfo.getId()), this.getAccountMgrStrategySelector());
                OverdraftCtrlEnum overdraftCtrl = accountMgrStrategyInfo.getOverdraftCtrl();
                if (interestActual.compareTo(payeeInnerAcctBalance) <= 0) continue;
                if (overDraftControl && !OverdraftCtrlEnum.NOTCONTROL.equals((Object)overdraftCtrl)) {
                    ++overDraftCount;
                    it.remove();
                    this.setMessage(overDraftDetail, numberFormat, intInfo, interestActual, payeeInnerAcctBalance);
                    String loanTitle = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"check_detail", (Object[])new String[]{intInfo.getLoanBill().getNumber()});
                    str.append(loanTitle + "\n");
                    continue;
                }
                if (!overdraftCtrl.equals((Object)OverdraftCtrlEnum.NOTCONTROL) || !accountMgrStrategyInfo.isRemind()) continue;
                remindIDSet.add(intInfo.getId().toString());
                ++remindCount;
                this.setMessage(msgDetail, numberFormat, intInfo, interestActual, payeeInnerAcctBalance);
            }
        }
        int result = 0;
        if (remindCount > 0) {
            result = MsgBox.showConfirm4a((String)FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftMain", (Object[])new String[]{String.valueOf(this.intCol.size()), String.valueOf(remindCount)}), (String)msgDetail.toString());
        }
        if (result == 1) {
            Iterator it = this.intCol.iterator();
            while (it.hasNext()) {
                LoanInterestBillInfo info = (LoanInterestBillInfo)it.next();
                if (!remindIDSet.contains(info.getId().toString())) continue;
                it.remove();
            }
        }
        if (overDraftCount > 0) {
            MsgBox.showConfirm3a((String)FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"not_banlance_insuffcient", (Object[])new String[]{String.valueOf(overDraftCount)}), (String)str.toString());
        }
        return true;
    }

    private void setMessage(StringBuffer msgDetail, NumberFormat numberFormat, LoanInterestBillInfo intInfo, BigDecimal interestActual, BigDecimal payeeInnerAcctBalance) {
        numberFormat.setMaximumFractionDigits(intInfo.getCurrency().getPrecision());
        numberFormat.setMinimumFractionDigits(intInfo.getCurrency().getPrecision());
        String tmp = FMHelper.formatMessage(null, (String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"DraftDetail", (Object[])new String[]{intInfo.getLoanBill().getNumber(), intInfo.getIntAccount().getName(), numberFormat.format(payeeInnerAcctBalance), numberFormat.format(FMHelper.subtract((BigDecimal)interestActual, (BigDecimal)payeeInnerAcctBalance))});
        msgDetail.append(tmp + "\n");
    }

    private IRow getRowByID(String ID) {
        for (int i = 0; i < this.tbl.getRowCount(); ++i) {
            IRow row = this.tbl.getRow(i);
            if (!ID.equals(row.getCell("ID").getValue())) continue;
            return row;
        }
        return null;
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            this.fillTable(ModifyFpItemsUI.this.tbl, e);
        }

        private void fillTable(KDTable tblMain, KDTDataRequestEvent e) {
            IRow row = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = tblMain.getRow(i);
                Integer precesion = (Integer)row.getCell("presicion").getValue();
                this.setAmtCellNumberFormat(row, FMClientHelper.getNumberFtm((int)precesion));
            }
        }

        private void setAmtCellNumberFormat(IRow row, String format) {
            this.setNumberFormat(row, "amount", format);
            this.setNumberFormat(row, "yingjiAmt", format);
            this.setNumberFormat(row, "shijiAmt", format);
            this.setNumberFormat(row, "yingjiPenaAmt", format);
            this.setNumberFormat(row, "shijiPenaAmt", format);
        }

        private void setNumberFormat(IRow row, String columnKey, String format) {
            StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
            styleAttributes.setNumberFormat(format);
            styleAttributes.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }
}

