/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.IFMDetailRptHandler;
import com.kingdee.eas.fm.fin.RptLoanDetailFilterParam;
import com.kingdee.eas.fm.fin.client.RptLoanDetailMainUI;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.client.AbstractRptChloanDetailMainUI;
import com.kingdee.eas.fm.ivt.client.RptChLoanDetailByCurrencyHandler;
import com.kingdee.eas.fm.ivt.client.RptChLoanDetailByLoanCompanyHandler;
import com.kingdee.eas.fm.ivt.client.RptChLoanDetailByLoanProductsHandler;
import com.kingdee.eas.fm.ivt.client.RptChLoanDetailHandlerAdapter;
import com.kingdee.eas.fm.ivt.client.RptChloanDetailFilterParam;
import com.kingdee.eas.fm.ivt.client.RptChloanDetailFilterUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;

public class RptChloanDetailMainUI
extends AbstractRptChloanDetailMainUI {
    private FMFilterBaseUI filterUI;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptChloanDetailFilterUI();
        }
        return this.filterUI;
    }

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        FSClientHelper.clearingHouseIsUsed((String)this.currentCompany.getId().toString());
        super.onLoad();
        this.tblMain.setColumnMoveable(true);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("id").getValue();
        if (id == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        this.tblMain.checkParsed();
        RptChloanDetailFilterParam filterParam = (RptChloanDetailFilterParam)this.getFilterParam();
        this.showHead(filterParam);
        int groupType = filterParam.getType();
        IFMDetailRptHandler handler = this.getBizHander(filterParam, groupType);
        handler.initHeader();
        handler.setTableStateRow();
        IRowSet rs = handler.getRowSet();
        try {
            handler.filldata(rs);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        handler.endDataFill();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    private IFMDetailRptHandler getBizHander(RptChloanDetailFilterParam filterParam, int groupType) {
        RptChLoanDetailHandlerAdapter handler = null;
        switch (groupType) {
            case 0: {
                handler = new RptChLoanDetailByLoanCompanyHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            case 1: {
                handler = new RptChLoanDetailByLoanProductsHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            case 2: {
                handler = new RptChLoanDetailByCurrencyHandler(this.tblMain, filterParam.getFilter(), filterParam);
                break;
            }
            default: {
                handler = new RptChLoanDetailByLoanCompanyHandler(this.tblMain, filterParam.getFilter(), filterParam);
            }
        }
        return handler;
    }

    private void showHead(RptChloanDetailFilterParam filterParam) {
        DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
        this.txtEndDate.setText(dtformat.format(filterParam.getEndDate()));
        this.txtUnit.setText(filterParam.getLoanStatisticalUnitEnum().getAlias());
    }

    public static void showSequenceCheckWindow(IUIObject owner, RptLoanDetailFilterParam param) throws UIException {
        UIContext uiContext = new UIContext((Object)owner);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        uiContext.put((Object)"Owner", (Object)owner);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptLoanDetailMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.kDLabelContainer1.getBoundLabelText()).append("&[EndDate]&|").append(this.kDLabelContainer2.getBoundLabelText()).append("&[Unit]&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Unit", this.txtUnit.getText());
        map.put("EndDate", this.txtEndDate.getText());
        return map;
    }
}

