/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.ivt.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ivt.client.AbstractRptChloanSumFilterUI;
import com.kingdee.eas.framework.report.util.RptConditionManager;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Container;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class RptChloanSumFilterUI
extends AbstractRptChloanSumFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(RptChloanSumFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
    }

    public void onInit(RptParams initParams) throws Exception {
        super.onInit(initParams);
        this.initDate();
        this.intChloanCompany();
        this.prmtCurrency.setEditable(true);
    }

    public void clear() {
        super.clear();
        this.initDate();
        this.intChloanCompany();
        this.prmtCurrency.setEditable(true);
        this.prmtCurrency.setValue(null);
        this.prmtLoanCompany.setValue(null);
        this.byLoanCompany.setSelected(true);
        this.comboUnit.setSelectedItem((Object)LoanStatisticalUnitEnum.TEN_THOUSAND);
    }

    private void intChloanCompany() {
        this.prmtLoanCompany.setEditable(true);
        F7SelectorFactory.initNewCompanyF7((IUIObject)this, (KDBizPromptBox)this.prmtLoanCompany, (boolean)true);
    }

    public void initDate() {
        this.dpStartDate.setSupportedEmpty(false);
        this.dpEndDate.setSupportedEmpty(false);
        this.dpStartDate.setValue((Object)DateUtil.getFirstDayOfCurMonth());
        this.dpEndDate.setValue((Object)new Date());
    }

    public boolean verify() {
        if (((Date)this.dpStartDate.getValue()).after((Date)this.dpEndDate.getValue())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.CHLoanResource", (String)"enddate_error"));
            Date d = new Date();
            this.dpStartDate.setValue((Object)this.getStartDate(d));
            this.dpStartDate.setFocusable(true);
            SysUtil.abort();
        }
        if (this.comboUnit.getSelectedItem() == null) {
            this.comboUnit.setSelectedItem((Object)LoanStatisticalUnitEnum.TEN_THOUSAND);
        }
        return true;
    }

    private Date getStartDate(Date now) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public void setCustomCondition(RptParams params) {
        RptConditionManager rm = new RptConditionManager(params);
        rm.restoreAllStatus((Container)((Object)this));
        super.setCustomCondition(params);
    }

    public RptParams getCustomCondition() {
        RptConditionManager rm = new RptConditionManager();
        rm.setProperty("companyIDs", (Object)this.companyIdSet);
        rm.setProperty("startDate", (Object)this.dpStartDate.getSqlDate());
        rm.setProperty("endDate", (Object)this.dpEndDate.getSqlDate());
        rm.setProperty("currencyIDs", (Object)AccessHelper.getF7Ids((KDBizPromptBox)this.prmtCurrency));
        rm.setProperty("chLoanCompany", (Object)AccessHelper.getF7Ids((KDBizPromptBox)this.prmtLoanCompany));
        rm.setProperty("amount_amt", (Object)((LoanStatisticalUnitEnum)((Object)this.comboUnit.getSelectedItem())));
        if (this.byLoanCompany.isSelected()) {
            rm.setProperty("query_type", (Object)"by_company");
        } else if (this.byLoanProducts.isSelected()) {
            rm.setProperty("query_type", (Object)"by_loanProduct");
        } else {
            rm.setProperty("query_type", (Object)"by_currency");
        }
        rm.recordAllStatus((Container)((Object)this));
        return rm.toRptParams();
    }
}

