/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.ivt.ChLoanConstants;
import com.kingdee.eas.fm.ivt.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ivt.RptChLoanSumFacadeFactory;
import com.kingdee.eas.fm.ivt.client.AbstractRptChloanSumMainUI;
import com.kingdee.eas.fm.ivt.client.RptChloanDetailFilterParam;
import com.kingdee.eas.fm.ivt.client.RptChloanDetailMainUI;
import com.kingdee.eas.fm.ivt.client.RptChloanSumFilterUI;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.client.BireportBaseFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class RptChloanSumMainUI
extends AbstractRptChloanSumMainUI {
    private Date startDate;
    private Date endDate;
    private LoanStatisticalUnitEnum amountUnit;
    private String[] currencyIDs;
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();

    public void onLoad() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
        FSClientHelper.clearingHouseIsUsed((String)this.currentCompany.getId().toString());
        super.onLoad();
        this.actionJoinQuery.setVisible(true);
        this.actionJoinQuery.setEnabled(true);
        this.actionJoinQuery.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.kDTable1.setColumnMoveable(true);
    }

    protected BireportBaseFilterUI getQueryDialogUserPanel() throws Exception {
        return new RptChloanSumFilterUI();
    }

    protected IBireportBaseFacade getRemoteInstance() throws BOSException {
        return RptChLoanSumFacadeFactory.getRemoteInstance();
    }

    protected void onBeforeQuery() throws Exception {
        this.startDate = (Date)this.params.getObject("startDate");
        this.endDate = (Date)this.params.getObject("endDate");
        this.amountUnit = (LoanStatisticalUnitEnum)((Object)this.params.getObject("amount_amt"));
        this.currencyIDs = (String[])this.params.getObject("currencyIDs");
        this.initLableText();
    }

    private void initLableText() {
        this.txtScope.setText(this.getLableText(1));
        this.txtCurrency.setText(this.getLableText(2));
        this.txtUnit.setText(this.getLableText(3));
    }

    private String getLableText(int i) {
        StringBuffer sb = new StringBuffer();
        if (1 == i) {
            DateFormat dtformat = CtrlFormatUtilities.getDateFormat();
            if (this.startDate != null && this.endDate != null) {
                java.util.Date date = new java.util.Date(this.startDate.getTime());
                sb.append(dtformat.format(date));
                sb.append(ChLoanConstants.RPT_END_TEXT);
                date = new java.util.Date(this.endDate.getTime());
                sb.append(dtformat.format(date));
            } else if (this.startDate == null) {
                java.util.Date date = new java.util.Date(this.endDate.getTime());
                sb.append(ChLoanConstants.RPT_END_TEXT);
                sb.append(dtformat.format(date));
                sb.append(ChLoanConstants.RPT_END_TEXT);
            } else if (this.endDate == null) {
                java.util.Date date = new java.util.Date(this.startDate.getTime());
                sb.append(ChLoanConstants.RPT_FROM_TEXT);
                sb.append(dtformat.format(date));
                sb.append(ChLoanConstants.RPT_START_TEXT);
            }
        } else if (2 == i) {
            sb.append(this.currencyIDs != null ? this.getCurrencyText(this.currencyIDs) : ChLoanConstants.RPT_ALL);
        } else if (3 == i) {
            if (this.amountUnit != null) {
                sb.append(this.amountUnit.getAlias());
            }
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    private String getCurrencyText(String[] currencyIDs) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (currencyIDs != null && currencyIDs.length > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])currencyIDs), CompareType.INCLUDE));
        }
        ev.setFilter(filter);
        CurrencyCollection ccol = null;
        try {
            ccol = CurrencyFactory.getRemoteInstance().getCurrencyCollection(ev);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
        CurrencyInfo info = null;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ccol.size(); ++i) {
            info = ccol.get(i);
            sb.append(info.getName()).append(",");
        }
        if (sb.length() > 0) {
            sb = sb.deleteCharAt(sb.toString().length() - 1);
        }
        return sb.toString();
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable1;
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.kDLabelContainer1.getBoundLabelText()).append("&[Scope]&|").append(this.kDLabelContainer2.getBoundLabelText()).append("&[Currency]&| ").append(this.tx.getBoundLabelText()).append("&[Unit]&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Scope", this.txtScope.getText());
        map.put("Currency", this.txtCurrency.getText());
        map.put("Unit", this.txtUnit.getText());
        return map;
    }

    protected void onAfterQuery() throws Exception {
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        Member[] ms = this.getSelectedDataCellItemInfo();
        if (ms == null) {
            String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"InValiadLine"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        RptChloanDetailFilterParam rcpfp = new RptChloanDetailFilterParam();
        rcpfp.setEndDate((Date)this.params.getObjectElement("endDate"));
        rcpfp.setLoanStatisticalUnitEnum((LoanStatisticalUnitEnum)((Object)this.params.getObjectElement("amount_amt")));
        rcpfp.setCurrencyIDs((String[])this.params.getObject("currencyIDs"));
        HashSet companySet = new HashSet();
        HashSet currencySet = new HashSet();
        HashSet<Object> loanProducesSet = new HashSet<Object>();
        HashSet horisonSet = new HashSet();
        if (ms != null) {
            for (Member m : ms) {
                HashSet<Object> set;
                if (!m.isLeaf()) continue;
                String dimName = m.getDimension().getName();
                if ("FinancingProduct".equals(dimName)) {
                    set = loanProducesSet;
                } else if ("Currency".equals(dimName)) {
                    set = currencySet;
                } else if ("LoanCompany".equals(dimName)) {
                    set = companySet;
                } else {
                    if (!"Horizon".endsWith(dimName)) continue;
                    set = horisonSet;
                }
                if (m.getKey() == null) continue;
                set.add(m.getKey());
            }
        }
        if (companySet.size() > 0) {
            rcpfp.setLoanCompanyIDs(companySet.toArray(new String[companySet.size()]));
        } else {
            HashSet<String> compset = new HashSet<String>();
            compset.add(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
            rcpfp.setCompanyIdSet(compset);
        }
        if (currencySet.size() > 0) {
            rcpfp.setCurrencyIDs(currencySet.toArray(new String[currencySet.size()]));
        }
        if (loanProducesSet != null && loanProducesSet.size() > 0) {
            String[] loanProID = loanProducesSet.toArray(new String[loanProducesSet.size()]);
            rcpfp.setLoanProductId(loanProID[0]);
        }
        if (companySet != null && companySet.size() > 0) {
            rcpfp.setOrderByFromSumMainUI("loanCompanyName");
            rcpfp.setQueryType("by_company");
        } else if (currencySet != null && currencySet.size() > 0) {
            rcpfp.setOrderByFromSumMainUI("fcurrencyName");
            rcpfp.setQueryType("by_currency");
        } else if (loanProducesSet != null && loanProducesSet.size() > 0) {
            rcpfp.setOrderByFromSumMainUI("finproName");
            rcpfp.setQueryType("by_loanProduct");
        }
        if (rcpfp.getOrderByFromSumMainUI() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"111_RptChloanSumMainUI"));
            SysUtil.abort();
        }
        String horizon = ((Object)horisonSet).toString();
        rcpfp.setHorizon(horizon);
        rcpfp.setIsIncludeZero(true);
        uiContext.put((Object)"filterParam", (Object)rcpfp);
        uiContext.put((Object)"Owner", (Object)this);
        IUIWindow uiWindow = null;
        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(RptChloanDetailMainUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

