/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.ivt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.client.FMRptClientUtils;
import com.kingdee.eas.fm.ivt.IntRateTypeExpressionEnum;
import com.kingdee.eas.fm.ivt.LoanStatisticalUnitEnum;
import com.kingdee.eas.fm.ivt.client.AbstractRptCreditLevelDetailMainUI;
import com.kingdee.eas.fm.ivt.client.RptCreditLevelDetailFilterUI;
import com.kingdee.eas.fm.ivt.client.RptCreditLevellFilterDetailParam;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class RptCreditLevelDetailMainUI
extends AbstractRptCreditLevelDetailMainUI {
    private static final Logger logger = CoreUIObject.getLogger(RptCreditLevelDetailMainUI.class);
    private FMFilterBaseUI filterUI;
    private CurrencyInfo currencyInfo;
    private IRowSet rs;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("count").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionJoinQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
    }

    protected void execQuery() throws BOSException {
        RptCreditLevellFilterDetailParam filterParam = (RptCreditLevellFilterDetailParam)this.getFilterParam();
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)filterParam.getDpStartDate(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startDate", (Object)filterParam.getDpEndDate(), CompareType.LESS_EQUALS));
        if (filterParam.getPrmtLoanCompany() != null && filterParam.getPrmtLoanCompany().size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("applyUnit.id", (Object)filterParam.getPrmtLoanCompany(), CompareType.INCLUDE));
        }
        if (filterParam.getPrmtLoanProducts() != null && filterParam.getPrmtLoanProducts().size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("finacingProduct.id", (Object)filterParam.getPrmtLoanProducts(), CompareType.INCLUDE));
        }
        if (filterParam.getPrmtItem() != null && filterParam.getPrmtItem().size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)filterParam.getPrmtItem(), CompareType.INCLUDE));
        }
        if (filterParam.getPrmtCreditLevel() != null && filterParam.getPrmtCreditLevel().size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("creditLevel.id", (Object)filterParam.getPrmtCreditLevel(), CompareType.INCLUDE));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString(), CompareType.EQUALS));
        this.currencyInfo = filterParam.getCurrencyInfo();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.currencyInfo.getId().toString(), CompareType.EQUALS));
        this.mainQuery.setFilter(filter);
        this.mainQuery.getSorter().add(new SorterItemInfo("creditLevel.id"));
        this.mainQuery.getSorter().add(new SorterItemInfo("applyUnit.name"));
        this.mainQuery.getSorter().add(new SorterItemInfo("finacingProduct.id"));
        exec.setObjectView(this.mainQuery);
        this.rs = exec.executeQuery();
        this.txtUnit.setText(filterParam.getComboUnit().toString());
        this.fillTable(this.rs, this.parseUnit(filterParam.getComboUnit()));
        this.addSummedRow();
        this.addCreditLevelSubtotalRow();
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getGroupManager().group();
        this.addSubtotalRow();
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)this.currencyInfo.getId());
        if (numberFtm == null) {
            numberFtm = FMClientHelper.getNumberFtm((int)2);
        }
        this.tblMain.getColumn("loanTotalAmt").getStyleAttributes().setNumberFormat(numberFtm);
        this.tblMain.getColumn("loanBalance").getStyleAttributes().setNumberFormat(numberFtm);
        String dformat = FMHelper.getDateFormatString();
        this.tblMain.getColumn("startDate").getStyleAttributes().setNumberFormat(dformat);
        this.tblMain.getColumn("endDate").getStyleAttributes().setNumberFormat(dformat);
    }

    private void fillTable(IRowSet rs, BigDecimal unit) {
        this.tblMain.checkParsed();
        if (this.tblMain.getRowCount3() > 0) {
            this.tblMain.removeRows();
        }
        if (rs == null || rs.size() == 0) {
            return;
        }
        BigDecimal yearRate = null;
        try {
            while (rs.next()) {
                IRow row = this.tblMain.addRow();
                row.getCell("company").setValue(rs.getObject("applyUnit.name"));
                row.getCell("loanProducts").setValue(rs.getObject("finacingProduct.name"));
                row.getCell("nmber").setValue(rs.getObject("number"));
                row.getCell("currency").setValue(rs.getObject("currency.name"));
                String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)this.currencyInfo.getId());
                if (numberFtm == null) {
                    numberFtm = FMClientHelper.getNumberFtm((int)2);
                }
                row.getCell("loanTotalAmt").getStyleAttributes().setNumberFormat(numberFtm);
                row.getCell("loanTotalAmt").setValue((Object)rs.getBigDecimal("loanTotalAmt").divide(unit, 5, 4));
                row.getCell("loanTotalAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("loanBalance").getStyleAttributes().setNumberFormat(numberFtm);
                row.getCell("loanBalance").setValue((Object)rs.getBigDecimal("loanBalance").divide(unit, 5, 4));
                row.getCell("loanBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("project").setValue(rs.getObject("project.name"));
                row.getCell("startDate").setValue(rs.getObject("startDate"));
                row.getCell("endDate").setValue(rs.getObject("endDate"));
                row.getCell("loanAccountName").setValue((Object)rs.getString("loanAccount.name"));
                row.getCell("distributeAccountName").setValue((Object)rs.getString("distributeAccou.name"));
                row.getCell("lastSettleDate").setValue((Object)rs.getDate("lastSettleDate"));
                row.getCell("intRateTypeExpression").setValue((Object)IntRateTypeExpressionEnum.getEnum((String)rs.getObject("intRateTypeExpression")));
                yearRate = rs.getObject("yearRate") == null ? Constants.ZERO : new BigDecimal(rs.getObject("yearRate").toString());
                row.getCell("yearRateDisplay").setValue((Object)yearRate);
                row.getCell("yearRateDisplay").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (rs.getObject("intRateTypeExpression") != null && rs.getObject("intRateTypeExpression").toString().equals("year")) {
                    row.getCell("yearRateDisplay").getStyleAttributes().setNumberFormat("#,##0.00\\%");
                } else {
                    row.getCell("yearRateDisplay").getStyleAttributes().setNumberFormat("#,##0.00\\\u2030");
                }
                row.getCell("creditLevel").setValue(rs.getObject("creditLevel.id"));
                row.getCell("creditLevelName").setValue(rs.getObject("creditLevel.name"));
                row.getCell("count").setValue((Object)Constants.ONE);
                row.getCell("id").setValue(rs.getObject("id"));
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.tblMain.setEditable(false);
        this.tblMain.setEnabled(true);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new RptCreditLevelDetailFilterUI();
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    private void addSubtotalRow() {
        int rowNumber = this.tblMain.getRowCount3();
        int bottom = 0;
        for (int i = 0; i < rowNumber; ++i) {
            String company = (String)this.tblMain.getRow(i).getCell("company").getValue();
            ICell cell = this.tblMain.getRow(i).getCell("company");
            if (cell.getMergeBlock() == null || cell.getMergeBlock().getTop() == cell.getMergeBlock().getBottom()) continue;
            BigDecimal loanTotalAmt = Constants.ZERO;
            BigDecimal loanBalance = Constants.ZERO;
            for (int j = cell.getMergeBlock().getTop(); j <= cell.getMergeBlock().getBottom(); ++j) {
                loanTotalAmt = loanTotalAmt.add((BigDecimal)this.tblMain.getRow(j).getCell("loanTotalAmt").getValue());
                loanBalance = loanBalance.add((BigDecimal)this.tblMain.getRow(j).getCell("loanBalance").getValue());
            }
            bottom = cell.getMergeBlock().getBottom() + 1;
            this.addSubtotalRow(cell.getMergeBlock().getBottom() + 1, loanTotalAmt, loanBalance, company, i);
            this.tblMain.getMergeManager().mergeBlock(cell.getMergeBlock().getBottom(), 1, bottom, 3);
            i = bottom;
            ++rowNumber;
        }
    }

    private void addSubtotalRow(int rowIndex, BigDecimal loanTotalAmt, BigDecimal loanBalance, String company, int i) {
        IRow row = this.tblMain.addRow(rowIndex);
        row.getCell("company").setValue((Object)company);
        row.getCell("loanProducts").setValue((Object)FMRptClientUtils.getSumTotalResString());
        row.getCell("loanTotalAmt").setValue((Object)loanTotalAmt);
        row.getCell("loanBalance").setValue((Object)loanBalance);
        row.getCell("loanTotalAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("loanBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        this.tblMain.getMergeManager().mergeBlock(i, 0, rowIndex, 0);
        this.tblMain.getGroupManager().setGroup(false);
    }

    private BigDecimal formatBigDecimal(Object value) {
        if (value == null) {
            return Constants.ZERO;
        }
        return (BigDecimal)value;
    }

    private void addSummedRow() {
        int rowNumber = this.tblMain.getRowCount3();
        if (rowNumber <= 0) {
            return;
        }
        BigDecimal loanTotalAmt = Constants.ZERO;
        BigDecimal loanBalance = Constants.ZERO;
        BigDecimal count = Constants.ZERO;
        for (int i = 0; i < rowNumber; ++i) {
            loanTotalAmt = loanTotalAmt.add(this.formatBigDecimal(this.tblMain.getRow(i).getCell("loanTotalAmt").getValue()));
            loanBalance = loanBalance.add(this.formatBigDecimal(this.tblMain.getRow(i).getCell("loanBalance").getValue()));
            count = count.add(this.formatBigDecimal(this.tblMain.getRow(i).getCell("count").getValue()));
        }
        IRow row = this.tblMain.addRow(rowNumber);
        this.tblMain.getMergeManager().mergeBlock(rowNumber, 0, rowNumber, 3);
        row.getCell("company").setValue((Object)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"104_RptChLoanDetailHandlerAdapter"));
        row.getCell("loanTotalAmt").setValue((Object)loanTotalAmt);
        row.getCell("loanBalance").setValue((Object)loanBalance);
        row.getCell("loanTotalAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("loanBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("count").setValue((Object)count);
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell("company").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
    }

    @Override
    public void actionJoinQuery_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        int rowIndex = FMClientHelper.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(rowIndex);
        String id = (String)row.getCell("id").getValue();
        if (id == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fm.ivt.IVTAutoGenerateResource", (String)"112_RptCreditLevelDetailMainUI"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)id, (CompanyOrgUnitInfo)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
    }

    private BigDecimal parseUnit(LoanStatisticalUnitEnum amountUnit) {
        if (amountUnit.equals((Object)LoanStatisticalUnitEnum.THOUSAND)) {
            return new BigDecimal(String.valueOf(1000));
        }
        if (amountUnit.equals((Object)LoanStatisticalUnitEnum.TEN_THOUSAND)) {
            return new BigDecimal(String.valueOf(10000));
        }
        if (amountUnit.equals((Object)LoanStatisticalUnitEnum.MILLION)) {
            return new BigDecimal(String.valueOf(1000000));
        }
        if (amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_THOUSAND)) {
            return new BigDecimal(String.valueOf(10000000));
        }
        if (amountUnit.equals((Object)LoanStatisticalUnitEnum.HUNDRED_MILLION)) {
            return new BigDecimal(100000000);
        }
        return new BigDecimal(1);
    }

    private void addCreditLevelSubtotalRow() {
        int rowNumber = this.tblMain.getRowCount3();
        if (rowNumber <= 0) {
            return;
        }
        BigDecimal loanTotalAmt = new BigDecimal(0);
        BigDecimal loanBalance = new BigDecimal(0);
        BigDecimal count = new BigDecimal(0);
        String totalDisplay = "";
        for (int i = 0; i < rowNumber; ++i) {
            if (i == 0) continue;
            loanTotalAmt = loanTotalAmt.add(this.formatBigDecimal(this.tblMain.getRow(i - 1).getCell("loanTotalAmt").getValue()));
            loanBalance = loanBalance.add(this.formatBigDecimal(this.tblMain.getRow(i - 1).getCell("loanBalance").getValue()));
            count = count.add(this.formatBigDecimal(this.tblMain.getRow(i - 1).getCell("count").getValue()));
            String creditLevel = (String)this.tblMain.getRow(i - 1).getCell("creditLevel").getValue();
            String nextCreditLevel = (String)this.tblMain.getRow(i).getCell("creditLevel").getValue();
            if (creditLevel != null && creditLevel.equals(nextCreditLevel)) continue;
            IRow row = this.tblMain.addRow(i);
            totalDisplay = this.tblMain.getRow(i - 1).getCell("creditLevelName").getValue() == null ? FMRptClientUtils.getTotalResString() : this.tblMain.getRow(i - 1).getCell("creditLevelName").getValue() + FMRptClientUtils.getTotalResString();
            row.getCell("loanProducts").setValue((Object)totalDisplay);
            row.getCell("loanProducts").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            row.getCell("loanTotalAmt").setValue((Object)loanTotalAmt);
            row.getCell("loanBalance").setValue((Object)loanBalance);
            row.getCell("loanTotalAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("loanBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            row.getCell("count").setValue((Object)count);
            row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
            loanTotalAmt = new BigDecimal(0);
            loanBalance = new BigDecimal(0);
            count = new BigDecimal(0);
            this.tblMain.getMergeManager().mergeBlock(i, 0, i, 3);
            ++i;
            ++rowNumber;
        }
    }
}

