/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.INewOUInnerFacade;
import com.kingdee.eas.basedata.org.NewOUInnerFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.NewAdminF7;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfo;
import com.kingdee.eas.basedata.org.helper.OrgTypeInfoMgr;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FeeTypeCollection;
import com.kingdee.eas.fi.cas.FeeTypeFactory;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IFeeType;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.IllegalConversionException;
import com.kingdee.util.InvalidDateException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class LiquidBaseHelper {
    private static Logger logger = Logger.getLogger((String)LiquidBaseHelper.class.getName());

    public static HashMap getAuthorizedOrgViewIDs(Context ctx, boolean isIncludeSub, IObjectPK userPK, OrgViewType orgViewType, IObjectPK orgTreePK, IMetaDataPK uiPK, IMetaDataPK actionPK) throws EASBizException, BOSException {
        HashMap ret = null;
        IPermission iPermission = null;
        INewOUInnerFacade iNOU = null;
        if (ctx == null) {
            iPermission = PermissionFactory.getRemoteInstance();
            iNOU = NewOUInnerFacadeFactory.getRemoteInstance();
        } else {
            iPermission = PermissionFactory.getLocalInstance((Context)ctx);
            iNOU = NewOUInnerFacadeFactory.getLocalInstance((Context)ctx);
        }
        OrgTypeInfo curOrgTypeInfo = OrgTypeInfoMgr.getInstance().getOrgTypeInfo(orgViewType);
        OrgType curOrgType = null;
        if (curOrgTypeInfo != null) {
            curOrgType = curOrgTypeInfo.getOrgType();
        }
        if (curOrgTypeInfo != null && curOrgType != null && !curOrgTypeInfo.isBasicOrgType()) {
            ret = (HashMap)iPermission.getAuthorizedOrgs(userPK, curOrgType, orgTreePK, uiPK, actionPK);
            HashMap importCompany = (HashMap)iNOU.getCompanyFromUnionGroup(orgTreePK.toString(), ret);
            ret.putAll(importCompany);
        } else {
            ret = (HashMap)iPermission.getAuthorizedOrgs(userPK, NewOrgViewHelper.convert((OrgViewType)orgViewType), orgTreePK, uiPK, actionPK);
        }
        if (ret == null) {
            ret = new HashMap();
        }
        return ret;
    }

    public static CompanyOrgUnitInfo getCompanyByNumber(Context ctx, String number) throws TaskExternalException {
        CompanyOrgUnitInfo company = null;
        try {
            ICompanyOrgUnit iCompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection coll = iCompanyOrg.getCompanyOrgUnitCollection("where number='" + number + "'");
            if (coll != null && coll.size() > 0) {
                company = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage());
        }
        return company;
    }

    public static CurrencyInfo getCurrencyById(String id) throws TaskExternalException {
        CurrencyInfo currency = null;
        CurrencyCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        view.setSelector(sic);
        view.setFilter(filter);
        try {
            ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
            coll = iCurrency.getCurrencyCollection(view);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (coll.size() > 0) {
            currency = coll.get(0);
        }
        return currency;
    }

    public static CurrencyInfo getCurrencyByNumber(Context ctx, String number) throws TaskExternalException {
        CurrencyInfo currency = null;
        try {
            ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyCollection collection = icurrency.getCurrencyCollection("where number='" + number + "'");
            if (collection != null && collection.size() > 0) {
                currency = collection.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return currency;
    }

    public static void initNumber(Context ctx, BillBaseInfo info, String companyId, AbstractCoreBaseControllerBean controller) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!EmptyUtil.isEmpty((String)info.getNumber())) {
            return;
        }
        if (companyId == null) {
            companyId = info.getCompany().getId().toString();
        }
        int i = 0;
        do {
            String numberSilent;
            if (EmptyUtil.isEmpty((String)(numberSilent = NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)companyId)))) {
                return;
            }
            info.setNumber(numberSilent);
        } while (controller.exists(ctx, filter = NumberRuleUtil.getCheckNumberDupFilter((IObjectValue)info, (boolean)true)) && ++i < 10);
    }

    public static NewAdminF7 initAdminOrgUnit(IUIObject coreui, KDBizPromptBox prmtDepartment) {
        prmtDepartment.setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        prmtDepartment.setVisible(true);
        prmtDepartment.setEditable(true);
        prmtDepartment.setDisplayFormat("$name$");
        prmtDepartment.setEditFormat("$number$");
        prmtDepartment.setCommitFormat("$number$");
        prmtDepartment.setRequired(true);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isFreeze", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isSealUp", (Object)new Integer(0)));
        fic.add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        prmtDepartment.setEntityViewInfo(view);
        NewAdminF7 f7 = new NewAdminF7(coreui);
        f7.setNeedAddOrgRange(false);
        prmtDepartment.setSelector((KDPromptSelector)f7);
        return f7;
    }

    public static DataBaseInfo getDataBaseFromNumber(Context ctx, String number, String companyNumber) {
        AccountBankInfo baseInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.number"));
        FilterInfo Filter = new FilterInfo();
        Filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        Filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)companyNumber));
        view.setFilter(Filter);
        view.setSelector(sic);
        try {
            AccountViewCollection accountViewCol;
            AccountBankCollection accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (accountBankCol != null && accountBankCol.size() > 0) {
                baseInfo = accountBankCol.get(0);
            }
            if ((accountViewCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view)) != null && accountViewCol.size() > 0) {
                baseInfo = accountViewCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return baseInfo;
    }

    public static AccountBankInfo getBankFromNumber(Context ctx, String number, String companyNumber) {
        AccountBankInfo bankInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.number"));
        FilterInfo Filter = new FilterInfo();
        Filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        Filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)companyNumber));
        view.setFilter(Filter);
        view.setSelector(sic);
        try {
            AccountBankCollection accountBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (accountBankCol != null && accountBankCol.size() > 0) {
                bankInfo = accountBankCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return bankInfo;
    }

    public static AccountViewInfo getViewFromNumber(Context ctx, String number, String companyNumber) {
        AccountViewInfo viewInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("accountCurrency.*"));
        FilterInfo Filter = new FilterInfo();
        Filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        Filter.getFilterItems().add(new FilterItemInfo("companyID.number", (Object)companyNumber));
        view.setFilter(Filter);
        view.setSelector(sic);
        try {
            AccountViewCollection accountViewCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            if (accountViewCol != null && accountViewCol.size() > 0) {
                viewInfo = accountViewCol.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return viewInfo;
    }

    public static Timestamp objToTimestamp(Object obj) throws InvalidDateException, IllegalConversionException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        try {
            if (obj instanceof Time) {
                Time time = (Time)obj;
                return new Timestamp(time.getTime());
            }
            if (obj instanceof Date) {
                Date date = (Date)obj;
                return new Timestamp(date.getTime());
            }
            if (obj instanceof java.util.Date) {
                java.util.Date dt = (java.util.Date)obj;
                return new Timestamp(dt.getTime());
            }
            String strObj = obj.toString();
            return new Timestamp(DateTimeUtils.parseDate((String)strObj).getTime());
        }
        catch (IllegalArgumentException _ex) {
            throw new InvalidDateException("Illegal Timestamp value - Java Timestamp Objects cannot be earlier than 1/1/70");
        }
        catch (Exception _ex) {
            throw new IllegalConversionException(EASResource.getString((String)"com.kingdee.eas.fm.liquid.LIQUIDAutoGenerateResource", (String)"6_LiquidBaseHelper"));
        }
    }

    public static FeeTypeInfo getFeeTypeByNumber(Context ctx, String number) throws TaskExternalException {
        FeeTypeInfo feeType = null;
        try {
            IFeeType iFeeType = FeeTypeFactory.getLocalInstance((Context)ctx);
            FeeTypeCollection coll = iFeeType.getFeeTypeCollection("where number='" + number + "'");
            if (coll != null && coll.size() > 0) {
                feeType = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage());
        }
        return feeType;
    }

    public static boolean isCompanyUnion(CompanyOrgUnitInfo company) {
        if (company == null) {
            throw new RuntimeException("Parameter[company] is null");
        }
        if (!company.containsKey("isBizUnit")) {
            throw new RuntimeException("Please load property [company.bizUnit]");
        }
        return !company.isIsBizUnit();
    }
}

