/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fm.liquid.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.F7SelectorFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.fm.liquid.CapitalReservesFactory;
import com.kingdee.eas.fm.liquid.CapitalReservesInfo;
import com.kingdee.eas.fm.liquid.client.AbstractCapitalReservesEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class CapitalReservesEditUI
extends AbstractCapitalReservesEditUI {
    private static final Logger logger = CoreUIObject.getLogger(CapitalReservesEditUI.class);
    private CompanyOrgUnitInfo companyInfo = null;
    private CurrencyInfo bassCurrency;
    private UserInfo userInfo = null;

    protected ICoreBase getBizInterface() throws Exception {
        return CapitalReservesFactory.getRemoteInstance();
    }

    protected void updateButtonStatus() {
        super.updateButtonStatus();
        this.btnAuditResult.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.chkMenuItemSubmitAndAddNew.setSelected(true);
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
    }

    public void onLoad() throws Exception {
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.bassCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
        this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.baseCurrency.getId().toString()));
        this.userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        super.onLoad();
        NewCompanyF7 selector = F7SelectorFactory.getSelectCompany((IUIObject)this, null, null, (boolean)false);
        selector.setMultiSelect(false);
        selector.setUsePerm(true);
        this.prmtCompany.setSelector((KDPromptSelector)selector);
        this.prmtCompany.getEntityViewInfo();
    }

    protected void initUIProp() throws Exception {
        super.initUIProp();
        this.txtAmount.setRemoveingZeroInDispaly(false);
        this.txtAmount.setHorizontalAlignment(4);
        this.txtAmount.setMinimumValue((Comparable)Constants.ZERO);
        this.txtAmount.setMaximumValue((Comparable)new BigDecimal("9999999999999"));
        this.txtRemarks.setMaxLength(200);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        try {
            FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true, (String)this.getOprtState());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.editData.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
    }

    protected IObjectValue createNewData() {
        CapitalReservesInfo info = new CapitalReservesInfo();
        info.setAmount(BigDecimal.ZERO);
        info.setCompany(this.companyInfo);
        info.setEffectiveDate(DateTimeUtils.truncateDate((Date)new Date()));
        info.setCurrency(this.baseCurrency);
        info.setCreator(this.userInfo);
        return info;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("*");
        return sic;
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        FMClientVerifyHelper.verifyUIControlEmpty((CoreUI)this);
        FMClientHelper.verifyMoreThanZero((CoreUIObject)this, (KDFormattedTextField)this.txtAmount);
    }

    @Override
    public void loadFields() {
        int precision = FMHelper.getPrecOfCurrency(null, (String)this.editData.getCurrency().getId().toString());
        this.txtAmount.setPrecision(precision);
        this.prmtCompany.setValue((Object)this.editData.getCompany());
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.editData.getCurrency());
        this.txtAmount.setValue((Object)this.editData.getAmount());
        this.pkEffectiveDate.setValue((Object)this.editData.getEffectiveDate());
        this.txtRemarks.setText(this.editData.getRemarks());
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        super.comboCurrency_itemStateChanged(e);
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currency == null) {
            return;
        }
        this.txtAmount.setPrecision(currency.getPrecision());
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    protected boolean isContinueAddNew() {
        return false;
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtCompany_dataChanged(e);
        if (e.getNewValue() != null && e.getOldValue() != null && !e.getNewValue().equals(e.getOldValue())) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        }
    }
}

